/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.util;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.globalclock.provider.GlobalClockProvider;
import org.apache.shardingsphere.globalclock.rule.GlobalClockRule;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedClusterInfo;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedMetaData;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedSnapshotInfo;
import org.apache.shardingsphere.proxy.backend.util.DatabaseExportMetaDataGenerator;

public final class ClusterExportMetaDataGenerator {
    private final ContextManager contextManager;

    public String generateJsonFormat() {
        ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
        ExportedMetaData exportedMetaData = new ExportedMetaData();
        exportedMetaData.setDatabases(this.generatorDatabasesExportData());
        exportedMetaData.setProps(this.generatePropsData(metaData.getProps().getProps()));
        exportedMetaData.setRules(this.generateRulesData(metaData.getGlobalRuleMetaData().getConfigurations()));
        ExportedClusterInfo exportedClusterInfo = new ExportedClusterInfo();
        exportedClusterInfo.setMetaData(exportedMetaData);
        this.generateSnapshotInfo(metaData, exportedClusterInfo);
        return JsonUtils.toJsonString((Object)exportedClusterInfo);
    }

    private Map<String, String> generatorDatabasesExportData() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.contextManager.getMetaDataContexts().getMetaData().getAllDatabases().size(), 1.0f);
        for (ShardingSphereDatabase each : this.contextManager.getMetaDataContexts().getMetaData().getAllDatabases()) {
            if (each.getResourceMetaData().getAllInstanceDataSourceNames().isEmpty()) continue;
            result.put(each.getName(), new DatabaseExportMetaDataGenerator(each).generateYAMLFormat());
        }
        return result;
    }

    private String generatePropsData(Properties props) {
        if (props.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("props:").append(System.lineSeparator());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (null == entry.getValue() || "".equals(entry.getValue().toString())) continue;
            result.append("  ").append(entry.getKey()).append(": ").append(entry.getValue()).append(System.lineSeparator());
        }
        return result.toString();
    }

    private String generateRulesData(Collection<RuleConfiguration> rules) {
        if (rules.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("rules:").append(System.lineSeparator());
        for (Map.Entry entry : OrderedSPILoader.getServices(YamlRuleConfigurationSwapper.class, rules).entrySet()) {
            result.append(YamlEngine.marshal(Collections.singletonList(((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey()))));
        }
        return result.toString();
    }

    private void generateSnapshotInfo(ShardingSphereMetaData metaData, ExportedClusterInfo exportedClusterInfo) {
        GlobalClockRule globalClockRule = (GlobalClockRule)metaData.getGlobalRuleMetaData().getSingleRule(GlobalClockRule.class);
        if (globalClockRule.getConfiguration().isEnabled()) {
            ExportedSnapshotInfo snapshotInfo = new ExportedSnapshotInfo();
            snapshotInfo.setCsn(String.valueOf(globalClockRule.getGlobalClockProvider().map(GlobalClockProvider::getCurrentTimestamp).orElse(0L)));
            snapshotInfo.setCreateTime(LocalDateTime.now());
            exportedClusterInfo.setSnapshotInfo(snapshotInfo);
        }
    }

    @Generated
    public ClusterExportMetaDataGenerator(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

