/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.distsql.handler.cdc.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.cdc.api.CDCJobAPI;
import org.apache.shardingsphere.data.pipeline.cdc.core.pojo.CDCJobItemInfo;
import org.apache.shardingsphere.data.pipeline.cdc.distsql.statement.queryable.ShowStreamingStatusStatement;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.pojo.TransmissionJobItemInfo;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowStreamingJobStatusExecutor
implements DistSQLQueryExecutor<ShowStreamingStatusStatement> {
    private final CDCJobAPI jobAPI = (CDCJobAPI)TypedSPILoader.getService(TransmissionJobAPI.class, (Object)"STREAMING");

    public Collection<String> getColumnNames(ShowStreamingStatusStatement sqlStatement) {
        return Arrays.asList("item", "data_source", "status", "active", "processed_records_count", "inventory_finished_percentage", "incremental_idle_seconds", "confirmed_position", "current_position", "error_message");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowStreamingStatusStatement sqlStatement, ContextManager contextManager) {
        Collection jobItemInfos = this.jobAPI.getJobItemInfos(sqlStatement.getJobId());
        long currentTimeMillis = System.currentTimeMillis();
        return jobItemInfos.stream().map(each -> this.getRow((CDCJobItemInfo)each, currentTimeMillis)).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow getRow(CDCJobItemInfo cdcJobItemInfo, long currentTimeMillis) {
        TransmissionJobItemInfo transmissionJobItemInfo = cdcJobItemInfo.getTransmissionJobItemInfo();
        TransmissionJobItemProgress jobItemProgress = transmissionJobItemInfo.getJobItemProgress();
        if (null == jobItemProgress) {
            return new LocalDataQueryResultRow(new Object[]{transmissionJobItemInfo.getShardingItem(), "", "", "", "", "", "", "", "", transmissionJobItemInfo.getErrorMessage()});
        }
        return new LocalDataQueryResultRow(new Object[]{transmissionJobItemInfo.getShardingItem(), jobItemProgress.getDataSourceName(), jobItemProgress.getStatus(), jobItemProgress.isActive(), jobItemProgress.getProcessedRecordsCount(), transmissionJobItemInfo.getInventoryFinishedPercentage(), ShowStreamingJobStatusExecutor.getIncrementalIdleSeconds(jobItemProgress, transmissionJobItemInfo, currentTimeMillis), cdcJobItemInfo.getConfirmedPosition(), cdcJobItemInfo.getCurrentPosition(), transmissionJobItemInfo.getErrorMessage()});
    }

    private static Optional<Long> getIncrementalIdleSeconds(TransmissionJobItemProgress jobItemProgress, TransmissionJobItemInfo transmissionJobItemInfo, long currentTimeMillis) {
        if (jobItemProgress.getIncremental().getIncrementalLatestActiveTimeMillis() > 0L) {
            long latestActiveTimeMillis = Math.max(transmissionJobItemInfo.getStartTimeMillis(), jobItemProgress.getIncremental().getIncrementalLatestActiveTimeMillis());
            return Optional.of(TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis - latestActiveTimeMillis));
        }
        return Optional.empty();
    }

    public Class<ShowStreamingStatusStatement> getType() {
        return ShowStreamingStatusStatement.class;
    }
}

