/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.distsql.handler.migration.update;

import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.exception.job.MissingRequiredTargetDatabaseException;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.migration.distsql.statement.updatable.MigrateTableStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.api.MigrationJobAPI;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;

@DistSQLExecutorClusterModeRequired
public final class MigrateTableExecutor
implements DistSQLUpdateExecutor<MigrateTableStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    public void executeUpdate(MigrateTableStatement sqlStatement, ContextManager contextManager) {
        String targetDatabaseName = sqlStatement.getTargetDatabaseName();
        if (Objects.nonNull(targetDatabaseName)) {
            ShardingSpherePreconditions.checkState((boolean)contextManager.getMetaDataContexts().getMetaData().containsDatabase(targetDatabaseName), () -> new MissingRequiredTargetDatabaseException(sqlStatement.getTargetDatabaseName()));
        } else {
            targetDatabaseName = this.database.getName();
        }
        MigrationJobAPI jobAPI = (MigrationJobAPI)TypedSPILoader.getService(TransmissionJobAPI.class, (Object)"MIGRATION");
        jobAPI.schedule(new PipelineContextKey(InstanceType.PROXY), new MigrateTableStatement(sqlStatement.getSourceTargetEntries(), targetDatabaseName));
    }

    public Class<MigrateTableStatement> getType() {
        return MigrateTableStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

