/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.checker;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.loadbalancer.core.LoadBalanceAlgorithm;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.readwritesplitting.checker.ReadwriteSplittingDataSourceRuleConfigurationChecker;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;

public final class ReadwriteSplittingRuleConfigurationChecker
implements RuleConfigurationChecker<ReadwriteSplittingRuleConfiguration> {
    public void check(String databaseName, ReadwriteSplittingRuleConfiguration ruleConfig, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.checkDataSources(databaseName, ruleConfig.getDataSourceGroups(), dataSourceMap, builtRules);
        this.checkLoadBalancer(databaseName, ruleConfig);
    }

    private void checkDataSources(String databaseName, Collection<ReadwriteSplittingDataSourceGroupRuleConfiguration> configs, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        HashSet builtWriteDataSourceNames = new HashSet();
        HashSet builtReadDataSourceNames = new HashSet();
        configs.forEach(each -> new ReadwriteSplittingDataSourceRuleConfigurationChecker(databaseName, (ReadwriteSplittingDataSourceGroupRuleConfiguration)each, dataSourceMap).check(builtWriteDataSourceNames, builtReadDataSourceNames, builtRules));
    }

    private void checkLoadBalancer(String databaseName, ReadwriteSplittingRuleConfiguration ruleConfig) {
        Map<String, LoadBalanceAlgorithm> loadBalancers = ruleConfig.getLoadBalancers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (LoadBalanceAlgorithm)TypedSPILoader.getService(LoadBalanceAlgorithm.class, (Object)((AlgorithmConfiguration)entry.getValue()).getType(), (Properties)((AlgorithmConfiguration)entry.getValue()).getProps())));
        for (ReadwriteSplittingDataSourceGroupRuleConfiguration each : ruleConfig.getDataSourceGroups()) {
            if (Strings.isNullOrEmpty((String)each.getLoadBalancerName())) continue;
            LoadBalanceAlgorithm loadBalancer = loadBalancers.get(each.getLoadBalancerName());
            ShardingSpherePreconditions.checkNotNull((Object)loadBalancer, () -> new UnregisteredAlgorithmException("Load balancer", each.getLoadBalancerName(), new SQLExceptionIdentifier(databaseName)));
            loadBalancer.check(databaseName, (Collection)each.getReadDataSourceNames());
        }
    }

    public Collection<String> getRequiredDataSourceNames(ReadwriteSplittingRuleConfiguration ruleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ReadwriteSplittingDataSourceGroupRuleConfiguration each : ruleConfig.getDataSourceGroups()) {
            if (null != each.getWriteDataSourceName()) {
                result.add(each.getWriteDataSourceName());
            }
            if (each.getReadDataSourceNames().isEmpty()) continue;
            result.addAll(each.getReadDataSourceNames());
        }
        return result;
    }

    public int getOrder() {
        return 45;
    }

    public Class<ReadwriteSplittingRuleConfiguration> getTypeClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }
}

