/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.advisor.executor.type;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.api.advice.type.ConstructorAdvice;
import org.apache.shardingsphere.agent.api.plugin.AgentPluginEnable;
import org.apache.shardingsphere.agent.core.advisor.executor.AdviceExecutor;
import org.apache.shardingsphere.shade.net.bytebuddy.description.method.MethodDescription;
import org.apache.shardingsphere.shade.net.bytebuddy.dynamic.DynamicType;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.MethodDelegation;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.SuperMethodCall;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.This;
import org.apache.shardingsphere.shade.net.bytebuddy.matcher.ElementMatchers;

public final class ConstructorAdviceExecutor
implements AdviceExecutor {
    private static final Logger LOGGER = Logger.getLogger(ConstructorAdviceExecutor.class.getName());
    private final Map<String, Collection<ConstructorAdvice>> advices;

    @RuntimeType
    public void advice(@This TargetAdviceObject target, @AllArguments Object[] args) {
        try {
            for (Map.Entry<String, Collection<ConstructorAdvice>> entry : this.advices.entrySet()) {
                for (ConstructorAdvice each : entry.getValue()) {
                    if (!this.isPluginEnabled(each)) continue;
                    each.onConstructor(target, args, entry.getKey());
                }
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "Constructor advice execution error. class: {0}, {1}", new String[]{target.getClass().getTypeName(), ex.getMessage()});
        }
    }

    private boolean isPluginEnabled(ConstructorAdvice advice) {
        return !(advice instanceof AgentPluginEnable) || ((AgentPluginEnable)((Object)advice)).isPluginEnabled();
    }

    @Override
    public DynamicType.Builder<?> intercept(DynamicType.Builder<?> builder, MethodDescription pointcut) {
        return builder.constructor(ElementMatchers.is(pointcut)).intercept(SuperMethodCall.INSTANCE.andThen(MethodDelegation.withDefaultConfiguration().to(this)));
    }

    @Generated
    public ConstructorAdviceExecutor(Map<String, Collection<ConstructorAdvice>> advices) {
        this.advices = advices;
    }
}

