/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.manager.DatabaseRuleConfigurationManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;

public class RuleItemManager {
    private final MetaDataContexts metaDataContexts;
    private final DatabaseRuleConfigurationManager ruleConfigManager;
    private final MetaDataPersistService metaDataPersistService;

    public RuleItemManager(MetaDataContexts metaDataContexts, PersistRepository repository, DatabaseRuleConfigurationManager ruleConfigManager) {
        this.metaDataContexts = metaDataContexts;
        this.ruleConfigManager = ruleConfigManager;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterRuleItem(AlterRuleItem alterRuleItem) throws SQLException {
        Preconditions.checkArgument((boolean)alterRuleItem.getActiveVersion().equals(this.metaDataPersistService.getRepository().query(alterRuleItem.getActiveVersionKey())), (String)"Invalid active version: {} of key: {}", (Object)alterRuleItem.getActiveVersion(), (Object)alterRuleItem.getActiveVersionKey());
        RuleItemConfigurationChangedProcessor processor = (RuleItemConfigurationChangedProcessor)TypedSPILoader.getService(RuleItemConfigurationChangedProcessor.class, (Object)alterRuleItem.getType());
        String yamlContent = this.metaDataPersistService.getMetaDataVersionPersistService().getVersionPathByActiveVersion(alterRuleItem.getActiveVersionKey(), alterRuleItem.getActiveVersion());
        String databaseName = alterRuleItem.getDatabaseName();
        RuleConfiguration currentRuleConfig = processor.findRuleConfiguration(this.metaDataContexts.getMetaData().getDatabase(databaseName));
        RuleItemManager ruleItemManager = this;
        synchronized (ruleItemManager) {
            processor.changeRuleItemConfiguration(alterRuleItem, currentRuleConfig, processor.swapRuleItemConfiguration(alterRuleItem, yamlContent));
            this.ruleConfigManager.alterRuleConfiguration(databaseName, currentRuleConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropRuleItem(DropRuleItem dropRuleItem) throws SQLException {
        String databaseName = dropRuleItem.getDatabaseName();
        Preconditions.checkState((boolean)this.metaDataContexts.getMetaData().containsDatabase(databaseName), (String)"No database '%s' exists.", (Object)databaseName);
        RuleItemConfigurationChangedProcessor processor = (RuleItemConfigurationChangedProcessor)TypedSPILoader.getService(RuleItemConfigurationChangedProcessor.class, (Object)dropRuleItem.getType());
        RuleConfiguration currentRuleConfig = processor.findRuleConfiguration(this.metaDataContexts.getMetaData().getDatabase(databaseName));
        RuleItemManager ruleItemManager = this;
        synchronized (ruleItemManager) {
            processor.dropRuleItemConfiguration(dropRuleItem, currentRuleConfig);
            this.ruleConfigManager.dropRuleConfiguration(databaseName, currentRuleConfig);
        }
    }
}

