/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.manager.ResourceSwitchManager;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageUnitManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageUnitManager.class);
    private final MetaDataContexts metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final ResourceSwitchManager resourceSwitchManager;
    private final MetaDataPersistService metaDataPersistService;

    public StorageUnitManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, PersistRepository repository, ResourceSwitchManager resourceSwitchManager) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.resourceSwitchManager = resourceSwitchManager;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public synchronized void registerStorageUnit(String databaseName, Map<String, DataSourcePoolProperties> propsMap) {
        try {
            this.closeStaleRules(databaseName);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByRegisterStorageUnit(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), propsMap);
            this.buildNewMetaDataContext(databaseName, switchingResource);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void alterStorageUnit(String databaseName, Map<String, DataSourcePoolProperties> propsMap) {
        try {
            this.closeStaleRules(databaseName);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByAlterStorageUnit(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), propsMap);
            this.buildNewMetaDataContext(databaseName, switchingResource);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void unregisterStorageUnit(String databaseName, String storageUnitName) {
        try {
            this.closeStaleRules(databaseName);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByUnregisterStorageUnit(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), Collections.singletonList(storageUnitName));
            this.buildNewMetaDataContext(databaseName, switchingResource);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed", (Object)databaseName, (Object)ex);
        }
    }

    private void buildNewMetaDataContext(String databaseName, SwitchingResource switchingResource) throws SQLException {
        MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createBySwitchResource(databaseName, true, switchingResource, this.metaDataContexts, this.metaDataPersistService, this.computeNodeInstanceContext);
        this.metaDataContexts.update(reloadMetaDataContexts);
        this.metaDataContexts.getMetaData().putDatabase(this.buildDatabase(reloadMetaDataContexts.getMetaData().getDatabase(databaseName)));
        switchingResource.closeStaleDataSources();
    }

    private ShardingSphereDatabase buildDatabase(ShardingSphereDatabase originalDatabase) {
        return new ShardingSphereDatabase(originalDatabase.getName(), originalDatabase.getProtocolType(), originalDatabase.getResourceMetaData(), originalDatabase.getRuleMetaData(), this.buildSchemas(originalDatabase));
    }

    private Collection<ShardingSphereSchema> buildSchemas(ShardingSphereDatabase originalDatabase) {
        return originalDatabase.getAllSchemas().stream().map(each -> new ShardingSphereSchema(each.getName(), each.getAllTables(), this.metaDataPersistService.getDatabaseMetaDataFacade().getView().load(originalDatabase.getName(), each.getName()))).collect(Collectors.toList());
    }

    private void closeStaleRules(String databaseName) {
        for (ShardingSphereRule each : this.metaDataContexts.getMetaData().getDatabase(databaseName).getRuleMetaData().getRules()) {
            if (!(each instanceof AutoCloseable)) continue;
            ((AutoCloseable)each).close();
        }
    }
}

