/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlShardingSphereRowDataSwapper;
import org.apache.shardingsphere.mode.metadata.persist.data.AlteredShardingSphereDatabaseData;
import org.apache.shardingsphere.mode.metadata.persist.service.metadata.table.TableRowDataPersistService;
import org.apache.shardingsphere.mode.node.path.metadata.ShardingSphereDataNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class ShardingSphereDataPersistService {
    private final PersistRepository repository;
    private final TableRowDataPersistService tableRowDataPersistService;

    public ShardingSphereDataPersistService(PersistRepository repository) {
        this.repository = repository;
        this.tableRowDataPersistService = new TableRowDataPersistService(repository);
    }

    public Optional<ShardingSphereStatistics> load(ShardingSphereMetaData metaData) {
        List databaseNames = this.repository.getChildrenKeys(ShardingSphereDataNodePath.getDatabasesRootPath());
        if (databaseNames.isEmpty()) {
            return Optional.empty();
        }
        ShardingSphereStatistics result = new ShardingSphereStatistics();
        for (String each : databaseNames.stream().filter(arg_0 -> ((ShardingSphereMetaData)metaData).containsDatabase(arg_0)).collect(Collectors.toList())) {
            result.getDatabaseData().put(each, this.load(metaData.getDatabase(each)));
        }
        return Optional.of(result);
    }

    private ShardingSphereDatabaseData load(ShardingSphereDatabase database) {
        ShardingSphereDatabaseData result = new ShardingSphereDatabaseData();
        for (String each : this.repository.getChildrenKeys(ShardingSphereDataNodePath.getSchemaRootPath((String)database.getName())).stream().filter(arg_0 -> ((ShardingSphereDatabase)database).containsSchema(arg_0)).collect(Collectors.toList())) {
            result.putSchema(each, this.load(database.getName(), database.getSchema(each)));
        }
        return result;
    }

    private ShardingSphereSchemaData load(String databaseName, ShardingSphereSchema schema) {
        ShardingSphereSchemaData result = new ShardingSphereSchemaData();
        for (String each : this.repository.getChildrenKeys(ShardingSphereDataNodePath.getTableRootPath((String)databaseName, (String)schema.getName())).stream().filter(arg_0 -> ((ShardingSphereSchema)schema).containsTable(arg_0)).collect(Collectors.toList())) {
            result.getTableData().put(each, this.tableRowDataPersistService.load(databaseName, schema.getName(), schema.getTable(each)));
        }
        return result;
    }

    public void persist(ShardingSphereDatabase database, String schemaName, ShardingSphereSchemaData schemaData) {
        if (schemaData.getTableData().isEmpty()) {
            this.persistSchema(database.getName(), schemaName);
        }
        this.persistTableData(database, schemaName, schemaData);
    }

    private void persistSchema(String databaseName, String schemaName) {
        this.repository.persist(ShardingSphereDataNodePath.getSchemaPath((String)databaseName, (String)schemaName), "");
    }

    private void persistTableData(ShardingSphereDatabase database, String schemaName, ShardingSphereSchemaData schemaData) {
        schemaData.getTableData().values().forEach(each -> {
            YamlShardingSphereRowDataSwapper swapper = new YamlShardingSphereRowDataSwapper(new ArrayList(database.getSchema(schemaName).getTable(each.getName()).getAllColumns()));
            this.persistTableData(database.getName(), schemaName, each.getName(), each.getRows().stream().map(arg_0 -> ((YamlShardingSphereRowDataSwapper)swapper).swapToYamlConfiguration(arg_0)).collect(Collectors.toList()));
        });
    }

    private void persistTableData(String databaseName, String schemaName, String tableName, Collection<YamlShardingSphereRowData> rows) {
        this.tableRowDataPersistService.persist(databaseName, schemaName, tableName, rows);
    }

    public void update(AlteredShardingSphereDatabaseData alteredData) {
        this.tableRowDataPersistService.persist(alteredData.getDatabaseName(), alteredData.getSchemaName(), alteredData.getTableName(), alteredData.getAddedRows());
        this.tableRowDataPersistService.persist(alteredData.getDatabaseName(), alteredData.getSchemaName(), alteredData.getTableName(), alteredData.getUpdatedRows());
        this.tableRowDataPersistService.delete(alteredData.getDatabaseName(), alteredData.getSchemaName(), alteredData.getTableName(), alteredData.getDeletedRows());
    }

    public void delete(String databaseName) {
        this.repository.delete(ShardingSphereDataNodePath.getDatabasePath((String)databaseName));
    }
}

