/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.config.global;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.metadata.persist.service.config.RepositoryTuplePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.node.path.GlobalRuleNodePath;
import org.apache.shardingsphere.mode.node.tuple.RepositoryTuple;
import org.apache.shardingsphere.mode.node.tuple.RepositoryTupleSwapperEngine;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class GlobalRulePersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;
    private final RepositoryTuplePersistService repositoryTuplePersistService;

    public GlobalRulePersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.metaDataVersionPersistService = metaDataVersionPersistService;
        this.repositoryTuplePersistService = new RepositoryTuplePersistService(repository);
    }

    public Collection<RuleConfiguration> load() {
        return new RepositoryTupleSwapperEngine().swapToRuleConfigurations(this.repositoryTuplePersistService.load(GlobalRuleNodePath.getRootPath()));
    }

    public Optional<RuleConfiguration> load(String ruleTypeName) {
        return new RepositoryTupleSwapperEngine().swapToRuleConfiguration(ruleTypeName, this.repositoryTuplePersistService.load(GlobalRuleNodePath.getRulePath((String)ruleTypeName)));
    }

    public void persist(Collection<RuleConfiguration> globalRuleConfigs) {
        LinkedList<MetaDataVersion> metaDataVersions = new LinkedList<MetaDataVersion>();
        RepositoryTupleSwapperEngine repositoryTupleSwapperEngine = new RepositoryTupleSwapperEngine();
        for (YamlRuleConfiguration each : new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(globalRuleConfigs)) {
            metaDataVersions.addAll(this.persistTuples(repositoryTupleSwapperEngine.swapToRepositoryTuples(each)));
        }
        this.metaDataVersionPersistService.switchActiveVersion(metaDataVersions);
    }

    private Collection<MetaDataVersion> persistTuples(Collection<RepositoryTuple> repositoryTuples) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (RepositoryTuple each : repositoryTuples) {
            List<String> versions = this.metaDataVersionPersistService.getVersions(GlobalRuleNodePath.getVersionRootPath((String)each.getKey()));
            String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt(versions.get(0)) + 1);
            this.repository.persist(GlobalRuleNodePath.getVersionPath((String)each.getKey(), (String)nextActiveVersion), each.getValue());
            String ruleActiveVersionPath = GlobalRuleNodePath.getActiveVersionPath((String)each.getKey());
            if (Strings.isNullOrEmpty((String)this.repository.query(ruleActiveVersionPath))) {
                this.repository.persist(ruleActiveVersionPath, "0");
            }
            result.add(new MetaDataVersion(GlobalRuleNodePath.getRulePath((String)each.getKey()), this.repository.query(ruleActiveVersionPath), nextActiveVersion));
        }
        return result;
    }
}

