/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.single.yaml.config;

import lombok.Getter;
import lombok.Setter;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.mode.node.tuple.annotation.RepositoryTupleEntity;
import org.apache.shardingsphere.mode.node.tuple.annotation.RepositoryTupleField;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;

import java.util.Collection;
import java.util.LinkedList;

/**
 * Single rule configuration for YAML.
 */
@RepositoryTupleEntity("single")
@Getter
@Setter
public final class YamlSingleRuleConfiguration implements YamlRuleConfiguration {
    
    @RepositoryTupleField(type = RepositoryTupleField.Type.TABLE)
    private Collection<String> tables = new LinkedList<>();
    
    @RepositoryTupleField(type = RepositoryTupleField.Type.OTHER)
    private String defaultDataSource;
    
    @Override
    public Class<SingleRuleConfiguration> getRuleConfigurationType() {
        return SingleRuleConfiguration.class;
    }
}
