/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.error.handler;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.error.handler.JobErrorHandler;
import org.apache.shardingsphere.elasticjob.error.handler.JobErrorHandlerFactory;
import org.apache.shardingsphere.elasticjob.infra.context.Reloadable;
import org.apache.shardingsphere.elasticjob.infra.context.ReloadablePostProcessor;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobErrorHandlerReloadable
implements Reloadable<JobErrorHandler>,
ReloadablePostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobErrorHandlerReloadable.class);
    private String jobErrorHandlerType;
    private Properties props;
    private JobErrorHandler jobErrorHandler;

    public void init(JobConfiguration jobConfig) {
        this.jobErrorHandlerType = Strings.isNullOrEmpty((String)jobConfig.getJobErrorHandlerType()) ? "LOG" : jobConfig.getJobErrorHandlerType();
        this.props = (Properties)jobConfig.getProps().clone();
        this.jobErrorHandler = JobErrorHandlerFactory.createHandler(this.jobErrorHandlerType, this.props).orElseThrow(() -> new JobConfigurationException("Cannot find job error handler type '%s'.", new Object[]{this.jobErrorHandlerType}));
    }

    public synchronized void reloadIfNecessary(JobConfiguration jobConfig) {
        String newJobErrorHandlerType;
        String string = newJobErrorHandlerType = Strings.isNullOrEmpty((String)jobConfig.getJobErrorHandlerType()) ? "LOG" : jobConfig.getJobErrorHandlerType();
        if (newJobErrorHandlerType.equals(this.jobErrorHandlerType) && this.props.equals(jobConfig.getProps())) {
            return;
        }
        log.debug("JobErrorHandler reload occurred in the job '{}'. Change from '{}' to '{}'.", new Object[]{jobConfig.getJobName(), this.jobErrorHandlerType, newJobErrorHandlerType});
        this.reload(newJobErrorHandlerType, jobConfig.getProps());
    }

    private void reload(String jobErrorHandlerType, Properties props) {
        this.jobErrorHandler.close();
        this.jobErrorHandlerType = jobErrorHandlerType;
        this.props = (Properties)props.clone();
        this.jobErrorHandler = JobErrorHandlerFactory.createHandler(jobErrorHandlerType, props).orElseThrow(() -> new JobConfigurationException("Cannot find job error handler type '%s'.", new Object[]{jobErrorHandlerType}));
    }

    public JobErrorHandler getInstance() {
        return this.jobErrorHandler;
    }

    public String getType() {
        return JobErrorHandler.class.getName();
    }

    public void close() {
        Optional.ofNullable(this.jobErrorHandler).ifPresent(JobErrorHandler::close);
    }
}

