/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTracker;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.sla.ResAllocs;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class ResAllocsEvaluater {
    private final Map<String, ResAllocs> resAllocs;
    private final TaskTracker taskTracker;
    private final Set<String> failedTaskGroups = new HashSet<String>();
    private final BlockingQueue<ResAllocs> addQ = new LinkedBlockingQueue<ResAllocs>();
    private final BlockingQueue<String> remQ = new LinkedBlockingQueue<String>();
    private final List<ResAllocs> addList = new LinkedList<ResAllocs>();
    private final List<String> remList = new LinkedList<String>();

    ResAllocsEvaluater(TaskTracker taskTracker, Map<String, ResAllocs> initialResAllocs) {
        this.taskTracker = taskTracker;
        this.resAllocs = initialResAllocs == null ? new HashMap<String, ResAllocs>() : new HashMap<String, ResAllocs>(initialResAllocs);
    }

    void replaceResAllocs(ResAllocs r) {
        if (r != null) {
            this.addQ.offer(r);
        }
    }

    void remResAllocs(String groupName) {
        if (groupName != null && !groupName.isEmpty()) {
            this.remQ.offer(groupName);
        }
    }

    boolean prepare() {
        this.failedTaskGroups.clear();
        this.updateResAllocs();
        return !this.resAllocs.isEmpty();
    }

    private void updateResAllocs() {
        Iterator<Object> iter;
        this.addQ.drainTo(this.addList);
        if (!this.addList.isEmpty()) {
            iter = this.addList.iterator();
            while (iter.hasNext()) {
                ResAllocs r = iter.next();
                this.resAllocs.put(r.getTaskGroupName(), r);
                iter.remove();
            }
        }
        this.remQ.drainTo(this.remList);
        if (!this.remList.isEmpty()) {
            iter = this.remList.iterator();
            while (iter.hasNext()) {
                this.resAllocs.remove(iter.next());
                iter.remove();
            }
        }
    }

    boolean taskGroupFailed(String taskGroupName) {
        return this.failedTaskGroups.contains(taskGroupName);
    }

    AssignmentFailure hasResAllocs(TaskRequest task) {
        if (this.resAllocs.isEmpty()) {
            return null;
        }
        if (this.failedTaskGroups.contains(task.taskGroupName())) {
            return new AssignmentFailure(VMResource.ResAllocs, 1.0, 0.0, 0.0, "");
        }
        TaskTracker.TaskGroupUsage usage = this.taskTracker.getUsage(task.taskGroupName());
        ResAllocs resAllocs = this.resAllocs.get(task.taskGroupName());
        if (resAllocs == null) {
            return new AssignmentFailure(VMResource.ResAllocs, 1.0, 0.0, 0.0, "");
        }
        if (usage == null) {
            boolean success = this.hasZeroUsageAllowance(resAllocs);
            if (!success) {
                this.failedTaskGroups.add(task.taskGroupName());
            }
            return success ? null : new AssignmentFailure(VMResource.ResAllocs, 1.0, 0.0, 0.0, "");
        }
        if (usage.getCores() + task.getCPUs() > resAllocs.getCores()) {
            return new AssignmentFailure(VMResource.ResAllocs, task.getCPUs(), usage.getCores(), resAllocs.getCores(), "");
        }
        if (usage.getMemory() + task.getMemory() > resAllocs.getMemory()) {
            return new AssignmentFailure(VMResource.ResAllocs, task.getMemory(), usage.getMemory(), resAllocs.getMemory(), "");
        }
        if (usage.getNetworkMbps() + task.getNetworkMbps() > resAllocs.getNetworkMbps()) {
            return new AssignmentFailure(VMResource.ResAllocs, task.getNetworkMbps(), usage.getNetworkMbps(), resAllocs.getNetworkMbps(), "");
        }
        if (usage.getDisk() + task.getDisk() > resAllocs.getDisk()) {
            return new AssignmentFailure(VMResource.ResAllocs, task.getDisk(), usage.getDisk(), resAllocs.getDisk(), "");
        }
        return null;
    }

    private boolean hasZeroUsageAllowance(ResAllocs resAllocs) {
        return resAllocs != null && (resAllocs.getCores() > 0.0 || resAllocs.getMemory() > 0.0 || resAllocs.getNetworkMbps() > 0.0 || resAllocs.getDisk() > 0.0);
    }

    public Map<String, ResAllocs> getResAllocs() {
        return Collections.unmodifiableMap(this.resAllocs);
    }
}

