/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.ScaleDownConstraintEvaluator;
import com.netflix.fenzo.ScaleDownOrderEvaluator;
import com.netflix.fenzo.VirtualMachineLease;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScaleDownConstraintExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ScaleDownConstraintExecutor.class);
    private static final double NOT_REMOVABLE_MARKER = -1.0;
    private final ScaleDownOrderEvaluator orderEvaluator;
    private final Map<ScaleDownConstraintEvaluator, Double> scoringEvaluators;

    ScaleDownConstraintExecutor(ScaleDownOrderEvaluator orderEvaluator, Map<ScaleDownConstraintEvaluator, Double> weightedScoringEvaluators) {
        this.checkArguments(weightedScoringEvaluators);
        this.orderEvaluator = orderEvaluator;
        this.scoringEvaluators = weightedScoringEvaluators;
    }

    List<VirtualMachineLease> evaluate(Collection<VirtualMachineLease> candidates) {
        List<VirtualMachineLease> scaleDownOrder;
        List<Set<VirtualMachineLease>> fixedOrder = this.orderEvaluator.evaluate(candidates);
        List<VirtualMachineLease> list = scaleDownOrder = this.scoringEvaluators.isEmpty() ? fixedOrder.stream().flatMap(Collection::stream).collect(Collectors.toList()) : fixedOrder.stream().flatMap(this::groupEvaluator).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            List hosts = scaleDownOrder.stream().map(VirtualMachineLease::hostname).collect(Collectors.toList());
            logger.debug("Evaluated scale down order: {}", hosts);
        }
        return scaleDownOrder;
    }

    private void checkArguments(Map<ScaleDownConstraintEvaluator, Double> weightedScoringEvaluators) {
        List evaluatorsWithInvalidWeights = weightedScoringEvaluators.entrySet().stream().filter(e -> (Double)e.getValue() <= 0.0).map(e -> ((ScaleDownConstraintEvaluator)e.getKey()).getName() + '=' + e.getValue()).collect(Collectors.toList());
        if (!evaluatorsWithInvalidWeights.isEmpty()) {
            throw new IllegalArgumentException("Evaluator weighs must be > 0. This invariant is violated by " + evaluatorsWithInvalidWeights);
        }
    }

    private Stream<VirtualMachineLease> groupEvaluator(Set<VirtualMachineLease> groupCandidates) {
        HashMap scores = new HashMap();
        this.scoringEvaluators.forEach((e, weight) -> {
            Optional<Object> optionalContext = Optional.empty();
            for (VirtualMachineLease lease : groupCandidates) {
                double currentScore = scores.getOrDefault(lease, 0.0);
                if (currentScore == -1.0) continue;
                ScaleDownConstraintEvaluator.Result result = e.evaluate(lease, optionalContext);
                double newScore = result.getScore() * weight;
                if (newScore == 0.0) {
                    scores.put(lease, -1.0);
                } else {
                    scores.put(lease, currentScore + newScore);
                }
                optionalContext = result.getContext();
            }
        });
        return scores.entrySet().stream().filter(e -> (Double)e.getValue() != -1.0).sorted((e1, e2) -> Double.compare((Double)e2.getValue(), (Double)e1.getValue())).map(Map.Entry::getKey);
    }
}

