/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.queues.TaskQueueSla;
import com.netflix.fenzo.queues.tiered.TierSla;
import com.netflix.fenzo.sla.ResAllocs;
import com.netflix.fenzo.sla.ResAllocsUtil;
import java.util.HashMap;
import java.util.Map;

public class TieredQueueSlas
implements TaskQueueSla {
    private final Map<Integer, TierSla> slas;

    public TieredQueueSlas(Map<Integer, ResAllocs> tierCapacities, Map<Integer, Map<String, ResAllocs>> slas) {
        HashMap<Integer, TierSla> tmpResAllocsMap = new HashMap<Integer, TierSla>();
        if (!slas.isEmpty()) {
            for (Map.Entry<Integer, Map<String, ResAllocs>> entry : slas.entrySet()) {
                int tierNumber = entry.getKey();
                Map<String, ResAllocs> tierAllocs = entry.getValue();
                TierSla tierSla = new TierSla();
                tierSla.setTierCapacity(this.getOrComputeTierCapacity(tierNumber, tierCapacities.get(tierNumber), tierAllocs));
                for (Map.Entry<String, ResAllocs> e : tierAllocs.entrySet()) {
                    tierSla.setAlloc(e.getKey(), e.getValue());
                }
                tmpResAllocsMap.put(tierNumber, tierSla);
            }
        }
        tierCapacities.forEach((tierIndex, capacity) -> {
            if (!tmpResAllocsMap.containsKey(tierIndex)) {
                TierSla tierSla = new TierSla();
                tierSla.setTierCapacity((ResAllocs)tierCapacities.get(tierIndex));
                tmpResAllocsMap.put((Integer)tierIndex, tierSla);
            }
        });
        this.slas = tmpResAllocsMap;
    }

    private ResAllocs getOrComputeTierCapacity(int tierNumber, ResAllocs tierCapacity, Map<String, ResAllocs> queueAllocs) {
        if (tierCapacity != null) {
            return tierCapacity;
        }
        String tierName = "tier#" + tierNumber;
        if (queueAllocs.isEmpty()) {
            return ResAllocsUtil.emptyOf(tierName);
        }
        return queueAllocs.values().stream().reduce(ResAllocsUtil.emptyOf(tierName), ResAllocsUtil::add);
    }

    Map<Integer, TierSla> getSlas() {
        return this.slas;
    }
}

