/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful;

import com.google.common.base.Strings;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.NettyRuntime;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.NettyRestfulServiceConfiguration;
import org.apache.shardingsphere.elasticjob.restful.RestfulService;
import org.apache.shardingsphere.elasticjob.restful.pipeline.RestfulServiceChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRestfulService
implements RestfulService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyRestfulService.class);
    private static final int DEFAULT_WORKER_GROUP_THREADS = 1 + 2 * NettyRuntime.availableProcessors();
    private final NettyRestfulServiceConfiguration configuration;
    private ServerBootstrap serverBootstrap;
    private EventLoopGroup bossEventLoopGroup;
    private EventLoopGroup workerEventLoopGroup;

    private void initServerBootstrap() {
        this.bossEventLoopGroup = new NioEventLoopGroup();
        this.workerEventLoopGroup = new NioEventLoopGroup(DEFAULT_WORKER_GROUP_THREADS);
        this.serverBootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.bossEventLoopGroup, this.workerEventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new RestfulServiceChannelInitializer(this.configuration));
    }

    @Override
    public void startup() {
        this.initServerBootstrap();
        ChannelFuture channelFuture = !Strings.isNullOrEmpty((String)this.configuration.getHost()) ? this.serverBootstrap.bind(this.configuration.getHost(), this.configuration.getPort()) : this.serverBootstrap.bind(this.configuration.getPort());
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                log.info("Restful Service started on port {}.", (Object)this.configuration.getPort());
            } else {
                log.error("Failed to start Restful Service.", future.cause());
            }
        }).sync();
    }

    @Override
    public void shutdown() {
        this.bossEventLoopGroup.shutdownGracefully();
        this.workerEventLoopGroup.shutdownGracefully();
    }

    @Generated
    public NettyRestfulService(NettyRestfulServiceConfiguration configuration) {
        this.configuration = configuration;
    }
}

