/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.annotation.Param;
import org.apache.shardingsphere.elasticjob.restful.annotation.ParamSource;
import org.apache.shardingsphere.elasticjob.restful.annotation.RequestBody;
import org.apache.shardingsphere.elasticjob.restful.annotation.Returning;
import org.apache.shardingsphere.elasticjob.restful.handler.HandlerParameter;

public final class Handler {
    private final Object instance;
    private final Method handleMethod;
    private final List<HandlerParameter> handlerParameters;
    private final int httpStatusCode;
    private final String producing;

    public Handler(Object instance, Method handleMethod) {
        this.instance = instance;
        this.handleMethod = handleMethod;
        this.handlerParameters = this.parseHandleMethodParameter();
        this.httpStatusCode = this.parseReturning();
        this.producing = this.parseProducing();
    }

    public Object execute(Object ... args) throws InvocationTargetException, IllegalAccessException {
        return this.handleMethod.invoke(this.instance, args);
    }

    private List<HandlerParameter> parseHandleMethodParameter() {
        LinkedList<HandlerParameter> params = new LinkedList<HandlerParameter>();
        Parameter[] parameters = this.handleMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            RequestBody requestBody;
            Parameter parameter = parameters[i];
            Param annotation = parameter.getAnnotation(Param.class);
            HandlerParameter handlerParameter = null != annotation ? new HandlerParameter(i, parameter.getType(), annotation.source(), annotation.name(), annotation.required()) : (null != (requestBody = parameter.getAnnotation(RequestBody.class)) ? new HandlerParameter(i, parameter.getType(), ParamSource.BODY, parameter.getName(), requestBody.required()) : new HandlerParameter(i, parameter.getType(), ParamSource.UNKNOWN, parameter.getName(), false));
            params.add(handlerParameter);
        }
        return Collections.unmodifiableList(params);
    }

    private int parseReturning() {
        Returning returning = this.handleMethod.getAnnotation(Returning.class);
        return Optional.ofNullable(returning).map(Returning::code).orElse(200);
    }

    private String parseProducing() {
        Returning returning = this.handleMethod.getAnnotation(Returning.class);
        return Optional.ofNullable(returning).map(Returning::contentType).orElse("application/json; charset=utf-8");
    }

    @Generated
    public List<HandlerParameter> getHandlerParameters() {
        return this.handlerParameters;
    }

    @Generated
    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Generated
    public String getProducing() {
        return this.producing;
    }
}

