/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.mapping;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.shardingsphere.elasticjob.restful.mapping.AmbiguousPathPatternException;
import org.apache.shardingsphere.elasticjob.restful.mapping.DefaultMappingContext;
import org.apache.shardingsphere.elasticjob.restful.mapping.MappingContext;
import org.apache.shardingsphere.elasticjob.restful.mapping.PathMatcher;
import org.apache.shardingsphere.elasticjob.restful.mapping.RegexPathMatcher;
import org.apache.shardingsphere.elasticjob.restful.mapping.UrlPatternMap;

public final class RegexUrlPatternMap<V>
implements UrlPatternMap<V> {
    private static final String PATH_SEPARATOR = "/";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("(?<=/)\\{(?<template>[^/]+)}");
    private final Map<String, MappingContext<V>> map = new LinkedHashMap<String, MappingContext<V>>();
    private final PathMatcher pathMatcher = new RegexPathMatcher();

    @Override
    public void put(String pathPattern, V value) {
        Objects.requireNonNull(pathPattern, "Path pattern must be not null.");
        Preconditions.checkArgument((boolean)this.pathMatcher.isValidPathPattern(pathPattern), (String)"Path pattern [%s] invalid.", (Object)pathPattern);
        String unified = this.unifyPattern(pathPattern);
        DefaultMappingContext<V> mappingContext = new DefaultMappingContext<V>(pathPattern, value);
        if (this.map.containsKey(unified)) {
            throw new IllegalArgumentException(String.format("Duplicate pattern [%s]", unified));
        }
        this.map.put(unified, mappingContext);
    }

    @Override
    public MappingContext<V> match(String path) {
        ArrayList<MappingContext<Object>> hits = new ArrayList<MappingContext<Object>>();
        for (Map.Entry<String, MappingContext<V>> entry : this.map.entrySet()) {
            String pattern = entry.getKey();
            if (pattern.equals(path)) {
                return entry.getValue();
            }
            if (!this.pathMatcher.matches(pattern, path)) continue;
            hits.add(entry.getValue());
        }
        if (hits.isEmpty()) {
            return null;
        }
        if (1 < hits.size()) {
            hits.sort(new MappingComparator().reversed());
        }
        return (MappingContext)hits.get(0);
    }

    private String unifyPattern(String pattern) {
        return TEMPLATE_PATTERN.matcher(pattern).replaceAll("[^/]+");
    }

    static class MappingComparator
    implements Comparator<MappingContext<?>> {
        MappingComparator() {
        }

        @Override
        public int compare(MappingContext<?> o1, MappingContext<?> o2) {
            String[] s1 = o1.pattern().split(RegexUrlPatternMap.PATH_SEPARATOR);
            String[] s2 = o2.pattern().split(RegexUrlPatternMap.PATH_SEPARATOR);
            int len = Math.min(s1.length, s2.length);
            for (int i = 0; i < len; ++i) {
                if (MappingComparator.isTemplate(s1[i]) && !MappingComparator.isTemplate(s2[i])) {
                    return -1;
                }
                if (MappingComparator.isTemplate(s1[i]) || !MappingComparator.isTemplate(s2[i])) continue;
                return 1;
            }
            throw new AmbiguousPathPatternException(MessageFormat.format("Ambiguous path pattern: [{0}], [{1}].", o1.pattern(), o2.pattern()));
        }

        private static boolean isTemplate(String fragment) {
            return fragment.startsWith("{") && fragment.endsWith("}");
        }
    }
}

