/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.InvocationTargetException;
import org.apache.shardingsphere.elasticjob.restful.handler.HandleContext;
import org.apache.shardingsphere.elasticjob.restful.handler.Handler;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializer;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializerFactory;

@ChannelHandler.Sharable
public final class HandleMethodExecutor
extends ChannelInboundHandlerAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HandleContext handleContext = (HandleContext)msg;
        try {
            Handler handler = (Handler)handleContext.getMappingContext().payload();
            Object[] args = handleContext.getArgs();
            Object handleResult = handler.execute(args);
            FullHttpResponse httpResponse = handleContext.getHttpResponse();
            if (null != handleResult) {
                String mimeType = HttpUtil.getMimeType((CharSequence)handler.getProducing()).toString();
                ResponseBodySerializer serializer = ResponseBodySerializerFactory.getResponseBodySerializer(mimeType);
                byte[] bodyBytes = serializer.serialize(handleResult);
                this.populateHttpResponse(httpResponse, handler.getProducing(), bodyBytes, handler.getHttpStatusCode());
            } else {
                this.populateHttpResponse(httpResponse, handler.getProducing(), new byte[0], handler.getHttpStatusCode());
            }
            ctx.writeAndFlush((Object)httpResponse);
        }
        finally {
            ReferenceCountUtil.release((Object)handleContext.getHttpRequest());
        }
    }

    private void populateHttpResponse(FullHttpResponse httpResponse, String producingContentType, byte[] bodyBytes, int statusCode) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)statusCode);
        httpResponse.setStatus(httpResponseStatus);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)producingContentType);
        httpResponse.content().writeBytes(bodyBytes);
        HttpUtil.setContentLength((HttpMessage)httpResponse, (long)httpResponse.content().readableBytes());
        HttpUtil.setKeepAlive((HttpMessage)httpResponse, (boolean)true);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            ctx.fireExceptionCaught(cause.getCause());
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }
}

