/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app;

import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.mesos.Protos;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.MesosStateService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudAppConfigurationListener
implements CuratorCacheListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudAppConfigurationListener.class);
    private final CoordinatorRegistryCenter regCenter;
    private final ProducerManager producerManager;
    private MesosStateService mesosStateService;

    public CloudAppConfigurationListener(CoordinatorRegistryCenter regCenter, ProducerManager producerManager) {
        this.regCenter = regCenter;
        this.producerManager = producerManager;
        this.mesosStateService = new MesosStateService(regCenter);
    }

    public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
        String path;
        String string = path = CuratorCacheListener.Type.NODE_DELETED == type ? oldData.getPath() : data.getPath();
        if (CuratorCacheListener.Type.NODE_DELETED == type && this.isJobAppConfigNode(path)) {
            String appName = path.substring("/config/app".length() + 1);
            this.stopExecutors(appName);
        }
    }

    private boolean isJobAppConfigNode(String path) {
        return path.startsWith("/config/app") && path.length() > "/config/app".length();
    }

    public void start() {
        this.getCache().listenable().addListener((Object)this, (Executor)Executors.newSingleThreadExecutor());
    }

    public void stop() {
        this.getCache().listenable().removeListener((Object)this);
    }

    private CuratorCache getCache() {
        CuratorCache result = (CuratorCache)this.regCenter.getRawCache("/config/app");
        if (null != result) {
            return result;
        }
        this.regCenter.addCacheData("/config/app");
        return (CuratorCache)this.regCenter.getRawCache("/config/app");
    }

    private void stopExecutors(String appName) {
        try {
            Collection<MesosStateService.ExecutorStateInfo> executorBriefInfo = this.mesosStateService.executors(appName);
            for (MesosStateService.ExecutorStateInfo each : executorBriefInfo) {
                this.producerManager.sendFrameworkMessage(Protos.ExecutorID.newBuilder().setValue(each.getId()).build(), Protos.SlaveID.newBuilder().setValue(each.getSlaveId()).build(), "STOP".getBytes());
            }
        }
        catch (JsonParseException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }
}

