/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationNode;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class CloudJobConfigurationService {
    private final CoordinatorRegistryCenter regCenter;

    public void add(CloudJobConfigurationPOJO cloudJobConfig) {
        this.regCenter.persist(CloudJobConfigurationNode.getRootNodePath(cloudJobConfig.getJobName()), YamlEngine.marshal((Object)cloudJobConfig));
    }

    public void update(CloudJobConfigurationPOJO cloudJobConfig) {
        this.regCenter.update(CloudJobConfigurationNode.getRootNodePath(cloudJobConfig.getJobName()), YamlEngine.marshal((Object)cloudJobConfig));
    }

    public Collection<CloudJobConfigurationPOJO> loadAll() {
        if (!this.regCenter.isExisted("/config/job")) {
            return Collections.emptyList();
        }
        List jobNames = this.regCenter.getChildrenKeys("/config/job");
        ArrayList<CloudJobConfigurationPOJO> result = new ArrayList<CloudJobConfigurationPOJO>(jobNames.size());
        for (String each : jobNames) {
            this.load(each).ifPresent(result::add);
        }
        return result;
    }

    public Optional<CloudJobConfigurationPOJO> load(String jobName) {
        String configContent = this.regCenter.get(CloudJobConfigurationNode.getRootNodePath(jobName));
        return Strings.isNullOrEmpty((String)configContent) ? Optional.empty() : Optional.of((CloudJobConfigurationPOJO)YamlEngine.unmarshal((String)configContent, CloudJobConfigurationPOJO.class));
    }

    public void remove(String jobName) {
        this.regCenter.remove(CloudJobConfigurationNode.getRootNodePath(jobName));
    }

    @Generated
    public CloudJobConfigurationService(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }
}

