/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.app;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.app.DisableAppNode;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableAppService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisableAppService.class);
    private final BootstrapEnvironment env = BootstrapEnvironment.getINSTANCE();
    private final CoordinatorRegistryCenter regCenter;

    public DisableAppService(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }

    public void add(String appName) {
        if (this.regCenter.getNumChildren("/state/disable/app") > this.env.getFrameworkConfiguration().getJobStateQueueSize()) {
            log.warn("Cannot add disable app, caused by read state queue size is larger than {}.", (Object)this.env.getFrameworkConfiguration().getJobStateQueueSize());
            return;
        }
        String disableAppNodePath = DisableAppNode.getDisableAppNodePath(appName);
        if (!this.regCenter.isExisted(disableAppNodePath)) {
            this.regCenter.persist(disableAppNodePath, appName);
        }
    }

    public void remove(String appName) {
        this.regCenter.remove(DisableAppNode.getDisableAppNodePath(appName));
    }

    public boolean isDisabled(String appName) {
        return this.regCenter.isExisted(DisableAppNode.getDisableAppNodePath(appName));
    }
}

