/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.StatisticJob;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.util.StatisticTimeUtils;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;

abstract class AbstractStatisticJob
implements StatisticJob {
    AbstractStatisticJob() {
    }

    String getJobName() {
        return this.getClass().getSimpleName();
    }

    String getTriggerName() {
        return this.getClass().getSimpleName() + "Trigger";
    }

    List<Date> findBlankStatisticTimes(Date latestStatisticTime, StatisticInterval statisticInterval) {
        ArrayList<Date> result = new ArrayList<Date>();
        int previousInterval = -1;
        Date previousTime = StatisticTimeUtils.getStatisticTime(statisticInterval, previousInterval);
        while (previousTime.after(latestStatisticTime)) {
            result.add(previousTime);
            previousTime = StatisticTimeUtils.getStatisticTime(statisticInterval, --previousInterval);
        }
        Collections.sort(result);
        return result;
    }
}

