/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.exception.HttpClientException;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.util.IOUtils;

public final class HttpClientUtils {
    public static HttpResult httpGet(String url) {
        return HttpClientUtils.httpGet(url, null, null, 3000L);
    }

    public static HttpResult httpGet(String url, List<String> paramValues, String encoding, long readTimeoutMilliseconds) {
        HttpURLConnection connection = null;
        try {
            String encodedContent = HttpClientUtils.encodingParams(paramValues, encoding);
            String urlWithParam = url + (null == encodedContent ? "" : "?" + encodedContent);
            connection = (HttpURLConnection)new URL(urlWithParam).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout((int)readTimeoutMilliseconds);
            connection.setReadTimeout((int)readTimeoutMilliseconds);
            connection.connect();
            String response = 200 == connection.getResponseCode() ? IOUtils.toString(connection.getInputStream(), encoding) : IOUtils.toString(connection.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(connection.getResponseCode(), response);
            return httpResult;
        }
        catch (IOException ex) {
            throw new HttpClientException(ex);
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    private static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        if (null == paramValues || 0 == paramValues.size()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            stringBuilder.append(iter.next()).append("=");
            stringBuilder.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    public static HttpResult httpPost(String url) {
        return HttpClientUtils.httpPost(url, null, null, 3000L);
    }

    public static HttpResult httpPost(String url, List<String> paramValues, String encoding, long readTimeoutMilliseconds) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout((int)readTimeoutMilliseconds);
            connection.setReadTimeout((int)readTimeoutMilliseconds);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.getOutputStream().write(HttpClientUtils.encodingParams(paramValues, encoding).getBytes(StandardCharsets.UTF_8));
            String response = 200 == connection.getResponseCode() ? IOUtils.toString(connection.getInputStream(), encoding) : IOUtils.toString(connection.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(connection.getResponseCode(), response);
            return httpResult;
        }
        catch (IOException ex) {
            throw new HttpClientException(ex);
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    @Generated
    private HttpClientUtils() {
    }

    public static class HttpResult {
        private final int code;
        private final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getContent() {
            return this.content;
        }
    }
}

