/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.executor.error.handler;

import java.io.Closeable;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.spi.executor.error.handler.JobErrorHandler;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class JobErrorHandlerReloader
implements Closeable {
    private Properties props;
    private JobErrorHandler jobErrorHandler;

    public JobErrorHandlerReloader(JobConfiguration jobConfig) {
        this.init(jobConfig);
    }

    public synchronized void reloadIfNecessary(JobConfiguration jobConfig) {
        if (this.jobErrorHandler.getType().equals(jobConfig.getJobErrorHandlerType()) && this.props.equals(jobConfig.getProps())) {
            return;
        }
        this.jobErrorHandler.close();
        this.init(jobConfig);
    }

    private void init(JobConfiguration jobConfig) {
        this.props = jobConfig.getProps();
        this.jobErrorHandler = (JobErrorHandler)TypedSPILoader.getService(JobErrorHandler.class, (Object)jobConfig.getJobErrorHandlerType(), (Properties)this.props);
    }

    @Override
    public void close() {
        this.jobErrorHandler.close();
    }

    @Generated
    public JobErrorHandler getJobErrorHandler() {
        return this.jobErrorHandler;
    }
}

