/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.listener;

import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.kernel.infra.time.TimeService;
import org.apache.shardingsphere.elasticjob.kernel.infra.util.BlockUtils;
import org.apache.shardingsphere.elasticjob.kernel.internal.guarantee.GuaranteeService;
import org.apache.shardingsphere.elasticjob.spi.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.spi.listener.param.ShardingContexts;

public abstract class AbstractDistributeOnceElasticJobListener
implements ElasticJobListener {
    private final long startedTimeoutMilliseconds;
    private final Object startedWait = new Object();
    private final long completedTimeoutMilliseconds;
    private final Object completedWait = new Object();
    private GuaranteeService guaranteeService;
    private final TimeService timeService = new TimeService();

    public AbstractDistributeOnceElasticJobListener(long startedTimeoutMilliseconds, long completedTimeoutMilliseconds) {
        this.startedTimeoutMilliseconds = startedTimeoutMilliseconds <= 0L ? Long.MAX_VALUE : startedTimeoutMilliseconds;
        this.completedTimeoutMilliseconds = completedTimeoutMilliseconds <= 0L ? Long.MAX_VALUE : completedTimeoutMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeJobExecuted(ShardingContexts shardingContexts) {
        Set<Integer> shardingItems = shardingContexts.getShardingItemParameters().keySet();
        if (shardingItems.isEmpty()) {
            return;
        }
        this.guaranteeService.registerStart(shardingItems);
        while (!this.guaranteeService.isRegisterStartSuccess(shardingItems)) {
            BlockUtils.waitingShortTime();
        }
        if (this.guaranteeService.isAllStarted()) {
            this.guaranteeService.executeInLeaderForLastStarted(this, shardingContexts);
            return;
        }
        long before = this.timeService.getCurrentMillis();
        try {
            Object object = this.startedWait;
            synchronized (object) {
                this.startedWait.wait(this.startedTimeoutMilliseconds);
            }
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        if (this.timeService.getCurrentMillis() - before >= this.startedTimeoutMilliseconds) {
            this.guaranteeService.clearAllStartedInfo();
            this.handleTimeout(this.startedTimeoutMilliseconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterJobExecuted(ShardingContexts shardingContexts) {
        Set<Integer> shardingItems = shardingContexts.getShardingItemParameters().keySet();
        if (shardingItems.isEmpty()) {
            return;
        }
        this.guaranteeService.registerComplete(shardingItems);
        while (!this.guaranteeService.isRegisterCompleteSuccess(shardingItems)) {
            BlockUtils.waitingShortTime();
        }
        if (this.guaranteeService.isAllCompleted()) {
            this.guaranteeService.executeInLeaderForLastCompleted(this, shardingContexts);
            return;
        }
        long before = this.timeService.getCurrentMillis();
        try {
            Object object = this.completedWait;
            synchronized (object) {
                this.completedWait.wait(this.completedTimeoutMilliseconds);
            }
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        if (this.timeService.getCurrentMillis() - before >= this.completedTimeoutMilliseconds) {
            this.guaranteeService.clearAllCompletedInfo();
            this.handleTimeout(this.completedTimeoutMilliseconds);
        }
    }

    private void handleTimeout(long timeoutMilliseconds) {
        throw new JobSystemException("Job timeout. timeout mills is %s.", timeoutMilliseconds);
    }

    public abstract void doBeforeJobExecutedAtLastStarted(ShardingContexts var1);

    public abstract void doAfterJobExecutedAtLastCompleted(ShardingContexts var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaitingTaskStart() {
        Object object = this.startedWait;
        synchronized (object) {
            this.startedWait.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaitingTaskComplete() {
        Object object = this.completedWait;
        synchronized (object) {
            this.completedWait.notifyAll();
        }
    }

    @Generated
    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }
}

