/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.SourceFile;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.Type;

public class ClassGen
extends Modifiers
implements Cloneable {
    private String classname;
    private String superclassname;
    private String filename;
    private int classnameIndex = -1;
    private int superclassnameIndex = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPool cpool;
    private List<Field> fieldsList = new ArrayList<Field>();
    private List<Method> methodsList = new ArrayList<Method>();
    private List<Attribute> attributesList = new ArrayList<Attribute>();
    private List<String> interfaceList = new ArrayList<String>();
    private List<AnnotationGen> annotationsList = new ArrayList<AnnotationGen>();

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray, ConstantPool constantPool) {
        this.classname = string;
        this.superclassname = string2;
        this.filename = string3;
        this.modifiers = n;
        this.cpool = constantPool;
        if (string3 != null) {
            this.addAttribute(new SourceFile(constantPool.addUtf8("SourceFile"), 2, constantPool.addUtf8(string3), constantPool));
        }
        this.classnameIndex = constantPool.addClass(string);
        this.superclassnameIndex = constantPool.addClass(string2);
        if (stringArray != null) {
            for (String string4 : stringArray) {
                this.addInterface(string4);
            }
        }
    }

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray) {
        this(string, string2, string3, n, stringArray, new ConstantPool());
    }

    public ClassGen(JavaClass javaClass) {
        int n;
        Attribute[] attributeArray;
        this.classnameIndex = javaClass.getClassNameIndex();
        this.superclassnameIndex = javaClass.getSuperclassNameIndex();
        this.classname = javaClass.getClassName();
        this.superclassname = javaClass.getSuperclassName();
        this.filename = javaClass.getSourceFileName();
        this.modifiers = javaClass.getModifiers();
        this.cpool = javaClass.getConstantPool().copy();
        this.major = javaClass.getMajor();
        this.minor = javaClass.getMinor();
        Method[] methodArray = javaClass.getMethods();
        Field[] fieldArray = javaClass.getFields();
        String[] stringArray = javaClass.getInterfaceNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addInterface(stringArray[i]);
        }
        for (Attribute attribute : attributeArray = javaClass.getAttributes()) {
            List<AnnotationGen> list;
            RuntimeAnnos runtimeAnnos;
            if (attribute instanceof RuntimeVisAnnos) {
                runtimeAnnos = (RuntimeVisAnnos)attribute;
                list = runtimeAnnos.getAnnotations();
                for (AnnotationGen annotationGen : list) {
                    this.annotationsList.add(new AnnotationGen(annotationGen, this.cpool, false));
                }
                continue;
            }
            if (attribute instanceof RuntimeInvisAnnos) {
                runtimeAnnos = (RuntimeInvisAnnos)attribute;
                list = runtimeAnnos.getAnnotations();
                for (AnnotationGen annotationGen : list) {
                    this.annotationsList.add(new AnnotationGen(annotationGen, this.cpool, false));
                }
                continue;
            }
            this.attributesList.add(attribute);
        }
        for (n = 0; n < methodArray.length; ++n) {
            this.addMethod(methodArray[n]);
        }
        for (n = 0; n < fieldArray.length; ++n) {
            this.addField(fieldArray[n]);
        }
    }

    public JavaClass getJavaClass() {
        int[] nArray = this.getInterfaces();
        Field[] fieldArray = this.getFields();
        Method[] methodArray = this.getMethods();
        List<Attribute> list = null;
        if (this.annotationsList.size() == 0) {
            list = this.attributesList;
        } else {
            list = new ArrayList<Attribute>();
            list.addAll(Utility.getAnnotationAttributes(this.cpool, this.annotationsList));
            list.addAll(this.attributesList);
        }
        ConstantPool constantPool = this.cpool.getFinalConstantPool();
        return new JavaClass(this.classnameIndex, this.superclassnameIndex, this.filename, this.major, this.minor, this.modifiers, constantPool, nArray, fieldArray, methodArray, list.toArray(new Attribute[list.size()]));
    }

    public void addInterface(String string) {
        this.interfaceList.add(string);
    }

    public void removeInterface(String string) {
        this.interfaceList.remove(string);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute attribute) {
        this.attributesList.add(attribute);
    }

    public void addAnnotation(AnnotationGen annotationGen) {
        this.annotationsList.add(annotationGen);
    }

    public void addMethod(Method method) {
        this.methodsList.add(method);
    }

    public void addEmptyConstructor(int n) {
        InstructionList instructionList = new InstructionList();
        instructionList.append(InstructionConstants.THIS);
        instructionList.append(new InvokeInstruction(183, this.cpool.addMethodref(this.superclassname, "<init>", "()V")));
        instructionList.append(InstructionConstants.RETURN);
        MethodGen methodGen = new MethodGen(n, Type.VOID, Type.NO_ARGS, null, "<init>", this.classname, instructionList, this.cpool);
        methodGen.setMaxStack(1);
        methodGen.setMaxLocals();
        this.addMethod(methodGen.getMethod());
    }

    public void addField(Field field) {
        this.fieldsList.add(field);
    }

    public boolean containsField(Field field) {
        return this.fieldsList.contains(field);
    }

    public Field containsField(String string) {
        for (Field field : this.fieldsList) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public Method containsMethod(String string, String string2) {
        for (Method method : this.methodsList) {
            if (!method.getName().equals(string) || !method.getSignature().equals(string2)) continue;
            return method;
        }
        return null;
    }

    public void removeAttribute(Attribute attribute) {
        this.attributesList.remove(attribute);
    }

    public void removeAnnotation(AnnotationGen annotationGen) {
        this.annotationsList.remove(annotationGen);
    }

    public void removeMethod(Method method) {
        this.methodsList.remove(method);
    }

    public void replaceMethod(Method method, Method method2) {
        if (method2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.methodsList.indexOf(method);
        if (n < 0) {
            this.methodsList.add(method2);
        } else {
            this.methodsList.set(n, method2);
        }
    }

    public void replaceField(Field field, Field field2) {
        if (field2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.fieldsList.indexOf(field);
        if (n < 0) {
            this.fieldsList.add(field2);
        } else {
            this.fieldsList.set(n, field2);
        }
    }

    public void removeField(Field field) {
        this.fieldsList.remove(field);
    }

    public String getClassName() {
        return this.classname;
    }

    public String getSuperclassName() {
        return this.superclassname;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setClassName(String string) {
        this.classname = string.replace('/', '.');
        this.classnameIndex = this.cpool.addClass(string);
    }

    public void setSuperclassName(String string) {
        this.superclassname = string.replace('/', '.');
        this.superclassnameIndex = this.cpool.addClass(string);
    }

    public Method[] getMethods() {
        Method[] methodArray = new Method[this.methodsList.size()];
        this.methodsList.toArray(methodArray);
        return methodArray;
    }

    public void setMethods(Method[] methodArray) {
        this.methodsList.clear();
        for (int i = 0; i < methodArray.length; ++i) {
            this.addMethod(methodArray[i]);
        }
    }

    public void setFields(Field[] fieldArray) {
        this.fieldsList.clear();
        for (int i = 0; i < fieldArray.length; ++i) {
            this.addField(fieldArray[i]);
        }
    }

    public void setMethodAt(Method method, int n) {
        this.methodsList.set(n, method);
    }

    public Method getMethodAt(int n) {
        return this.methodsList.get(n);
    }

    public String[] getInterfaceNames() {
        int n = this.interfaceList.size();
        String[] stringArray = new String[n];
        this.interfaceList.toArray(stringArray);
        return stringArray;
    }

    public int[] getInterfaces() {
        int n = this.interfaceList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.cpool.addClass(this.interfaceList.get(i));
        }
        return nArray;
    }

    public Field[] getFields() {
        Field[] fieldArray = new Field[this.fieldsList.size()];
        this.fieldsList.toArray(fieldArray);
        return fieldArray;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributesList;
    }

    public AnnotationGen[] getAnnotations() {
        AnnotationGen[] annotationGenArray = new AnnotationGen[this.annotationsList.size()];
        this.annotationsList.toArray(annotationGenArray);
        return annotationGenArray;
    }

    public ConstantPool getConstantPool() {
        return this.cpool;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.cpool = constantPool;
    }

    public void setClassNameIndex(int n) {
        this.classnameIndex = n;
        this.classname = this.cpool.getConstantString(n, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int n) {
        this.superclassnameIndex = n;
        this.superclassname = this.cpool.getConstantString(n, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclassnameIndex;
    }

    public int getClassNameIndex() {
        return this.classnameIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public final boolean isAnnotation() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public long getSUID() {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.getClassName());
            int n2 = 0;
            n2 |= this.isPublic() ? 1 : 0;
            n2 |= this.isFinal() ? 16 : 0;
            n2 |= this.isInterface() ? 512 : 0;
            if (this.isAbstract()) {
                if (this.isInterface()) {
                    if (this.methodsList.size() > 0) {
                        n2 |= 0x400;
                    }
                } else {
                    n2 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n2);
            Object[] objectArray = this.getInterfaceNames();
            if (objectArray != null) {
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    dataOutputStream.writeUTF((String)objectArray[i]);
                }
            }
            ArrayList<Field> arrayList = new ArrayList<Field>();
            for (Field object32 : this.fieldsList) {
                if (object32.isPrivate() && object32.isStatic() || object32.isPrivate() && object32.isTransient()) continue;
                arrayList.add(object32);
            }
            Collections.sort(arrayList, new FieldComparator());
            int n3 = 223;
            for (Field field : arrayList) {
                dataOutputStream.writeUTF(field.getName());
                dataOutputStream.writeInt(n3 & field.getModifiers());
                dataOutputStream.writeUTF(field.getType().getSignature());
            }
            ArrayList<Method> arrayList2 = new ArrayList<Method>();
            ArrayList<Method> arrayList3 = new ArrayList<Method>();
            boolean bl = false;
            for (Method method : this.methodsList) {
                boolean bl2;
                boolean bl3 = bl2 = method.getName().charAt(0) == '<';
                if (bl2 && method.getName().equals("<clinit>")) {
                    bl = true;
                    continue;
                }
                if (bl2 && method.getName().equals("<init>")) {
                    if (method.isPrivate()) continue;
                    arrayList3.add(method);
                    continue;
                }
                if (method.isPrivate()) continue;
                arrayList2.add(method);
            }
            Collections.sort(arrayList3, new ConstructorComparator());
            Collections.sort(arrayList2, new MethodComparator());
            if (bl) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            n3 = 3391;
            for (Method method : arrayList3) {
                dataOutputStream.writeUTF(method.getName());
                dataOutputStream.writeInt(n3 & method.getModifiers());
                dataOutputStream.writeUTF(method.getSignature().replace('/', '.'));
            }
            for (Method method : arrayList2) {
                dataOutputStream.writeUTF(method.getName());
                dataOutputStream.writeInt(n3 & method.getModifiers());
                dataOutputStream.writeUTF(method.getSignature().replace('/', '.'));
            }
            dataOutputStream.flush();
            dataOutputStream.close();
            Object object = byteArrayOutputStream.toByteArray();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest((byte[])object);
            long l = 0L;
            int n4 = n = byArray.length > 8 ? 7 : byArray.length - 1;
            while (n >= 0) {
                l = l << 8 | (long)byArray[n--] & 0xFFL;
            }
            return l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Unable to calculate suid for " + this.getClassName() + ": " + exception.toString());
        }
    }

    public boolean hasAttribute(String string) {
        for (Attribute attribute : this.attributesList) {
            if (!attribute.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Attribute getAttribute(String string) {
        for (Attribute attribute : this.attributesList) {
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method method, Method method2) {
            int n = method.getName().compareTo(method2.getName());
            if (n == 0) {
                n = method.getSignature().compareTo(method2.getSignature());
            }
            return n;
        }
    }

    private static class ConstructorComparator
    implements Comparator<Method> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(Method method, Method method2) {
            return method.getSignature().compareTo(method2.getSignature());
        }
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field field, Field field2) {
            return field.getName().compareTo(field2.getName());
        }
    }
}

