/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.IINC;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionByte;
import org.aspectj.apache.bcel.generic.InstructionCP;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionLV;
import org.aspectj.apache.bcel.generic.InstructionShort;
import org.aspectj.apache.bcel.generic.InvokeDynamic;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.LOOKUPSWITCH;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.TABLESWITCH;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.ByteSequence;

public class Instruction
implements Cloneable,
Serializable,
Constants {
    public short opcode = (short)-1;

    public Instruction(short s) {
        this.opcode = s;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
    }

    public String getName() {
        return Constants.OPCODE_NAMES[this.opcode];
    }

    public final Instruction copy() {
        if (InstructionConstants.INSTRUCTIONS[this.opcode] != null) {
            return this;
        }
        Instruction instruction = null;
        try {
            instruction = (Instruction)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
        }
        return instruction;
    }

    public static final Instruction readInstruction(ByteSequence byteSequence) throws IOException {
        Instruction instruction;
        boolean bl = false;
        short s = (short)byteSequence.readUnsignedByte();
        if (s == 196) {
            bl = true;
            s = (short)byteSequence.readUnsignedByte();
        }
        if ((instruction = InstructionConstants.INSTRUCTIONS[s]) != null) {
            return instruction;
        }
        Instruction instruction2 = null;
        try {
            switch (s) {
                case 16: {
                    instruction2 = new InstructionByte(16, byteSequence.readByte());
                    break;
                }
                case 17: {
                    instruction2 = new InstructionShort(17, byteSequence.readShort());
                    break;
                }
                case 18: {
                    instruction2 = new InstructionCP(18, byteSequence.readUnsignedByte());
                    break;
                }
                case 19: 
                case 20: {
                    instruction2 = new InstructionCP(s, byteSequence.readUnsignedShort());
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    instruction2 = new InstructionLV(s, bl ? byteSequence.readUnsignedShort() : byteSequence.readUnsignedByte());
                    break;
                }
                case 132: {
                    instruction2 = new IINC(bl ? byteSequence.readUnsignedShort() : byteSequence.readUnsignedByte(), bl ? byteSequence.readShort() : (short)byteSequence.readByte(), bl);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    instruction2 = new InstructionBranch(s, byteSequence.readShort());
                    break;
                }
                case 200: 
                case 201: {
                    instruction2 = new InstructionBranch(s, byteSequence.readInt());
                    break;
                }
                case 170: {
                    instruction2 = new TABLESWITCH(byteSequence);
                    break;
                }
                case 171: {
                    instruction2 = new LOOKUPSWITCH(byteSequence);
                    break;
                }
                case 169: {
                    instruction2 = new RET(bl ? byteSequence.readUnsignedShort() : byteSequence.readUnsignedByte(), bl);
                    break;
                }
                case 187: {
                    instruction2 = new InstructionCP(187, byteSequence.readUnsignedShort());
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    instruction2 = new FieldInstruction(s, byteSequence.readUnsignedShort());
                    break;
                }
                case 182: 
                case 183: 
                case 184: {
                    instruction2 = new InvokeInstruction(s, byteSequence.readUnsignedShort());
                    break;
                }
                case 185: {
                    instruction2 = new INVOKEINTERFACE(byteSequence.readUnsignedShort(), byteSequence.readUnsignedByte(), byteSequence.readByte());
                    break;
                }
                case 186: {
                    instruction2 = new InvokeDynamic(byteSequence.readUnsignedShort(), byteSequence.readUnsignedShort());
                    break;
                }
                case 188: {
                    instruction2 = new InstructionByte(188, byteSequence.readByte());
                    break;
                }
                case 189: 
                case 192: {
                    instruction2 = new InstructionCP(s, byteSequence.readUnsignedShort());
                    break;
                }
                case 193: {
                    instruction2 = new InstructionCP(193, byteSequence.readUnsignedShort());
                    break;
                }
                case 197: {
                    instruction2 = new MULTIANEWARRAY(byteSequence.readUnsignedShort(), byteSequence.readByte());
                    break;
                }
                default: {
                    throw new ClassGenException("Illegal opcode detected");
                }
            }
        }
        catch (ClassGenException classGenException) {
            throw classGenException;
        }
        catch (Exception exception) {
            throw new ClassGenException(exception.toString());
        }
        return instruction2;
    }

    public int consumeStack(ConstantPool constantPool) {
        return Constants.CONSUME_STACK[this.opcode];
    }

    public int produceStack(ConstantPool constantPool) {
        return Constants.stackEntriesProduced[this.opcode];
    }

    public short getOpcode() {
        return this.opcode;
    }

    public int getLength() {
        byte by = Constants.iLen[this.opcode];
        assert (by != 0);
        return by;
    }

    void dispose() {
    }

    public boolean equals(Object object) {
        if (this.getClass() != Instruction.class) {
            throw new RuntimeException("NO WAY " + this.getClass());
        }
        if (!(object instanceof Instruction)) {
            return false;
        }
        return ((Instruction)object).opcode == this.opcode;
    }

    public int hashCode() {
        if (this.getClass() != Instruction.class) {
            throw new RuntimeException("NO WAY " + this.getClass());
        }
        return this.opcode * 37;
    }

    public Type getType() {
        return this.getType(null);
    }

    public Type getType(ConstantPool constantPool) {
        Type type = Constants.types[this.opcode];
        if (type != null) {
            return type;
        }
        throw new RuntimeException("Do not know type for instruction " + this.getName() + "(" + this.opcode + ")");
    }

    public Number getValue() {
        assert ((instFlags[this.opcode] & 2L) == 0L);
        switch (this.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new Integer(this.opcode - 3);
            }
        }
        throw new IllegalStateException("Not implemented yet for " + this.getName());
    }

    public int getIndex() {
        return -1;
    }

    public void setIndex(int n) {
        throw new IllegalStateException("Shouldnt be asking " + this.getName().toUpperCase());
    }

    public Object getValue(ConstantPool constantPool) {
        throw new IllegalStateException("Shouldnt be asking " + this.getName().toUpperCase());
    }

    public boolean isLoadInstruction() {
        return (Constants.instFlags[this.opcode] & 0x20L) != 0L;
    }

    public boolean isASTORE() {
        return false;
    }

    public boolean isALOAD() {
        return false;
    }

    public boolean isStoreInstruction() {
        return (Constants.instFlags[this.opcode] & 0x100L) != 0L;
    }

    public boolean isJsrInstruction() {
        return (Constants.instFlags[this.opcode] & 0x4000L) != 0L;
    }

    public boolean isConstantInstruction() {
        return (Constants.instFlags[this.opcode] & 2L) != 0L;
    }

    public boolean isConstantPoolInstruction() {
        return (Constants.instFlags[this.opcode] & 8L) != 0L;
    }

    public boolean isStackProducer() {
        return Constants.stackEntriesProduced[this.opcode] != 0;
    }

    public boolean isStackConsumer() {
        return Constants.CONSUME_STACK[this.opcode] != 0;
    }

    public boolean isIndexedInstruction() {
        return (Constants.instFlags[this.opcode] & 0x10L) != 0L;
    }

    public boolean isArrayCreationInstruction() {
        return this.opcode == 188 || this.opcode == 189 || this.opcode == 197;
    }

    public ObjectType getLoadClassType(ConstantPool constantPool) {
        assert ((Constants.instFlags[this.opcode] & 4L) == 0L);
        Type type = this.getType(constantPool);
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getBasicType();
        }
        return type instanceof ObjectType ? (ObjectType)type : null;
    }

    public boolean isReturnInstruction() {
        return (Constants.instFlags[this.opcode] & 0x8000L) != 0L;
    }

    public boolean isLocalVariableInstruction() {
        return (Constants.instFlags[this.opcode] & 0x40L) != 0L;
    }

    public String toString(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getName()).append("[").append(this.opcode).append("](size").append(Constants.iLen[this.opcode]).append(")");
            return stringBuffer.toString();
        }
        return this.getName();
    }

    public String toString() {
        return this.toString(true);
    }
}

