/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.state.failover;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.failover.FailoverNode;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.failover.FailoverTaskInfo;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class FailoverService {
    private static final Logger log = LoggerFactory.getLogger(FailoverService.class);
    @Autowired
    private CoordinatorRegistryCenter regCenter;

    public Map<String, Collection<FailoverTaskInfo>> getAllFailoverTasks() {
        if (!this.regCenter.isExisted("/state/failover")) {
            return Collections.emptyMap();
        }
        List jobNames = this.regCenter.getChildrenKeys("/state/failover");
        HashMap<String, Collection<FailoverTaskInfo>> result = new HashMap<String, Collection<FailoverTaskInfo>>(jobNames.size(), 1.0f);
        for (String each : jobNames) {
            Collection<FailoverTaskInfo> failoverTasks = this.getFailoverTasks(each);
            if (failoverTasks.isEmpty()) continue;
            result.put(each, failoverTasks);
        }
        return result;
    }

    private Collection<FailoverTaskInfo> getFailoverTasks(String jobName) {
        List failOverTasks = this.regCenter.getChildrenKeys(FailoverNode.getFailoverJobNodePath(jobName));
        ArrayList<FailoverTaskInfo> result = new ArrayList<FailoverTaskInfo>(failOverTasks.size());
        for (String each : failOverTasks) {
            String originalTaskId = this.regCenter.get(FailoverNode.getFailoverTaskNodePath(each));
            if (Strings.isNullOrEmpty((String)originalTaskId)) continue;
            result.add(new FailoverTaskInfo(TaskContext.MetaInfo.from((String)each), originalTaskId));
        }
        return result;
    }
}

