/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.web.controller;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shardingsphere.elasticjob.cloud.ui.domain.RegistryCenterConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.RegistryCenterConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.RegistryCenterFactory;
import org.apache.shardingsphere.elasticjob.cloud.ui.util.SessionRegistryCenterConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResultUtil;
import org.apache.shardingsphere.elasticjob.reg.exception.RegException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/registry-center"})
public final class RegistryCenterController {
    public static final String REG_CENTER_CONFIG_KEY = "reg_center_config_key";
    private RegistryCenterConfigurationService regCenterService;

    @Autowired
    public RegistryCenterController(RegistryCenterConfigurationService regCenterService) {
        this.regCenterService = regCenterService;
    }

    @GetMapping(value={"/activated"})
    public ResponseResult<RegistryCenterConfiguration> activated() {
        return ResponseResultUtil.build(this.regCenterService.loadActivated().get());
    }

    @GetMapping(value={"/load"})
    public ResponseResult<Collection<RegistryCenterConfiguration>> load(HttpServletRequest request) {
        this.regCenterService.loadActivated().ifPresent(regCenterConfig -> this.setRegistryCenterNameToSession((RegistryCenterConfiguration)regCenterConfig, request.getSession()));
        return ResponseResultUtil.build(this.regCenterService.loadAll().getRegistryCenterConfiguration());
    }

    @PostMapping(value={"/add"})
    public ResponseResult<Boolean> add(@RequestBody RegistryCenterConfiguration config) {
        return ResponseResultUtil.build(this.regCenterService.add(config));
    }

    @DeleteMapping
    public ResponseResult delete(@RequestBody RegistryCenterConfiguration config) {
        this.regCenterService.delete(config.getName());
        return ResponseResultUtil.success();
    }

    @PostMapping(value={"/connect"})
    public ResponseResult<Boolean> connect(@RequestBody RegistryCenterConfiguration config, HttpServletRequest request) {
        boolean isConnected = this.setRegistryCenterNameToSession(this.regCenterService.find(config.getName(), this.regCenterService.loadAll()), request.getSession());
        if (isConnected) {
            this.regCenterService.load(config.getName());
        }
        return ResponseResultUtil.build(isConnected);
    }

    private boolean setRegistryCenterNameToSession(RegistryCenterConfiguration regCenterConfig, HttpSession session) {
        session.setAttribute(REG_CENTER_CONFIG_KEY, (Object)regCenterConfig);
        try {
            RegistryCenterFactory.createCoordinatorRegistryCenter(regCenterConfig.getZkAddressList(), regCenterConfig.getNamespace(), regCenterConfig.getDigest());
            SessionRegistryCenterConfiguration.setRegistryCenterConfiguration((RegistryCenterConfiguration)session.getAttribute(REG_CENTER_CONFIG_KEY));
        }
        catch (RegException ex) {
            return false;
        }
        return true;
    }
}

