/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openjpa.enhance.ApplicationIdTool;
import org.apache.openjpa.enhance.CodeGenerator;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.DiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.NoneMappingDefaults;
import org.apache.openjpa.jdbc.meta.PropertiesReverseCustomizer;
import org.apache.openjpa.jdbc.meta.ReverseCustomizer;
import org.apache.openjpa.jdbc.meta.StrategyInstaller;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.AbstractFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.FullClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedBlobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedClobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.PrimitiveFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationCollectionInverseKeyFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationCollectionTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.StateComparisonVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.StringFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.SubclassJoinDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.SuperclassDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.SuperclassVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.VerticalClassStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGenerator;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.schema.XMLSchemaParser;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.CodeFormat;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataModes;
import org.apache.openjpa.meta.NoneMetaDataFactory;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import serp.bytecode.BCClass;
import serp.bytecode.BCClassLoader;
import serp.bytecode.Project;

public class ReverseMappingTool
implements MetaDataModes,
Cloneable {
    public static final int TABLE_NONE = 0;
    public static final int TABLE_BASE = 1;
    public static final int TABLE_SECONDARY = 2;
    public static final int TABLE_SECONDARY_OUTER = 3;
    public static final int TABLE_ASSOCIATION = 4;
    public static final int TABLE_SUBCLASS = 5;
    public static final String LEVEL_NONE = "none";
    public static final String LEVEL_PACKAGE = "package";
    public static final String LEVEL_CLASS = "class";
    public static final String ACCESS_TYPE_FIELD = "field";
    public static final String ACCESS_TYPE_PROPERTY = "property";
    private static Localizer _loc = Localizer.forPackage(ReverseMappingTool.class);
    private static final Map _javaKeywords = new HashMap();
    private final JDBCConfiguration _conf;
    private final Log _log;
    private final Map _tables = new HashMap();
    private final Project _project = new Project();
    private final BCClassLoader _loader = AccessController.doPrivileged(J2DoPrivHelper.newBCClassLoaderAction(this._project));
    private StrategyInstaller _strat = null;
    private String _package = null;
    private File _dir = null;
    private MappingRepository _repos = null;
    private SchemaGroup _schema = null;
    private boolean _nullAsObj = false;
    private boolean _blobAsObj = false;
    private boolean _useGenericColl = false;
    private Properties _typeMap = null;
    private boolean _useFK = false;
    private boolean _useSchema = false;
    private boolean _pkOnJoin = false;
    private boolean _datastore = false;
    private boolean _builtin = true;
    private boolean _inner = false;
    private String _idSuffix = "Id";
    private boolean _inverse = true;
    private boolean _detachable = false;
    private boolean _genAnnotations = false;
    private String _accessType = "field";
    private CodeFormat _format = null;
    private ReverseCustomizer _custom = null;
    private String _discStrat = null;
    private String _versStrat = null;
    private boolean _useSchemaElement = true;
    private Set _abandonedFieldNames = null;
    private Map _annos = null;

    public ReverseMappingTool(JDBCConfiguration conf) {
        this._conf = conf;
        this._log = conf.getLog("openjpa.MetaData");
    }

    private StrategyInstaller getStrategyInstaller() {
        if (this._strat == null) {
            this._strat = new ReverseStrategyInstaller(this.getRepository());
        }
        return this._strat;
    }

    public JDBCConfiguration getConfiguration() {
        return this._conf;
    }

    public Log getLog() {
        return this._log;
    }

    public String getPackageName() {
        return this._package;
    }

    public void setPackageName(String packageName) {
        this._package = StringUtil.trimToNull(packageName);
    }

    public File getDirectory() {
        return this._dir;
    }

    public void setDirectory(File dir) {
        this._dir = dir;
    }

    public boolean getUseSchemaName() {
        return this._useSchema;
    }

    public void setUseSchemaName(boolean useSchema) {
        this._useSchema = useSchema;
    }

    public boolean getUseForeignKeyName() {
        return this._useFK;
    }

    public void setUseForeignKeyName(boolean useFK) {
        this._useFK = useFK;
    }

    public boolean getNullableAsObject() {
        return this._nullAsObj;
    }

    public void setNullableAsObject(boolean nullAsObj) {
        this._nullAsObj = nullAsObj;
    }

    public boolean getBlobAsObject() {
        return this._blobAsObj;
    }

    public void setBlobAsObject(boolean blobAsObj) {
        this._blobAsObj = blobAsObj;
    }

    public boolean getUseGenericCollections() {
        return this._useGenericColl;
    }

    public void setUseGenericCollections(boolean useGenericCollections) {
        this._useGenericColl = useGenericCollections;
    }

    public Properties getTypeMap() {
        return this._typeMap;
    }

    public void setTypeMap(Properties typeMap) {
        this._typeMap = typeMap;
    }

    public boolean getPrimaryKeyOnJoin() {
        return this._pkOnJoin;
    }

    public void setPrimaryKeyOnJoin(boolean pkOnJoin) {
        this._pkOnJoin = pkOnJoin;
    }

    public boolean getUseDataStoreIdentity() {
        return this._datastore;
    }

    public void setUseDataStoreIdentity(boolean datastore) {
        this._datastore = datastore;
    }

    public boolean getUseBuiltinIdentityClass() {
        return this._builtin;
    }

    public void setUseBuiltinIdentityClass(boolean builtin) {
        this._builtin = builtin;
    }

    public boolean getInnerIdentityClasses() {
        return this._inner;
    }

    public void setInnerIdentityClasses(boolean inner) {
        this._inner = inner;
    }

    public String getIdentityClassSuffix() {
        return this._idSuffix;
    }

    public void setIdentityClassSuffix(String suffix) {
        this._idSuffix = suffix;
    }

    public boolean getInverseRelations() {
        return this._inverse;
    }

    public void setInverseRelations(boolean inverse) {
        this._inverse = inverse;
    }

    public boolean getDetachable() {
        return this._detachable;
    }

    public void setDetachable(boolean detachable) {
        this._detachable = detachable;
    }

    public String getDiscriminatorStrategy() {
        return this._discStrat;
    }

    public void setDiscriminatorStrategy(String discStrat) {
        this._discStrat = discStrat;
    }

    public String getVersionStrategy() {
        return this._versStrat;
    }

    public void setVersionStrategy(String versionStrat) {
        this._versStrat = versionStrat;
    }

    public boolean getGenerateAnnotations() {
        return this._genAnnotations;
    }

    public void setGenerateAnnotations(boolean genAnnotations) {
        this._genAnnotations = genAnnotations;
    }

    public String getAccessType() {
        return this._accessType;
    }

    public void setAccessType(String accessType) {
        this._accessType = ACCESS_TYPE_PROPERTY.equalsIgnoreCase(accessType) ? ACCESS_TYPE_PROPERTY : ACCESS_TYPE_FIELD;
    }

    public CodeFormat getCodeFormat() {
        return this._format;
    }

    public void setCodeFormat(CodeFormat format) {
        this._format = format;
    }

    public ReverseCustomizer getCustomizer() {
        return this._custom;
    }

    public void setCustomizer(ReverseCustomizer customizer) {
        if (customizer != null) {
            customizer.setTool(this);
        }
        this._custom = customizer;
    }

    public boolean getUseSchemaElement() {
        return this._useSchemaElement;
    }

    public void setUseSchemaElement(boolean useSchemaElement) {
        this._useSchemaElement = useSchemaElement;
    }

    public MappingRepository getRepository() {
        if (this._repos == null) {
            this._repos = this._conf.newMappingRepositoryInstance();
            this._repos.setMetaDataFactory(NoneMetaDataFactory.getInstance());
            this._repos.setMappingDefaults(NoneMappingDefaults.getInstance());
            this._repos.setResolve(0);
            this._repos.setValidate(0);
        }
        return this._repos;
    }

    public void setRepository(MappingRepository repos) {
        this._repos = repos;
    }

    public SchemaGroup getSchemaGroup() {
        if (this._schema == null) {
            SchemaGenerator gen = new SchemaGenerator(this._conf);
            try {
                gen.generateSchemas();
            }
            catch (SQLException se) {
                throw SQLExceptions.getStore(se, this._conf.getDBDictionaryInstance());
            }
            this._schema = gen.getSchemaGroup();
        }
        return this._schema;
    }

    public void setSchemaGroup(SchemaGroup schema) {
        this._schema = schema;
    }

    public ClassMapping[] getMappings() {
        return this.getRepository().getMappings();
    }

    public void run() {
        int i;
        Table[] tables;
        Schema[] schemas = this.getSchemaGroup().getSchemas();
        for (int i2 = 0; i2 < schemas.length; ++i2) {
            tables = schemas[i2].getTables();
            for (int j = 0; j < tables.length; ++j) {
                if (!this.isBaseTable(tables[j])) continue;
                this.mapBaseClass(tables[j]);
            }
        }
        HashSet<Table> subs = null;
        for (int i3 = 0; i3 < schemas.length; ++i3) {
            tables = schemas[i3].getTables();
            for (int j = 0; j < tables.length; ++j) {
                if (this._tables.containsKey(tables[j]) || this.getSecondaryType(tables[j], false) != 5) continue;
                if (subs == null) {
                    subs = new HashSet<Table>();
                }
                subs.add(tables[j]);
            }
        }
        if (subs != null) {
            this.mapSubclasses(subs);
        }
        for (ClassMapping cls : this._tables.values()) {
            this.mapColumns(cls, cls.getTable(), null, false);
        }
        for (int i4 = 0; i4 < schemas.length; ++i4) {
            tables = schemas[i4].getTables();
            for (int j = 0; j < tables.length; ++j) {
                if (this._tables.containsKey(tables[j])) continue;
                this.mapTable(tables[j], this.getSecondaryType(tables[j], false));
            }
        }
        for (ClassMapping cls : this._tables.values()) {
            cls.refSchemaComponents();
            if (cls.getDiscriminator().getStrategy() == null) {
                this.getStrategyInstaller().installStrategy(cls.getDiscriminator());
            }
            cls.getDiscriminator().refSchemaComponents();
            if (cls.getVersion().getStrategy() == null) {
                this.getStrategyInstaller().installStrategy(cls.getVersion());
            }
            cls.getVersion().refSchemaComponents();
            if (cls.getPCSuperclass() == null && cls.getIdentityType() == 2) {
                if (cls.getPrimaryKeyFields().length == 0) {
                    throw new MetaDataException(_loc.get("no-pk-fields", cls));
                }
                if (cls.getObjectIdType() == null || cls.isOpenJPAIdentity() && !ReverseMappingTool.isBuiltinIdentity(cls)) {
                    this.setObjectIdType(cls);
                }
            } else if (cls.getIdentityType() == 1) {
                cls.getPrimaryKeyColumns()[0].setJavaType(6);
            }
            FieldMapping[] fields = cls.getDeclaredFieldMappings();
            for (i = 0; i < fields.length; ++i) {
                fields[i].refSchemaComponents();
                ReverseMappingTool.setColumnJavaType(fields[i]);
                ReverseMappingTool.setColumnJavaType(fields[i].getElementMapping());
            }
        }
        for (ClassMapping cls : this._tables.values()) {
            ReverseMappingTool.setForeignKeyJavaType(cls.getJoinForeignKey());
            FieldMapping[] fields = cls.getDeclaredFieldMappings();
            for (i = 0; i < fields.length; ++i) {
                ReverseMappingTool.setForeignKeyJavaType(fields[i].getJoinForeignKey());
                ReverseMappingTool.setForeignKeyJavaType(fields[i].getForeignKey());
                ReverseMappingTool.setForeignKeyJavaType(fields[i].getElementMapping().getForeignKey());
            }
        }
        ArrayList<Column> unmappedCols = new ArrayList<Column>(5);
        for (int i5 = 0; i5 < schemas.length; ++i5) {
            tables = schemas[i5].getTables();
            for (int j = 0; j < tables.length; ++j) {
                unmappedCols.clear();
                Column[] cols = tables[j].getColumns();
                for (int k = 0; k < cols.length; ++k) {
                    if (cols[k].getRefCount() != 0) continue;
                    unmappedCols.add(cols[k]);
                }
                if (unmappedCols.size() == cols.length) {
                    if (this._custom != null && this._custom.unmappedTable(tables[j])) continue;
                    this._log.info(_loc.get("unmap-table", tables[j]));
                    continue;
                }
                if (unmappedCols.size() <= 0) continue;
                this._log.info(_loc.get("unmap-cols", tables[j], unmappedCols));
            }
        }
        if (this._custom != null) {
            this._custom.close();
        }
        Iterator itr = this._tables.values().iterator();
        while (itr.hasNext()) {
            ((ClassMapping)itr.next()).resolve(3);
        }
    }

    private void mapTable(Table table, int type) {
        switch (type) {
            case 2: 
            case 3: {
                this.mapSecondaryTable(table, type != 2);
                break;
            }
            case 4: {
                this.mapAssociationTable(table);
            }
        }
    }

    private static boolean isBuiltinIdentity(ClassMapping cls) {
        FieldMapping[] fields = cls.getPrimaryKeyFieldMappings();
        if (fields.length != 1) {
            return false;
        }
        switch (fields[0].getDeclaredTypeCode()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private static void setColumnJavaType(ValueMapping vm) {
        Column[] cols = vm.getColumns();
        if (cols.length == 1) {
            cols[0].setJavaType(vm.getDeclaredTypeCode());
        }
    }

    private static void setForeignKeyJavaType(ForeignKey fk) {
        if (fk == null) {
            return;
        }
        Column[] cols = fk.getColumns();
        Column[] pks = fk.getPrimaryKeyColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].getJavaType() != 8) continue;
            cols[i].setJavaType(pks[i].getJavaType());
        }
    }

    public List recordCode() throws IOException {
        return this.recordCode(null);
    }

    public List recordCode(Map<Class<?>, String> output) throws IOException {
        LinkedList<File> written = new LinkedList<File>();
        ClassMapping[] mappings = this.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            if (this._log.isInfoEnabled()) {
                this._log.info(_loc.get("class-code", mappings[i]));
            }
            ApplicationIdTool aid = this.newApplicationIdTool(mappings[i]);
            ReverseCodeGenerator gen = this.getGenerateAnnotations() ? new AnnotatedCodeGenerator(mappings[i], aid) : new ReverseCodeGenerator(mappings[i], aid);
            gen.generateCode();
            if (output == null) {
                gen.writeCode();
                written.add(gen.getFile());
                if (aid == null || aid.isInnerClass()) continue;
                aid.record();
                continue;
            }
            StringWriter writer = new StringWriter();
            gen.writeCode(writer);
            output.put(mappings[i].getDescribedType(), writer.toString());
            if (aid == null || aid.isInnerClass()) continue;
            writer = new StringWriter();
            aid.setWriter(writer);
            aid.record();
            output.put(mappings[i].getObjectIdType(), writer.toString());
        }
        return written;
    }

    public Collection recordMetaData(boolean perClass) throws IOException {
        return this.recordMetaData(perClass, null);
    }

    public Collection recordMetaData(boolean perClass, Map output) throws IOException {
        ClassMetaData[] mappings = this.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            mappings[i].setResolve(3, true);
            mappings[i].setUseSchemaElement(this.getUseSchemaElement());
        }
        MetaDataFactory mdf = this._conf.newMetaDataFactoryInstance();
        mdf.setRepository(this.getRepository());
        mdf.setStoreDirectory(this._dir);
        if (perClass) {
            mdf.setStoreMode(1);
        }
        mdf.store(mappings, new QueryMetaData[0], new SequenceMetaData[0], 3, output);
        TreeSet<File> files = new TreeSet<File>();
        for (int i = 0; i < mappings.length; ++i) {
            if (mappings[i].getSourceFile() == null) continue;
            files.add(mappings[i].getSourceFile());
        }
        return files;
    }

    public void buildAnnotations() {
        HashMap<File, String> output = new HashMap<File, String>();
        ClassMetaData[] mappings = this.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            mappings[i].setResolve(3, true);
            mappings[i].setUseSchemaElement(this.getUseSchemaElement());
        }
        MetaDataFactory mdf = this._conf.newMetaDataFactoryInstance();
        mdf.setRepository(this.getRepository());
        mdf.setStoreDirectory(this._dir);
        mdf.store(mappings, new QueryMetaData[0], new SequenceMetaData[0], 19, output);
        this._annos = output;
    }

    public List getAnnotationsForMeta(Object meta) {
        if (null == this._annos) {
            return null;
        }
        return (List)this._annos.get(meta);
    }

    private ApplicationIdTool newApplicationIdTool(ClassMapping mapping) {
        if (mapping.getIdentityType() == 2 && !mapping.isOpenJPAIdentity() && mapping.getPCSuperclass() == null) {
            ApplicationIdTool tool = new ApplicationIdTool(this._conf, mapping.getDescribedType(), mapping);
            tool.setDirectory(this._dir);
            tool.setCodeFormat(this._format);
            if (!tool.run()) {
                return null;
            }
            return tool;
        }
        return null;
    }

    public ClassMapping getClassMapping(Table table) {
        return (ClassMapping)this._tables.get(table);
    }

    public ClassMapping newClassMapping(Class cls, Table table) {
        ClassMapping mapping = (ClassMapping)this.getRepository().addMetaData(cls);
        Class<?> sup = mapping.getDescribedType().getSuperclass();
        if (sup == Object.class) {
            this.setObjectIdType(mapping);
        } else {
            mapping.setPCSuperclass(sup);
        }
        mapping.setTable(table);
        if (this._detachable) {
            mapping.setDetachable(true);
        }
        this._tables.put(table, mapping);
        return mapping;
    }

    private void setObjectIdType(ClassMapping cls) {
        String name = cls.getDescribedType().getName();
        if (this._inner) {
            name = name + "$";
        }
        name = name + this._idSuffix;
        cls.setObjectIdType(this.generateClass(name, null), false);
    }

    public Class generateClass(String name, Class parent) {
        BCClass bc = this._project.loadClass(name, null);
        if (parent != null) {
            bc.setSuperclass(parent);
        }
        bc.addDefaultConstructor();
        try {
            return Class.forName(name, false, (ClassLoader)this._loader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InternalException(cnfe.toString(), (Throwable)cnfe);
        }
    }

    public boolean isUnique(ForeignKey fk) {
        PrimaryKey pk = fk.getTable().getPrimaryKey();
        if (pk != null && pk.columnsMatch(fk.getColumns())) {
            return true;
        }
        Index[] idx = fk.getTable().getIndexes();
        for (int i = 0; i < idx.length; ++i) {
            if (!idx[i].isUnique() || !idx[i].columnsMatch(fk.getColumns())) continue;
            return true;
        }
        Unique[] unq = fk.getTable().getUniques();
        for (int i = 0; i < unq.length; ++i) {
            if (!unq[i].columnsMatch(fk.getColumns())) continue;
            return true;
        }
        return false;
    }

    public ForeignKey getUniqueForeignKey(Table table) {
        ForeignKey[] fks = table.getForeignKeys();
        PrimaryKey pk = table.getPrimaryKey();
        ForeignKey unq = null;
        int count = 0;
        for (int i = 0; i < fks.length; ++i) {
            if (pk != null && pk.columnsMatch(fks[i].getColumns())) {
                return fks[i];
            }
            if (!this.isUnique(fks[i])) continue;
            ++count;
            if (unq != null) continue;
            unq = fks[i];
        }
        return count == 1 ? unq : null;
    }

    public void addJoinConstraints(FieldMapping field) {
        Unique unq;
        ForeignKey fk = field.getJoinForeignKey();
        if (fk == null) {
            return;
        }
        Index idx = this.findIndex(fk.getColumns());
        if (idx != null) {
            field.setJoinIndex(idx);
        }
        if ((unq = this.findUnique(fk.getColumns())) != null) {
            field.setJoinUnique(unq);
        }
    }

    public void addConstraints(ValueMapping vm) {
        Unique unq;
        Column[] cols = vm.getForeignKey() != null ? vm.getForeignKey().getColumns() : vm.getColumns();
        Index idx = this.findIndex(cols);
        if (idx != null) {
            vm.setValueIndex(idx);
        }
        if ((unq = this.findUnique(cols)) != null) {
            vm.setValueUnique(unq);
        }
    }

    private Index findIndex(Column[] cols) {
        if (cols == null || cols.length == 0) {
            return null;
        }
        Table table = cols[0].getTable();
        Index[] idxs = table.getIndexes();
        for (int i = 0; i < idxs.length; ++i) {
            if (!idxs[i].columnsMatch(cols)) continue;
            return idxs[i];
        }
        return null;
    }

    private Unique findUnique(Column[] cols) {
        if (cols == null || cols.length == 0) {
            return null;
        }
        Table table = cols[0].getTable();
        Unique[] unqs = table.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            if (!unqs[i].columnsMatch(cols)) continue;
            return unqs[i];
        }
        return null;
    }

    public boolean isBaseTable(Table table) {
        if (table.getPrimaryKey() == null) {
            return false;
        }
        int type = this.getSecondaryType(table, true);
        if (type != -1) {
            return type == 1;
        }
        if (this._custom != null) {
            return this._custom.getTableType(table, 1) == 1;
        }
        return true;
    }

    private int getSecondaryType(Table table, boolean maybeBase) {
        ForeignKey[] fks = table.getForeignKeys();
        int type = !(fks.length != 2 || table.getPrimaryKey() != null && !this._pkOnJoin || fks[0].getColumns().length + fks[1].getColumns().length != table.getColumns().length || this.isUnique(fks[0]) && this.isUnique(fks[1])) ? 4 : (maybeBase && table.getPrimaryKey() != null ? -1 : (this.getUniqueForeignKey(table) != null ? 2 : (fks.length == 1 ? 0 : -1)));
        if (this._custom != null && type != -1) {
            type = this._custom.getTableType(table, type);
        }
        return type;
    }

    private void mapBaseClass(Table table) {
        ClassMapping cls = this.newClassMapping(table, null);
        if (cls == null) {
            return;
        }
        Column[] pks = table.getPrimaryKey().getColumns();
        cls.setPrimaryKeyColumns(pks);
        if (pks.length == 1 && this._datastore && pks[0].isCompatible(-5, null, 0, 0)) {
            cls.setObjectIdType(null, false);
            cls.setIdentityType(1);
        } else if (pks.length == 1 && this._builtin) {
            cls.setObjectIdType(null, false);
        }
        cls.setStrategy(new FullClassStrategy(), null);
        if (this._custom != null) {
            this._custom.customize(cls);
        }
    }

    private void mapSubclasses(Set tables) {
        Table table = null;
        ForeignKey fk = null;
        while (!tables.isEmpty()) {
            ClassMetaData base = null;
            Iterator itr = tables.iterator();
            while (itr.hasNext()) {
                table = (Table)itr.next();
                fk = this.getUniqueForeignKey(table);
                if (fk == null && table.getForeignKeys().length == 1) {
                    fk = table.getForeignKeys()[0];
                    continue;
                }
                if (fk == null) {
                    itr.remove();
                    continue;
                }
                base = (ClassMapping)this._tables.get(fk.getPrimaryKeyTable());
                if (base == null) continue;
                itr.remove();
                break;
            }
            if (base == null) {
                return;
            }
            ClassMapping sub = this.newClassMapping(table, base.getDescribedType());
            sub.setJoinForeignKey(fk);
            sub.setPrimaryKeyColumns(fk.getColumns());
            sub.setIdentityType(base.getIdentityType());
            sub.setStrategy(new VerticalClassStrategy(), null);
            if (this._custom == null) continue;
            this._custom.customize(sub);
        }
    }

    private void mapAssociationTable(Table table) {
        FieldMapping field2;
        ForeignKey[] fks = table.getForeignKeys();
        if (fks.length != 2) {
            return;
        }
        ClassMapping cls1 = (ClassMapping)this._tables.get(fks[0].getPrimaryKeyTable());
        ClassMapping cls2 = (ClassMapping)this._tables.get(fks[1].getPrimaryKeyTable());
        if (cls1 == null || cls2 == null) {
            return;
        }
        String name = this.getRelationName(cls2.getDescribedType(), true, fks[1], false, cls1);
        FieldMapping field1 = this.newFieldMapping(name, Set.class, null, fks[1], cls1);
        if (field1 != null) {
            field1.setJoinForeignKey(fks[0]);
            this.addJoinConstraints(field1);
            ValueMapping vm = field1.getElementMapping();
            vm.setDeclaredType(cls2.getDescribedType());
            vm.setForeignKey(fks[1]);
            this.addConstraints(vm);
            field1.setStrategy(new RelationCollectionTableFieldStrategy(), null);
            if (this._custom != null) {
                this._custom.customize(field1);
            }
        }
        if ((field2 = this.newFieldMapping(name = this.getRelationName(cls1.getDescribedType(), true, fks[0], false, cls2), Set.class, null, fks[0], cls2)) == null) {
            return;
        }
        field2.setJoinForeignKey(fks[1]);
        this.addJoinConstraints(field2);
        ValueMapping vm = field2.getElementMapping();
        vm.setDeclaredType(cls1.getDescribedType());
        vm.setForeignKey(fks[0]);
        this.addConstraints(vm);
        if (field1 != null && field1.getMappedBy() == null) {
            field2.setMappedBy(field1.getName());
        }
        field2.setStrategy(new RelationCollectionTableFieldStrategy(), null);
        if (this._custom != null) {
            this._custom.customize(field2);
        }
    }

    private void mapSecondaryTable(Table table, boolean outer) {
        ForeignKey fk = this.getUniqueForeignKey(table);
        if (fk == null && table.getForeignKeys().length == 1) {
            fk = table.getForeignKeys()[0];
        } else if (fk == null) {
            return;
        }
        ClassMapping cls = (ClassMapping)this._tables.get(fk.getPrimaryKeyTable());
        if (cls == null) {
            return;
        }
        this.mapColumns(cls, table, fk, outer);
    }

    private void mapColumns(ClassMapping cls, Table table, ForeignKey join, boolean outer) {
        ForeignKey[] fks = table.getForeignKeys();
        for (int i = 0; i < fks.length; ++i) {
            if (fks[i] == join || fks[i] == cls.getJoinForeignKey()) continue;
            this.mapForeignKey(cls, fks[i], join, outer);
        }
        PrimaryKey pk = join != null ? null : table.getPrimaryKey();
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            boolean pkcol;
            boolean bl = pkcol = pk != null && pk.containsColumn(cols[i]);
            if (pkcol && cls.getIdentityType() == 1 || (cls.getPCSuperclass() != null || !pkcol) && ReverseMappingTool.isForeignKeyColumn(cols[i])) continue;
            this.mapColumn(cls, cols[i], join, outer);
        }
    }

    private static boolean isForeignKeyColumn(Column col) {
        ForeignKey[] fks = col.getTable().getForeignKeys();
        for (int i = 0; i < fks.length; ++i) {
            if (!fks[i].containsColumn(col)) continue;
            return true;
        }
        return false;
    }

    private void mapForeignKey(ClassMapping cls, ForeignKey fk, ForeignKey join, boolean outer) {
        Class type;
        ClassMapping rel = (ClassMapping)this._tables.get(fk.getPrimaryKeyTable());
        if (rel == null) {
            return;
        }
        String name = this.getRelationName(rel.getDescribedType(), false, fk, false, cls);
        FieldMapping field1 = this.newFieldMapping(name, rel.getDescribedType(), null, fk, cls);
        if (field1 != null) {
            field1.setJoinForeignKey(join);
            field1.setJoinOuter(outer);
            this.addJoinConstraints(field1);
            field1.setForeignKey(fk);
            this.addConstraints(field1);
            field1.setStrategy(new RelationFieldStrategy(), null);
            if (this._custom != null) {
                this._custom.customize(field1);
            }
        }
        if (!this._inverse || join != null) {
            return;
        }
        boolean unq = this.isUnique(fk);
        name = this.getRelationName(cls.getDescribedType(), !unq, fk, true, rel);
        FieldMapping field2 = this.newFieldMapping(name, type = unq ? cls.getDescribedType() : Set.class, null, fk, rel);
        if (field2 == null) {
            return;
        }
        if (field1 != null) {
            field2.setMappedBy(field1.getName());
        }
        if (unq) {
            field2.setForeignKey(fk);
            field2.setJoinDirection(1);
            field2.setStrategy(new RelationFieldStrategy(), null);
        } else {
            ValueMapping vm = field2.getElementMapping();
            vm.setDeclaredType(cls.getDescribedType());
            vm.setForeignKey(fk);
            vm.setJoinDirection(2);
            field2.setStrategy(new RelationCollectionInverseKeyFieldStrategy(), null);
        }
        if (this._custom != null) {
            this._custom.customize(field2);
        }
    }

    private void mapColumn(ClassMapping cls, Column col, ForeignKey join, boolean outer) {
        String name = this.getFieldName(col.getName(), cls);
        Class type = this.getFieldType(col, false);
        FieldMapping field = this.newFieldMapping(name, type, col, null, cls);
        field.setSerialized(type == Object.class);
        field.setJoinForeignKey(join);
        field.setJoinOuter(outer);
        this.addJoinConstraints(field);
        field.setColumns(new Column[]{col});
        this.addConstraints(field);
        if (col.isPrimaryKey() && cls.getIdentityType() != 1) {
            field.setPrimaryKey(true);
        }
        AbstractFieldStrategy strat = type.isPrimitive() ? new PrimitiveFieldStrategy() : (col.getType() == 2005 && this._conf.getDBDictionaryInstance().maxEmbeddedClobSize != -1 ? new MaxEmbeddedClobFieldStrategy() : (col.isLob() && this._conf.getDBDictionaryInstance().maxEmbeddedBlobSize != -1 ? new MaxEmbeddedBlobFieldStrategy() : (type == String.class ? new StringFieldStrategy() : new HandlerFieldStrategy())));
        field.setStrategy(strat, null);
        if (this._custom != null) {
            this._custom.customize(field);
        }
    }

    private ClassMapping newClassMapping(Table table, Class parent) {
        String name = this.getClassName(table);
        if (this._custom != null) {
            name = this._custom.getClassName(table, name);
        }
        if (name == null) {
            return null;
        }
        return this.newClassMapping(this.generateClass(name, parent), table);
    }

    public FieldMapping newFieldMapping(String name, Class type, Column col, ForeignKey fk, ClassMapping dec) {
        if (this._custom != null) {
            Column[] columnArray;
            if (fk == null) {
                Column[] columnArray2 = new Column[1];
                columnArray = columnArray2;
                columnArray2[0] = col;
            } else {
                columnArray = fk.getColumns();
            }
            Column[] cols = columnArray;
            String newName = this._custom.getFieldName(dec, cols, fk, name);
            if (newName == null || !newName.equals(name)) {
                if (this._abandonedFieldNames == null) {
                    this._abandonedFieldNames = new HashSet();
                }
                this._abandonedFieldNames.add(dec.getDescribedType().getName() + "." + name);
                if (newName == null) {
                    return null;
                }
                name = newName;
            }
        }
        FieldMapping field = dec.addDeclaredFieldMapping(name, type);
        field.setExplicit(true);
        return field;
    }

    private String getClassName(Table table) {
        int i;
        String[] subs;
        StringBuilder buf = new StringBuilder();
        if (this.getPackageName() != null) {
            buf.append(this.getPackageName()).append(".");
        }
        String name = ReverseMappingTool.replaceInvalidCharacters(table.getSchemaName());
        if (this._useSchema && name != null) {
            if (ReverseMappingTool.allUpperCase(name)) {
                name = name.toLowerCase();
            }
            subs = StringUtil.split(name, "_", 0);
            for (i = 0; i < subs.length; ++i) {
                buf.append(StringUtil.capitalize(subs[i]));
            }
        }
        if (ReverseMappingTool.allUpperCase(name = ReverseMappingTool.replaceInvalidCharacters(table.getName()))) {
            name = name.toLowerCase();
        }
        subs = StringUtil.split(name, "_", 0);
        for (i = 0; i < subs.length; ++i) {
            if (i == subs.length - 1 && subs[i].equalsIgnoreCase("id")) {
                subs[i] = "ident";
            }
            buf.append(StringUtil.capitalize(subs[i]));
        }
        return buf.toString();
    }

    public String getFieldName(String name, ClassMapping dec) {
        name = ReverseMappingTool.allUpperCase(name = ReverseMappingTool.replaceInvalidCharacters(name)) ? name.toLowerCase() : Character.toLowerCase(name.charAt(0)) + name.substring(1);
        StringBuilder buf = new StringBuilder();
        String[] subs = StringUtil.split(name, "_", 0);
        for (int i = 0; i < subs.length; ++i) {
            if (i > 0) {
                subs[i] = StringUtil.capitalize(subs[i]);
            }
            buf.append(subs[i]);
        }
        return this.getUniqueName(buf.toString(), dec);
    }

    private String getRelationName(Class fieldType, boolean coll, ForeignKey fk, boolean inverse, ClassMapping dec) {
        if (this._useFK && fk.getName() != null) {
            String name = this.getFieldName(fk.getName(), dec);
            if (inverse && coll) {
                name = name + "Inverses";
            } else if (inverse) {
                name = name + "Inverse";
            }
            return this.getUniqueName(name, dec);
        }
        String name = fieldType.getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        if (coll && !name.endsWith("s")) {
            name = name + "s";
        }
        return this.getUniqueName(name, dec);
    }

    private static boolean allUpperCase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i)) || Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String replaceInvalidCharacters(String str) {
        int end;
        int start;
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != '$' && Character.isJavaIdentifierPart(str.charAt(i))) continue;
            buf.setCharAt(i, '_');
        }
        for (start = 0; start < buf.length() && buf.charAt(start) == '_'; ++start) {
        }
        for (end = buf.length() - 1; end >= 0 && buf.charAt(end) == '_'; --end) {
        }
        if (start > end) {
            return "x";
        }
        return buf.substring(start, end + 1);
    }

    private String getUniqueName(String name, ClassMapping dec) {
        if (_javaKeywords.containsKey(name)) {
            name = (String)_javaKeywords.get(name);
        }
        String prefix = dec.getDescribedType().getName() + ".";
        int version = 2;
        int chars = 1;
        while (dec.getDeclaredField(name) != null || this._abandonedFieldNames != null && this._abandonedFieldNames.contains(prefix + name)) {
            if (version > 2) {
                name = name.substring(0, name.length() - chars);
            }
            if ((double)version >= Math.pow(10.0, chars)) {
                ++chars;
            }
            name = name + version;
            ++version;
        }
        return name;
    }

    public Class getFieldType(Column col, boolean forceObject) {
        Class type = null;
        if (this._typeMap != null) {
            String[] propNames = new String[]{col.getTypeName() + "(" + col.getSize() + "," + col.getDecimalDigits() + ")", col.getTypeName() + "(" + col.getSize() + ")", col.getTypeName()};
            String typeName = null;
            String typeSpec = null;
            for (int nameIdx = 0; typeSpec == null && nameIdx < propNames.length; ++nameIdx) {
                if (propNames[nameIdx] == null || (typeSpec = StringUtil.trimToNull(this._typeMap.getProperty(propNames[nameIdx]))) == null) continue;
                typeName = propNames[nameIdx];
            }
            if (typeSpec != null) {
                this._log.info(_loc.get("reverse-type", typeName, typeSpec));
            } else {
                this._log.trace(_loc.get("no-reverse-type", propNames[propNames.length - 1]));
            }
            if (typeSpec != null) {
                type = ClassUtil.toClass(typeSpec, this._conf.getClassResolverInstance().getClassLoader(ReverseMappingTool.class, null));
            }
        }
        if (type == null) {
            type = Schemas.getJavaType(col.getType(), col.getSize(), col.getDecimalDigits());
        }
        if (type == Object.class) {
            if (!this._blobAsObj) {
                return byte[].class;
            }
            return type;
        }
        if (type == Character.TYPE && this._conf.getDBDictionaryInstance().storeCharsAsNumbers) {
            type = String.class;
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("cant-use-char", col.getFullName()));
            }
        }
        if (!type.isPrimitive()) {
            return type;
        }
        if (!(forceObject || !col.isNotNull() && this._nullAsObj)) {
            return type;
        }
        switch (type.getName().charAt(0)) {
            case 'b': {
                if (type == Boolean.TYPE) {
                    return Boolean.class;
                }
                return Byte.class;
            }
            case 'c': {
                return Character.class;
            }
            case 'd': {
                return Double.class;
            }
            case 'f': {
                return Float.class;
            }
            case 'i': {
                return Integer.class;
            }
            case 'l': {
                return Long.class;
            }
            case 's': {
                return Short.class;
            }
        }
        throw new InternalException();
    }

    public Object clone() {
        ReverseMappingTool tool = new ReverseMappingTool(this._conf);
        tool.setSchemaGroup(this.getSchemaGroup());
        tool.setPackageName(this.getPackageName());
        tool.setDirectory(this.getDirectory());
        tool.setUseSchemaName(this.getUseSchemaName());
        tool.setUseForeignKeyName(this.getUseForeignKeyName());
        tool.setNullableAsObject(this.getNullableAsObject());
        tool.setBlobAsObject(this.getBlobAsObject());
        tool.setUseGenericCollections(this.getUseGenericCollections());
        tool.setPrimaryKeyOnJoin(this.getPrimaryKeyOnJoin());
        tool.setUseDataStoreIdentity(this.getUseDataStoreIdentity());
        tool.setUseBuiltinIdentityClass(this.getUseBuiltinIdentityClass());
        tool.setInnerIdentityClasses(this.getInnerIdentityClasses());
        tool.setIdentityClassSuffix(this.getIdentityClassSuffix());
        tool.setInverseRelations(this.getInverseRelations());
        tool.setDetachable(this.getDetachable());
        tool.setGenerateAnnotations(this.getGenerateAnnotations());
        tool.setCustomizer(this.getCustomizer());
        tool.setCodeFormat(this.getCodeFormat());
        tool.setUseSchemaElement(this.getUseSchemaElement());
        return tool;
    }

    protected static ReverseMappingTool newInstance(JDBCConfiguration conf) {
        return new ReverseMappingTool(conf);
    }

    public static void main(String[] args) throws IOException, SQLException {
        Options opts = new Options();
        final String[] arguments = opts.setFromCmdLine(args);
        boolean ret = Configurations.runAgainstAllAnchors(opts, new Configurations.Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Options opts) throws Exception {
                try (JDBCConfigurationImpl conf = new JDBCConfigurationImpl();){
                    boolean bl = ReverseMappingTool.run(conf, arguments, opts);
                    return bl;
                }
            }
        });
        if (!ret) {
            System.out.println(_loc.get("revtool-usage"));
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws IOException, SQLException {
        return ReverseMappingTool.run(conf, args, opts, null);
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts, Map<Class<?>, String> output) throws IOException, SQLException {
        Flags flags = new Flags();
        flags.packageName = opts.removeProperty(LEVEL_PACKAGE, "pkg", flags.packageName);
        flags.directory = Files.getFile(opts.removeProperty("directory", "d", null), null);
        flags.useSchemaName = opts.removeBooleanProperty("useSchemaName", "sn", flags.useSchemaName);
        flags.useForeignKeyName = opts.removeBooleanProperty("useForeignKeyName", "fkn", flags.useForeignKeyName);
        flags.nullableAsObject = opts.removeBooleanProperty("nullableAsObject", "no", flags.nullableAsObject);
        flags.blobAsObject = opts.removeBooleanProperty("blobAsObject", "bo", flags.blobAsObject);
        flags.useGenericCollections = opts.removeBooleanProperty("useGenericCollections", "gc", flags.useGenericCollections);
        flags.primaryKeyOnJoin = opts.removeBooleanProperty("primaryKeyOnJoin", "pkj", flags.primaryKeyOnJoin);
        flags.useDataStoreIdentity = opts.removeBooleanProperty("useDatastoreIdentity", "ds", flags.useDataStoreIdentity);
        flags.useBuiltinIdentityClass = opts.removeBooleanProperty("useBuiltinIdentityClass", "bic", flags.useBuiltinIdentityClass);
        flags.innerIdentityClasses = opts.removeBooleanProperty("innerIdentityClasses", "inn", flags.innerIdentityClasses);
        flags.identityClassSuffix = opts.removeProperty("identityClassSuffix", "is", flags.identityClassSuffix);
        flags.inverseRelations = opts.removeBooleanProperty("inverseRelations", "ir", flags.inverseRelations);
        flags.detachable = opts.removeBooleanProperty("detachable", "det", flags.detachable);
        flags.discriminatorStrategy = opts.removeProperty("discriminatorStrategy", "ds", flags.discriminatorStrategy);
        flags.versionStrategy = opts.removeProperty("versionStrategy", "vs", flags.versionStrategy);
        flags.metaDataLevel = opts.removeProperty("metadata", "md", flags.metaDataLevel);
        flags.generateAnnotations = opts.removeBooleanProperty("annotations", "ann", flags.generateAnnotations);
        flags.accessType = opts.removeProperty("accessType", "access", flags.accessType);
        flags.useSchemaElement = opts.removeBooleanProperty("useSchemaElement", "se", flags.useSchemaElement);
        String typeMap = opts.removeProperty("typeMap", "typ", null);
        if (typeMap != null) {
            flags.typeMap = Configurations.parseProperties(typeMap);
        }
        if (opts.containsKey("s")) {
            opts.put("schemas", opts.get("s"));
        }
        String customCls = opts.removeProperty("customizerClass", "cc", PropertiesReverseCustomizer.class.getName());
        File customFile = Files.getFile(opts.removeProperty("customizerProperties", "cp", null), null);
        Properties customProps = new Properties();
        if (customFile != null && AccessController.doPrivileged(J2DoPrivHelper.existsAction(customFile)).booleanValue()) {
            FileInputStream fis = null;
            try {
                fis = AccessController.doPrivileged(J2DoPrivHelper.newFileInputStreamAction(customFile));
            }
            catch (PrivilegedActionException pae) {
                throw (FileNotFoundException)pae.getException();
            }
            customProps.load(fis);
        }
        Options customOpts = new Options();
        Options formatOpts = new Options();
        Iterator<Map.Entry<Object, Object>> itr = opts.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            String key = (String)entry.getKey();
            if (key.startsWith("customizer.")) {
                customOpts.put(key.substring(11), entry.getValue());
                itr.remove();
                continue;
            }
            if (key.startsWith("c.")) {
                customOpts.put(key.substring(2), entry.getValue());
                itr.remove();
                continue;
            }
            if (key.startsWith("codeFormat.")) {
                formatOpts.put(key.substring(11), entry.getValue());
                itr.remove();
                continue;
            }
            if (!key.startsWith("cf.")) continue;
            formatOpts.put(key.substring(3), entry.getValue());
            itr.remove();
        }
        if (!formatOpts.isEmpty()) {
            flags.format = new CodeFormat();
            formatOpts.setInto(flags.format);
        }
        Configurations.populateConfiguration(conf, opts);
        ClassLoader loader = conf.getClassResolverInstance().getClassLoader(ReverseMappingTool.class, null);
        flags.customizer = (ReverseCustomizer)Configurations.newInstance(customCls, loader);
        if (flags.customizer != null) {
            Configurations.configureInstance((Object)flags.customizer, (Configuration)conf, customOpts);
            flags.customizer.setConfiguration(customProps);
        }
        ReverseMappingTool.run(conf, args, flags, loader, output);
        return true;
    }

    public static void run(JDBCConfiguration conf, String[] args, Flags flags, ClassLoader loader) throws IOException, SQLException {
        ReverseMappingTool.run(conf, args, flags, loader, null);
    }

    public static void run(JDBCConfiguration conf, String[] args, Flags flags, ClassLoader loader, Map<Class<?>, String> output) throws IOException, SQLException {
        SchemaGroup schema;
        Log log = conf.getLog("openjpa.Tool");
        if (args.length == 0) {
            log.info(_loc.get("revtool-running"));
            SchemaGenerator gen = new SchemaGenerator(conf);
            gen.generateSchemas();
            schema = gen.getSchemaGroup();
        } else {
            XMLSchemaParser parser = new XMLSchemaParser(conf);
            for (int i = 0; i < args.length; ++i) {
                File file = Files.getFile(args[i], loader);
                log.info(_loc.get("revtool-running-file", file));
                parser.parse(file);
            }
            schema = parser.getSchemaGroup();
        }
        ReverseMappingTool tool = ReverseMappingTool.newInstance(conf);
        tool.setSchemaGroup(schema);
        tool.setPackageName(flags.packageName);
        tool.setDirectory(flags.directory);
        tool.setUseSchemaName(flags.useSchemaName);
        tool.setUseForeignKeyName(flags.useForeignKeyName);
        tool.setNullableAsObject(flags.nullableAsObject);
        tool.setBlobAsObject(flags.blobAsObject);
        tool.setUseGenericCollections(flags.useGenericCollections);
        tool.setTypeMap(flags.typeMap);
        tool.setPrimaryKeyOnJoin(flags.primaryKeyOnJoin);
        tool.setUseDataStoreIdentity(flags.useDataStoreIdentity);
        tool.setUseBuiltinIdentityClass(flags.useBuiltinIdentityClass);
        tool.setInnerIdentityClasses(flags.innerIdentityClasses);
        tool.setIdentityClassSuffix(flags.identityClassSuffix);
        tool.setInverseRelations(flags.inverseRelations);
        tool.setDetachable(flags.detachable);
        tool.setGenerateAnnotations(flags.generateAnnotations);
        tool.setAccessType(flags.accessType);
        tool.setCustomizer(flags.customizer);
        tool.setCodeFormat(flags.format);
        tool.setUseSchemaElement(flags.useSchemaElement);
        log.info(_loc.get("revtool-map"));
        tool.run();
        if (flags.generateAnnotations) {
            log.info(_loc.get("revtool-gen-annos"));
            tool.buildAnnotations();
        }
        log.info(_loc.get("revtool-write-code"));
        tool.recordCode(output);
        if (!LEVEL_NONE.equals(flags.metaDataLevel)) {
            log.info(_loc.get("revtool-write-metadata"));
            tool.recordMetaData(LEVEL_CLASS.equals(flags.metaDataLevel));
        }
    }

    static {
        InputStream in = ReverseMappingTool.class.getResourceAsStream("java-keywords.rsrc");
        try {
            String[] keywords = StringUtil.split(new BufferedReader(new InputStreamReader(in)).readLine(), ",", 0);
            for (int i = 0; i < keywords.length; i += 2) {
                _javaKeywords.put(keywords[i], keywords[i + 1]);
            }
        }
        catch (IOException ioe) {
            throw new InternalException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private class AnnotatedCodeGenerator
    extends ReverseCodeGenerator {
        public AnnotatedCodeGenerator(ClassMapping mapping, ApplicationIdTool aid) {
            super(mapping, aid);
        }

        @Override
        public Set getImportPackages() {
            Set pkgs = super.getImportPackages();
            pkgs.add("javax.persistence");
            return pkgs;
        }

        @Override
        protected List getClassAnnotations() {
            return ReverseMappingTool.this.getAnnotationsForMeta(this._mapping);
        }

        @Override
        protected List getFieldAnnotations(FieldMetaData field) {
            return ReverseMappingTool.this.getAnnotationsForMeta(field);
        }

        @Override
        protected boolean usePropertyBasedAccess() {
            return ReverseMappingTool.ACCESS_TYPE_PROPERTY.equals(ReverseMappingTool.this._accessType);
        }
    }

    private class ReverseCodeGenerator
    extends CodeGenerator {
        protected final ClassMapping _mapping;
        protected final ApplicationIdTool _appid;

        public ReverseCodeGenerator(ClassMapping mapping, ApplicationIdTool aid) {
            super(mapping);
            super.setDirectory(ReverseMappingTool.this._dir);
            super.setCodeFormat(ReverseMappingTool.this._format);
            this._mapping = mapping;
            this._appid = aid != null && aid.isInnerClass() ? aid : null;
        }

        @Override
        protected void closeClassBrace(CodeFormat code) {
            if (this._appid != null) {
                code.afterSection();
                code.append(this._appid.getCode());
                code.endl();
            }
            super.closeClassBrace(code);
        }

        @Override
        public Set getImportPackages() {
            Set pkgs = super.getImportPackages();
            if (this._appid != null) {
                pkgs.addAll(this._appid.getImportPackages());
            }
            return pkgs;
        }

        @Override
        protected String getClassCode() {
            return ReverseMappingTool.this._custom == null ? null : ReverseMappingTool.this._custom.getClassCode(this._mapping);
        }

        @Override
        protected String getInitialValue(FieldMetaData field) {
            if (ReverseMappingTool.this._custom == null) {
                return null;
            }
            return ReverseMappingTool.this._custom.getInitialValue((FieldMapping)field);
        }

        @Override
        protected String getDeclaration(FieldMetaData field) {
            if (ReverseMappingTool.this._custom == null) {
                return null;
            }
            return ReverseMappingTool.this._custom.getDeclaration((FieldMapping)field);
        }

        @Override
        protected String getFieldCode(FieldMetaData field) {
            if (ReverseMappingTool.this._custom == null) {
                return null;
            }
            return ReverseMappingTool.this._custom.getFieldCode((FieldMapping)field);
        }

        @Override
        protected boolean useGenericCollections() {
            return ReverseMappingTool.this._useGenericColl;
        }
    }

    private class ReverseStrategyInstaller
    extends StrategyInstaller {
        private static final long serialVersionUID = 1L;

        public ReverseStrategyInstaller(MappingRepository repos) {
            super(repos);
        }

        @Override
        public void installStrategy(ClassMapping cls) {
            throw new InternalException();
        }

        @Override
        public void installStrategy(FieldMapping field) {
            throw new InternalException();
        }

        @Override
        public void installStrategy(Version version) {
            ClassMapping cls = version.getClassMapping();
            if (cls.getPCSuperclass() != null) {
                version.setStrategy(new SuperclassVersionStrategy(), null);
            } else if (ReverseMappingTool.this._versStrat != null) {
                VersionStrategy strat = this.repos.instantiateVersionStrategy(ReverseMappingTool.this._versStrat, version);
                version.setStrategy(strat, null);
            } else {
                version.setStrategy(new StateComparisonVersionStrategy(), null);
            }
        }

        @Override
        public void installStrategy(Discriminator discrim) {
            ClassMapping cls = discrim.getClassMapping();
            if (cls.getPCSuperclass() != null) {
                discrim.setStrategy(new SuperclassDiscriminatorStrategy(), null);
            } else if (!this.hasSubclasses(cls)) {
                discrim.setStrategy(NoneDiscriminatorStrategy.getInstance(), null);
            } else if (ReverseMappingTool.this._discStrat != null) {
                DiscriminatorStrategy strat = this.repos.instantiateDiscriminatorStrategy(ReverseMappingTool.this._discStrat, discrim);
                discrim.setStrategy(strat, null);
            } else {
                discrim.setStrategy(new SubclassJoinDiscriminatorStrategy(), null);
            }
        }

        private boolean hasSubclasses(ClassMapping cls) {
            ClassMetaData[] metas = this.repos.getMetaDatas();
            for (int i = 0; i < metas.length; ++i) {
                if (metas[i].getPCSuperclass() != cls.getDescribedType()) continue;
                return true;
            }
            return false;
        }
    }

    public static class Flags {
        public String packageName = null;
        public File directory = null;
        public boolean useSchemaName = false;
        public boolean useForeignKeyName = false;
        public boolean nullableAsObject = false;
        public boolean blobAsObject = false;
        public boolean useGenericCollections = false;
        public Properties typeMap = null;
        public boolean primaryKeyOnJoin = false;
        public boolean useDataStoreIdentity = false;
        public boolean useBuiltinIdentityClass = true;
        public boolean innerIdentityClasses = false;
        public String identityClassSuffix = "Id";
        public boolean inverseRelations = true;
        public boolean detachable = false;
        public boolean generateAnnotations = false;
        public String accessType = "field";
        public String metaDataLevel = "package";
        public String discriminatorStrategy = null;
        public String versionStrategy = null;
        public ReverseCustomizer customizer = null;
        public CodeFormat format = null;
        public boolean useSchemaElement = true;
    }
}

