/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.commons.dbcp2.PoolingConnection;

public class PStmtKey {
    private final String _sql;
    private final Integer _resultSetType;
    private final Integer _resultSetConcurrency;
    private final Integer _resultSetHoldability;
    private final String _catalog;
    private final Integer _autoGeneratedKeys;
    private final int[] _columnIndexes;
    private final String[] _columnNames;
    private final PoolingConnection.StatementType _stmtType;
    private StatementBuilder builder;

    public PStmtKey(String sql) {
        this(sql, null, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog) {
        this(sql, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, PoolingConnection.StatementType stmtType) {
        this._sql = sql;
        this._catalog = catalog;
        this._stmtType = stmtType;
        this._autoGeneratedKeys = null;
        this._columnIndexes = null;
        this._columnNames = null;
        this._resultSetType = null;
        this._resultSetConcurrency = null;
        this._resultSetHoldability = null;
        if (stmtType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementSQL();
        } else if (stmtType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String sql, String catalog, int autoGeneratedKeys) {
        this(sql, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)autoGeneratedKeys);
    }

    public PStmtKey(String sql, String catalog, PoolingConnection.StatementType stmtType, Integer autoGeneratedKeys) {
        this._sql = sql;
        this._catalog = catalog;
        this._stmtType = stmtType;
        this._autoGeneratedKeys = autoGeneratedKeys;
        this._columnIndexes = null;
        this._columnNames = null;
        this._resultSetType = null;
        this._resultSetConcurrency = null;
        this._resultSetHoldability = null;
        if (stmtType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithAutoGeneratedKeys();
        } else if (stmtType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String sql, String catalog, int[] columnIndexes) {
        this._sql = sql;
        this._catalog = catalog;
        this._stmtType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this._autoGeneratedKeys = null;
        this._columnIndexes = columnIndexes;
        this._columnNames = null;
        this._resultSetType = null;
        this._resultSetConcurrency = null;
        this._resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnIndexes();
    }

    public PStmtKey(String sql, String catalog, String[] columnNames) {
        this._sql = sql;
        this._catalog = catalog;
        this._stmtType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this._autoGeneratedKeys = null;
        this._columnIndexes = null;
        this._columnNames = columnNames;
        this._resultSetType = null;
        this._resultSetConcurrency = null;
        this._resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnNames();
    }

    public PStmtKey(String sql, int resultSetType, int resultSetConcurrency) {
        this(sql, null, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency) {
        this(sql, catalog, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, PoolingConnection.StatementType stmtType) {
        this._sql = sql;
        this._catalog = catalog;
        this._resultSetType = resultSetType;
        this._resultSetConcurrency = resultSetConcurrency;
        this._resultSetHoldability = null;
        this._stmtType = stmtType;
        this._autoGeneratedKeys = null;
        this._columnIndexes = null;
        this._columnNames = null;
        if (stmtType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetConcurrency();
        } else if (stmtType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetConcurrency();
        }
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(sql, catalog, resultSetType, resultSetConcurrency, resultSetHoldability, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability, PoolingConnection.StatementType stmtType) {
        this._sql = sql;
        this._catalog = catalog;
        this._resultSetType = resultSetType;
        this._resultSetConcurrency = resultSetConcurrency;
        this._resultSetHoldability = resultSetHoldability;
        this._stmtType = stmtType;
        this._autoGeneratedKeys = null;
        this._columnIndexes = null;
        this._columnNames = null;
        if (stmtType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetHoldability();
        } else if (stmtType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetHoldability();
        }
    }

    public String getSql() {
        return this._sql;
    }

    public Integer getResultSetType() {
        return this._resultSetType;
    }

    public Integer getResultSetConcurrency() {
        return this._resultSetConcurrency;
    }

    public Integer getResultSetHoldability() {
        return this._resultSetHoldability;
    }

    public Integer getAutoGeneratedKeys() {
        return this._autoGeneratedKeys;
    }

    public int[] getColumnIndexes() {
        return this._columnIndexes;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public String getCatalog() {
        return this._catalog;
    }

    public PoolingConnection.StatementType getStmtType() {
        return this._stmtType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PStmtKey other = (PStmtKey)obj;
        if (this._catalog == null ? other._catalog != null : !this._catalog.equals(other._catalog)) {
            return false;
        }
        if (this._resultSetConcurrency == null ? other._resultSetConcurrency != null : !this._resultSetConcurrency.equals(other._resultSetConcurrency)) {
            return false;
        }
        if (this._resultSetType == null ? other._resultSetType != null : !this._resultSetType.equals(other._resultSetType)) {
            return false;
        }
        if (this._resultSetHoldability == null ? other._resultSetHoldability != null : !this._resultSetHoldability.equals(other._resultSetHoldability)) {
            return false;
        }
        if (this._autoGeneratedKeys == null ? other._autoGeneratedKeys != null : !this._autoGeneratedKeys.equals(other._autoGeneratedKeys)) {
            return false;
        }
        if (!Arrays.equals(this._columnIndexes, other._columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this._columnNames, other._columnNames)) {
            return false;
        }
        if (this._sql == null ? other._sql != null : !this._sql.equals(other._sql)) {
            return false;
        }
        return this._stmtType == other._stmtType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._catalog == null ? 0 : this._catalog.hashCode());
        result = 31 * result + (this._resultSetConcurrency == null ? 0 : this._resultSetConcurrency.hashCode());
        result = 31 * result + (this._resultSetType == null ? 0 : this._resultSetType.hashCode());
        result = 31 * result + (this._resultSetHoldability == null ? 0 : this._resultSetHoldability.hashCode());
        result = 31 * result + (this._sql == null ? 0 : this._sql.hashCode());
        result = 31 * result + (this._autoGeneratedKeys == null ? 0 : this._autoGeneratedKeys.hashCode());
        result = 31 * result + Arrays.hashCode(this._columnIndexes);
        result = 31 * result + Arrays.hashCode(this._columnNames);
        result = 31 * result + this._stmtType.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PStmtKey: sql=");
        buf.append(this._sql);
        buf.append(", catalog=");
        buf.append(this._catalog);
        buf.append(", resultSetType=");
        buf.append(this._resultSetType);
        buf.append(", resultSetConcurrency=");
        buf.append(this._resultSetConcurrency);
        buf.append(", resultSetHoldability=");
        buf.append(this._resultSetHoldability);
        buf.append(", autoGeneratedKeys=");
        buf.append(this._autoGeneratedKeys);
        buf.append(", columnIndexes=");
        buf.append(Arrays.toString(this._columnIndexes));
        buf.append(", columnNames=");
        buf.append(Arrays.toString(this._columnNames));
        buf.append(", statementType=");
        buf.append((Object)this._stmtType);
        return buf.toString();
    }

    public Statement createStatement(Connection connection) throws SQLException {
        if (this.builder == null) {
            throw new IllegalStateException("Prepared statement key is invalid.");
        }
        return this.builder.createStatement(connection);
    }

    private class PreparedCallWithResultSetHoldability
    implements StatementBuilder {
        private PreparedCallWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            CallableStatement statement = connection.prepareCall(PStmtKey.this._sql, PStmtKey.this._resultSetType, PStmtKey.this._resultSetConcurrency, PStmtKey.this._resultSetHoldability);
            return statement;
        }
    }

    private class PreparedCallWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedCallWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            CallableStatement statement = connection.prepareCall(PStmtKey.this._sql, PStmtKey.this._resultSetType, PStmtKey.this._resultSetConcurrency);
            return statement;
        }
    }

    private class PreparedCallSQL
    implements StatementBuilder {
        private PreparedCallSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            CallableStatement statement = connection.prepareCall(PStmtKey.this._sql);
            return statement;
        }
    }

    private class PreparedStatementWithColumnNames
    implements StatementBuilder {
        private PreparedStatementWithColumnNames() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this._sql, PStmtKey.this._columnNames);
            return statement;
        }
    }

    private class PreparedStatementWithResultSetHoldability
    implements StatementBuilder {
        private PreparedStatementWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this._sql, PStmtKey.this._resultSetType, PStmtKey.this._resultSetConcurrency, PStmtKey.this._resultSetHoldability);
            return statement;
        }
    }

    private class PreparedStatementWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedStatementWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this._sql, PStmtKey.this._resultSetType, PStmtKey.this._resultSetConcurrency);
            return statement;
        }
    }

    private class PreparedStatementWithColumnIndexes
    implements StatementBuilder {
        private PreparedStatementWithColumnIndexes() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this._sql, PStmtKey.this._columnIndexes);
            return statement;
        }
    }

    private class PreparedStatementWithAutoGeneratedKeys
    implements StatementBuilder {
        private PreparedStatementWithAutoGeneratedKeys() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this._sql, PStmtKey.this._autoGeneratedKeys);
            return statement;
        }
    }

    private class PreparedStatementSQL
    implements StatementBuilder {
        private PreparedStatementSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this._sql);
            return statement;
        }
    }

    private static interface StatementBuilder {
        public Statement createStatement(Connection var1) throws SQLException;
    }
}

