/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.reg.exception;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.reg.exception.IgnoredExceptionProvider;
import org.apache.shardingsphere.elasticjob.reg.exception.RegException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegExceptionHandler.class);
    private static final Collection<Class<? extends Throwable>> IGNORED_EXCEPTIONS = new LinkedList<Class<? extends Throwable>>();

    public static void handleException(Exception cause) {
        if (null == cause) {
            return;
        }
        if (RegExceptionHandler.isIgnoredException(cause) || null != cause.getCause() && RegExceptionHandler.isIgnoredException(cause.getCause())) {
            log.debug("Elastic job: ignored exception for: {}", (Object)cause.getMessage());
        } else if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        } else {
            throw new RegException(cause);
        }
    }

    private static boolean isIgnoredException(Throwable cause) {
        return IGNORED_EXCEPTIONS.stream().anyMatch(each -> each.isInstance(cause));
    }

    @Generated
    private RegExceptionHandler() {
    }

    static {
        ServiceLoader.load(IgnoredExceptionProvider.class).forEach(each -> IGNORED_EXCEPTIONS.addAll(each.getIgnoredExceptions()));
    }
}

