/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.MeridianArcBased;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class Polyconic
extends MeridianArcBased {
    private static final long serialVersionUID = -808283103170618880L;
    private final double ci2;
    private final double ci4;
    private final double ci6;

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.Polyconic.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.Polyconic.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.Polyconic.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, null);
    }

    public Polyconic(OperationMethod method, Parameters parameters) {
        this(Polyconic.initializer(method, parameters));
    }

    private Polyconic(Initializer initializer) {
        super(initializer);
        double \u03c60 = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.Polyconic.LATITUDE_OF_ORIGIN));
        double e2 = this.eccentricitySquared;
        double e4 = e2 * e2;
        double e6 = e2 * e4;
        this.ci2 = -1.5 * e4 + 1.5 * e2;
        this.ci4 = -1.875 * e6 + 1.875 * e4;
        this.ci6 = 2.1875 * e6;
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(1, null, -this.distance(\u03c60, Math.sin(\u03c60), Math.cos(\u03c60)));
    }

    Polyconic(Polyconic other) {
        super(other);
        this.ci2 = other.ci2;
        this.ci4 = other.ci4;
        this.ci6 = other.ci6;
    }

    @Override
    public MathTransform createMapProjection(MathTransformProvider.Context parameters) throws FactoryException {
        Polyconic kernel = this;
        if (this.eccentricity == 0.0) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(parameters.getFactory(), kernel);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        double cos\u03c6 = Math.cos(\u03c6);
        double \u03bdcos\u03c6 = cos\u03c6 / Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
        double \u03bdcot\u03c6 = \u03bdcos\u03c6 / sin\u03c6;
        if (Double.isInfinite(\u03bdcot\u03c6)) {
            if (dstPts != null) {
                dstPts[dstOff] = \u03bb;
                dstPts[dstOff + 1] = \u03c6;
            }
            return derivate ? new Matrix2() : null;
        }
        double L = \u03bb * sin\u03c6;
        double sinL = Math.sin(L);
        double cosL = Math.cos(L);
        if (dstPts != null) {
            dstPts[dstOff] = \u03bdcot\u03c6 * sinL;
            dstPts[dstOff + 1] = \u03bdcot\u03c6 * (1.0 - cosL) + this.distance(\u03c6, sin\u03c6, cos\u03c6);
        }
        if (!derivate) {
            return null;
        }
        double cot\u03c6 = cos\u03c6 / sin\u03c6;
        double d\u03bdcot\u03c6_d\u03c6 = \u03bdcos\u03c6 * this.eccentricity;
        d\u03bdcot\u03c6_d\u03c6 = (d\u03bdcot\u03c6_d\u03c6 - 1.0) * (d\u03bdcot\u03c6_d\u03c6 + 1.0) / cot\u03c6 - cot\u03c6;
        double dL_d\u03c6 = \u03bb * cos\u03c6;
        return new Matrix2(\u03bdcos\u03c6 * cosL, \u03bdcot\u03c6 * (dL_d\u03c6 * cosL + d\u03bdcot\u03c6_d\u03c6 * sinL), \u03bdcos\u03c6 * sinL, \u03bdcot\u03c6 * (dL_d\u03c6 * sinL + d\u03bdcot\u03c6_d\u03c6 * (1.0 - cosL)) + this.dM_d\u03c6(sin\u03c6 * sin\u03c6));
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double d\u03c6;
        double y;
        double x = srcPts[srcOff];
        double \u03c6 = y = srcPts[srcOff + 1];
        double B = y * y + x * x;
        double ome = 1.0 - this.eccentricitySquared;
        int i = 18;
        do {
            if (--i < 0) {
                throw new ProjectionException(Resources.format((short)46));
            }
            double cos\u03c6 = Math.cos(\u03c6);
            double sin\u03c6 = Math.sin(\u03c6);
            double sin\u03c62 = sin\u03c6 * sin\u03c6;
            double r\u03bd = Math.sqrt(1.0 - this.eccentricitySquared * sin\u03c62);
            double C = r\u03bd * sin\u03c6 / cos\u03c6;
            double M = this.distance(\u03c6, sin\u03c6, cos\u03c6);
            double Mp = ome + sin\u03c62 * (this.ci2 + sin\u03c62 * (this.ci4 + sin\u03c62 * this.ci6));
            double M2B = M * M + B;
            double sin2\u03c6 = Math.sin(2.0 * \u03c6);
            d\u03c6 = (y * (M * C + 1.0) - M - 0.5 * M2B * C) / (this.eccentricitySquared * sin2\u03c6 * (M2B - 2.0 * y * M) / (4.0 * C) + (y - M) * (C * Mp - 2.0 / sin2\u03c6) - Mp);
            \u03c6 -= d\u03c6;
        } while (Math.abs(d\u03c6) > 3.926676682852614E-10);
        double sin\u03c6 = Math.sin(\u03c6);
        double \u03bb = Math.asin(x * Math.tan(\u03c6) * Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6))) / sin\u03c6;
        if (!Double.isFinite(\u03bb) && Math.abs(y) <= 1.5706706731410455E-9 && Double.isFinite(x)) {
            \u03bb = x;
            \u03c6 = y;
        }
        dstPts[dstOff] = \u03bb;
        dstPts[dstOff + 1] = \u03c6;
    }

    private static final class Spherical
    extends Polyconic {
        private static final long serialVersionUID = 8500881467002808593L;

        Spherical(Polyconic other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double cot\u03c6 = cos\u03c6 / sin\u03c6;
            if (Double.isInfinite(cot\u03c6)) {
                if (dstPts != null) {
                    dstPts[dstOff] = \u03bb;
                    dstPts[dstOff + 1] = \u03c6;
                }
                return derivate ? new Matrix2() : null;
            }
            double E = \u03bb * sin\u03c6;
            double sinE = Math.sin(E);
            double cosE = Math.cos(E);
            if (dstPts != null) {
                dstPts[dstOff] = sinE * cot\u03c6;
                dstPts[dstOff + 1] = \u03c6 + cot\u03c6 * (1.0 - cosE);
            }
            if (!derivate) {
                return null;
            }
            double c2\u03bb = cos\u03c6 * cos\u03c6 * \u03bb;
            return new Matrix2(cos\u03c6 * cosE, (c2\u03bb * cosE - sinE / sin\u03c6) / sin\u03c6, cos\u03c6 * sinE, (c2\u03bb * sinE - (1.0 - cosE) / sin\u03c6) / sin\u03c6 + 1.0);
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
            double d\u03c6;
            double y;
            double x = srcPts[srcOff];
            double \u03c6 = y = srcPts[srcOff + 1];
            double B = x * x + y * y;
            int i = 18;
            do {
                if (--i < 0) {
                    throw new ProjectionException(Resources.format((short)46));
                }
                double tan\u03c6 = Math.tan(\u03c6);
                d\u03c6 = (y * (\u03c6 * tan\u03c6 + 1.0) - \u03c6 - 0.5 * (\u03c6 * \u03c6 + B) * tan\u03c6) / ((\u03c6 - y) / tan\u03c6 - 1.0);
                \u03c6 -= d\u03c6;
            } while (Math.abs(d\u03c6) > 3.926676682852614E-10);
            double \u03bb = Math.asin(x * Math.tan(\u03c6)) / Math.sin(\u03c6);
            if (!Double.isFinite(\u03bb) && Math.abs(y) <= 1.5706706731410455E-9 && Double.isFinite(x)) {
                \u03bb = x;
                \u03c6 = y;
            }
            dstPts[dstOff] = \u03bb;
            dstPts[dstOff + 1] = \u03c6;
        }
    }
}

