/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gdal.ErrorHandler;
import org.apache.sis.storage.gdal.GDALStoreProvider;
import org.apache.sis.storage.gdal.OGR;
import org.apache.sis.storage.panama.LibraryLoader;
import org.apache.sis.storage.panama.LibraryStatus;
import org.apache.sis.storage.panama.NativeFunctions;
import org.apache.sis.storage.panama.Resources;
import org.apache.sis.util.logging.Logging;

final class GDAL
extends NativeFunctions {
    private static GDAL global;
    private static LibraryStatus globalStatus;
    final MethodHandle getName;
    final MethodHandle getIdentifier;
    final MethodHandle getMetadata;
    final MethodHandle getMetadataItem;
    final MethodHandle identifyDriver;
    final MethodHandle open;
    final MethodHandle close;
    final MethodHandle free;
    final MethodHandle destroy;
    final MethodHandle getFileList;
    final MethodHandle getDatasetDriver;
    final MethodHandle getSpatialRef;
    final MethodHandle getGCPSpatialRef;
    final MethodHandle exportToWkt;
    final MethodHandle getDataAxisToCRSAxis;
    final MethodHandle getGeoTransform;
    final MethodHandle getRasterXSize;
    final MethodHandle getRasterYSize;
    final MethodHandle getRasterBandXSize;
    final MethodHandle getRasterBandYSize;
    final MethodHandle getRasterCount;
    final MethodHandle getRasterBand;
    final MethodHandle getBandNumber;
    final MethodHandle getRasterDataType;
    final MethodHandle getRasterMinimum;
    final MethodHandle getRasterMaximum;
    final MethodHandle getRasterNoDataValue;
    final MethodHandle getRasterScale;
    final MethodHandle getRasterOffset;
    final MethodHandle getRasterUnitType;
    final MethodHandle getRasterCategoryNames;
    final MethodHandle getRasterColorTable;
    final MethodHandle getColorEntryCount;
    final MethodHandle getColorEntryAsRGB;
    final MethodHandle getColorInterpretation;
    final MethodHandle getBlockSize;
    final MethodHandle rasterIO;
    final MethodHandle adviseRead;
    final MethodHandle getLayerCount;
    private OGR ogr;

    private GDAL(LibraryLoader<GDAL> loader) {
        super(loader);
        FunctionDescriptor acceptPointerReturnPointer = FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS);
        FunctionDescriptor acceptPointerReturnInt = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
        FunctionDescriptor acceptTwoPtrsReturnDouble = FunctionDescriptor.of(ValueLayout.JAVA_DOUBLE, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
        FunctionDescriptor acceptTwoPtrsReturnPointer = FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
        this.free = this.lookup("VSIFree", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS));
        this.destroy = this.lookup("CSLDestroy", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS));
        this.identifyDriver = this.lookup("GDALIdentifyDriver", acceptTwoPtrsReturnPointer);
        this.getName = this.lookup("GDALGetDriverLongName", acceptPointerReturnPointer);
        this.getIdentifier = this.lookup("GDALGetDriverShortName", acceptPointerReturnPointer);
        this.getMetadata = this.lookup("GDALGetMetadata", acceptTwoPtrsReturnPointer);
        this.getMetadataItem = this.lookup("GDALGetMetadataItem", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        this.close = this.lookup("GDALClose", acceptPointerReturnInt);
        this.open = this.lookup("GDALOpenEx", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        this.getFileList = this.lookup("GDALGetFileList", acceptPointerReturnPointer);
        this.getDatasetDriver = this.lookup("GDALGetDatasetDriver", acceptPointerReturnPointer);
        this.getSpatialRef = this.lookup("GDALGetSpatialRef", acceptPointerReturnPointer);
        this.getGCPSpatialRef = this.lookup("GDALGetGCPSpatialRef", acceptPointerReturnPointer);
        this.exportToWkt = this.lookup("OSRExportToWktEx", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        this.getDataAxisToCRSAxis = this.lookup("OSRGetDataAxisToSRSAxisMapping", acceptTwoPtrsReturnPointer);
        this.getGeoTransform = this.lookup("GDALGetGeoTransform", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        this.getRasterXSize = this.lookup("GDALGetRasterXSize", acceptPointerReturnInt);
        this.getRasterYSize = this.lookup("GDALGetRasterYSize", acceptPointerReturnInt);
        this.getRasterCount = this.lookup("GDALGetRasterCount", acceptPointerReturnInt);
        this.getRasterBandXSize = this.lookup("GDALGetRasterBandXSize", acceptPointerReturnInt);
        this.getRasterBandYSize = this.lookup("GDALGetRasterBandYSize", acceptPointerReturnInt);
        this.getRasterBand = this.lookup("GDALGetRasterBand", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.getBandNumber = this.lookup("GDALGetBandNumber", acceptPointerReturnInt);
        this.getColorInterpretation = this.lookup("GDALGetRasterColorInterpretation", acceptPointerReturnInt);
        this.getRasterDataType = this.lookup("GDALGetRasterDataType", acceptPointerReturnInt);
        this.getRasterMinimum = this.lookup("GDALGetRasterMinimum", acceptTwoPtrsReturnDouble);
        this.getRasterMaximum = this.lookup("GDALGetRasterMaximum", acceptTwoPtrsReturnDouble);
        this.getRasterNoDataValue = this.lookup("GDALGetRasterNoDataValue", acceptTwoPtrsReturnDouble);
        this.getRasterScale = this.lookup("GDALGetRasterScale", acceptTwoPtrsReturnDouble);
        this.getRasterOffset = this.lookup("GDALGetRasterOffset", acceptTwoPtrsReturnDouble);
        this.getRasterUnitType = this.lookup("GDALGetRasterUnitType", acceptPointerReturnPointer);
        this.getRasterCategoryNames = this.lookup("GDALGetRasterCategoryNames", acceptPointerReturnPointer);
        this.getRasterColorTable = this.lookup("GDALGetRasterColorTable", acceptPointerReturnPointer);
        this.getColorEntryCount = this.lookup("GDALGetColorEntryCount", acceptPointerReturnInt);
        this.getColorEntryAsRGB = this.lookup("GDALGetColorEntryAsRGB", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.getBlockSize = this.lookup("GDALGetBlockSize", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        this.rasterIO = this.lookup("GDALRasterIO", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.adviseRead = this.lookup("GDALRasterAdviseRead", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.getLayerCount = this.lookup("GDALDatasetGetLayerCount", acceptPointerReturnInt);
        this.setErrorHandler(null);
        if (!this.invoke("GDALAllRegister")) {
            GDAL.log(GDAL.class, "<init>", Resources.forLocale(null).createLogRecord(Level.WARNING, (short)2, "GDAL"));
        }
    }

    private static LibraryLoader<GDAL> load(boolean now) {
        LibraryLoader<GDAL> loader = new LibraryLoader<GDAL>(GDAL::new);
        if (now) {
            try {
                global = loader.global("gdal");
            }
            finally {
                globalStatus = loader.status();
            }
            if (global != null && GDALStoreProvider.LOGGER.isLoggable(Level.CONFIG)) {
                global.version("--version").ifPresent(version -> GDAL.log(GDAL.class, "<init>", new LogRecord(Level.CONFIG, (String)version)));
            }
        }
        return loader;
    }

    static GDAL load(Path library) {
        return GDAL.load(false).load(library);
    }

    static synchronized GDAL global() throws DataStoreException {
        if (globalStatus == null) {
            GDAL.load(true).validate("GDAL");
        }
        globalStatus.report("GDAL", null);
        return global;
    }

    static synchronized Optional<GDAL> tryGlobal(Class<?> classe, String method) {
        if (globalStatus == null) {
            GDAL.load(true).getError("GDAL").ifPresent(record -> GDAL.log(classe, method, record));
        }
        return Optional.ofNullable(global);
    }

    private MemorySegment setErrorHandler(MemorySegment target) {
        MemorySegment setter = this.symbols.find("CPLSetErrorHandler").orElse(null);
        if (setter == null) {
            return MemorySegment.NULL;
        }
        if (target == null) {
            target = this.linker.upcallStub(ErrorHandler.getMethod(), FunctionDescriptor.ofVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), this.arena(), new Linker.Option[0]);
        }
        MethodHandle handle = this.linker.downcallHandle(setter, FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        try {
            return handle.invokeExact(target);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
    }

    private static void log(Class<?> classe, String method, LogRecord record) {
        Logging.completeAndLog((Logger)GDALStoreProvider.LOGGER, classe, (String)method, (LogRecord)record);
    }

    final Optional<String> version(String request) {
        return this.invokeGetString("GDALVersionInfo", request);
    }

    static List<String> fromNullTerminatedStrings(MemorySegment result) {
        String item;
        if (GDAL.isNull(result)) {
            return null;
        }
        result = result.reinterpret(Integer.MAX_VALUE);
        ArrayList<String> items = new ArrayList<String>();
        long stride = ValueLayout.ADDRESS.byteSize();
        long offset = 0L;
        while ((item = GDAL.toString(result.get(ValueLayout.ADDRESS, offset))) != null) {
            items.add(item);
            offset += stride;
        }
        return items;
    }

    static MemorySegment toNullTerminatedStrings(Arena arena, String ... items) {
        if (items == null) {
            return MemorySegment.NULL;
        }
        AddressLayout layout = ValueLayout.ADDRESS;
        MemorySegment array = arena.allocate(layout, items.length + 1);
        for (int i = 0; i < items.length; ++i) {
            array.setAtIndex(layout, (long)i, arena.allocateFrom(items[i]));
        }
        array.setAtIndex(layout, (long)items.length, MemorySegment.NULL);
        return array;
    }

    final synchronized OGR ogr() {
        if (this.ogr == null) {
            this.ogr = new OGR(this);
        }
        return this.ogr;
    }

    @Override
    public void run() {
        try {
            this.setErrorHandler(MemorySegment.NULL);
            this.invoke("GDALDestroy");
        }
        finally {
            super.run();
        }
    }
}

