/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.config.AnnotationTypedConfig;
import org.apache.sling.testing.mock.osgi.config.ComponentPropertyParser;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigType;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import osgimock.org.apache.felix.scr.impl.inject.internal.Annotations;

public final class ConfigTypeContext {
    private final OsgiContextImpl osgiContext;

    public ConfigTypeContext(OsgiContextImpl osgiContext) {
        this.osgiContext = osgiContext;
    }

    static void updatePropertiesForConfigPid(@NotNull Map<String, Object> updatedProperties, @NotNull String pid, @Nullable ConfigurationAdmin configurationAdmin) {
        if (configurationAdmin != null) {
            try {
                Configuration configuration = configurationAdmin.getConfiguration(pid);
                configuration.update(MapUtil.toDictionary(updatedProperties));
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read/write config for pid " + pid, e);
            }
        }
    }

    static void mergePropertiesFromConfigPid(@NotNull Map<String, Object> mergedProperties, @NotNull String pid, @Nullable ConfigurationAdmin configurationAdmin) {
        if (configurationAdmin != null) {
            try {
                Configuration configuration = configurationAdmin.getConfiguration(pid);
                Optional.ofNullable(MapUtil.toMap(configuration.getProperties())).ifPresent(mergedProperties::putAll);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read config for pid " + pid, e);
            }
        }
    }

    public Optional<String> getConfigurationPid(@NotNull String pid, @NotNull Class component) {
        if (pid.isEmpty() || "$".equals(pid)) {
            if (Void.class.equals((Object)component)) {
                return Optional.empty();
            }
            return Optional.of(component.getName());
        }
        return Optional.of(pid);
    }

    public void updateConfiguration(@NotNull SetConfig annotation) {
        this.getConfigurationPid(annotation.pid(), annotation.component()).ifPresent(pid -> {
            Map<String, Object> updated = ComponentPropertyParser.parse(annotation.property());
            this.updateConfiguration((String)pid, updated);
        });
    }

    public void updateConfiguration(@NotNull String pid, @NotNull Map<String, Object> propertyMap) {
        ConfigTypeContext.updatePropertiesForConfigPid(propertyMap, pid, this.osgiContext.getService(ConfigurationAdmin.class));
    }

    public Object constructConfigType(@NotNull ConfigType annotation) {
        return this.constructConfigType(annotation, null);
    }

    public Object constructConfigType(@NotNull ConfigType annotation, @Nullable String applyPid) {
        if (!annotation.type().isAnnotation() && !annotation.type().isInterface()) {
            throw new IllegalArgumentException("illegal value for ConfigType type " + String.valueOf(annotation.type()));
        }
        if (!annotation.lenient()) {
            ComponentPropertyParser.assertOneToOneMapping(annotation.type(), annotation.property());
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(ComponentPropertyParser.parse(annotation.type(), annotation.property()));
        Optional.ofNullable(applyPid).filter(pid -> !pid.isEmpty()).or(() -> this.getConfigurationPid(annotation.pid(), annotation.component())).ifPresent(pid -> ConfigTypeContext.mergePropertiesFromConfigPid(merged, pid, this.osgiContext.getService(ConfigurationAdmin.class)));
        return Annotations.toObject(annotation.type(), merged, this.osgiContext.bundleContext().getBundle(), false);
    }

    public TypedConfig newTypedConfig(@NotNull Annotation annotation) {
        return this.newTypedConfig(annotation, null);
    }

    public TypedConfig newTypedConfig(@NotNull Annotation annotation, @Nullable String applyPid) {
        if (annotation instanceof ConfigType) {
            ConfigType osgiConfig = (ConfigType)annotation;
            Class<?> mappingType = osgiConfig.type();
            return AnnotationTypedConfig.newInstance(mappingType, mappingType.cast(this.constructConfigType(osgiConfig, applyPid)), annotation);
        }
        return AnnotationTypedConfig.newInstance(annotation.annotationType(), annotation, annotation);
    }
}

