/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.ConstraintTarget;
import jakarta.validation.Payload;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.bval.util.reflection.TypeUtils;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public enum ConstraintAnnotationAttributes {
    MESSAGE("message", m -> true),
    GROUPS("groups", ObjectUtils::isEmptyArray),
    PAYLOAD("payload", ObjectUtils::isEmptyArray),
    VALIDATION_APPLIES_TO("validationAppliesTo", Predicate.isEqual(ConstraintTarget.IMPLICIT)),
    VALUE("value", ObjectUtils::isEmptyArray);

    private static final Set<ConstraintAnnotationAttributes> MANDATORY;
    private final Class<?> type;
    private final String attributeName;
    private final Predicate<Object> validateDefaultValue;
    private static final ConcurrentMap<Class<?>, Worker<?>> WORKER_CACHE;
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Method>> METHOD_BY_NAME_AND_CLASS;
    private static final Method NULL_METHOD;

    private ConstraintAnnotationAttributes(String name, Predicate<Object> validateDefaultValue) {
        this.attributeName = name;
        try {
            this.type = Types.class.getDeclaredField(this.getAttributeName()).getType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.validateDefaultValue = Validate.notNull(validateDefaultValue, "validateDefaultValue", new Object[0]);
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        return this.attributeName;
    }

    public <V> Object put(Map<? super String, ? super V> map, V value) {
        return map.put(this.getAttributeName(), value);
    }

    public <V> V get(Map<? super String, ? super V> map) {
        V result = map.get(this.getAttributeName());
        if (!TypeUtils.isInstance(result, this.getType())) {
            Exceptions.raise(IllegalStateException::new, "Invalid '%s' value: %s", this.getAttributeName(), result);
        }
        return result;
    }

    public <C extends Annotation> Worker<C> analyze(Class<C> clazz) {
        if (clazz.getName().startsWith("jakarta.validation.constraint.")) {
            Worker w = WORKER_CACHE.computeIfAbsent(clazz, c -> new Worker(c));
            return w;
        }
        return new Worker<C>(clazz);
    }

    public boolean isMandatory() {
        return MANDATORY.contains((Object)this);
    }

    public boolean isValidDefaultValue(Object o) {
        return this.validateDefaultValue.test(o);
    }

    static {
        MANDATORY = Collections.unmodifiableSet(EnumSet.of(MESSAGE, GROUPS, PAYLOAD));
        WORKER_CACHE = new ConcurrentHashMap();
        METHOD_BY_NAME_AND_CLASS = new ConcurrentHashMap();
        try {
            NULL_METHOD = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Impossible normally");
        }
    }

    @Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
    public class Worker<C extends Annotation> {
        public final Method method;

        Worker(Class<C> constraintType) {
            this.method = this.findMethod(constraintType, ConstraintAnnotationAttributes.this.attributeName);
        }

        private Method findMethod(Class<C> constraintType, String attributeName) {
            ConcurrentMap cache = METHOD_BY_NAME_AND_CLASS.computeIfAbsent(constraintType, t -> new ConcurrentHashMap());
            Method found = (Method)cache.get(attributeName);
            if (found != null) {
                return found;
            }
            Method m = Reflection.getPublicMethod(constraintType, attributeName, new Class[0]);
            if (m == null) {
                cache.putIfAbsent(attributeName, NULL_METHOD);
                return null;
            }
            return cache.computeIfAbsent(attributeName, s -> m);
        }

        public boolean isValid() {
            return this.method != null && this.method != NULL_METHOD && TypeUtils.isAssignable(this.method.getReturnType(), ConstraintAnnotationAttributes.this.type);
        }

        public Type getSpecificType() {
            return this.isValid() ? this.method.getGenericReturnType() : ConstraintAnnotationAttributes.this.type;
        }

        public <T> T read(Annotation constraint) {
            Object result = this.doInvoke(constraint);
            return (T)result;
        }

        private Object doInvoke(Annotation constraint) {
            Reflection.makeAccessible(this.method);
            try {
                return this.method.invoke((Object)constraint, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Types {
        String message;
        Class<?>[] groups;
        Class<? extends Payload>[] payload;
        Annotation[] value;
        ConstraintTarget validationAppliesTo;

        private Types() {
        }
    }
}

