/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.sd.task.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.container.sd.task.error.TaskProtocolException;
import org.apache.uima.ducc.container.sd.task.iface.TaskProtocolHandler;
import org.apache.uima.ducc.container.sd.task.transport.TaskTransportException;
import org.apache.uima.ducc.container.sd.task.transport.iface.TaskTransportHandler;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpTaskTransportHandler
implements TaskTransportHandler {
    Logger logger = UIMAFramework.getLogger(HttpTaskTransportHandler.class);
    private Server server = null;
    private TaskProtocolHandler taskProtocolHandler = null;
    private volatile boolean running = false;
    private Object mux = new Object();

    @Override
    public void setTaskProtocolHandler(TaskProtocolHandler taskProtocolHandler) {
        this.taskProtocolHandler = taskProtocolHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String start() throws Exception {
        Object object = this.mux;
        synchronized (object) {
            if (!this.running) {
                if (this.taskProtocolHandler == null) {
                    throw new TaskProtocolException("start() called before initialize() - task protocol handler not started");
                }
                if (this.server == null) {
                    throw new TaskProtocolException("start() called before initialize() - Jetty not started yet");
                }
                this.server.start();
                this.logger.log(Level.INFO, "Jetty Started - Waiting for Messages ...");
                this.running = true;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Object object = this.mux;
        synchronized (object) {
            if (this.server != null && this.server.isRunning()) {
                this.server.stop();
            }
        }
    }

    public Server createServer(int httpPort, int maxThreads, String app, TaskProtocolHandler handler) throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        if (maxThreads < threadPool.getMinThreads()) {
            threadPool.setMaxThreads(threadPool.getMinThreads());
        } else {
            threadPool.setMaxThreads(maxThreads);
        }
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(httpPort);
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new TaskHandlerServlet(handler)), "/" + app);
        return server;
    }

    @Override
    public String initialize(Properties properties) throws TaskTransportException {
        int cores = Runtime.getRuntime().availableProcessors();
        String portString = (String)properties.get("driver.server.port");
        String maxThreadsString = (String)properties.get("driver.server.max.threads");
        String appName = (String)properties.get("driver.application.name");
        int maxThreads = cores;
        int httpPort = -1;
        if (maxThreadsString != null) {
            try {
                maxThreads = Integer.parseInt(maxThreadsString.trim());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARNING, "Error", (Throwable)e);
            }
        }
        if (cores > maxThreads) {
            maxThreads = cores;
        }
        if (portString != null) {
            try {
                httpPort = Integer.parseInt(portString.trim());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARNING, "Error", (Throwable)e);
                throw new TaskTransportException("Unable to start Server using provided port:" + httpPort);
            }
        }
        if (appName == null) {
            appName = "test";
            this.logger.log(Level.WARNING, "The driver.application.name property is not specified - using " + appName);
        }
        try {
            this.server = this.createServer(httpPort, maxThreads, appName, this.taskProtocolHandler);
        }
        catch (Exception e) {
            throw new TaskTransportException(e);
        }
        String taskUrl = this.server.getURI().toString();
        if (taskUrl.endsWith("/")) {
            taskUrl = taskUrl.substring(0, taskUrl.length() - 1);
        }
        taskUrl = taskUrl + ":" + httpPort + "/" + appName;
        this.logger.log(Level.INFO, "Service Driver URL: " + taskUrl);
        return taskUrl;
    }

    public static void main(String[] args) {
    }

    public class TaskHandlerServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        TaskProtocolHandler taskProtocolHandler = null;

        public TaskHandlerServlet(TaskProtocolHandler handler) {
            this.taskProtocolHandler = handler;
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                String content = sb.toString().trim();
                IMetaTaskTransaction imt = null;
                imt = (IMetaTaskTransaction)XStreamUtils.unmarshall((String)content);
                this.taskProtocolHandler.handle(imt);
                imt.setDirection(IMetaTaskTransaction.Direction.Response);
                response.setStatus(200);
                response.setHeader("content-type", "text/xml");
                String body = XStreamUtils.marshall((Object)imt);
                response.getWriter().write(body);
            }
            catch (Throwable e) {
                throw new ServletException(e);
            }
        }
    }
}

