/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ducc.cli.DuccServiceApi;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.sm.ApiHandler;
import org.apache.uima.ducc.sm.IServiceManager;
import org.apache.uima.ducc.sm.ServiceInstance;
import org.apache.uima.ducc.sm.ServiceManagerComponent;
import org.apache.uima.ducc.sm.ServiceSet;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.AServiceRequest;
import org.apache.uima.ducc.transport.event.ServiceDisableEvent;
import org.apache.uima.ducc.transport.event.ServiceEnableEvent;
import org.apache.uima.ducc.transport.event.ServiceIgnoreEvent;
import org.apache.uima.ducc.transport.event.ServiceModifyEvent;
import org.apache.uima.ducc.transport.event.ServiceObserveEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryReplyEvent;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.apache.uima.ducc.transport.event.ServiceStartEvent;
import org.apache.uima.ducc.transport.event.ServiceStopEvent;
import org.apache.uima.ducc.transport.event.ServiceUnregisterEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.IServiceDescription;
import org.apache.uima.ducc.transport.event.sm.ServiceDependency;
import org.apache.uima.ducc.transport.event.sm.ServiceMap;

public class ServiceHandler
implements SmConstants,
Runnable {
    private DuccLogger logger = DuccLogger.getLogger((String)ServiceHandler.class.getName(), (String)"SM");
    private DuccId jobid = null;
    private IServiceManager serviceManager;
    private ServiceStateHandler serviceStateHandler = new ServiceStateHandler();
    private ServiceMap serviceMap = new ServiceMap();
    private IStateServices stateHandler;
    private Map<DuccId, IDuccWork> newJobs = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> newServices = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> deletedJobs = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> deletedServices = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> modifiedJobs = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> modifiedServices = new HashMap<DuccId, IDuccWork>();
    private List<ApiHandler> pendingRequests = new LinkedList<ApiHandler>();
    private Object stateUpdateLock = new Object();
    private Map<String, IUiOptions.UiOption> optionMap;
    boolean restart_pinger = false;
    boolean restart_service = false;

    public ServiceHandler(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        Runtime.getRuntime().addShutdownHook(new ServiceShutdown());
        DuccServiceApi dsi = new DuccServiceApi(null);
        IUiOptions.UiOption[] options = dsi.getModifyOptions();
        this.optionMap = new HashMap<String, IUiOptions.UiOption>();
        for (IUiOptions.UiOption o : options) {
            this.optionMap.put(o.pname(), o);
        }
    }

    public void init() {
        String methodName = "init";
        this.logger.debug(methodName, this.jobid, new Object[]{""});
        this.serviceStateHandler = new ServiceStateHandler();
        this.serviceMap.clear();
    }

    public void resume(IDuccWorkMap dwm) {
        String methodName = "resume";
        this.logger.debug(methodName, this.jobid, new Object[]{""});
        this.newJobs.clear();
        this.newServices.clear();
        this.deletedJobs.clear();
        this.deletedServices.clear();
        this.modifiedJobs.clear();
        this.modifiedServices.clear();
        this.pendingRequests.clear();
        Set serviceKeys = dwm.getServiceKeySet();
        if (serviceKeys != null) {
            for (DuccId duccId : serviceKeys) {
                IDuccWork dw = dwm.findDuccWork(duccId);
                if (dw != null) {
                    IDuccWorkService service = (IDuccWorkService)dw;
                    long swId = duccId.getFriendly();
                    String endpoint = service.getServiceEndpoint();
                    if (endpoint != null) {
                        ServiceSet ss = this.serviceStateHandler.getServiceByUrl(endpoint);
                        if (ss != null) {
                            ServiceInstance si = new ServiceInstance(ss);
                            ss.implementors.put(swId, si);
                            this.addInstance(ss, si);
                            this.logger.info(methodName, ss.getId(), new Object[]{swId, ss.endpoint});
                            continue;
                        }
                        this.logger.warn(methodName, duccId, new Object[]{"ss == null"});
                        continue;
                    }
                    this.logger.warn(methodName, duccId, new Object[]{"endpoint == null"});
                    continue;
                }
                this.logger.warn(methodName, duccId, new Object[]{"dw == null"});
            }
        } else {
            this.logger.debug(methodName, this.jobid, new Object[]{"serviceKeys == null"});
        }
    }

    public void quiesce() {
        String methodName = "quiesce";
        List<ServiceSet> list = this.serviceStateHandler.getServices();
        this.logger.debug(methodName, this.jobid, new Object[]{list.size()});
        for (ServiceSet ss : list) {
            DuccId duccId = ss.getId();
            ss.setState(IService.ServiceState.Dispossessed);
            this.logger.info(methodName, duccId, new Object[]{ss.getState(), ss.getImplementors().length, ss.getKey()});
            ss.stopPingThread();
        }
    }

    public void setAccessMode(IStateServices.AccessMode accessMode) {
        this.stateHandler.setAccessMode(accessMode);
    }

    void setStateHandler(IStateServices handler) {
        this.stateHandler = handler;
    }

    @Override
    public synchronized void run() {
        String methodName = "run";
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.error(methodName, null, (Throwable)e, new Object[0]);
            }
            try {
                this.runCommands();
                this.processUpdates();
                continue;
            }
            catch (Throwable t) {
                this.logger.error(methodName, null, t, new Object[0]);
                continue;
            }
            break;
        }
    }

    void bootImplementors(Map<DuccId, DuccWorkJob> incoming) {
        String methodName = "bootImplementors";
        for (DuccId id : incoming.keySet()) {
            DuccWorkJob j = incoming.get(id);
            String ep = j.getServiceEndpoint();
            ServiceSet sset = this.serviceStateHandler.getServiceByUrl(ep);
            if (sset == null) continue;
            sset.bootImplementor(id, j.getJobState());
        }
        List<ServiceSet> services = this.serviceStateHandler.getServices();
        for (ServiceSet sset : services) {
            try {
                sset.bootComplete();
            }
            catch (Exception e) {
                this.logger.warn(methodName, sset.getId(), new Object[]{"Error updating meta properties:", e});
            }
            if (sset.countImplementors() <= 0) continue;
            sset.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processUpdates() {
        String methodName = "processUpdates";
        this.logger.info(methodName, null, new Object[]{"Processing updates."});
        HashMap<DuccId, IDuccWork> deletedJobsMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> modifiedJobsMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> newJobsMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> deletedServicesMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> modifiedServicesMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> newServicesMap = new HashMap<DuccId, IDuccWork>();
        Object object = this.stateUpdateLock;
        synchronized (object) {
            deletedJobsMap.putAll(this.deletedJobs);
            this.deletedJobs.clear();
            this.logger.info(methodName, this.jobid, new Object[]{"deletedJobsMap", deletedJobsMap.size()});
            modifiedJobsMap.putAll(this.modifiedJobs);
            this.modifiedJobs.clear();
            this.logger.info(methodName, this.jobid, new Object[]{"modifiedJobsMap", modifiedJobsMap.size()});
            deletedServicesMap.putAll(this.deletedServices);
            this.deletedServices.clear();
            this.logger.info(methodName, this.jobid, new Object[]{"deletedServicessMap", deletedServicesMap.size()});
            modifiedServicesMap.putAll(this.modifiedServices);
            this.modifiedServices.clear();
            this.logger.info(methodName, this.jobid, new Object[]{"modifiedServicesMap", modifiedServicesMap.size()});
            newServicesMap.putAll(this.newServices);
            this.newServices.clear();
            this.logger.info(methodName, this.jobid, new Object[]{"newServicesMap", newServicesMap.size()});
            newJobsMap.putAll(this.newJobs);
            this.newJobs.clear();
            this.logger.info(methodName, this.jobid, new Object[]{"newJobsMap", newJobsMap.size()});
        }
        this.handleNewServices(newServicesMap);
        this.handleModifiedServices(modifiedServicesMap);
        this.handleDeletedServices(deletedServicesMap);
        this.handleNewJobs(newJobsMap);
        this.handleModifiedJobs(modifiedJobsMap);
        this.handleDeletedJobs(deletedJobsMap);
        List<ServiceSet> regsvcs = this.serviceStateHandler.getServices();
        for (ServiceSet sset : regsvcs) {
            sset.enforceAutostart();
        }
        this.serviceManager.publish(this.serviceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalUpdates(HashMap<DuccId, IDuccWork> newJobs, HashMap<DuccId, IDuccWork> newServices, HashMap<DuccId, IDuccWork> deletedJobs, HashMap<DuccId, IDuccWork> deletedServices, HashMap<DuccId, IDuccWork> modifiedJobs, HashMap<DuccId, IDuccWork> modifiedServices) {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            this.newJobs.putAll(newJobs);
            this.newServices.putAll(newServices);
            this.deletedJobs.putAll(deletedJobs);
            this.deletedServices.putAll(deletedServices);
            this.modifiedJobs.putAll(modifiedJobs);
            this.modifiedServices.putAll(modifiedServices);
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCommands() {
        String methodName = "runCommands";
        LinkedList<ApiHandler> tmp = new LinkedList<ApiHandler>();
        Object object = this.pendingRequests;
        synchronized (object) {
            tmp.addAll(this.pendingRequests);
            this.pendingRequests.clear();
        }
        this.logger.info(methodName, null, new Object[]{"Running", tmp.size(), "API Tasks."});
        object = this;
        synchronized (object) {
            for (ApiHandler apih : tmp) {
                apih.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addApiTask(ApiHandler apih) {
        List<ApiHandler> list = this.pendingRequests;
        synchronized (list) {
            this.pendingRequests.add(apih);
        }
    }

    protected Map<String, ServiceSet> resolveDependencies(DuccWorkJob w, ServiceDependency s) {
        DuccId id = w.getDuccId();
        String[] deps = w.getServiceDependencies();
        boolean fatal = false;
        HashMap<String, ServiceSet> jobServices = new HashMap<String, ServiceSet>();
        for (String dep : deps) {
            ServiceSet sset = this.serviceStateHandler.getServiceByUrl(dep);
            if (sset == null) {
                s.addMessage(dep, "Service is unknown.");
                s.setState(IService.ServiceState.NotAvailable);
                fatal = true;
                continue;
            }
            jobServices.put(dep, sset);
        }
        if (fatal) {
            jobServices.clear();
        } else {
            for (ServiceSet sset : jobServices.values()) {
                this.serviceStateHandler.putServiceForJob(w.getDuccId(), sset);
                sset.reference(id);
            }
        }
        return jobServices;
    }

    protected void resolveState(DuccId id, ServiceDependency dep) {
        Map<Long, ServiceSet> services = this.serviceStateHandler.getServicesForJob(id);
        if (services == null) {
            dep.setState(IService.ServiceState.NotAvailable);
            return;
        }
        IService.ServiceState state = IService.ServiceState.Available;
        for (ServiceSet sset : services.values()) {
            if (sset.getState().ordinality() < state.ordinality()) {
                state = sset.getState();
            }
            dep.setIndividualState(sset.getKey(), sset.getState());
            if (!sset.excessiveFailures()) continue;
            dep.addMessage(sset.getKey(), sset.getErrorString());
        }
        if (state.ordinality() < 5) {
            state = IService.ServiceState.Pending;
        }
        dep.setState(state);
    }

    protected void stopDependentServices(DuccId id) {
        String methodName = "stopDependentServices";
        Map<Long, ServiceSet> deps = this.serviceStateHandler.getServicesForJob(id);
        if (deps == null) {
            this.logger.info(methodName, id, new Object[]{"No dependent services to stop, returning."});
            return;
        }
        for (Long depid : deps.keySet()) {
            this.logger.debug(methodName, id, new Object[]{"Looking up service", depid});
            ServiceSet sset = deps.get(depid);
            if (sset == null) {
                this.logger.error(methodName, id, new Object[]{"Internal error: Null service for " + depid});
                continue;
            }
            sset.dereference(id);
        }
        this.serviceStateHandler.removeServicesForJob(id);
    }

    protected void handleNewJobs(Map<DuccId, IDuccWork> work) {
        String methodName = "handleNewJobs";
        HashMap<DuccId, ServiceDependency> updates = new HashMap<DuccId, ServiceDependency>();
        for (DuccId id : work.keySet()) {
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            if (!w.isActive()) {
                this.logger.info(methodName, id, new Object[]{"Bypassing inactive job, state =", w.getStateObject()});
                continue;
            }
            ServiceDependency s = new ServiceDependency();
            updates.put(id, s);
            String[] deps = w.getServiceDependencies();
            if (deps == null) {
                s.setState(IService.ServiceState.Available);
                this.logger.info(methodName, id, new Object[]{"Added to map, no service dependencies."});
                continue;
            }
            Map<String, ServiceSet> jobServices = this.resolveDependencies(w, s);
            for (ServiceSet sset : jobServices.values()) {
                this.logger.info(methodName, id, new Object[]{"Job is dependent on", sset.getKey()});
            }
            this.resolveState(id, s);
            this.logger.info(methodName, id, new Object[]{"Added job to map, with service dependency state.", s.getState()});
            this.logger.info(methodName, id, new Object[]{s.getMessages()});
        }
        this.serviceMap.putAll(updates);
    }

    protected void handleModifiedJobs(Map<DuccId, IDuccWork> work) {
        String methodName = "handleModifiedobs";
        for (DuccId id : work.keySet()) {
            DuccWorkJob j = (DuccWorkJob)work.get(id);
            String[] deps = j.getServiceDependencies();
            if (deps == null) {
                this.logger.info(methodName, id, new Object[]{"No service dependencies, no updates made."});
                continue;
            }
            ServiceDependency s = (ServiceDependency)this.serviceMap.get((Object)id);
            if (j.isFinished()) {
                this.stopDependentServices(id);
                s.setState(IService.ServiceState.NotAvailable);
                s.clearMessages();
                continue;
            }
            if (!j.isActive()) continue;
            this.resolveDependencies(j, s);
            this.resolveState(id, s);
        }
    }

    protected void handleDeletedJobs(Map<DuccId, IDuccWork> work) {
        String methodName = "handleDeletedobs";
        for (DuccId id : work.keySet()) {
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            String[] deps = w.getServiceDependencies();
            if (deps == null) {
                this.logger.info(methodName, id, new Object[]{"No service dependencies, no updates made."});
                continue;
            }
            this.stopDependentServices(id);
            this.logger.info(methodName, id, new Object[]{"Deleted job from map"});
        }
        this.serviceMap.removeAll(work.keySet());
    }

    protected void handleNewServices(Map<DuccId, IDuccWork> work) {
        String methodName = "handleNewServices";
        HashMap<DuccId, ServiceDependency> updates = new HashMap<DuccId, ServiceDependency>();
        for (DuccId id : work.keySet()) {
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            if (!w.isActive()) {
                this.logger.info(methodName, id, new Object[]{"Bypassing inactive service, state=", w.getStateObject()});
                continue;
            }
            ServiceDependency s = new ServiceDependency();
            updates.put(id, s);
            String endpoint = w.getServiceEndpoint();
            if (endpoint == null) {
                String msg = "No service endpoint.  Service cannot be validated.";
                this.logger.warn(methodName, id, new Object[]{msg});
                s.addMessage("null", msg);
                s.setState(IService.ServiceState.NotAvailable);
                continue;
            }
            String[] deps = w.getServiceDependencies();
            ServiceSet sset = this.serviceStateHandler.getServiceByImplementor(id.getFriendly());
            if (sset == null) {
                s.addMessage(endpoint, "No registered service for " + endpoint);
                s.setState(IService.ServiceState.NotAvailable);
                continue;
            }
            if (deps == null) {
                this.logger.info(methodName, id, new Object[]{"Added service to map, no service dependencies. "});
                s.setState(IService.ServiceState.Available);
                sset.signalUpdate(w);
                continue;
            }
            this.resolveDependencies(w, s);
            this.resolveState(id, s);
            sset.signalUpdate(w);
            this.logger.info(methodName, id, new Object[]{"Added to map, with service dependencies,", s.getState()});
        }
        this.serviceMap.putAll(updates);
    }

    protected void handleModifiedServices(Map<DuccId, IDuccWork> work) {
        String methodName = "handleModifiedServices";
        for (DuccId id : work.keySet()) {
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            IDuccProcessMap pm = w.getProcessMap();
            String node = "<unknown>";
            Long share_id = -1L;
            if (pm.size() > 1) {
                this.logger.warn(methodName, id, new Object[]{"Process map is too large, should be size 1.  Size:", pm.size(), "Cannot determine node or share_id for service."});
            } else if (pm.size() < 1) {
                this.logger.warn(methodName, id, new Object[]{"Process map is empty but we are expecting exactly one entry. Cannot determine node or share id for service."});
            } else {
                for (DuccId pid : pm.keySet()) {
                    NodeIdentity ni = ((IDuccProcess)pm.get((Object)pid)).getNodeIdentity();
                    node = ni.getCanonicalName();
                    share_id = pid.getFriendly();
                }
            }
            String ssid = w.getServiceId();
            if (ssid == null) {
                this.logger.warn(methodName, id, new Object[]{"Missing service id, ignoring."});
                continue;
            }
            ServiceSet sset = this.serviceStateHandler.getServiceByImplementor(id.getFriendly());
            if (sset == null) {
                long sid = Long.valueOf(ssid);
                sset = this.serviceStateHandler.getServiceById(sid);
                if (sset == null) {
                    this.logger.info(methodName, id, new Object[]{"Active service instance update for", w.getServiceId(), "but have no registration for it. Job state:", w.getJobState()});
                    continue;
                }
                this.logger.info(methodName, id, new Object[]{"Update for possibly unregistered service. Job State:", w.getJobState()});
            }
            if (!sset.containsImplementor(id)) {
                if (sset.canDeleteInstance(w)) continue;
                this.logger.warn(methodName, id, new Object[]{"sset for", sset.getId(), "does not contain instance"});
                continue;
            }
            if (share_id != -1L) {
                sset.updateInstance(id.getFriendly(), share_id, node);
            }
            ServiceDependency s = (ServiceDependency)this.serviceMap.get((Object)id);
            if (w.isFinished()) {
                this.stopDependentServices(id);
                s.setState(IService.ServiceState.NotAvailable);
            } else if (w.getServiceDependencies() != null) {
                this.resolveDependencies(w, s);
                this.resolveState(id, s);
            }
            sset.signalUpdate(w);
        }
    }

    protected void handleDeletedServices(Map<DuccId, IDuccWork> work) {
        String methodName = "handleDeletedServices";
        for (DuccId id : work.keySet()) {
            ServiceSet sset;
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            String url = w.getServiceEndpoint();
            this.logger.info(methodName, id, new Object[]{"Instance deleted for", url});
            if (url == null) {
                this.logger.warn(methodName, id, new Object[]{"Missing service endpoint, ignoring."});
                continue;
            }
            if (w.getServiceDependencies() == null) {
                this.logger.info(methodName, id, new Object[]{"No service dependencies to update on removal."});
            } else {
                this.stopDependentServices(id);
            }
            if ((sset = this.serviceStateHandler.getServiceByImplementor(id.getFriendly())) == null) continue;
            sset.signalUpdate(w);
        }
        this.serviceMap.removeAll(work.keySet());
    }

    void updateServiceQuery(IServiceDescription sd, ServiceSet sset) {
        String[] deps = sset.getIndependentServices();
        if (deps != null) {
            for (String dep : deps) {
                ServiceSet independent = this.serviceStateHandler.getServiceByUrl(dep);
                if (independent != null) {
                    sd.addDependency(dep, independent.getState().decode());
                    continue;
                }
                sd.addDependency(dep, IService.ServiceState.Stopped.decode());
            }
        }
    }

    synchronized ServiceReplyEvent query(ServiceQueryEvent ev) {
        long id = ev.getFriendly();
        String url = ev.getEndpoint();
        ServiceQueryReplyEvent reply = new ServiceQueryReplyEvent();
        if (id == -1L && url == null) {
            for (ServiceSet sset : this.serviceStateHandler.getServices()) {
                IServiceDescription sd = sset.query();
                this.updateServiceQuery(sd, sset);
                reply.addService(sd);
                reply.setReturnCode(true);
            }
        } else {
            ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url);
            reply.setEndpoint(url);
            reply.setId(id);
            if (sset == null) {
                reply.setMessage("Unknown service");
                reply.setEndpoint(url);
                reply.setReturnCode(false);
            } else {
                IServiceDescription sd = sset.query();
                this.updateServiceQuery(sd, sset);
                reply.addService(sd);
                reply.setReturnCode(true);
            }
        }
        return reply;
    }

    boolean authorized(String operation, ServiceSet sset, AServiceRequest req) {
        String userout;
        String methodName = "authorized";
        String userin = req.getUser();
        if (userin.equals(userout = sset.getUser())) {
            this.logger.info(methodName, sset.getId(), new Object[]{operation, "request from", userin, "allowed."});
            return true;
        }
        if (this.serviceManager.isAdministrator(req)) {
            this.logger.info(methodName, sset.getId(), new Object[]{operation, "request from", userin, "allowed as DUCC administrator. Service owner:", userout});
            return true;
        }
        if (sset.isAuthorized(userin)) {
            this.logger.info(methodName, sset.getId(), new Object[]{operation, "request from", userin, "alloed as co-ownder.  Service owner:", userout});
            return true;
        }
        this.logger.info(methodName, sset.getId(), new Object[]{operation, "request from", userin, "not authorized.  Service owner:", userout});
        return false;
    }

    synchronized ServiceReplyEvent start(ServiceStartEvent ev) {
        String url;
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("start", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        int running = sset.countImplementors();
        int instances = ev.getInstances();
        if (instances == -1 && !sset.enabled()) {
            sset.enable();
        } else if (!sset.enabled()) {
            return ServiceManagerComponent.makeResponse(false, "Service is disabled, cannot start (" + sset.getDisableReason() + ")", url, sset.getId().getFriendly());
        }
        if (sset.isDebug() && sset.countImplementors() > 0) {
            return ServiceManagerComponent.makeResponse(true, "Already has instances[" + running + "] and service has process_debug set - no additional instances started", sset.getKey(), sset.getId().getFriendly());
        }
        int registered = sset.getNInstancesRegistered();
        int wanted = 0;
        wanted = instances == -1 ? Math.max(0, registered - running) : instances;
        if (wanted == 0) {
            return ServiceManagerComponent.makeResponse(true, "Already has instances[" + running + "] - no additional instances started", sset.getKey(), sset.getId().getFriendly());
        }
        this.pendingRequests.add(new ApiHandler(ev, this));
        if (sset.isDebug() && wanted > 1) {
            return ServiceManagerComponent.makeResponse(true, "Instances adjusted to [1] because process_debug is set", sset.getKey(), sset.getId().getFriendly());
        }
        return ServiceManagerComponent.makeResponse(true, "New instances[" + wanted + "]", sset.getKey(), sset.getId().getFriendly());
    }

    void doStart(ServiceStartEvent ev) {
        String methodName = "doStart";
        long friendly = ev.getFriendly();
        String epname = ev.getEndpoint();
        int instances = ev.getInstances();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname);
        int running = sset.countImplementors();
        int registered = sset.getNInstancesRegistered();
        int wanted = 0;
        if (sset.isDebug()) {
            if (sset.countImplementors() > 0) {
                this.logger.warn(methodName, sset.getId(), new Object[]{"Not starting additional instances because process_debug is set."});
                return;
            }
            if (instances > 1) {
                this.logger.warn(methodName, sset.getId(), new Object[]{"Adjusting instances to [1] because process_debug is set."});
                instances = 1;
            }
        }
        wanted = instances == -1 ? Math.max(0, registered - running) : instances;
        sset.resetRuntimeErrors();
        sset.setStarted();
        sset.updateInstances(running + wanted);
    }

    synchronized ServiceReplyEvent stop(ServiceStopEvent ev) {
        String msg;
        String url;
        String methodName = "stop";
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("stop", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        if (sset.isStopped()) {
            return ServiceManagerComponent.makeResponse(false, "Already stopped", sset.getKey(), sset.getId().getFriendly());
        }
        int running = sset.countImplementors();
        int instances = ev.getInstances();
        if (instances == -1) {
            int tolose = running;
            msg = "Stopping all deployments.";
        } else {
            int tolose = Math.min(instances, running);
            msg = "Stopping " + tolose + " deployments.";
        }
        this.logger.info(methodName, sset.getId(), new Object[]{msg});
        this.pendingRequests.add(new ApiHandler(ev, this));
        return ServiceManagerComponent.makeResponse(true, msg, sset.getKey(), sset.getId().getFriendly());
    }

    void doStop(ServiceStopEvent event) {
        int instances = event.getInstances();
        long id = event.getFriendly();
        String url = event.getEndpoint();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url);
        int running = sset.countImplementors();
        if (instances == -1) {
            sset.disableAndStop("Disabled by stop from id " + event.getUser());
        } else {
            int tolose = Math.min(instances, running);
            sset.updateInstances(Math.max(0, running - tolose));
        }
    }

    synchronized ServiceReplyEvent disable(ServiceDisableEvent ev) {
        String url;
        String methodName = "disable";
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("disable", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        if (!sset.enabled()) {
            return ServiceManagerComponent.makeResponse(true, "Service is already disabled", sset.getKey(), sset.getId().getFriendly());
        }
        sset.disable("Disabled by owner or administrator " + ev.getUser());
        try {
            sset.updateMetaProperties();
        }
        catch (Exception e) {
            this.logger.warn(methodName, sset.getId(), new Object[]{"Error updating meta properties:", e});
        }
        return ServiceManagerComponent.makeResponse(true, "Disabled", sset.getKey(), sset.getId().getFriendly());
    }

    synchronized ServiceReplyEvent enable(ServiceEnableEvent ev) {
        String url;
        String methodName = "enable";
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("enable", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        if (sset.enabled()) {
            return ServiceManagerComponent.makeResponse(true, "Service is already enabled", sset.getKey(), sset.getId().getFriendly());
        }
        sset.enable();
        try {
            sset.updateMetaProperties();
        }
        catch (Exception e) {
            this.logger.warn(methodName, sset.getId(), new Object[]{"Error updating meta properties:", e});
        }
        return ServiceManagerComponent.makeResponse(true, "Enabled.", sset.getKey(), sset.getId().getFriendly());
    }

    synchronized ServiceReplyEvent ignore(ServiceIgnoreEvent ev) {
        String url;
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("ignore", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        if (sset.isAutostart()) {
            return ServiceManagerComponent.makeResponse(false, "Service is autostarted, ignore-references not applied.", sset.getKey(), sset.getId().getFriendly());
        }
        if (!sset.isReferencedStart()) {
            return ServiceManagerComponent.makeResponse(true, "Service is already ignoring references", sset.getKey(), sset.getId().getFriendly());
        }
        if (sset.countImplementors() == 0) {
            return ServiceManagerComponent.makeResponse(false, "Cannot ignore references, service is not running.", sset.getKey(), sset.getId().getFriendly());
        }
        sset.ignoreReferences();
        return ServiceManagerComponent.makeResponse(true, "References now being ignored.", sset.getKey(), sset.getId().getFriendly());
    }

    synchronized ServiceReplyEvent observe(ServiceObserveEvent ev) {
        String url;
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("observe", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        if (sset.isAutostart()) {
            return ServiceManagerComponent.makeResponse(false, "Must set autostart off before enabling reference-starts.", sset.getKey(), sset.getId().getFriendly());
        }
        if (sset.countImplementors() == 0) {
            return ServiceManagerComponent.makeResponse(false, "Cannot observe references, service is not running.", sset.getKey(), sset.getId().getFriendly());
        }
        sset.observeReferences();
        return ServiceManagerComponent.makeResponse(true, "Observing references.", sset.getKey(), sset.getId().getFriendly());
    }

    synchronized ServiceReplyEvent register(DuccId id, DuccProperties props, DuccProperties meta, boolean isRecovered) {
        String methodName = "register";
        String error = null;
        boolean must_deregister = false;
        String url = meta.getProperty("endpoint");
        ServiceSet sset = this.serviceStateHandler.getServiceByUrl(url);
        if (sset != null) {
            error = "Duplicate registered by " + sset.getUser();
            return ServiceManagerComponent.makeResponse(false, error, url, sset.getId().getFriendly());
        }
        try {
            sset = new ServiceSet(this, this.stateHandler, id, props, meta);
        }
        catch (Throwable t) {
            error = t.getMessage();
            return ServiceManagerComponent.makeResponse(false, error, url, id.getFriendly());
        }
        try {
            sset.storeProperties(isRecovered);
        }
        catch (Exception e) {
            error = "Internal error; unable to store service descriptor. " + url;
            this.logger.error(methodName, id, (Throwable)e, new Object[0]);
        }
        if (!must_deregister) {
            // empty if block
        }
        if (error == null) {
            this.serviceStateHandler.registerService(id.getFriendly(), url, sset);
            return ServiceManagerComponent.makeResponse(true, "Registered", url, id.getFriendly());
        }
        return ServiceManagerComponent.makeResponse(false, error, url, id.getFriendly());
    }

    synchronized ServiceReplyEvent modify(ServiceModifyEvent ev) {
        String url;
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("modify", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        this.pendingRequests.add(new ApiHandler(ev, this));
        return ServiceManagerComponent.makeResponse(true, "Modify accepted:", sset.getKey(), sset.getId().getFriendly());
    }

    void modifyRegistration(ServiceSet sset, IUiOptions.UiOption option, String value) {
        int intval = 0;
        boolean boolval = false;
        switch (option) {
            case Instances: {
                intval = Integer.parseInt(value);
                sset.updateRegisteredInstances(intval);
                break;
            }
            case Autostart: {
                boolval = Boolean.parseBoolean(value);
                sset.setAutostart(boolval);
                break;
            }
            case Administrators: {
                sset.setJobProperty(option.pname(), value);
                sset.parseAdministrators(value);
                break;
            }
            case Description: 
            case LogDirectory: 
            case Jvm: 
            case ProcessJvmArgs: 
            case Classpath: 
            case SchedulingClass: 
            case Environment: 
            case ProcessMemorySize: 
            case ProcessExecutable: 
            case ProcessExecutableArgs: 
            case ServiceDependency: 
            case ProcessInitializationTimeMax: 
            case WorkingDirectory: {
                sset.setJobProperty(option.pname(), value);
                break;
            }
            case InstanceInitFailureLimit: {
                sset.updateInitFailureLimit(value);
                sset.setJobProperty(option.pname(), value);
                break;
            }
            case ServiceLinger: {
                sset.updateLinger(value);
                sset.setJobProperty(option.pname(), value);
                break;
            }
            case ProcessDebug: {
                sset.updateDebug(value);
                break;
            }
            case ServicePingArguments: 
            case ServicePingClasspath: 
            case ServicePingJvmArgs: 
            case ServicePingTimeout: 
            case ServicePingDoLog: 
            case ServicePingClass: 
            case InstanceFailureWindow: 
            case InstanceFailureLimit: {
                if (value.equals("default")) {
                    sset.deleteJobProperty(option.pname());
                } else {
                    sset.setJobProperty(option.pname(), value);
                }
                this.restart_pinger = true;
                break;
            }
        }
    }

    void doModify(ServiceModifyEvent sme) {
        String methodName = "doModify";
        long id = sme.getFriendly();
        String url = sme.getEndpoint();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url);
        DuccProperties mods = sme.getProperties();
        this.restart_pinger = false;
        this.restart_service = false;
        boolean updateMeta = false;
        Set keys = mods.stringPropertyNames();
        block8: for (String kk : keys) {
            IUiOptions.UiOption k = this.optionMap.get(kk);
            if (k == null) {
                this.logger.debug(methodName, sset.getId(), new Object[]{"Bypass property", kk});
                continue;
            }
            switch (k) {
                case Help: 
                case Debug: 
                case Modify: {
                    continue block8;
                }
                case Autostart: {
                    updateMeta = true;
                }
            }
            String v = (String)mods.get((Object)kk);
            try {
                this.modifyRegistration(sset, k, v);
            }
            catch (Throwable t) {
                this.logger.error(methodName, sset.getId(), new Object[]{"Modify", kk, "to", v, "Failed:", t});
                continue;
            }
            this.logger.info(methodName, sset.getId(), new Object[]{"Modify", kk, "to", v, "restart_service[" + this.restart_service + "]", "restart_pinger[" + this.restart_pinger + "]"});
        }
        sset.resetRuntimeErrors();
        try {
            sset.updateSvcProperties();
            if (updateMeta) {
                sset.updateMetaProperties();
            }
        }
        catch (Exception e) {
            this.logger.error(methodName, sset.getId(), new Object[]{"Cannot store properties:", e});
        }
        if (this.restart_pinger) {
            sset.restartPinger();
            this.restart_pinger = false;
        }
    }

    synchronized ServiceReplyEvent unregister(ServiceUnregisterEvent ev) {
        String url;
        String methodName = "unregister";
        long id = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(id, url = ev.getEndpoint());
        if (sset == null) {
            this.logger.info(methodName, null, new Object[]{"Unknown service", id, url});
            return ServiceManagerComponent.makeResponse(false, "Unknown service", url, id);
        }
        if (!this.authorized("unregister", sset, (AServiceRequest)ev)) {
            return ServiceManagerComponent.makeResponse(false, "Owned by " + sset.getUser(), url, sset.getId().getFriendly());
        }
        ev.setFriendly(sset.getId().getFriendly());
        this.serviceStateHandler.unregister(sset);
        this.pendingRequests.add(new ApiHandler(ev, this));
        this.logger.info(methodName, null, new Object[]{"Unregistering service", id, url});
        return ServiceManagerComponent.makeResponse(true, "Shutting down implementors", sset.getKey(), sset.getId().getFriendly());
    }

    void doUnregister(ServiceUnregisterEvent ev) {
        String methodName = "doUnregister";
        long friendly = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceById(friendly);
        if (sset == null) {
            this.logger.error(methodName, null, new Object[]{"Service", friendly, "is not a known, service. No action taken."});
            return;
        }
        String url = sset.getKey();
        sset.disableAndStop("Disabled by unregister from id " + ev.getUser());
        if (sset.isPingOnly()) {
            this.logger.info(methodName, sset.getId(), new Object[]{"Unregister ping-only setvice:", friendly, url});
            this.serviceStateHandler.removeService(sset);
            try {
                sset.deleteProperties();
            }
            catch (Exception e) {
                this.logger.error(methodName, sset.getId(), new Object[]{"Cannot delete service from DB:", e});
            }
        } else if (sset.countImplementors() > 0) {
            this.logger.debug(methodName, sset.getId(), new Object[]{"Stopping implementors:", friendly, url});
        } else {
            this.logger.debug(methodName, sset.getId(), new Object[]{"Removing from map:", friendly, url});
            sset.clearQueue();
        }
    }

    void addInstance(ServiceSet sset, ServiceInstance inst) {
        this.serviceStateHandler.addImplementorFor(sset, inst);
    }

    void removeImplementor(ServiceSet sset, ServiceInstance inst) {
        this.serviceStateHandler.removeImplementorFor(sset, inst);
    }

    void removeService(ServiceSet sset) {
        this.serviceStateHandler.removeService(sset);
    }

    public static void main(String[] args) {
    }

    class ServiceStateHandler {
        private Map<String, Long> registeredServiceIdsByUrl = new HashMap<String, Long>();
        private Map<Long, ServiceSet> registeredServicesById = new HashMap<Long, ServiceSet>();
        private Map<Long, ServiceSet> servicesByImplementor = new HashMap<Long, ServiceSet>();
        private Map<DuccId, Map<Long, ServiceSet>> servicesByJob = new HashMap<DuccId, Map<Long, ServiceSet>>();

        ServiceStateHandler() {
        }

        synchronized void unregister(ServiceSet sset) {
            String methodName = "ServiceStateHandler.unregister";
            String key = sset.getKey();
            ServiceHandler.this.logger.info(methodName, sset.getId(), new Object[]{"Removing", key, "from name->id map"});
            this.registeredServiceIdsByUrl.remove(key);
            sset.deregister();
        }

        synchronized boolean hasService(DuccId id) {
            String methodName = "ServiceStateHandler.hasService";
            ServiceHandler.this.logger.info(methodName, null, new Object[]{"containsKey", id, this.registeredServicesById.containsKey(id.getFriendly())});
            return this.registeredServicesById.containsKey(id.getFriendly());
        }

        synchronized void registerService(Long id, String ep, ServiceSet sset) {
            String methodName = "ServiceStateHandler.registerService";
            ServiceHandler.this.logger.info(methodName, sset.getId(), new Object[]{"adding", ep, id});
            this.registeredServiceIdsByUrl.put(ep, id);
            this.registeredServicesById.put(id, sset);
        }

        synchronized ServiceSet getServiceByUrl(String n) {
            Long id = this.registeredServiceIdsByUrl.get(n);
            return id == null ? null : this.registeredServicesById.get(id);
        }

        synchronized ServiceSet getServiceById(long id) {
            return this.registeredServicesById.get(id);
        }

        synchronized List<ServiceSet> getServices() {
            ArrayList<ServiceSet> answer = new ArrayList<ServiceSet>();
            for (ServiceSet sset : this.registeredServicesById.values()) {
                if (sset.isDeregistered()) continue;
                answer.add(sset);
            }
            return answer;
        }

        synchronized void addImplementorFor(ServiceSet sset, ServiceInstance inst) {
            this.servicesByImplementor.put(inst.getId(), sset);
        }

        synchronized ServiceSet getServiceByImplementor(long instId) {
            return this.servicesByImplementor.get(instId);
        }

        synchronized void removeImplementorFor(ServiceSet sset, ServiceInstance inst) {
            this.servicesByImplementor.remove(inst.getId());
        }

        synchronized ServiceSet getServiceForApi(long id, String n) {
            return n == null ? this.getServiceById(id) : this.getServiceByUrl(n);
        }

        synchronized void removeService(ServiceSet sset) {
            DuccId[] refids;
            Long[] implids;
            long id = sset.getId().getFriendly();
            this.registeredServicesById.remove(id);
            Long[] longArray = implids = sset.getImplementors();
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long l = longArray[i];
                this.servicesByImplementor.remove(l);
            }
            for (DuccId rid : refids = sset.getReferences()) {
                this.servicesByJob.remove(rid);
            }
        }

        synchronized Map<Long, ServiceSet> getServicesForJob(DuccId id) {
            return this.servicesByJob.get(id);
        }

        synchronized void putServiceForJob(DuccId id, ServiceSet s) {
            Map<Long, ServiceSet> services = this.servicesByJob.get(id);
            if (services == null) {
                services = new HashMap<Long, ServiceSet>();
                this.servicesByJob.put(id, services);
            }
            services.put(s.getId().getFriendly(), s);
        }

        synchronized void removeServicesForJob(DuccId id) {
            this.servicesByJob.remove(id);
        }
    }

    class ServiceShutdown
    extends Thread {
        ServiceShutdown() {
            System.out.println("Setting shutdown hook");
        }

        @Override
        public void run() {
            System.out.println("Running shutdown hook");
            List<ServiceSet> allServices = ServiceHandler.this.serviceStateHandler.getServices();
            for (ServiceSet sset : allServices) {
                sset.stopMonitor();
            }
            try {
                ServiceHandler.this.stateHandler.shutdown();
            }
            catch (Exception e) {
                ServiceHandler.this.logger.warn("ServicShutdown.run", null, new Object[]{"Error closing database: ", e});
            }
        }
    }
}

