/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm.config;

import javax.jms.Destination;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.sm.ServiceManagerComponent;
import org.apache.uima.ducc.sm.event.ServiceManagerEventListener;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.event.AServiceRequest;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class ServiceManagerConfiguration {
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration serviceManagerTransport;
    private DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"SM");
    private static DuccId jobid = null;

    public ServiceManagerEventListener serviceManagerDelegateListener(ServiceManagerComponent sm) {
        ServiceManagerEventListener smel = new ServiceManagerEventListener(sm);
        smel.setEndpoint(this.common.pmRequestEndpoint);
        return smel;
    }

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String endpoint, final ServiceManagerEventListener delegate) {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(endpoint).process((Processor)new TransportProcessor())).bean((Object)delegate);
            }
        };
    }

    public synchronized RouteBuilder routeBuilderForApi(final String endpoint, final ServiceManagerEventListener delegate) {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(endpoint).process((Processor)new TransportProcessor())).bean((Object)delegate)).process((Processor)new SmReplyProcessor());
            }
        };
    }

    @Bean
    public ServiceManagerComponent serviceManager() throws Exception {
        ServiceManagerComponent sm = new ServiceManagerComponent(this.common.camelContext());
        ServiceManagerEventListener delegateListener = this.serviceManagerDelegateListener(sm);
        sm.setTransportConfiguration(this.serviceManagerTransport.duccEventDispatcher(this.common.smStateUpdateEndpoint, sm.getContext()), this.common.smStateUpdateEndpoint, this.common.daemonsStateChangeEndpoint);
        sm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.orchestratorStateUpdateEndpoint, delegateListener));
        sm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForApi(this.common.smApiEndpoint, delegateListener));
        return sm;
    }

    public class TransportProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String location = "process";
            String text = "... SM transport received Event. Body Type:" + exchange.getIn().getBody().getClass().getName();
            ServiceManagerConfiguration.this.logger.debug(location, jobid, new Object[]{text});
            Destination replyTo = (Destination)exchange.getIn().getHeader("JMSReplyTo", Destination.class);
            text = "... transport - value of replyTo:" + replyTo;
            ServiceManagerConfiguration.this.logger.debug(location, jobid, new Object[]{text});
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            try {
                ServiceManagerConfiguration.this.logger.error("ErrorProcessor.process", null, caused, new Object[0]);
                exchange.getOut().setBody((Object)XStreamUtils.marshall((Object)caused));
            }
            catch (Throwable t) {
                ServiceManagerConfiguration.this.logger.error("ErrorProcessor.process", null, t, new Object[0]);
            }
        }
    }

    private class SmReplyProcessor
    implements Processor {
        private SmReplyProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String methodName = "process";
            try {
                ServiceManagerConfiguration.this.logger.info(methodName, null, new Object[]{"Replying"});
                AServiceRequest incoming = (AServiceRequest)exchange.getIn().getBody();
                ServiceReplyEvent reply = incoming.getReply();
                exchange.getIn().setBody((Object)reply);
            }
            catch (Throwable t) {
                ServiceManagerConfiguration.this.logger.error(methodName, null, t, new Object[0]);
            }
        }
    }
}

