/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.jd.files.workitem.IRemoteLocation;
import org.apache.uima.ducc.common.jd.files.workitem.RemoteLocation;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.IDuccId;
import org.apache.uima.ducc.orchestrator.CGroupManager;
import org.apache.uima.ducc.orchestrator.OrUtil;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.OrchestratorHelper;
import org.apache.uima.ducc.orchestrator.ProcessToJobMap;
import org.apache.uima.ducc.orchestrator.StateJobAccounting;
import org.apache.uima.ducc.orchestrator.WorkMapHelper;
import org.apache.uima.ducc.orchestrator.ckpt.OrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.user.UserLogging;
import org.apache.uima.ducc.orchestrator.utilities.TrackSync;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.cmdline.JavaCommandLine;
import org.apache.uima.ducc.transport.event.common.DuccProcess;
import org.apache.uima.ducc.transport.event.common.DuccReservation;
import org.apache.uima.ducc.transport.event.common.DuccUimaDeploymentDescriptor;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccUimaDeployableConfiguration;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.Rationale;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;
import org.apache.uima.ducc.transport.event.jd.IDriverStatusReport;
import org.apache.uima.ducc.transport.event.jd.IDuccProcessWorkItemsReport;
import org.apache.uima.ducc.transport.event.rm.IResource;
import org.apache.uima.ducc.transport.event.rm.IRmJobState;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.ServiceDependency;
import org.apache.uima.ducc.transport.event.sm.ServiceMap;

public class StateManager {
    private static final DuccLogger logger = DuccLogger.getLogger(StateManager.class);
    private static final DuccId jobid = null;
    private static StateManager stateManager = new StateManager();
    private OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private Messages messages = this.orchestratorCommonArea.getSystemMessages();
    private StateJobAccounting stateJobAccounting = StateJobAccounting.getInstance();
    private IHistoryPersistenceManager hpm = this.orchestratorCommonArea.getHistoryPersistencemanager();
    private long SECONDS = 1000L;
    private long MINUTES = 60L * this.SECONDS;
    private long AgeTime = 1L * this.MINUTES;
    private static AtomicBoolean refusedLogged = new AtomicBoolean(false);

    public static StateManager getInstance() {
        return stateManager;
    }

    private boolean jobDriverTerminated(DuccWorkJob duccWorkJob) {
        String methodName = "jobDriverTerminated";
        boolean status = true;
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        IDuccProcessMap processMap = duccWorkJob.getDriver().getProcessMap();
        for (DuccId duccId : processMap.keySet()) {
            IDuccProcess process = (IDuccProcess)processMap.get((Object)duccId);
            if (!process.isActive()) continue;
            logger.debug(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("processes active:") + duccId});
            status = false;
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return status;
    }

    private boolean jobProcessesTerminated(DuccWorkJob duccWorkJob) {
        String methodName = "jobProcessesTerminated";
        boolean status = true;
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        IDuccProcessMap processMap = duccWorkJob.getProcessMap();
        for (DuccId duccId : processMap.keySet()) {
            IDuccProcess process = (IDuccProcess)processMap.get((Object)duccId);
            if (!process.isActive()) continue;
            logger.debug(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("processes active:") + duccId});
            status = false;
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return status;
    }

    private boolean allProcessesTerminated(DuccWorkJob duccWorkJob) {
        String methodName = "allProcessesTerminated";
        boolean status = false;
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        switch (duccWorkJob.getDuccType()) {
            case Job: {
                if (!this.jobDriverTerminated(duccWorkJob) || !this.jobProcessesTerminated(duccWorkJob)) break;
                status = true;
                if (duccWorkJob.getStandardInfo().getDateOfShutdownProcessesMillis() > 0L) break;
                duccWorkJob.getStandardInfo().setDateOfShutdownProcesses(TimeStamp.getCurrentMillis());
                break;
            }
            case Service: {
                if (!this.jobProcessesTerminated(duccWorkJob)) break;
                status = true;
                if (duccWorkJob.getStandardInfo().getDateOfShutdownProcessesMillis() > 0L) break;
                duccWorkJob.getStandardInfo().setDateOfShutdownProcesses(TimeStamp.getCurrentMillis());
                break;
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return status;
    }

    private boolean isAgedOut(IDuccWork duccWork) {
        String methodName = "isAgedOut";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean retVal = true;
        long endMillis = 0L;
        long nowMillis = 0L;
        long elapsed = 0L;
        try {
            endMillis = duccWork.getStandardInfo().getDateOfCompletionMillis();
            nowMillis = System.currentTimeMillis();
            elapsed = nowMillis - endMillis;
            if (elapsed <= this.AgeTime) {
                logger.info(methodName, jobid, new Object[]{"Completion", elapsed, this.AgeTime});
                retVal = false;
            }
            if ((elapsed = nowMillis - (endMillis = duccWork.getStandardInfo().getDateOfShutdownProcessesMillis())) <= this.AgeTime) {
                logger.info(methodName, jobid, new Object[]{"Shutdown", elapsed, this.AgeTime});
                retVal = false;
            }
        }
        catch (Exception e) {
            logger.error(methodName, null, new Object[]{"nowMillis:" + endMillis + " nowMillis:" + endMillis + " ", e});
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return retVal;
    }

    public boolean isSaved(IDuccWorkJob duccWorkJob) {
        String methodName = "isSaved";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean retVal = false;
        try {
            switch (duccWorkJob.getDuccType()) {
                case Job: {
                    this.hpm.saveJob(duccWorkJob);
                    retVal = true;
                    break;
                }
                case Service: {
                    this.hpm.saveService((IDuccWorkService)duccWorkJob);
                    retVal = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error(methodName, duccWorkJob.getDuccId(), (Throwable)e, new Object[0]);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return retVal;
    }

    public boolean isSaved(IDuccWorkReservation duccWorkReservation) {
        String methodName = "isSaved";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean retVal = false;
        try {
            this.hpm.saveReservation(duccWorkReservation);
            retVal = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return retVal;
    }

    private void dumper() {
        String location = "dumper";
        try {
            DuccWorkMap dwMap = this.orchestratorCommonArea.getWorkMap();
            for (DuccId duccId : dwMap.keySet()) {
                IDuccWork dw = dwMap.findDuccWork(duccId);
                if (dw == null) continue;
                logger.trace(location, duccId, new Object[]{"dw: " + dw.getDuccType()});
            }
            ConcurrentHashMap<DuccId, DuccId> p2jMap = ProcessToJobMap.getInstance().getMap();
            for (Map.Entry<DuccId, DuccId> entry : p2jMap.entrySet()) {
                logger.trace(location, jobid, new Object[]{"p:" + entry.getKey() + " j:" + entry.getValue()});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private boolean isCompleting(DuccWorkJob dwj) {
        String location = "isCompleting";
        boolean retVal = false;
        DuccId duccId = null;
        if (dwj != null) {
            duccId = dwj.getDuccId();
            retVal = dwj.isCompleting();
        }
        logger.debug(location, duccId, new Object[]{retVal});
        return retVal;
    }

    private boolean isCompleted(DuccWorkJob dwj) {
        String location = "isCompleted";
        boolean retVal = false;
        DuccId duccId = null;
        if (dwj != null) {
            duccId = dwj.getDuccId();
            retVal = dwj.isCompleted();
        }
        logger.debug(location, duccId, new Object[]{retVal});
        return retVal;
    }

    public int prune(DuccWorkMap workMap) {
        String methodName = "prune";
        this.dumper();
        int changes = 0;
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        long t0 = System.currentTimeMillis();
        Set workMapSet = workMap.keySet();
        logger.debug(methodName, jobid, new Object[]{"size=" + workMapSet.size()});
        block7: for (DuccId duccId : workMapSet) {
            IDuccWork duccWork = WorkMapHelper.findDuccWork(workMap, duccId, (Object)this, methodName);
            if (duccWork == null) {
                logger.warn(methodName, duccId, new Object[]{"not found"});
                continue;
            }
            IDuccTypes.DuccType duccType = duccWork.getDuccType();
            if (duccType == null) {
                logger.warn(methodName, duccId, new Object[]{"no type?"});
                continue;
            }
            switch (duccType) {
                case Job: 
                case Service: {
                    DuccWorkJob duccWorkJob = (DuccWorkJob)duccWork;
                    if (duccWorkJob == null) break;
                    switch (duccType) {
                        case Job: {
                            if (!this.jobDriverTerminated(duccWorkJob)) break;
                            OrchestratorHelper.jdDeallocate((IDuccWorkJob)duccWorkJob);
                            ++changes;
                            break;
                        }
                    }
                    if (this.isCompleting(duccWorkJob) && this.allProcessesTerminated(duccWorkJob)) {
                        this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.Completed);
                        ++changes;
                    }
                    if (this.isCompleted(duccWorkJob) && this.allProcessesTerminated(duccWorkJob) && this.isSaved((IDuccWorkJob)duccWorkJob) && this.isAgedOut((IDuccWork)duccWorkJob)) {
                        WorkMapHelper.removeDuccWork(workMap, (IDuccWork)duccWorkJob, this, methodName);
                        logger.info(methodName, duccId, new Object[]{this.messages.fetch("removed job")});
                        ++changes;
                        IDuccProcessMap processMap = null;
                        DuccWorkPopDriver driver = duccWorkJob.getDriver();
                        if (driver != null) {
                            processMap = driver.getProcessMap();
                        }
                        if (processMap != null) {
                            for (DuccId processDuccId : processMap.keySet()) {
                                this.orchestratorCommonArea.getProcessAccounting().removeProcess(processDuccId);
                                logger.info(methodName, duccId, new Object[]{this.messages.fetch("removed driver process") + " " + processDuccId.toString()});
                                ++changes;
                            }
                            logger.info(methodName, duccId, new Object[]{this.messages.fetch("processes driver inactive")});
                        }
                        if ((processMap = duccWorkJob.getProcessMap()) == null) continue block7;
                        for (DuccId processDuccId : processMap.keySet()) {
                            this.orchestratorCommonArea.getProcessAccounting().removeProcess(processDuccId);
                            logger.info(methodName, duccId, new Object[]{this.messages.fetch("removed process") + " " + processDuccId.toString()});
                            ++changes;
                        }
                        logger.info(methodName, duccId, new Object[]{this.messages.fetch("processes inactive")});
                        break;
                    }
                    logger.debug(methodName, duccId, new Object[]{this.messages.fetch("processes active")});
                    break;
                }
                case Reservation: {
                    DuccWorkReservation duccWorkReservation = (DuccWorkReservation)duccWork;
                    if (duccWorkReservation == null || !duccWorkReservation.isCompleted() || !this.isSaved((IDuccWorkReservation)duccWorkReservation) || !this.isAgedOut((IDuccWork)duccWorkReservation)) break;
                    WorkMapHelper.removeDuccWork(workMap, (IDuccWork)duccWorkReservation, this, methodName);
                    logger.info(methodName, duccId, new Object[]{this.messages.fetch("removed reservation")});
                    ++changes;
                    break;
                }
            }
        }
        long t1 = System.currentTimeMillis();
        long elapsed = t1 - t0;
        if (elapsed > 100L) {
            logger.debug(methodName, null, new Object[]{"elapsed msecs: " + elapsed});
        }
        logger.debug(methodName, null, new Object[]{"processToWorkMap.size=" + this.orchestratorCommonArea.getProcessAccounting().processCount()});
        if (changes > 0) {
            OrchestratorCheckpoint.getInstance().saveState();
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return changes;
    }

    private int stateChange(DuccWorkJob duccWorkJob, IDuccState.JobState state) {
        this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, state);
        return 1;
    }

    private int stateChange(DuccWorkReservation duccWorkReservation, IDuccState.ReservationState state) {
        duccWorkReservation.stateChange(state);
        return 1;
    }

    private void setJdJmxUrl(DuccWorkJob job, String jdJmxUrl) {
        DuccWorkPopDriver driver;
        IDuccProcessMap processMap;
        if (jdJmxUrl != null && (processMap = (driver = job.getDriver()).getProcessMap()) != null) {
            Collection processCollection = processMap.values();
            for (IDuccProcess process : processCollection) {
                process.setProcessJmxUrl(jdJmxUrl);
            }
        }
    }

    private void copyInvestmentReport(DuccWorkJob job, IDriverStatusReport jdStatusReport) {
        String methodName = "copyInvestmentReport";
        try {
            Map omMap = jdStatusReport.getInvestmentMillisMap();
            IDuccProcessMap processMap = job.getProcessMap();
            for (Map.Entry entry : processMap.entrySet()) {
                IDuccProcess process = (IDuccProcess)entry.getValue();
                Node node = process.getNode();
                NodeIdentity nodeIdentity = node.getNodeIdentity();
                String nodeIP = nodeIdentity.getIp();
                String pid = process.getPID();
                RemoteLocation remoteLocation = new RemoteLocation(nodeIP, pid);
                long investment = 0L;
                if (omMap.containsKey(remoteLocation)) {
                    investment = (Long)omMap.get(remoteLocation);
                }
                process.setWiMillisInvestment(investment);
                logger.debug(methodName, job.getDuccId(), process.getDuccId(), new Object[]{"investment:" + investment + " node(IP): " + nodeIP + " pid: " + pid});
            }
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
    }

    private void copyProcessWorkItemsReport(DuccWorkJob job, IDriverStatusReport jdStatusReport) {
        String methodName = "copyProcessWorkItemsReport";
        try {
            IDuccProcessMap processMap = job.getProcessMap();
            IDuccProcessWorkItemsReport pwiReport = jdStatusReport.getDuccProcessWorkItemsMap();
            if (pwiReport != null) {
                ConcurrentHashMap pwiMap = pwiReport.getMap();
                for (DuccId processId : pwiMap.keySet()) {
                    IDuccProcess process = (IDuccProcess)processMap.get((Object)processId);
                    IDuccProcessWorkItems pwi = (IDuccProcessWorkItems)pwiMap.get(processId);
                    process.setProcessWorkItems(pwi);
                    logger.trace(methodName, job.getDuccId(), new Object[]{"done:" + pwi.getCountDone() + " error:" + pwi.getCountError() + " dispatch:" + pwi.getCountDispatch()});
                }
            }
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
    }

    private void copyDriverWorkItemsReport(DuccWorkJob job, IDriverStatusReport jdStatusReport) {
        String methodName = "copyDriverWorkItemsReport";
        try {
            IDuccProcessWorkItemsReport pwiReport = jdStatusReport.getDuccProcessWorkItemsMap();
            if (pwiReport != null) {
                IDuccProcessWorkItems pwi = pwiReport.getTotals();
                DuccWorkPopDriver driver = job.getDriver();
                IDuccProcessMap processMap = driver.getProcessMap();
                if (processMap != null) {
                    for (DuccId processId : processMap.keySet()) {
                        IDuccProcess process = (IDuccProcess)processMap.get((Object)processId);
                        process.setProcessWorkItems(pwi);
                        logger.debug(methodName, job.getDuccId(), new Object[]{"done:" + pwi.getCountDone() + " error:" + pwi.getCountError() + " dispatch:" + pwi.getCountDispatch()});
                    }
                }
            }
            job.setWiMillisMin(jdStatusReport.getWiMillisMin());
            job.setWiMillisMax(jdStatusReport.getWiMillisMax());
            job.setWiMillisAvg(jdStatusReport.getWiMillisAvg());
            job.setWiMillisOperatingLeast(jdStatusReport.getWiMillisOperatingLeast());
            job.setWiMillisCompletedMost(jdStatusReport.getWiMillisCompletedMost());
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
    }

    private void setCompletionIfNotAlreadySet(DuccWorkJob duccWorkJob, IDriverStatusReport jdStatusReport) {
        String methodName = "setCompletionIfNotAlreadySet";
        DuccId jobid = null;
        try {
            jobid = duccWorkJob.getDuccId();
            this.setCompletionIfNotAlreadySet(jobid, duccWorkJob, jdStatusReport.getJobCompletionType(), jdStatusReport.getJobCompletionRationale());
        }
        catch (Exception e) {
            logger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void setCompletionIfNotAlreadySet(DuccWorkJob duccWorkJob, IDuccCompletionType.JobCompletionType jobCompletionType, IRationale rationale) {
        String methodName = "setCompletionIfNotAlreadySet";
        DuccId jobid = null;
        try {
            jobid = duccWorkJob.getDuccId();
            this.setCompletionIfNotAlreadySet(jobid, duccWorkJob, jobCompletionType, rationale);
        }
        catch (Exception e) {
            logger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void setCompletionIfNotAlreadySet(DuccId jobid, DuccWorkJob duccWorkJob, IDuccCompletionType.JobCompletionType reqJobCompletionType, IRationale reqRationale) {
        String methodName = "setCompletionIfNotAlreadySet";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        try {
            IDuccCompletionType.JobCompletionType curJobCompletionType = duccWorkJob.getCompletionType();
            switch (curJobCompletionType) {
                case Undefined: {
                    duccWorkJob.setCompletion(reqJobCompletionType, reqRationale);
                    logger.debug(methodName, jobid, new Object[]{"changed: " + curJobCompletionType + " to " + reqJobCompletionType});
                    break;
                }
                default: {
                    logger.debug(methodName, jobid, new Object[]{"unchanged: " + curJobCompletionType + " to " + reqJobCompletionType});
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void addJdUrlToJpCommandLine(IDuccWorkJob dwj, IDriverStatusReport jdStatusReport) {
        String location = "addJdPortToJpCommandLine";
        DuccId jobid = null;
        if (!dwj.isJdURLSpecified()) {
            jobid = dwj.getDuccId();
            String node = jdStatusReport.getNode();
            int port = jdStatusReport.getPort();
            if (port > 0) {
                JavaCommandLine jcl = (JavaCommandLine)dwj.getCommandLine();
                String value = "http://" + node + ":" + port + "/jdApp";
                String opt = FlagsHelper.Name.JdURL.dname() + "=" + value;
                jcl.addOption(opt);
                logger.info(location, jobid, new Object[]{opt});
                dwj.setJdURLSpecified();
            }
        }
    }

    private void addDeployableToJpCommandLine(IDuccWorkJob dwj, IDriverStatusReport jdStatusReport) {
        String location = "addDeployableToJpCommandLine";
        DuccId jobid = null;
        if (!dwj.isDdSpecified()) {
            String jpAe;
            boolean agentAddsDdToCommandLine;
            String jpDd = jdStatusReport.getUimaDeploymentDescriptor();
            if (jpDd != null) {
                DuccUimaDeploymentDescriptor uimaDeploymentDescriptor = new DuccUimaDeploymentDescriptor(jpDd);
                dwj.setUimaDeployableConfiguration((IDuccUimaDeployableConfiguration)uimaDeploymentDescriptor);
            }
            if (!(agentAddsDdToCommandLine = false) && (jpAe = jdStatusReport.getUimaAnalysisEngine()) != null) {
                ICommandLine jcl = dwj.getCommandLine();
                List args = jcl.getArguments();
                String arg = jpAe;
                if (args == null) {
                    jcl.addArgument(arg);
                    logger.debug(location, jobid, new Object[]{"add[null]:" + arg});
                } else if (args.isEmpty()) {
                    jcl.addArgument(jpAe);
                    logger.debug(location, jobid, new Object[]{"add[empty]:" + arg});
                }
                List argList = jcl.getArguments();
                if (args != null) {
                    int index = 0;
                    for (String argument : argList) {
                        logger.debug(location, jobid, new Object[]{"arg[" + index + "]: " + argument});
                        ++index;
                    }
                }
                dwj.setDdSpecified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileState(IDriverStatusReport jdStatusReport) {
        String methodName = "reconcileState (JD)";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        int changes = 0;
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            DuccId duccId = jdStatusReport.getDuccId();
            String sid = "" + duccId.getFriendly();
            DuccWorkJob duccWorkJob = (DuccWorkJob)WorkMapHelper.findDuccWork(workMap, sid, (Object)this, methodName);
            if (duccWorkJob != null) {
                String jdJmxUrl = jdStatusReport.getJdJmxUrl();
                this.setJdJmxUrl(duccWorkJob, jdJmxUrl);
                this.copyInvestmentReport(duccWorkJob, jdStatusReport);
                this.copyProcessWorkItemsReport(duccWorkJob, jdStatusReport);
                this.copyDriverWorkItemsReport(duccWorkJob, jdStatusReport);
                logger.debug(methodName, duccId, new Object[]{duccWorkJob.getJobState(), "total=" + jdStatusReport.getWorkItemsTotal(), "completed=" + jdStatusReport.getWorkItemsProcessingCompleted(), "error=" + jdStatusReport.getWorkItemsProcessingError()});
                switch (duccWorkJob.getJobState()) {
                    case Completed: {
                        break;
                    }
                    default: {
                        duccWorkJob.setWiTotal(jdStatusReport.getWorkItemsTotal());
                        duccWorkJob.setWiDone((long)jdStatusReport.getWorkItemsProcessingCompleted());
                        duccWorkJob.setWiError((long)jdStatusReport.getWorkItemsProcessingError());
                    }
                }
                if (jdStatusReport.getWorkItemsTotal() == 0L) {
                    this.jobTerminate((IDuccWorkJob)duccWorkJob, IDuccCompletionType.JobCompletionType.NoWorkItemsFound, (IRationale)new Rationale("job driver had no work items to process"), IResourceState.ProcessDeallocationType.JobCanceled);
                } else if (jdStatusReport.isKillJob()) {
                    IRationale rationale = jdStatusReport.getJobCompletionRationale();
                    this.jobTerminate((IDuccWorkJob)duccWorkJob, IDuccCompletionType.JobCompletionType.CanceledByDriver, rationale, IResourceState.ProcessDeallocationType.JobFailure);
                } else {
                    block6 : switch (jdStatusReport.getDriverState()) {
                        case Failed: {
                            IRationale rationale = jdStatusReport.getJobCompletionRationale();
                            this.jobTerminate((IDuccWorkJob)duccWorkJob, IDuccCompletionType.JobCompletionType.CanceledByDriver, rationale, IResourceState.ProcessDeallocationType.JobFailure);
                            break;
                        }
                        case NotRunning: {
                            break;
                        }
                        case Initializing: {
                            switch (duccWorkJob.getJobState()) {
                                case WaitingForDriver: {
                                    this.addJdUrlToJpCommandLine((IDuccWorkJob)duccWorkJob, jdStatusReport);
                                    this.addDeployableToJpCommandLine((IDuccWorkJob)duccWorkJob, jdStatusReport);
                                    if (!duccWorkJob.isJdURLSpecified()) {
                                        logger.debug(methodName, duccId, new Object[]{"No JdURL provided yet - still waitingForDriver"});
                                        break block6;
                                    }
                                    IDuccState.JobState nextState = IDuccState.JobState.WaitingForServices;
                                    if (duccWorkJob.getServiceDependencies() == null) {
                                        String message = this.messages.fetch("bypass") + " " + nextState;
                                        logger.debug(methodName, duccId, new Object[]{message});
                                        nextState = IDuccState.JobState.WaitingForResources;
                                    }
                                    this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, nextState);
                                    break block6;
                                }
                                case Assigned: {
                                    this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.Initializing);
                                    break block6;
                                }
                                case Initializing: {
                                    break block6;
                                }
                            }
                            break;
                        }
                        case Running: 
                        case Idle: {
                            if (jdStatusReport.isKillJob()) {
                                IRationale rationale = jdStatusReport.getJobCompletionRationale();
                                switch (duccWorkJob.getJobState()) {
                                    case WaitingForServices: {
                                        if (rationale == null) {
                                            rationale = new Rationale("waiting for services");
                                            break;
                                        }
                                        if (rationale.isSpecified()) {
                                            String text = rationale.getText();
                                            rationale = new Rationale(text + ": waiting for services");
                                            break;
                                        }
                                        rationale = new Rationale("waiting for services");
                                        break;
                                    }
                                }
                                this.jobTerminate((IDuccWorkJob)duccWorkJob, IDuccCompletionType.JobCompletionType.CanceledByDriver, rationale, IResourceState.ProcessDeallocationType.JobFailure);
                                break;
                            }
                            switch (duccWorkJob.getJobState()) {
                                case WaitingForDriver: {
                                    this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.WaitingForServices);
                                    break block6;
                                }
                                case Assigned: 
                                case Initializing: {
                                    this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.Running);
                                    break block6;
                                }
                            }
                            break;
                        }
                        case Completing: {
                            if (!duccWorkJob.isFinished()) {
                                this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.Completing);
                            }
                            this.stopJps(duccWorkJob);
                            this.stopJd(duccWorkJob);
                            break;
                        }
                        case Completed: {
                            if (duccWorkJob.isCompleted()) break;
                            if (!duccWorkJob.isFinished()) {
                                this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.Completing);
                            }
                            this.stopJps(duccWorkJob);
                            this.stopJd(duccWorkJob);
                            duccWorkJob.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                            switch (jdStatusReport.getJobCompletionType()) {
                                case EndOfJob: {
                                    try {
                                        int errors = jdStatusReport.getWorkItemsProcessingError();
                                        int done = jdStatusReport.getWorkItemsProcessingCompleted();
                                        if (errors > 0) {
                                            this.setCompletionIfNotAlreadySet(duccWorkJob, IDuccCompletionType.JobCompletionType.Error, (IRationale)new Rationale("state manager detected error work items=" + errors));
                                            break block6;
                                        }
                                        if (done == 0) {
                                            this.setCompletionIfNotAlreadySet(duccWorkJob, IDuccCompletionType.JobCompletionType.EndOfJob, (IRationale)new Rationale("state manager detected no work items processed"));
                                            break block6;
                                        }
                                        this.setCompletionIfNotAlreadySet(duccWorkJob, IDuccCompletionType.JobCompletionType.EndOfJob, (IRationale)new Rationale("state manager detected normal completion"));
                                    }
                                    catch (Exception e) {
                                        logger.error(methodName, duccId, (Throwable)e, new Object[0]);
                                    }
                                    break block6;
                                }
                            }
                            this.setCompletionIfNotAlreadySet(duccWorkJob, jdStatusReport);
                            break;
                        }
                    }
                }
                OrchestratorCommonArea.getInstance().getProcessAccounting().setStatus(jdStatusReport, duccWorkJob);
                if (this.deallocateIdleProcesses(duccWorkJob, jdStatusReport)) {
                    ++changes;
                }
                if (this.deallocateFailedProcesses(duccWorkJob, jdStatusReport)) {
                    ++changes;
                }
            } else {
                logger.warn(methodName, duccId, new Object[]{this.messages.fetch("not found")});
            }
        }
        ts.ended();
        if (changes > 0) {
            OrchestratorCheckpoint.getInstance().saveState();
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private boolean isExcessCapacity(DuccWorkJob job) {
        long error;
        long done;
        String methodName = "isExcessCapacity";
        boolean retVal = false;
        long total = job.getWiTotal();
        long sum = total + (done = job.getWiDone()) + (error = job.getWiError());
        if (sum > 0L) {
            long capacity = job.getWorkItemCapacity();
            long todo = total - (done + error);
            long tpp = job.getSchedulingInfo().getIntThreadsPerProcess();
            long numShares = 0L;
            if (todo % tpp > 0L) {
                numShares = 1L;
            }
            long adjTodo = (numShares += todo / tpp) * tpp;
            if (capacity > 0L && adjTodo < capacity) {
                retVal = true;
            }
            logger.info(methodName, job.getDuccId(), new Object[]{"todo:" + todo + " adjTodo:" + adjTodo + " capacity:" + capacity + " excess:" + retVal});
        } else {
            logger.info(methodName, job.getDuccId(), new Object[]{"todo:? capacity:? excess:" + retVal});
        }
        return retVal;
    }

    private boolean isDeallocatable(IDriverStatusReport jdStatusReport) {
        boolean retVal = false;
        if (!jdStatusReport.isPending()) {
            retVal = true;
        }
        return retVal;
    }

    private boolean deallocateIdleProcesses(DuccWorkJob job, IDriverStatusReport jdStatusReport) {
        String methodName = "deallocateIdleProcesses";
        boolean retVal = false;
        DuccId jobid = job.getDuccId();
        try {
            if (this.isDeallocatable(jdStatusReport)) {
                IDuccProcessMap processMap = job.getProcessMap();
                Iterator iterator = processMap.keySet().iterator();
                boolean excessCapacity = this.isExcessCapacity(job);
                int count = 0;
                while (iterator.hasNext() && excessCapacity) {
                    ++count;
                    DuccId duccId = (DuccId)iterator.next();
                    IDuccProcess process = (IDuccProcess)processMap.get((Object)duccId);
                    if (!process.isDeallocated()) {
                        String PID;
                        String nodeIP = process.getNodeIdentity().getIp();
                        if (!jdStatusReport.isOperating(nodeIP, PID = process.getPID())) {
                            OrUtil.setResourceState((IDuccWorkJob)job, process, IResourceState.ResourceState.Deallocated);
                            process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Voluntary);
                            logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{"deallocated"});
                            retVal = true;
                            excessCapacity = this.isExcessCapacity(job);
                            continue;
                        }
                        logger.debug(methodName, job.getDuccId(), process.getDuccId(), new Object[]{"operating"});
                        continue;
                    }
                    logger.trace(methodName, job.getDuccId(), process.getDuccId(), new Object[]{"already deallocated"});
                }
                logger.trace(methodName, jobid, new Object[]{"count=" + count});
            } else {
                logger.debug(methodName, jobid, new Object[]{"not deallocatable"});
            }
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private DuccId getDuccId(IDuccProcessMap processMap, IRemoteLocation remoteLocation) {
        String methodName = "getDuccId";
        DuccId duccId = null;
        if (processMap != null) {
            if (remoteLocation != null) {
                String nodeIp = remoteLocation.getNodeIP();
                String processId = remoteLocation.getPid();
                logger.debug(methodName, null, new Object[]{"nodeIp:" + nodeIp + " processId:" + processId});
                for (Map.Entry entry : processMap.entrySet()) {
                    IDuccProcess p = (IDuccProcess)entry.getValue();
                    logger.debug(methodName, null, new Object[]{"duccId:" + entry.getKey() + " nodeId:" + p.getNodeIdentity().getIp() + " processId:" + p.getPID()});
                }
                IDuccProcess process = processMap.findProcess(nodeIp, processId);
                if (process != null) {
                    duccId = process.getDuccId();
                }
            } else {
                logger.debug(methodName, null, new Object[]{"remoteLocation null?"});
            }
        } else {
            logger.debug(methodName, null, new Object[]{"processMap null?"});
        }
        return duccId;
    }

    private boolean deallocateFailedProcesses(DuccWorkJob job, IDriverStatusReport jdStatusReport) {
        String methodName = "deallocateFailedProcesses";
        boolean retVal = false;
        IDuccProcessMap processMap = job.getProcessMap();
        Map map = jdStatusReport.getProcessKillMap();
        if (map != null) {
            logger.debug(methodName, job.getDuccId(), new Object[]{"size:" + map.size()});
            for (Map.Entry entry : map.entrySet()) {
                DuccId duccId = this.getDuccId(processMap, (IRemoteLocation)entry.getKey());
                if (duccId != null) {
                    IDuccProcess process = (IDuccProcess)processMap.get((Object)duccId);
                    if (process != null) {
                        if (process.isDeallocated()) continue;
                        OrUtil.setResourceState((IDuccWorkJob)job, process, IResourceState.ResourceState.Deallocated);
                        process.setProcessDeallocationType((IResourceState.ProcessDeallocationType)entry.getValue());
                        logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{"deallocated"});
                        continue;
                    }
                    logger.warn(methodName, job.getDuccId(), duccId, new Object[]{"not in process map"});
                    continue;
                }
                logger.warn(methodName, job.getDuccId(), duccId, new Object[]{"null?"});
            }
        }
        return retVal;
    }

    private void stopJps(DuccWorkJob job) {
        String methodName = "stopJps";
        IDuccProcessMap processMap = job.getProcessMap();
        for (DuccId duccId : processMap.keySet()) {
            IDuccProcess process = (IDuccProcess)processMap.get((Object)duccId);
            if (process == null || process.isDeallocated()) continue;
            OrUtil.setResourceState((IDuccWorkJob)job, process, IResourceState.ResourceState.Deallocated);
            process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Voluntary);
            logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{"deallocated"});
        }
    }

    private boolean delayStopJd(DuccWorkJob job) {
        String methodName = "delayStopJd";
        boolean retVal = true;
        job.setCompletingTOD();
        if (!job.hasAliveProcess()) {
            long elapsed = System.currentTimeMillis() - job.getCompletingTOD();
            if (System.currentTimeMillis() - job.getCompletingTOD() > 300000L) {
                logger.debug(methodName, job.getDuccId(), new Object[]{"" + elapsed});
                retVal = false;
            } else if (!job.hasNoPidProcess()) {
                logger.debug(methodName, job.getDuccId(), new Object[]{"all JPs have PIDs"});
                retVal = false;
            }
        }
        if (retVal) {
            logger.debug(methodName, job.getDuccId(), new Object[]{""});
        }
        return retVal;
    }

    private void stopJd(DuccWorkJob job) {
        String methodName = "stopJd";
        if (!this.delayStopJd(job)) {
            IDuccProcessMap processMap = job.getDriver().getProcessMap();
            for (DuccId duccId : processMap.keySet()) {
                IDuccProcess process = (IDuccProcess)processMap.get((Object)duccId);
                if (process == null || process.isDeallocated()) continue;
                OrUtil.setResourceState((IDuccWorkJob)job, process, IResourceState.ResourceState.Deallocated);
                process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Voluntary);
                logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{"deallocated"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcileState(Map<DuccId, IRmJobState> rmResourceStateMap) throws Exception {
        String methodName = "reconcileState (RM)";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        logger.debug(methodName, null, new Object[]{this.messages.fetchLabel("size") + rmResourceStateMap.size()});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        int changes = 0;
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            block30: for (DuccId duccId : rmResourceStateMap.keySet()) {
                IDuccWork duccWork;
                Map mapRemovals;
                IRmJobState rmResourceState = rmResourceStateMap.get(duccId);
                Map mapAdditions = rmResourceState.getPendingAdditions();
                if (mapAdditions != null) {
                    int mapSize = mapAdditions.size();
                    if (mapSize > 0) {
                        logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("pending additions") + mapSize});
                    } else {
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("pending additions") + mapSize});
                    }
                }
                if ((mapRemovals = rmResourceState.getPendingRemovals()) != null) {
                    int mapSize = mapRemovals.size();
                    if (mapSize > 0) {
                        logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("pending removals") + mapSize});
                    } else {
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("pending removals") + mapSize});
                    }
                }
                if ((duccWork = WorkMapHelper.findDuccWork(workMap, duccId, (Object)this, methodName)) == null) {
                    logger.debug(methodName, duccId, new Object[]{this.messages.fetch("not found")});
                    continue;
                }
                logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("type") + duccWork.getDuccType()});
                duccWork.setRmReason(null);
                block2 : switch (duccWork.getDuccType()) {
                    case Job: {
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetch("processing job...")});
                        DuccWorkJob duccWorkJob = (DuccWorkJob)duccWork;
                        this.processPurger(duccWorkJob, rmResourceState.getResources());
                        changes += this.processMapResourcesAdd(duccWorkJob, rmResourceState.memoryGbPerProcess(), rmResourceState.getPendingAdditions());
                        changes += this.processMapResourcesDel(duccWorkJob, rmResourceState.memoryGbPerProcess(), rmResourceState.getPendingRemovals());
                        IDuccState.JobState jobState = duccWorkJob.getJobState();
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("job state") + jobState});
                        switch (jobState) {
                            case WaitingForDriver: 
                            case Received: {
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unexpected state") + jobState});
                                break;
                            }
                            case WaitingForServices: {
                                logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("unexpected state") + jobState});
                                break;
                            }
                            case WaitingForResources: {
                                String rmReason = rmResourceState.getReason();
                                logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("rmReason") + rmReason});
                                duccWork.setRmReason(rmReason);
                                if (rmResourceState.isRefused()) {
                                    duccWorkJob.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                                    duccWorkJob.setCompletionType(IDuccCompletionType.JobCompletionType.ResourcesUnavailable);
                                    duccWorkJob.setCompletionRationale((IRationale)new Rationale("resource manager refused allocation: " + rmResourceState.getReason()));
                                    changes += this.stateChange(duccWorkJob, IDuccState.JobState.Completed);
                                    logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("refused") + rmResourceState.getReason()});
                                    String text = rmResourceState.getReason();
                                    UserLogging.record((IDuccWorkJob)duccWorkJob, text);
                                }
                                if (duccWorkJob.getProcessMap().size() <= 0) continue block30;
                                changes += this.stateChange(duccWorkJob, IDuccState.JobState.Assigned);
                                logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("resources count") + duccWorkJob.getProcessMap().size()});
                                break;
                            }
                            case Assigned: 
                            case Initializing: 
                            case Running: {
                                if (duccWorkJob.getProcessMap().size() != 0) continue block30;
                                changes += this.stateChange(duccWorkJob, IDuccState.JobState.WaitingForResources);
                                logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("resources count") + duccWorkJob.getProcessMap().size()});
                                break;
                            }
                            case Completed: 
                            case Completing: {
                                logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("unsuitable state") + jobState});
                                break;
                            }
                            case Undefined: {
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unsuitable state") + jobState});
                                continue block30;
                            }
                        }
                        break;
                    }
                    case Reservation: {
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetch("processing reservation...")});
                        DuccWorkReservation duccWorkReservation = (DuccWorkReservation)duccWork;
                        changes += this.reservationMapResourcesAdd(duccWorkReservation, rmResourceState.memoryGbPerProcess(), rmResourceState.getPendingAdditions());
                        changes += this.reservationMapResourcesDel(duccWorkReservation, rmResourceState.memoryGbPerProcess(), rmResourceState.getPendingRemovals());
                        IDuccState.ReservationState reservationState = duccWorkReservation.getReservationState();
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("reservation state") + reservationState});
                        switch (reservationState) {
                            case Received: {
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unexpected state") + reservationState});
                                continue block30;
                            }
                            case WaitingForResources: {
                                String rmReason = rmResourceState.getReason();
                                logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("rmReason") + rmReason});
                                duccWork.setRmReason(rmReason);
                                if (rmResourceState.isRefused()) {
                                    String schedulingClass = duccWorkReservation.getSchedulingInfo().getSchedulingClass().trim();
                                    if (schedulingClass.equals("JobDriver")) {
                                        if (refusedLogged.get()) continue block30;
                                        logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("refusal ignored") + rmResourceState.getReason()});
                                        refusedLogged.set(true);
                                        continue block30;
                                    }
                                    duccWorkReservation.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                                    duccWorkReservation.setCompletionType(IDuccCompletionType.ReservationCompletionType.ResourcesUnavailable);
                                    duccWorkReservation.setCompletionRationale((IRationale)new Rationale("resource manager refused allocation: " + rmResourceState.getReason()));
                                    changes += this.stateChange(duccWorkReservation, IDuccState.ReservationState.Completed);
                                    logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("refused") + rmResourceState.getReason()});
                                    continue block30;
                                }
                                if (rmResourceState.getResources() != null) {
                                    if (rmResourceState.getResources().isEmpty()) break;
                                    changes += this.stateChange(duccWorkReservation, IDuccState.ReservationState.Assigned);
                                    logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("resources count") + rmResourceState.getResources().size()});
                                    continue block30;
                                }
                                logger.info(methodName, duccId, new Object[]{this.messages.fetch("waiting...no resources?")});
                                continue block30;
                            }
                            case Assigned: {
                                if (rmResourceState.getResources() != null) {
                                    if (!rmResourceState.getResources().isEmpty()) break;
                                    changes += this.stateChange(duccWorkReservation, IDuccState.ReservationState.Completed);
                                    logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("resources count") + rmResourceState.getResources().size()});
                                    continue block30;
                                }
                                logger.info(methodName, duccId, new Object[]{this.messages.fetch("assigned...no resources?")});
                                continue block30;
                            }
                            case Completed: {
                                logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("unsuitable state") + reservationState});
                                continue block30;
                            }
                            case Undefined: {
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unsuitable state") + reservationState});
                            }
                        }
                        continue block30;
                    }
                    case Service: {
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetch("processing service...")});
                        DuccWorkJob duccWorkService = (DuccWorkJob)duccWork;
                        int processPurged = this.processPurger(duccWorkService, rmResourceState.getResources());
                        changes += this.processMapResourcesAdd(duccWorkService, rmResourceState.memoryGbPerProcess(), rmResourceState.getPendingAdditions());
                        changes += this.processMapResourcesDel(duccWorkService, rmResourceState.memoryGbPerProcess(), rmResourceState.getPendingRemovals());
                        IDuccState.JobState serviceState = duccWorkService.getJobState();
                        logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("service state") + serviceState});
                        switch (serviceState) {
                            case Received: {
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unexpected state") + serviceState});
                                break block2;
                            }
                            case WaitingForServices: {
                                logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("unexpected state") + serviceState});
                                break block2;
                            }
                            case WaitingForResources: {
                                String text;
                                String rmReason = rmResourceState.getReason();
                                logger.trace(methodName, duccId, new Object[]{this.messages.fetchLabel("rmReason") + rmReason});
                                duccWork.setRmReason(rmReason);
                                if (rmResourceState.isRefused()) {
                                    duccWorkService.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                                    duccWorkService.setCompletionType(IDuccCompletionType.JobCompletionType.ResourcesUnavailable);
                                    duccWorkService.setCompletionRationale((IRationale)new Rationale("resource manager refused allocation: " + rmResourceState.getReason()));
                                    changes += this.stateChange(duccWorkService, IDuccState.JobState.Completed);
                                    logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("refused") + rmResourceState.getReason()});
                                    text = rmResourceState.getReason();
                                    UserLogging.record((IDuccWorkJob)duccWorkService, text);
                                }
                                if (duccWorkService.getProcessMap().size() > 0) {
                                    changes += this.stateChange(duccWorkService, IDuccState.JobState.Initializing);
                                    logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("resources count") + duccWorkService.getProcessMap().size()});
                                }
                                if (processPurged <= 0 || !this.allProcessesTerminated(duccWorkService)) break block2;
                                duccWorkService.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                                duccWorkService.setCompletionType(IDuccCompletionType.JobCompletionType.ResourcesUnavailable);
                                duccWorkService.setCompletionRationale((IRationale)new Rationale("resource manager purged allocation: " + rmResourceState.getReason()));
                                changes += this.stateChange(duccWorkService, IDuccState.JobState.Completed);
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("purged") + rmResourceState.getReason()});
                                text = rmResourceState.getReason();
                                UserLogging.record((IDuccWorkJob)duccWorkService, text);
                                break block2;
                            }
                            case Assigned: 
                            case Initializing: 
                            case Running: {
                                if (duccWorkService.getProcessMap().size() == 0) {
                                    changes += this.stateChange(duccWorkService, IDuccState.JobState.WaitingForResources);
                                    logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("resources count") + duccWorkService.getProcessMap().size()});
                                }
                                if (processPurged <= 0 || !this.allProcessesTerminated(duccWorkService)) break block2;
                                duccWorkService.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                                duccWorkService.setCompletionType(IDuccCompletionType.JobCompletionType.ResourcesUnavailable);
                                duccWorkService.setCompletionRationale((IRationale)new Rationale("resource manager purged allocation: " + rmResourceState.getReason()));
                                changes += this.stateChange(duccWorkService, IDuccState.JobState.Completed);
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("purged") + rmResourceState.getReason()});
                                String text = rmResourceState.getReason();
                                UserLogging.record((IDuccWorkJob)duccWorkService, text);
                                break block2;
                            }
                            case Completed: 
                            case Completing: {
                                logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("unsuitable state") + serviceState});
                                break block2;
                            }
                            case Undefined: {
                                logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unsuitable state") + serviceState});
                                break block2;
                            }
                        }
                        break;
                    }
                }
            }
            if (changes > 0) {
                OrchestratorCheckpoint.getInstance().saveState();
            }
        }
        ts.ended();
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private int processPurger(DuccWorkJob job, Map<DuccId, IResource> map) {
        String methodName = "processPurger";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        int changes = 0;
        if (job != null && map != null) {
            for (DuccId duccId : map.keySet()) {
                IDuccProcess process;
                IResource resource = map.get(duccId);
                if (!resource.isPurged() || (process = (IDuccProcess)job.getProcessMap().get((Object)duccId)).isDefunct()) continue;
                String rState = process.getResourceState().toString();
                String pState = process.getProcessState().toString();
                logger.info(methodName, job.getDuccId(), duccId, new Object[]{"rState:" + rState + " pState:" + pState});
                OrUtil.setResourceState((IDuccWorkJob)job, process, IResourceState.ResourceState.Deallocated);
                process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Purged);
                process.advanceProcessState(IProcessState.ProcessState.Stopped);
                ++changes;
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return changes;
    }

    private int processMapResourcesAdd(DuccWorkJob duccWorkJob, int memoryGbPerProcess, Map<DuccId, IResource> resourceMap) {
        String methodName = "processMapResourcesAdd";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        int changes = 0;
        duccWorkJob.getSchedulingInfo().setMemorySizeAllocatedInBytes((long)memoryGbPerProcess * SizeBytes.GB);
        if (resourceMap == null) {
            logger.info(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("no map found")});
        } else {
            IDuccProcessMap processMap = duccWorkJob.getProcessMap();
            block7: for (DuccId duccId : resourceMap.keySet()) {
                Node node = resourceMap.get(duccId).getNode();
                NodeIdentity nodeId = node.getNodeIdentity();
                if (!processMap.containsKey((Object)duccId)) {
                    IDuccProcessType.ProcessType processType = null;
                    switch (duccWorkJob.getServiceDeploymentType()) {
                        case custom: 
                        case other: {
                            processType = IDuccProcessType.ProcessType.Pop;
                            break;
                        }
                        case uima: 
                        case unspecified: {
                            processType = IDuccProcessType.ProcessType.Job_Uima_AS_Process;
                        }
                    }
                    DuccProcess process = new DuccProcess(duccId, node, processType);
                    long process_max_size_in_bytes = (long)memoryGbPerProcess * SizeBytes.GB;
                    CGroupManager.assign((IDuccId)duccWorkJob.getDuccId(), (IDuccProcess)process, process_max_size_in_bytes);
                    this.orchestratorCommonArea.getProcessAccounting().addProcess(duccId, duccWorkJob.getDuccId());
                    processMap.addProcess((IDuccProcess)process);
                    OrUtil.setResourceState((IDuccWorkJob)duccWorkJob, (IDuccProcess)process, IResourceState.ResourceState.Allocated);
                    logger.info(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("resource added") + " " + this.messages.fetchLabel("process") + duccId.getFriendly() + " " + this.messages.fetchLabel("unique") + duccId.getUnique() + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
                    ++changes;
                    switch (duccWorkJob.getJobState()) {
                        case Completed: 
                        case Completing: {
                            OrUtil.setResourceState((IDuccWorkJob)duccWorkJob, (IDuccProcess)process, IResourceState.ResourceState.Deallocated);
                            process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Voluntary);
                            process.advanceProcessState(IProcessState.ProcessState.Stopped);
                            logger.warn(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("resource allocated for completed job") + " " + this.messages.fetchLabel("process") + duccId.getFriendly()});
                            break;
                        }
                        default: {
                            if (!this.isExcessCapacity(duccWorkJob)) continue block7;
                            OrUtil.setResourceState((IDuccWorkJob)duccWorkJob, (IDuccProcess)process, IResourceState.ResourceState.Deallocated);
                            process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Voluntary);
                            process.advanceProcessState(IProcessState.ProcessState.Stopped);
                            logger.warn(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("resource allocated for over capacity job") + " " + this.messages.fetchLabel("process") + duccId.getFriendly()});
                            break;
                        }
                    }
                    continue;
                }
                logger.warn(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("resource exists") + " " + this.messages.fetchLabel("process") + duccId.getFriendly() + " " + this.messages.fetchLabel("unique") + duccId.getUnique() + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return changes;
    }

    private int processMapResourcesDel(DuccWorkJob duccWorkJob, int memoryGbPerProcess, Map<DuccId, IResource> resourceMap) {
        String methodName = "processMapResourcesDel";
        logger.trace(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("enter")});
        int changes = 0;
        if (resourceMap == null) {
            logger.info(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("no map found")});
        } else {
            IDuccProcessMap processMap = duccWorkJob.getProcessMap();
            Iterator<DuccId> resourceMapIterator = resourceMap.keySet().iterator();
            logger.debug(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetchLabel("size") + processMap.size()});
            while (resourceMapIterator.hasNext()) {
                DuccId duccId = resourceMapIterator.next();
                Node node = resourceMap.get(duccId).getNode();
                NodeIdentity nodeId = node.getNodeIdentity();
                logger.info(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("resource processing") + " " + this.messages.fetchLabel("process") + duccId.getFriendly() + " " + this.messages.fetchLabel("unique") + duccId.getUnique() + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
                if (processMap.containsKey((Object)duccId)) {
                    IDuccProcess process = (IDuccProcess)processMap.get((Object)duccId);
                    switch (process.getResourceState()) {
                        case Deallocated: {
                            break;
                        }
                        default: {
                            OrUtil.setResourceState((IDuccWorkJob)duccWorkJob, process, IResourceState.ResourceState.Deallocated);
                            process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Forced);
                            logger.info(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("resource deallocated") + " " + this.messages.fetchLabel("process") + duccId.getFriendly() + " " + this.messages.fetchLabel("unique") + duccId.getUnique() + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
                            break;
                        }
                    }
                    continue;
                }
                logger.info(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("resource not found") + " " + this.messages.fetchLabel("process") + duccId.getFriendly() + " " + this.messages.fetchLabel("unique") + duccId.getUnique() + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
            }
        }
        logger.trace(methodName, duccWorkJob.getDuccId(), new Object[]{this.messages.fetch("exit")});
        return changes;
    }

    private int reservationMapResourcesAdd(DuccWorkReservation duccWorkReservation, int memoryGbPerProcess, Map<DuccId, IResource> resourceMap) {
        String methodName = "reservationMapResourcesAdd";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        int changes = 0;
        duccWorkReservation.getSchedulingInfo().setMemorySizeAllocatedInBytes((long)memoryGbPerProcess * SizeBytes.GB);
        IDuccReservationMap reservationMap = duccWorkReservation.getReservationMap();
        if (resourceMap != null) {
            for (DuccId duccId : resourceMap.keySet()) {
                IResource resource = resourceMap.get(duccId);
                Node node = resource.getNode();
                NodeIdentity nodeId = node.getNodeIdentity();
                if (!reservationMap.containsKey((Object)duccId)) {
                    long bytes = (long)memoryGbPerProcess * SizeBytes.GB;
                    DuccReservation reservation = new DuccReservation(duccId, node, bytes);
                    reservationMap.addReservation((IDuccReservation)reservation);
                    logger.info(methodName, duccId, new Object[]{this.messages.fetch("add resource") + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
                    ++changes;
                    continue;
                }
                logger.debug(methodName, duccId, new Object[]{this.messages.fetch("duplicate resource") + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return changes;
    }

    private int reservationMapResourcesDel(DuccWorkReservation duccWorkReservation, int memoryGbPerProcess, Map<DuccId, IResource> resourceMap) {
        String methodName = "processMapResourcesDel";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        int changes = 0;
        IDuccReservationMap reservationMap = duccWorkReservation.getReservationMap();
        if (resourceMap != null) {
            for (DuccId duccId : resourceMap.keySet()) {
                Node node = resourceMap.get(duccId).getNode();
                NodeIdentity nodeId = node.getNodeIdentity();
                if (reservationMap.containsKey((Object)duccId)) {
                    reservationMap.removeReservation(duccId);
                    logger.info(methodName, duccId, new Object[]{this.messages.fetch("remove resource") + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
                    ++changes;
                    continue;
                }
                logger.debug(methodName, duccId, new Object[]{this.messages.fetch("not found resource") + " " + this.messages.fetchLabel("name") + nodeId.getCanonicalName() + " " + this.messages.fetchLabel("ip") + nodeId.getIp()});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return changes;
    }

    private String getServiceDependencyMessages(ServiceDependency sd) {
        String retVal = null;
        Map messages = sd.getMessages();
        if (messages != null) {
            StringBuffer sb = new StringBuffer();
            for (String endpoint : messages.keySet()) {
                sb.append(endpoint);
                sb.append(":");
                sb.append((String)messages.get(endpoint));
                sb.append(";");
            }
            retVal = sb.toString();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileState(ServiceMap serviceMap) {
        String methodName = "reconcileState (SM)";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        int changes = 0;
        Iterator serviceMapIterator = serviceMap.keySet().iterator();
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            while (serviceMapIterator.hasNext()) {
                DuccId duccId = (DuccId)serviceMapIterator.next();
                ServiceDependency services = (ServiceDependency)serviceMap.get((Object)duccId);
                DuccWorkJob duccWorkJob = (DuccWorkJob)WorkMapHelper.findDuccWork(workMap, duccId, (Object)this, methodName);
                if (duccWorkJob != null) {
                    IDuccState.JobState jobState = duccWorkJob.getJobState();
                    IService.ServiceState serviceState = services.getState();
                    block2 : switch (jobState) {
                        case Received: {
                            logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unexpected job state") + jobState});
                            break;
                        }
                        case WaitingForDriver: {
                            logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("pending job state") + jobState});
                            break;
                        }
                        case WaitingForServices: {
                            switch (serviceState) {
                                case Pending: 
                                case Waiting: 
                                case Starting: 
                                case Initializing: {
                                    break block2;
                                }
                                case Available: {
                                    this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.WaitingForResources);
                                    ++changes;
                                    logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("job state") + jobState + " " + this.messages.fetchLabel("services state") + serviceState});
                                    break block2;
                                }
                                case NotAvailable: 
                                case Stopped: 
                                case Stopping: {
                                    this.stateJobAccounting.stateChange((IDuccWorkJob)duccWorkJob, IDuccState.JobState.Completing);
                                    duccWorkJob.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                                    String sdm = this.getServiceDependencyMessages(services);
                                    Rationale rationale = new Rationale();
                                    if (sdm != null) {
                                        rationale = new Rationale("service manager reported " + sdm);
                                    }
                                    this.stateJobAccounting.complete((IDuccWorkJob)duccWorkJob, IDuccCompletionType.JobCompletionType.ServicesUnavailable, (IRationale)rationale);
                                    ++changes;
                                    logger.info(methodName, duccId, new Object[]{this.messages.fetchLabel("job state") + jobState + " " + this.messages.fetchLabel("services state") + serviceState});
                                    break block2;
                                }
                                case Undefined: {
                                    logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("job state") + jobState + " " + this.messages.fetchLabel("services state") + serviceState});
                                    break block2;
                                }
                            }
                            break;
                        }
                        case WaitingForResources: {
                            logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("job state") + jobState + " " + this.messages.fetchLabel("services state") + serviceState});
                            break;
                        }
                        case Assigned: 
                        case Initializing: 
                        case Running: {
                            logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("job state") + jobState + " " + this.messages.fetchLabel("services state") + serviceState});
                            break;
                        }
                        case Completed: {
                            logger.debug(methodName, duccId, new Object[]{this.messages.fetchLabel("job state") + jobState + " " + this.messages.fetchLabel("services state") + serviceState});
                            break;
                        }
                        case Undefined: {
                            logger.warn(methodName, duccId, new Object[]{this.messages.fetchLabel("unexpected job state") + jobState});
                            break;
                        }
                    }
                    continue;
                }
                logger.debug(methodName, duccId, new Object[]{this.messages.fetch("job not found")});
            }
            if (changes > 0) {
                OrchestratorCheckpoint.getInstance().saveState();
            }
        }
        ts.ended();
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void inventoryJob(IDuccWork duccWork, IDuccProcess inventoryProcess) {
        String methodName = "inventoryJob";
        DuccWorkJob job = (DuccWorkJob)duccWork;
        DuccId jobId = job.getDuccId();
        DuccId processId = inventoryProcess.getDuccId();
        IDuccProcessType.ProcessType processType = inventoryProcess.getProcessType();
        block1 : switch (processType) {
            case Pop: {
                OrchestratorCommonArea.getInstance().getProcessAccounting().setStatus(inventoryProcess);
                if (this.jobDriverTerminated(job)) {
                    OrchestratorHelper.jdDeallocate((IDuccWorkJob)job);
                }
                switch (inventoryProcess.getProcessState()) {
                    case LaunchFailed: 
                    case Failed: {
                        if (inventoryProcess.getDuccId().getFriendly() == 0L) {
                            this.jobTerminate((IDuccWorkJob)job, IDuccCompletionType.JobCompletionType.DriverProcessFailed, (IRationale)new Rationale(inventoryProcess.getReasonForStoppingProcess()), inventoryProcess.getProcessDeallocationType());
                            break block1;
                        }
                        this.jobTerminate((IDuccWorkJob)job, IDuccCompletionType.JobCompletionType.ProcessFailure, (IRationale)new Rationale(inventoryProcess.getReasonForStoppingProcess()), inventoryProcess.getProcessDeallocationType());
                        break block1;
                    }
                }
                if (!inventoryProcess.isComplete()) break;
                OrchestratorCommonArea.getInstance().getProcessAccounting().deallocate((IDuccWorkJob)job, IResourceState.ProcessDeallocationType.Stopped);
                Rationale rationale = new Rationale("state manager reported as normal completion");
                int errors = job.getSchedulingInfo().getIntWorkItemsError();
                int done = job.getSchedulingInfo().getIntWorkItemsCompleted();
                if (errors > 0) {
                    this.setCompletionIfNotAlreadySet(job, IDuccCompletionType.JobCompletionType.Error, (IRationale)new Rationale("state manager detected error work items=" + errors));
                } else if (done == 0) {
                    this.setCompletionIfNotAlreadySet(job, IDuccCompletionType.JobCompletionType.EndOfJob, (IRationale)new Rationale("state manager detected no work items processed"));
                } else {
                    this.setCompletionIfNotAlreadySet(job, IDuccCompletionType.JobCompletionType.EndOfJob, (IRationale)rationale);
                }
                this.completeJob(job, (IRationale)rationale);
                break;
            }
            case Service: {
                logger.warn(methodName, jobId, processId, new Object[]{"unexpected process type: " + processType});
                break;
            }
            case Job_Uima_AS_Process: {
                OrchestratorCommonArea.getInstance().getProcessAccounting().setStatus(inventoryProcess);
                try {
                    if (!job.isInitialized()) {
                        long startup_initialization_error_limit;
                        IDuccProcessMap map = job.getProcessMap();
                        for (Map.Entry entry : map.entrySet()) {
                            IDuccProcess process = (IDuccProcess)entry.getValue();
                            StringBuffer sb = new StringBuffer();
                            sb.append("pid:" + process.getPID() + " ");
                            sb.append("state:" + process.getProcessState() + " ");
                            sb.append("reason:" + process.getReasonForStoppingProcess() + " ");
                            logger.trace(methodName, job.getDuccId(), new Object[]{sb.toString()});
                        }
                        long initFailureCount = job.getProcessInitFailureCount();
                        if (initFailureCount >= (startup_initialization_error_limit = (long)DuccPropertiesResolver.get((String)"ducc.jd.startup.initialization.error.limit", (int)1))) {
                            String reason = "process inititialization failure count[" + initFailureCount + "] meets startup initialization error limit[" + startup_initialization_error_limit + "]";
                            logger.warn(methodName, job.getDuccId(), new Object[]{reason});
                            IDuccCompletionType.JobCompletionType jobCompletionType = IDuccCompletionType.JobCompletionType.CanceledBySystem;
                            Rationale rationale = new Rationale(reason);
                            IResourceState.ProcessDeallocationType processDeallocationType = IResourceState.ProcessDeallocationType.JobCanceled;
                            stateManager.jobTerminate((IDuccWorkJob)job, jobCompletionType, (IRationale)rationale, processDeallocationType);
                            break;
                        }
                        String reason = "process failure count[" + initFailureCount + "] does not exceed startup initialization error limit[" + startup_initialization_error_limit + "]";
                        logger.debug(methodName, job.getDuccId(), new Object[]{reason});
                        break;
                    }
                    logger.trace(methodName, job.getDuccId(), new Object[]{"job is initialized"});
                    break;
                }
                catch (Exception e) {
                    logger.error(methodName, jobId, (Throwable)e, new Object[0]);
                }
            }
        }
        this.advanceToCompleted(job);
    }

    private void inventoryService(IDuccWork duccWork, IDuccProcess inventoryProcess) {
        DuccWorkJob service = (DuccWorkJob)duccWork;
        IDuccProcessType.ProcessType processType = inventoryProcess.getProcessType();
        switch (processType) {
            case Pop: {
                OrchestratorCommonArea.getInstance().getProcessAccounting().setStatus(inventoryProcess);
                if (inventoryProcess.isComplete()) {
                    OrchestratorCommonArea.getInstance().getProcessAccounting().deallocate((IDuccWorkJob)service, IResourceState.ProcessDeallocationType.Stopped);
                }
                if (service.hasAliveProcess()) break;
                this.completeManagedReservation(service, (IRationale)new Rationale("state manager reported no viable service process exists, type=" + processType));
                break;
            }
            case Service: {
                OrchestratorCommonArea.getInstance().getProcessAccounting().setStatus(inventoryProcess);
                if (inventoryProcess.isComplete()) {
                    OrchestratorCommonArea.getInstance().getProcessAccounting().deallocate((IDuccWorkJob)service, IResourceState.ProcessDeallocationType.Stopped);
                }
                if (service.hasAliveProcess()) break;
                this.completeService(service, (IRationale)new Rationale("state manager reported no viable service process exists, type=" + processType));
                break;
            }
            case Job_Uima_AS_Process: {
                OrchestratorCommonArea.getInstance().getProcessAccounting().setStatus(inventoryProcess);
                if (inventoryProcess.isComplete()) {
                    OrchestratorCommonArea.getInstance().getProcessAccounting().deallocate((IDuccWorkJob)service, IResourceState.ProcessDeallocationType.Stopped);
                }
                if (service.hasAliveProcess()) break;
                this.completeService(service, (IRationale)new Rationale("state manager reported no viable service process exists, type=" + processType));
            }
        }
        this.advanceToCompleted(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileState(HashMap<DuccId, IDuccProcess> inventoryProcessMap) {
        String methodName = "reconcileState (Node Inventory)";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        Iterator<DuccId> iterator = inventoryProcessMap.keySet().iterator();
        TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            while (iterator.hasNext()) {
                StringBuffer sb;
                DuccId jobId;
                IDuccProcessType.ProcessType processType;
                DuccId processId = iterator.next();
                IDuccProcess inventoryProcess = inventoryProcessMap.get(processId);
                List upcList = inventoryProcess.getUimaPipelineComponents();
                if (upcList != null) {
                    for (IUimaPipelineAEComponent upc : upcList) {
                        logger.trace(methodName, null, processId, new Object[]{"pipelineInfo: " + inventoryProcess.getNodeIdentity() + " " + inventoryProcess.getPID() + " " + upc.getAeName() + " " + upc.getAeState() + " " + upc.getInitializationTime()});
                    }
                }
                if ((processType = inventoryProcess.getProcessType()) != null) {
                    jobId = OrchestratorCommonArea.getInstance().getProcessAccounting().getJobId(processId);
                    if (jobId != null) {
                        IDuccWork duccWork = WorkMapHelper.findDuccWork(workMap, jobId, (Object)this, methodName);
                        if (duccWork != null) {
                            IDuccTypes.DuccType jobType = duccWork.getDuccType();
                            switch (jobType) {
                                case Job: {
                                    this.inventoryJob(duccWork, inventoryProcess);
                                    break;
                                }
                                case Service: {
                                    this.inventoryService(duccWork, inventoryProcess);
                                    break;
                                }
                            }
                            continue;
                        }
                        StringBuffer sb2 = new StringBuffer();
                        sb2.append("node:" + inventoryProcess.getNodeIdentity().getCanonicalName());
                        sb2.append(" ");
                        sb2.append("PID:" + inventoryProcess.getPID());
                        sb2.append(" ");
                        sb2.append("type:" + inventoryProcess.getProcessType());
                        logger.debug(methodName, jobId, new Object[]{sb2});
                        continue;
                    }
                    sb = new StringBuffer();
                    sb.append("node:" + inventoryProcess.getNodeIdentity().getCanonicalName());
                    sb.append(" ");
                    sb.append("PID:" + inventoryProcess.getPID());
                    sb.append(" ");
                    sb.append("type:" + inventoryProcess.getProcessType());
                    logger.debug(methodName, jobId, new Object[]{sb});
                    continue;
                }
                jobId = null;
                sb = new StringBuffer();
                sb.append("node:" + inventoryProcess.getNodeIdentity().getCanonicalName());
                sb.append(" ");
                sb.append("PID:" + inventoryProcess.getPID());
                sb.append(" ");
                sb.append("type:" + inventoryProcess.getProcessType());
                logger.warn(methodName, jobId, new Object[]{sb});
            }
        }
        ts.ended();
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void advanceToCompleted(DuccWorkJob job) {
        switch (job.getJobState()) {
            case Completing: {
                if (job.getProcessMap().getAliveProcessCount() != 0) break;
                this.stateJobAccounting.stateChange((IDuccWorkJob)job, IDuccState.JobState.Completed);
                break;
            }
        }
    }

    private void advanceToCompleting(DuccWorkJob job) {
        switch (job.getJobState()) {
            case Completed: 
            case Completing: {
                break;
            }
            default: {
                if (job.getProcessMap().getAliveProcessCount() != 0) break;
                this.stateJobAccounting.stateChange((IDuccWorkJob)job, IDuccState.JobState.Completing);
            }
        }
    }

    private void completeManagedReservation(DuccWorkJob service, IRationale rationale) {
        String location = "completeManagedReservation";
        DuccId jobid = null;
        try {
            jobid = service.getDuccId();
            Map map = service.getProcessMap().getMap();
            int size = map.size();
            if (size != 1) {
                logger.warn(location, jobid, new Object[]{"size: " + size});
                this.completeJob(service, rationale);
            } else {
                Iterator iterator = map.keySet().iterator();
                if (iterator.hasNext()) {
                    DuccId key = (DuccId)iterator.next();
                    IDuccProcess process = (IDuccProcess)map.get(key);
                    int code = process.getProcessExitCode();
                    Rationale exitCode = new Rationale("code=" + code);
                    switch (service.getCompletionType()) {
                        case Undefined: {
                            IDuccCompletionType.JobCompletionType completionType = IDuccCompletionType.JobCompletionType.ProgramExit;
                            IProcessState.ProcessState processState = process.getProcessState();
                            if (processState != null) {
                                switch (processState) {
                                    case LaunchFailed: {
                                        completionType = IDuccCompletionType.JobCompletionType.LaunchFailure;
                                        break;
                                    }
                                }
                            }
                            service.setCompletion(completionType, (IRationale)exitCode);
                            service.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                            break;
                        }
                    }
                    this.advanceToCompleting(service);
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
            this.completeJob(service, rationale);
        }
    }

    private void completeService(DuccWorkJob service, IRationale rationale) {
        String location = "completeService";
        DuccId jobid = service.getDuccId();
        if (service.getProcessFailureCount() > 0L) {
            service.setCompletion(IDuccCompletionType.JobCompletionType.Warning, (IRationale)new Rationale("process failure(s) occurred"));
            logger.debug(location, jobid, new Object[]{service.getCompletionRationale().getText() + ", ProcessFailureCount=" + service.getProcessFailureCount()});
        } else if (service.getProcessInitFailureCount() > 0L) {
            service.setCompletion(IDuccCompletionType.JobCompletionType.Warning, (IRationale)new Rationale("process initialization failure(s) occurred"));
            logger.debug(location, jobid, new Object[]{service.getCompletionRationale().getText() + ", ProcessInitFailureCount=" + service.getProcessInitFailureCount()});
        } else {
            this.setCompletionIfNotAlreadySet(service, IDuccCompletionType.JobCompletionType.EndOfJob, rationale);
            logger.debug(location, jobid, new Object[]{service.getCompletionRationale().getText() + ", no failures"});
        }
        this.advanceToCompleting(service);
    }

    private void completeJob(DuccWorkJob job, IRationale rationale) {
        String location = "completeJob";
        DuccId jobid = null;
        switch (job.getCompletionType()) {
            case Undefined: {
                job.setCompletion(IDuccCompletionType.JobCompletionType.Undefined, rationale);
                job.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                break;
            }
            case EndOfJob: {
                if (job.getProcessFailureCount() > 0L) {
                    job.setCompletion(IDuccCompletionType.JobCompletionType.Warning, (IRationale)new Rationale("all work items completed, but job process failure(s) occurred"));
                    break;
                }
                if (job.getProcessInitFailureCount() > 0L) {
                    job.setCompletion(IDuccCompletionType.JobCompletionType.Warning, (IRationale)new Rationale("all work items completed, but job process initialization failure(s) occurred"));
                    break;
                }
                try {
                    if (Integer.parseInt(job.getSchedulingInfo().getWorkItemsError()) <= 0) break;
                    job.setCompletion(IDuccCompletionType.JobCompletionType.Error, rationale);
                }
                catch (Exception e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
                break;
            }
        }
        this.advanceToCompleting(job);
    }

    public void jobTerminate(IDuccWorkJob job, IDuccCompletionType.JobCompletionType jobCompletionType, IRationale rationale, IResourceState.ProcessDeallocationType processDeallocationType) {
        if (!job.isFinished()) {
            this.stateJobAccounting.stateChange(job, IDuccState.JobState.Completing);
            this.stateJobAccounting.complete(job, jobCompletionType, rationale);
            OrchestratorCommonArea.getInstance().getProcessAccounting().deallocate(job, processDeallocationType);
        }
    }
}

