/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.uima.ducc.common.IDuccEnv;

public class DuccWebAdministrators {
    private String fileName = IDuccEnv.DUCC_ADMINISTRATORS_FILE;
    private static DuccWebAdministrators duccWebAdministrators = new DuccWebAdministrators();

    public static DuccWebAdministrators getInstance() {
        return duccWebAdministrators;
    }

    private Properties load() {
        Properties properties = new Properties();
        try {
            File file = new File(this.fileName);
            FileInputStream fis = new FileInputStream(file);
            properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public Iterator<String> getSortedAuthorizedUserids() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Properties properties = this.load();
        if (!properties.isEmpty()) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                map.put(name, name);
            }
        }
        Iterator<String> iterator = map.keySet().iterator();
        return iterator;
    }

    public String getAuthorizationFileName() {
        return this.fileName;
    }

    public boolean isAdministrator(String userid) {
        boolean retVal;
        block3: {
            retVal = false;
            try {
                if (userid == null) break block3;
                Properties properties = this.load();
                Iterator<Object> iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    String authorizedUserid = ((String)iterator.next()).trim();
                    if (!userid.trim().equals(authorizedUserid)) continue;
                    retVal = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }
}

