/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.ckpt;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.DuccHead;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;

public abstract class AOrchestratorCheckpoint {
    private static DuccLogger logger = DuccLogger.getLogger(AOrchestratorCheckpoint.class);
    private static DuccId jobid = null;
    protected static OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    protected static Messages messages = orchestratorCommonArea.getSystemMessages();
    protected static DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
    protected static String on = "on";
    protected static String off = "off";
    private AtomicBoolean ckptEnabled = new AtomicBoolean(true);
    private IDuccHead dh = DuccHead.getInstance();
    private AtomicBoolean ckptMaster = new AtomicBoolean(true);

    protected String getStatus() {
        String retVal = off;
        if (this.ckptEnabled.get()) {
            return on;
        }
        return retVal;
    }

    protected void ckptOnOff() {
        String location = "ckptTrueFalse";
        logger.trace(location, jobid, new Object[]{messages.fetch("enter")});
        String position = dpr.getCachedProperty("ducc.orchestrator.checkpoint");
        if (position != null) {
            String desiredPosition = position.toLowerCase();
            if (desiredPosition.equals(off)) {
                this.ckptEnabled.set(false);
            } else if (desiredPosition.equals(on)) {
                this.ckptEnabled.set(true);
            }
        }
        String status = this.getStatus();
        logger.debug(location, jobid, new Object[]{status});
        logger.trace(location, jobid, new Object[]{messages.fetch("exit")});
    }

    private void head_resume() {
        String location = "head_resume";
        if (!this.ckptMaster.get()) {
            this.ckptMaster.set(true);
            logger.info(location, jobid, new Object[]{""});
        }
    }

    private void head_suspend() {
        String location = "head_suspend";
        if (this.ckptMaster.get()) {
            this.ckptMaster.set(false);
            logger.info(location, jobid, new Object[]{""});
        }
    }

    protected boolean isCkptEnabled() {
        boolean retVal = false;
        if (this.dh.is_ducc_head_virtual_master()) {
            this.head_resume();
            if (this.ckptEnabled.get()) {
                retVal = true;
            }
        } else {
            this.head_suspend();
        }
        return retVal;
    }
}

