/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.ckpt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.ckpt.AOrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.ckpt.IOrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.utilities.Checkpointable;
import org.apache.uima.ducc.orchestrator.utilities.TrackSync;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;

public class OrchestratorCheckpointFile
extends AOrchestratorCheckpoint
implements IOrchestratorCheckpoint {
    private static DuccLogger logger = DuccLogger.getLogger(OrchestratorCheckpointFile.class);
    private static DuccId jobid = null;
    private static String saveLocation = orchestratorCommonArea.getStateDirectory() + File.separator + "orchestrator.ckpt";

    protected OrchestratorCheckpointFile() {
        IOHelper.mkdirs((String)orchestratorCommonArea.getStateDirectory());
        this.ckptOnOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveState() {
        String location = "saveState";
        logger.trace(location, jobid, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        if (this.isCkptEnabled()) {
            DuccWorkMap workMap = orchestratorCommonArea.getWorkMap();
            TrackSync ts = TrackSync.await(workMap, this.getClass(), location);
            DuccWorkMap duccWorkMap = workMap;
            synchronized (duccWorkMap) {
                ts.using();
                try {
                    logger.info(location, jobid, new Object[]{messages.fetchLabel("saving to ") + saveLocation});
                    FileOutputStream fos = null;
                    ObjectOutputStream out = null;
                    fos = new FileOutputStream(saveLocation);
                    out = new ObjectOutputStream(fos);
                    Checkpointable checkpointable = orchestratorCommonArea.getCheckpointable();
                    out.writeObject(checkpointable);
                    out.close();
                    retVal = true;
                    logger.info(location, jobid, new Object[]{messages.fetchLabel("saved ") + saveLocation});
                }
                catch (IOException e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            }
            ts.ended();
        } else {
            logger.debug(location, jobid, new Object[]{messages.fetchLabel("bypass saving to ") + saveLocation});
        }
        logger.trace(location, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restoreState() {
        String location = "restoreState";
        logger.trace(location, jobid, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        if (this.isCkptEnabled()) {
            DuccWorkMap workMap = orchestratorCommonArea.getWorkMap();
            TrackSync ts = TrackSync.await(workMap, this.getClass(), location);
            DuccWorkMap duccWorkMap = workMap;
            synchronized (duccWorkMap) {
                ts.using();
                try {
                    logger.info(location, jobid, new Object[]{messages.fetchLabel("restoring from ") + saveLocation});
                    FileInputStream fis = null;
                    ObjectInputStream in = null;
                    fis = new FileInputStream(saveLocation);
                    in = new ObjectInputStream(fis);
                    Checkpointable checkpointable = (Checkpointable)in.readObject();
                    DuccWorkMap map = checkpointable.getWorkMap();
                    Set ids = map.getReservationKeySet();
                    for (DuccId id : ids) {
                        DuccWorkReservation r = (DuccWorkReservation)map.findDuccWork(IDuccTypes.DuccType.Reservation, "" + id.getFriendly());
                        logger.info(location, id, new Object[]{"Looking for work: r", r});
                        if (r == null) continue;
                        r.initLogger();
                    }
                    orchestratorCommonArea.setCheckpointable(checkpointable);
                    in.close();
                    retVal = true;
                    logger.info(location, jobid, new Object[]{messages.fetch("restored")});
                }
                catch (IOException e) {
                    logger.warn(location, jobid, (Throwable)e, new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            }
            ts.ended();
        } else {
            logger.info(location, jobid, new Object[]{messages.fetchLabel("bypass restoring from ") + saveLocation});
        }
        logger.trace(location, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }
}

