/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.user;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccAsUser {
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccAsUser.class);
    private static Messages messages = Messages.getInstance();
    public static String magicString = "1001 Command launching...";
    public static String identity = "orchestrator";
    private static File devNull = new File("/dev/null");

    public static String duckling(String user, String umask, String file, String text) {
        String methodName = "duckling";
        StringBuffer retVal = new StringBuffer();
        String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
        duccLogger.trace(methodName, null, new Object[]{messages.fetchLabel("the duckling launcher") + c_launcher_path});
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(c_launcher_path);
        cmd.add("-u");
        cmd.add(user);
        cmd.add("-a");
        cmd.add("-f");
        cmd.add(file);
        cmd.add(text);
        StringBuffer sbDebug = new StringBuffer();
        duccLogger.trace(methodName, null, new Object[]{"plist: " + sbDebug.toString().trim()});
        duccLogger.trace(methodName, null, new Object[]{"cmd: " + cmd});
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> env = pb.environment();
        env.clear();
        if (umask != null) {
            env.put("DUCC_UMASK", umask);
        }
        try {
            String line;
            pb = pb.redirectError(devNull);
            Process process = pb.start();
            BufferedReader bri = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean trigger = false;
            duccLogger.trace(methodName, null, new Object[]{"read stdout: start"});
            while ((line = bri.readLine()) != null) {
                duccLogger.trace(methodName, null, new Object[]{"stdout: " + line});
                if (trigger) {
                    retVal.append(line + "\n");
                }
                if (!line.startsWith(magicString)) continue;
                duccLogger.trace(methodName, null, new Object[]{"magic!"});
                trigger = true;
            }
            bri.close();
            duccLogger.trace(methodName, null, new Object[]{"read stdout: end"});
            duccLogger.trace(methodName, null, new Object[]{"process waitfor: start"});
            process.waitFor();
            duccLogger.trace(methodName, null, new Object[]{"process waitfor: end"});
        }
        catch (Exception e) {
            duccLogger.warn(methodName, null, (Throwable)e, new Object[0]);
        }
        return retVal.toString();
    }
}

