/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.utilities;

import org.apache.uima.ducc.transport.event.common.IDuccUnits;

public class MemorySpecification {
    private String msize = null;
    private String units = null;
    private IDuccUnits.MemoryUnits memUnits = null;

    public MemorySpecification(String memorySpecification) {
        this.init(memorySpecification);
    }

    private void init(String memorySpecification) {
        if (memorySpecification != null) {
            this.msize = memorySpecification.replaceAll("\\s", "");
            if (this.msize.endsWith("KB")) {
                this.units = "KB";
                this.memUnits = IDuccUnits.MemoryUnits.KB;
                this.msize = this.msize.substring(0, this.msize.length() - 2);
            } else if (this.msize.endsWith("MB")) {
                this.units = "MB";
                this.memUnits = IDuccUnits.MemoryUnits.MB;
                this.msize = this.msize.substring(0, this.msize.length() - 2);
            } else if (this.msize.endsWith("GB")) {
                this.units = "GB";
                this.memUnits = IDuccUnits.MemoryUnits.GB;
                this.msize = this.msize.substring(0, this.msize.length() - 2);
            } else if (this.msize.endsWith("TB")) {
                this.units = "TB";
                this.memUnits = IDuccUnits.MemoryUnits.TB;
                this.msize = this.msize.substring(0, this.msize.length() - 2);
            }
            try {
                Integer.parseInt(this.msize);
            }
            catch (Exception e) {
                this.msize = null;
            }
        }
    }

    public String getSize() {
        return this.msize;
    }

    public String getUnits() {
        return this.units;
    }

    public IDuccUnits.MemoryUnits getMemoryUnits() {
        return this.memUnits;
    }
}

