/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.asb.ASB;
import org.apache.uima.analysis_engine.asb.impl.ASB_impl;
import org.apache.uima.analysis_engine.asb.impl.FlowControllerContainer;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.CapabilityLanguageFlow;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.impl.FlowControllerDeclaration_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.flow.impl.CapabilityLanguageFlowController;
import org.apache.uima.flow.impl.FixedFlowController;
import org.apache.uima.internal.util.UUIDGenerator;
import org.apache.uima.resource.ConfigurableResource;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.ResourceCreationSpecifier_impl;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.ResourceMetaData_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.impl.ProcessTraceEvent_impl;

public class AggregateAnalysisEngine_impl
extends AnalysisEngineImplBase
implements AnalysisEngine {
    private static final Class<AggregateAnalysisEngine_impl> CLASS_NAME = AggregateAnalysisEngine_impl.class;
    public static final String PARAM_RESULT_SPECIFICATION = "RESULT_SPECIFICATION";
    private AnalysisEngineDescription mDescription;
    private Map<String, ProcessingResourceMetaData> mComponentMetaData;
    private ASB mASB;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        try {
            if (!(aSpecifier instanceof AnalysisEngineDescription)) {
                return false;
            }
            this.mDescription = (AnalysisEngineDescription)aSpecifier;
            if (this.mDescription.isPrimitive()) {
                return false;
            }
            String fwImpl = this.mDescription.getFrameworkImplementation();
            if (!fwImpl.startsWith("org.apache.uima.java")) {
                return false;
            }
            super.initialize(aSpecifier, aAdditionalParams);
            AnalysisEngineMetaData md = this.mDescription.getAnalysisEngineMetaData();
            Logger logger = this.getLogger();
            logger.logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_begin__CONFIG", md.getName());
            this.normalizeIsoLangCodes(md);
            AnalysisEngineMetaData mdCopy = (AnalysisEngineMetaData)md.clone();
            if (mdCopy.getUUID() == null) {
                mdCopy.setUUID(UUIDGenerator.generate());
            }
            this.setMetaData(mdCopy);
            UimaContext prevContext = UimaContextHolder.setContext(this.getUimaContext());
            try {
                this.mDescription.getDelegateAnalysisEngineSpecifiers(this.getResourceManager());
                if (this.mDescription.getFlowControllerDeclaration() != null) {
                    if (this.mDescription.getFlowControllerDeclaration().getImport() == null && this.mDescription.getFlowControllerDeclaration().getSpecifier() == null) {
                        throw new ResourceInitializationException("empty_flow_controller_declaration", new Object[]{this.getMetaData().getName(), this.mDescription.getSourceUrl()});
                    }
                    this.mDescription.getFlowControllerDeclaration().resolveImports(this.getResourceManager());
                }
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
            finally {
                UimaContextHolder.setContext(prevContext);
            }
            this.mDescription.validate(this.getResourceManager());
            aAdditionalParams = aAdditionalParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aAdditionalParams);
            aAdditionalParams.put("CONFIG_PARAM_SETTINGS", this.getCurrentConfigParameterSettings());
            aAdditionalParams.put("RESOURCE_MANAGER", this.getResourceManager());
            this.initializeAggregateAnalysisEngine(this.mDescription, aAdditionalParams);
            this.resetResultSpecificationToDefault();
            logger.logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_successful__CONFIG", md.getName());
            return true;
        }
        catch (ResourceConfigurationException e) {
            throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{this.getMetaData().getName(), aSpecifier.getSourceUrlString()});
        }
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
        if (aResultSpec == null) {
            this.resetResultSpecificationToDefault();
        } else {
            ResultSpecification resultSpecForComponents = (ResultSpecification)aResultSpec.clone();
            resultSpecForComponents.addCapabilities(this.getAllComponentCapabilities(), false);
            for (AnalysisEngine ae : this._getASB().getComponentAnalysisEngines().values()) {
                ae.setResultSpecification(resultSpecForComponents);
            }
        }
    }

    private Capability[] getAllComponentCapabilities() {
        ArrayList<Capability> capabilityList = new ArrayList<Capability>();
        for (ProcessingResourceMetaData md : this._getComponentMetaData().values()) {
            capabilityList.addAll(Arrays.asList(md.getCapabilities()));
        }
        Capability[] capabilityArray = new Capability[capabilityList.size()];
        capabilityList.toArray(capabilityArray);
        return capabilityArray;
    }

    @Override
    public void destroy() {
        if (this.mASB != null) {
            this.mASB.destroy();
        }
        this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "destroy", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_destroyed__CONFIG", this.getMetaData().getName());
        super.destroy();
    }

    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        String resourceName = this.getMetaData().getName();
        Logger logger = this.getLogger();
        logger.logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_begin__FINE", resourceName);
        try {
            CasIterator iterator = this._getASB().process(aCAS);
            logger.logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_end__FINE", resourceName);
            return iterator;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            if (e instanceof AnalysisEngineProcessException) {
                throw (AnalysisEngineProcessException)e;
            }
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        super.reconfigure();
        Map<String, AnalysisEngine> components = this._getASB().getComponentAnalysisEngines();
        for (ConfigurableResource configurableResource : components.values()) {
            configurableResource.reconfigure();
        }
        FlowControllerContainer flowControllerContainer = ((ASB_impl)this._getASB()).getFlowControllerContainer();
        flowControllerContainer.reconfigure();
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        this.enterBatchProcessComplete();
        try {
            Iterator<AnalysisEngine> iter = this._getASB().getComponentAnalysisEngines().values().iterator();
            while (iter.hasNext()) {
                iter.next().batchProcessComplete();
            }
        }
        finally {
            this.exitBatchProcessComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.enterCollectionProcessComplete();
        try {
            String[] orderedNodes = null;
            HashMap<String, AnalysisEngine> components = new HashMap<String, AnalysisEngine>(this._getASB().getComponentAnalysisEngines());
            FlowConstraints flow = this.getAnalysisEngineMetaData().getFlowConstraints();
            if (flow != null) {
                if (flow instanceof FixedFlow) {
                    orderedNodes = ((FixedFlow)flow).getFixedFlow();
                } else if (flow instanceof CapabilityLanguageFlow) {
                    orderedNodes = ((CapabilityLanguageFlow)flow).getCapabilityLanguageFlow();
                }
            }
            if (orderedNodes != null) {
                for (int i = 0; i < orderedNodes.length; ++i) {
                    AnalysisEngine component = (AnalysisEngine)components.remove(orderedNodes[i]);
                    component.collectionProcessComplete();
                }
            }
            Iterator iter = components.values().iterator();
            while (iter.hasNext()) {
                ((AnalysisEngine)iter.next()).collectionProcessComplete();
            }
            FlowControllerContainer fcc = this._getASB().getFlowControllerContainer();
            if (fcc != null) {
                fcc.collectionProcessComplete();
            }
        }
        finally {
            this.exitCollectionProcessComplete();
        }
    }

    protected void initializeAggregateAnalysisEngine(AnalysisEngineDescription aDescription, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        try {
            this.initASB(aDescription, aAdditionalParams);
        }
        catch (ResourceInitializationException e) {
            this.destroy();
            throw e;
        }
        this.processDelegateAnalysisEngineMetaData();
    }

    protected void initASB(AnalysisEngineDescription aAnalysisEngineDescription, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        HashMap<String, Object> asbParams = new HashMap<String, Object>(aAdditionalParams);
        asbParams.put("PARAM_AGGREGATE_ANALYSIS_ENGINE_NAME", this.getMetaData().getName());
        asbParams.put("RESOURCE_MANAGER", this.getResourceManager());
        asbParams.put("AGGREGATE_SOFA_MAPPINGS", aAnalysisEngineDescription.getSofaMappings());
        FlowControllerDeclaration flowControllerDecl = aAnalysisEngineDescription.getFlowControllerDeclaration();
        if (flowControllerDecl != null) {
            try {
                aAnalysisEngineDescription.getFlowControllerDeclaration().resolveImports(this.getResourceManager());
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
        } else {
            flowControllerDecl = this.getDefaultFlowControllerDeclaration();
        }
        this.mASB = new ASB_impl();
        ResourceCreationSpecifier_impl dummyAsbSpecifier = new ResourceCreationSpecifier_impl();
        dummyAsbSpecifier.setMetaData(new ResourceMetaData_impl());
        this.mASB.initialize(dummyAsbSpecifier, asbParams);
        this.mASB.setup(this._getComponentCasProcessorSpecifierMap(), this.getUimaContextAdmin(), flowControllerDecl, this.getAnalysisEngineMetaData());
        this.mComponentMetaData = this._getASB().getAllComponentMetaData();
    }

    protected void processDelegateAnalysisEngineMetaData() throws ResourceInitializationException {
        FsIndexCollection thisAEsIndexes;
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> typePriorities = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> fsIndexCollections = new ArrayList<FsIndexCollection>();
        TypePriorities thisAEsTypePriorities = this.getAnalysisEngineMetaData().getTypePriorities();
        if (thisAEsTypePriorities != null) {
            typePriorities.add(thisAEsTypePriorities);
        }
        if ((thisAEsIndexes = this.getAnalysisEngineMetaData().getFsIndexCollection()) != null) {
            fsIndexCollections.add(thisAEsIndexes);
        }
        for (ProcessingResourceMetaData md : this._getComponentMetaData().values()) {
            if (md.getTypeSystem() != null) {
                typeSystems.add(md.getTypeSystem());
            }
            if (md.getTypePriorities() != null) {
                typePriorities.add(md.getTypePriorities());
            }
            if (md.getFsIndexCollection() == null) continue;
            fsIndexCollections.add(md.getFsIndexCollection());
        }
        TypeSystemDescription aggTypeDesc = CasCreationUtils.mergeTypeSystems(typeSystems, this.getResourceManager());
        TypePriorities aggTypePriorities = CasCreationUtils.mergeTypePriorities(typePriorities, this.getResourceManager());
        FsIndexCollection aggIndexColl = CasCreationUtils.mergeFsIndexes(fsIndexCollections, this.getResourceManager());
        AnalysisEngineMetaData aggregateMD = this.getAnalysisEngineMetaData();
        aggregateMD.setTypeSystem(aggTypeDesc);
        aggregateMD.setTypePriorities(aggTypePriorities);
        aggregateMD.setFsIndexCollection(aggIndexColl);
        this.validateOperationalProperties();
    }

    protected void validateOperationalProperties() throws ResourceInitializationException {
        OperationalProperties aggProps = this.getAnalysisEngineMetaData().getOperationalProperties();
        if (aggProps != null) {
            boolean atLeastOneCasMultiplier = false;
            for (ProcessingResourceMetaData md : this._getComponentMetaData().values()) {
                OperationalProperties componentProps = md.getOperationalProperties();
                if (componentProps == null) continue;
                if (aggProps.isMultipleDeploymentAllowed() && !componentProps.isMultipleDeploymentAllowed()) {
                    throw new ResourceInitializationException("invalid_multiple_deployment_allowed", new Object[]{this.getAnalysisEngineMetaData().getName(), md.getName(), this.getAnalysisEngineMetaData().getSourceUrlString()});
                }
                if (!aggProps.getModifiesCas() && componentProps.getModifiesCas()) {
                    throw new ResourceInitializationException("invalid_modifies_cas", new Object[]{this.getAnalysisEngineMetaData().getName(), md.getName(), this.getAnalysisEngineMetaData().getSourceUrlString()});
                }
                if (!componentProps.getOutputsNewCASes()) continue;
                atLeastOneCasMultiplier = true;
            }
            if (aggProps.getOutputsNewCASes() && !atLeastOneCasMultiplier) {
                throw new ResourceInitializationException("invalid_outputs_new_CASes", new Object[]{this.getAnalysisEngineMetaData().getName(), this.getAnalysisEngineMetaData().getSourceUrlString()});
            }
        }
    }

    protected FlowControllerDeclaration getDefaultFlowControllerDeclaration() {
        FlowControllerDescription flowControllerDesc = this.getAnalysisEngineMetaData().getFlowConstraints() instanceof CapabilityLanguageFlow ? CapabilityLanguageFlowController.getDescription() : FixedFlowController.getDescription();
        FlowControllerDeclaration_impl decl = new FlowControllerDeclaration_impl();
        decl.setKey("_FlowController");
        decl.setSpecifier(flowControllerDesc);
        return decl;
    }

    protected ASB _getASB() {
        return this.mASB;
    }

    protected Map<String, ProcessingResourceMetaData> _getComponentMetaData() {
        return this.mComponentMetaData;
    }

    protected Map<String, ResourceSpecifier> _getComponentCasProcessorSpecifierMap() {
        try {
            return this.mDescription.getDelegateAnalysisEngineSpecifiers();
        }
        catch (InvalidXMLException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected void buildProcessTraceFromMBeanStats(ProcessTrace trace) {
        if (this.isProcessTraceEnabled()) {
            ProcessTraceEvent_impl procEvt = new ProcessTraceEvent_impl(this.getMetaData().getName(), "Analysis", "");
            procEvt.setDuration((int)this.getMBean().getAnalysisTimeSinceMark());
            trace.addEvent(procEvt);
            for (AnalysisEngine ae : this._getASB().getComponentAnalysisEngines().values()) {
                ProcessTrace subPT;
                if (!(ae instanceof AnalysisEngineImplBase) || (subPT = ((AnalysisEngineImplBase)ae).buildProcessTraceFromMBeanStats()).getEvents().size() <= 0) continue;
                procEvt.addSubEvent(subPT.getEvents().get(0));
            }
            FlowControllerContainer fcc = ((ASB_impl)this._getASB()).getFlowControllerContainer();
            int flowControllerTime = (int)fcc.getMBean().getAnalysisTimeSinceMark();
            ProcessTraceEvent_impl flowControllerEvent = new ProcessTraceEvent_impl(fcc.getMetaData().getName(), "Analysis", "");
            flowControllerEvent.setDuration(flowControllerTime);
            procEvt.addSubEvent(flowControllerEvent);
            this.getMBean().mark();
        }
    }
}

