/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import javax.management.ObjectName;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.aae.AsynchAECasManager;
import org.apache.uima.aae.AsynchAECasManager_impl;
import org.apache.uima.aae.EECasManager_impl;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.OutputChannel;
import org.apache.uima.aae.UIDGenerator;
import org.apache.uima.aae.UimaASApplicationEvent;
import org.apache.uima.aae.UimaAsContext;
import org.apache.uima.aae.UimaAsVersion;
import org.apache.uima.aae.UimaClassFactory;
import org.apache.uima.aae.UimaEEAdminContext;
import org.apache.uima.aae.VersionCompatibilityChecker;
import org.apache.uima.aae.WarmUpDataProvider;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController_impl;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Controller;
import org.apache.uima.aae.controller.ControllerCallbackListener;
import org.apache.uima.aae.controller.ControllerLatch;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.EventSubscriber;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController_impl;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.ErrorHandlerChain;
import org.apache.uima.aae.error.ForcedMessageTimeoutException;
import org.apache.uima.aae.error.ServiceShutdownException;
import org.apache.uima.aae.error.UimaAsUncaughtExceptionHandler;
import org.apache.uima.aae.error.handler.ProcessCasErrorHandler;
import org.apache.uima.aae.jmx.JmxManagement;
import org.apache.uima.aae.jmx.JmxManager;
import org.apache.uima.aae.jmx.ServiceErrors;
import org.apache.uima.aae.jmx.ServiceInfo;
import org.apache.uima.aae.jmx.ServicePerformance;
import org.apache.uima.aae.monitor.Monitor;
import org.apache.uima.aae.monitor.MonitorBaseImpl;
import org.apache.uima.aae.monitor.statistics.LongNumericStatistic;
import org.apache.uima.aae.monitor.statistics.Statistics;
import org.apache.uima.aae.spi.transport.UimaMessageListener;
import org.apache.uima.aae.spi.transport.UimaTransport;
import org.apache.uima.aae.spi.transport.vm.UimaVmMessage;
import org.apache.uima.aae.spi.transport.vm.VmTransport;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;

public abstract class BaseAnalysisEngineController
extends Resource_ImplBase
implements AnalysisEngineController,
EventSubscriber {
    private static final Class CLASS_NAME = BaseAnalysisEngineController.class;
    private static final String JMS_PROVIDER_HOME = "ACTIVEMQ_HOME";
    public static final boolean NO_RECOVERY = true;
    private Semaphore quiesceSemaphore = new Semaphore(0);
    protected ServiceState currentState = ServiceState.INITIALIZING;
    private static final long DoNotProcessTTL = 1800000L;
    private static int serviceInstance = 0;
    protected volatile ControllerLatch latch = new ControllerLatch(this);
    protected ConcurrentHashMap<String, Long> statsMap = new ConcurrentHashMap();
    protected Monitor monitor = new MonitorBaseImpl();
    protected Endpoint clientEndpoint;
    private CountDownLatch inputChannelLatch = new CountDownLatch(1);
    private OutputChannel outputChannel;
    protected AsynchAECasManager casManager;
    private InProcessCache inProcessCache;
    protected AnalysisEngineController parentController;
    protected String endpointName;
    protected ResourceSpecifier resourceSpecifier;
    protected HashMap paramsMap;
    protected InputChannel inputChannel;
    protected ErrorHandlerChain errorHandlerChain;
    protected long errorCount = 0L;
    protected List<InputChannel> inputChannelList = new ArrayList<InputChannel>();
    protected ConcurrentHashMap<String, InputChannel> inputChannelMap = new ConcurrentHashMap();
    private UimaEEAdminContext adminContext;
    protected int componentCasPoolSize = 0;
    protected long replyTime = 0L;
    protected long idleTime = 0L;
    protected ConcurrentHashMap serviceErrorMap = new ConcurrentHashMap();
    private boolean registeredWithJMXServer = false;
    protected String jmxContext = "";
    protected ServicePerformance servicePerformance = null;
    protected ServiceErrors serviceErrors = null;
    private String deploymentDescriptor = "";
    private JmxManagement jmxManagement = null;
    protected volatile boolean stopped = false;
    protected String delegateKey = null;
    protected List unregisteredDelegateList = new ArrayList();
    protected volatile boolean allDelegatesAreRemote = false;
    protected List controllerListeners = new ArrayList();
    protected volatile boolean serviceInitialized = false;
    protected ConcurrentHashMap perCasStatistics = new ConcurrentHashMap();
    private volatile boolean casMultiplier = false;
    protected Object syncObject = new Object();
    protected ConcurrentHashMap cmOutstandingCASes = new ConcurrentHashMap();
    private Object mux = new Object();
    private Object waitmux = new Object();
    private volatile boolean waitingForCAS = false;
    private long startTime = System.nanoTime();
    private long totalWaitTimeForCAS = 0L;
    private long lastCASWaitTimeUpdate = 0L;
    private Map<Long, AnalysisThreadState> threadStateMap = new HashMap<Long, AnalysisThreadState>();
    protected final Object finalStepMux = new Object();
    protected ConcurrentHashMap<String, UimaTransport> transports = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, UimaMessageListener> messageListeners = new ConcurrentHashMap();
    private Exception initException = null;
    private Object lock = new Object();
    protected LocalCache localCache;
    protected String aeDescriptor;
    protected List<Delegate> delegates = new ArrayList<Delegate>();
    protected volatile boolean callbackReceived = false;
    protected Object callbackMonitor = new Object();
    protected Semaphore onEmptyCacheSemaphore = new Semaphore(1);
    protected volatile boolean awaitingCacheCallbackNotification = false;
    protected ConcurrentHashMap<String, String> abortedCasesMap = new ConcurrentHashMap();
    protected String processPid = "";
    private CountDownLatch stopLatch = new CountDownLatch(1);
    private volatile boolean releasedAllCASes;
    private ScheduledExecutorService daemonServiceExecutor = null;
    private static final UimaAsVersion uimaAsVersion = new UimaAsVersion();
    protected ConcurrentHashMap<String, String> deadClientDestinationMap = new ConcurrentHashMap();
    private String serviceName = null;
    protected UimaContext uimaContext = null;

    @Override
    public abstract void dumpState(StringBuffer var1, String var2);

    protected abstract void doWarmUp(CAS var1, String var2) throws Exception;

    public BaseAnalysisEngineController() {
    }

    public BaseAnalysisEngineController(AnalysisEngineController aParentController, int aComponentCasPoolSize, String anEndpointName, String aDescriptor, AsynchAECasManager aCasManager, InProcessCache anInProcessCache) throws Exception {
        this(aParentController, aComponentCasPoolSize, 0L, anEndpointName, aDescriptor, aCasManager, anInProcessCache, null, null, false);
    }

    public BaseAnalysisEngineController(AnalysisEngineController aParentController, int aComponentCasPoolSize, String anEndpointName, String aDescriptor, AsynchAECasManager aCasManager, InProcessCache anInProcessCache, Map aDestinationMap) throws Exception {
        this(aParentController, aComponentCasPoolSize, 0L, anEndpointName, aDescriptor, aCasManager, anInProcessCache, aDestinationMap, null, false);
    }

    public BaseAnalysisEngineController(AnalysisEngineController aParentController, int aComponentCasPoolSize, String anEndpointName, String aDescriptor, AsynchAECasManager aCasManager, InProcessCache anInProcessCache, Map aDestinationMap, JmxManagement aJmxManagement) throws Exception {
        this(aParentController, aComponentCasPoolSize, 0L, anEndpointName, aDescriptor, aCasManager, anInProcessCache, aDestinationMap, aJmxManagement, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseAnalysisEngineController(AnalysisEngineController aParentController, int aComponentCasPoolSize, long anInitialCasHeapSize, String anEndpointName, String aDescriptor, AsynchAECasManager aCasManager, InProcessCache anInProcessCache, Map aDestinationMap, JmxManagement aJmxManagement, boolean disableJCasCache) throws Exception {
        this.casManager = aCasManager;
        this.inProcessCache = anInProcessCache;
        this.localCache = new LocalCache(this);
        this.aeDescriptor = aDescriptor;
        this.parentController = aParentController;
        this.componentCasPoolSize = aComponentCasPoolSize;
        if (this instanceof AggregateAnalysisEngineController) {
            Set set = aDestinationMap.entrySet();
            List list = this.unregisteredDelegateList;
            synchronized (list) {
                for (Map.Entry entry : set) {
                    Endpoint endpoint = (Endpoint)entry.getValue();
                    if (endpoint == null || endpoint.isRemote()) continue;
                    this.unregisteredDelegateList.add(entry.getKey());
                }
                if (this.unregisteredDelegateList.size() == 0) {
                    this.allDelegatesAreRemote = true;
                }
            }
        }
        this.endpointName = anEndpointName;
        this.delegateKey = anEndpointName;
        if (this instanceof AggregateAnalysisEngineController) {
            ConcurrentHashMap endpoints = new ConcurrentHashMap();
            endpoints.putAll(aDestinationMap);
            ((AggregateAnalysisEngineController)((Object)this)).mapEndpointsToKeys(endpoints);
        }
        if (!this.isTopLevelComponent()) {
            Endpoint endpoint = ((AggregateAnalysisEngineController)this.parentController).lookUpEndpoint(this.endpointName, false);
            this.endpointName = endpoint.getEndpoint();
        }
        this.resourceSpecifier = UimaClassFactory.produceResourceSpecifier(aDescriptor);
        if (this.resourceSpecifier instanceof PearSpecifier) {
            this.serviceName = ((PearSpecifier)this.resourceSpecifier).getPearPath();
            int pos = 0;
            pos = this.serviceName.lastIndexOf(".");
            if (pos > -1) {
                this.serviceName = this.serviceName.substring(pos + 1);
            }
        }
        if (this.isTopLevelComponent()) {
            Thread.setDefaultUncaughtExceptionHandler(new UimaAsUncaughtExceptionHandler(this.getComponentName()));
            VersionCompatibilityChecker.check(CLASS_NAME, this.getComponentName(), "BaseAnalysisEngineController()");
            this.logPlatformInfo(this.getComponentName());
        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "BaseAnalysisEngineController", "uimaee_messages", "UIMAEE_service_id_INFO", new Object[]{this.endpointName});
        }
        if (this.resourceSpecifier instanceof AnalysisEngineDescription && ((AnalysisEngineDescription)this.resourceSpecifier).getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes() || this.resourceSpecifier instanceof CollectionReaderDescription) {
            this.casMultiplier = true;
        }
        this.paramsMap = new HashMap();
        if (aJmxManagement == null) {
            if (this.isTopLevelComponent()) {
                ++serviceInstance;
            }
            this.jmxManagement = new JmxManager(this.getJMXDomain(serviceInstance));
        } else {
            this.jmxManagement = aJmxManagement;
            if (this.jmxManagement.getMBeanServer() != null) {
                this.paramsMap.put("MBEAN_SERVER", this.jmxManagement.getMBeanServer());
            }
        }
        this.paramsMap.put("MBEAN_NAME_PREFIX", this.jmxManagement.getJmxDomain());
        if (this.isTopLevelComponent() && this instanceof AggregateAnalysisEngineController && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "C'tor", "uimaee_messages", "UIMAEE_using_vm_transport_INFO", new Object[]{this.getComponentName()});
        }
        String casLogComponents = System.getProperty("UIMA_CASLOG_COMPONENT_ARRAY");
        if (this.parentController == null) {
            this.paramsMap.put("RESOURCE_MANAGER", this.casManager.getResourceManager());
            this.initialize(this.resourceSpecifier, this.paramsMap);
            AnalysisEngineManagementImpl mbean = (AnalysisEngineManagementImpl)this.getUimaContextAdmin().getManagementInterface();
            if (this instanceof AggregateAnalysisEngineController) {
                mbean.setName(this.getComponentName(), this.getUimaContextAdmin(), this.jmxManagement.getJmxDomain());
            }
            if (this.resourceSpecifier instanceof AnalysisEngineDescription && ((AnalysisEngineDescription)this.resourceSpecifier).getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "C'tor", "uimaee_messages", "UIMAEE_multiplier_cas_pool_config_INFO", new Object[]{this.getComponentName(), aComponentCasPoolSize, anInitialCasHeapSize, this.getUimaContextAdmin().getQualifiedContextName()});
                }
                this.initializeComponentCasPool(aComponentCasPoolSize, anInitialCasHeapSize, disableJCasCache);
            }
        } else {
            UimaContext childContext = this.parentController.getChildUimaContext(this.endpointName);
            if (childContext != null && childContext instanceof UimaContextAdmin) {
                String it = ((UimaContextAdmin)childContext).getQualifiedContextName();
            }
            this.uimaContext = childContext;
            this.paramsMap.put("UIMA_CONTEXT", childContext);
            this.initialize(this.resourceSpecifier, this.paramsMap);
            this.initializeComponentCasPool(aComponentCasPoolSize, anInitialCasHeapSize, disableJCasCache);
            if (this.parentController instanceof AggregateAnalysisEngineController) {
                ((AggregateAnalysisEngineController)this.parentController).registerChildController(this, this.delegateKey);
            }
        }
        int index = this.getIndex();
        this.jmxContext = this.getJmxContext();
        if (!this.isTopLevelComponent() && this instanceof PrimitiveAnalysisEngineController) {
            String thisComponentName = ((AggregateAnalysisEngineController)this.parentController).lookUpDelegateKey(this.endpointName);
            this.jmxContext = this.jmxContext + thisComponentName + " Uima EE Service";
        }
        if (this.inProcessCache != null && this.isTopLevelComponent()) {
            this.inProcessCache.setName(this.jmxManagement.getJmxDomain() + this.jmxContext + ",name=" + this.inProcessCache.getName());
            ObjectName on = new ObjectName(this.inProcessCache.getName());
            this.jmxManagement.registerMBean(this.inProcessCache, on);
        }
        this.initializeServiceStats();
        if (this instanceof AggregateAnalysisEngineController) {
            Set set = aDestinationMap.entrySet();
            for (Map.Entry entry : set) {
                Endpoint endpoint = (Endpoint)entry.getValue();
                if (endpoint == null || !endpoint.isRemote()) continue;
                String key = ((AggregateAnalysisEngineController)((Object)this)).lookUpDelegateKey(endpoint.getEndpoint());
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "C'tor", "uimaee_messages", "UIMAEE_show_remote_delegate_serialization_INFO", new Object[]{this.getComponentName(), key, endpoint.getSerializer()});
            }
        }
        if (this.isTopLevelComponent()) {
            Controller controller = new Controller(this);
            String jmxName = this.getManagementInterface().getJmxDomain() + "name=Controller";
            this.registerWithAgent(controller, jmxName);
        }
    }

    @Override
    public UimaContext getUimaContext() {
        return this.uimaContext;
    }

    @Override
    public String getPID() {
        return this.processPid;
    }

    private String getLoadedJars() {
        StringBuffer loadedJars;
        block4: {
            loadedJars = new StringBuffer("");
            try {
                if (this.getClass().getClassLoader() instanceof URLClassLoader) {
                    URL[] urls;
                    for (URL url : urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs()) {
                        loadedJars.append(url.getFile() + File.pathSeparator);
                    }
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "getLoadedJars", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "getLoadedJars", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        return loadedJars.toString();
    }

    private void logPlatformInfo(String serviceName) {
        if (ManagementFactory.getPlatformMBeanServer() != null) {
            int endPos;
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            this.processPid = bean.getName();
            if (this.processPid != null && this.processPid.trim().length() > 0 && (endPos = this.processPid.indexOf("@")) > -1) {
                this.processPid = this.processPid.substring(0, endPos);
            }
            String loadedJars = this.getLoadedJars();
            SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss ");
            if (System.getProperty("EXTENDED_TESTS") == null || System.getProperty("EXTENDED_TESTS").trim().length() == 0) {
                StringBuffer platformInfo = new StringBuffer();
                platformInfo.append("\n+------------------------------------------------------------------");
                platformInfo.append("\n                   Starting UIMA AS Service - PID: " + this.processPid);
                platformInfo.append("\n+------------------------------------------------------------------");
                platformInfo.append("\n+ Service Name:" + serviceName);
                platformInfo.append("\n+ Service Queue Name:" + this.endpointName);
                platformInfo.append("\n+ Service Start Time:" + df.format(bean.getStartTime()));
                platformInfo.append("\n+ UIMA AS Version:" + uimaAsVersion.getVersionString());
                platformInfo.append("\n+ UIMA Core Version:" + UIMAFramework.getVersionString());
                if (System.getenv(JMS_PROVIDER_HOME) != null) {
                    platformInfo.append("\n+ JMS Provider Home:" + System.getenv(JMS_PROVIDER_HOME));
                }
                platformInfo.append("\n+ OS Name:" + osBean.getName());
                platformInfo.append("\n+ OS Version:" + osBean.getVersion());
                platformInfo.append("\n+ OS Architecture:" + osBean.getArch());
                platformInfo.append("\n+ OS CPU Count:" + osBean.getAvailableProcessors());
                platformInfo.append("\n+ JVM Vendor:" + bean.getVmVendor());
                platformInfo.append("\n+ JVM Name:" + bean.getVmName());
                platformInfo.append("\n+ JVM Version:" + bean.getVmVersion());
                platformInfo.append("\n+ JVM Input Args:" + bean.getInputArguments());
                platformInfo.append("\n+ JVM Classpath:" + bean.getClassPath());
                if (loadedJars != null && loadedJars.length() > 0) {
                    platformInfo.append("\n+ JVM Loaded Jars:" + loadedJars);
                }
                platformInfo.append("\n+ JVM LIB_PATH:" + bean.getLibraryPath());
                platformInfo.append("\n+------------------------------------------------------------------");
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "logPlatformInfo", "uimaee_messages", "UIMAEE_show_platform_info__INFO", new Object[]{platformInfo.toString()});
            }
        }
    }

    @Override
    public AnalysisEngineController getParentController() {
        return this.parentController;
    }

    @Override
    public UimaTransport getTransport(String aKey) throws Exception {
        return this.getTransport(null, aKey);
    }

    public UimaTransport getTransport(UimaAsContext asContext) throws Exception {
        String endpointName = this.getName();
        if (!this.isTopLevelComponent()) {
            endpointName = this.parentController.getName();
        }
        return this.getTransport(asContext, endpointName);
    }

    @Override
    public UimaTransport getTransport(UimaAsContext asContext, String aKey) throws Exception {
        UimaTransport transport = null;
        if (!this.transports.containsKey(aKey)) {
            transport = new VmTransport(asContext, this);
            if (this.isStopped()) {
                throw new ServiceShutdownException();
            }
            this.transports.put(aKey, transport);
        } else {
            transport = this.transports.get(aKey);
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeVMTransport(int parentControllerReplyConsumerCount) throws Exception {
        if (this instanceof AggregateAnalysisEngineController) {
            List<AnalysisEngineController> childControllers;
            List<AnalysisEngineController> list = childControllers = ((AggregateAnalysisEngineController_impl)this).childControllerList;
            synchronized (list) {
                for (AnalysisEngineController ctrl : childControllers) {
                    ctrl.initializeVMTransport(parentControllerReplyConsumerCount);
                }
            }
        }
        if (this.parentController != null) {
            UimaAsContext uimaAsContext = new UimaAsContext();
            if (!this.registeredWithJMXServer) {
                this.registeredWithJMXServer = true;
                this.registerServiceWithJMX(this.jmxContext, false);
            }
            String key = ((AggregateAnalysisEngineController)this.parentController).lookUpDelegateKey(this.getName());
            int concurrentRequestConsumers = 1;
            int concurrentReplyConsumers = 1;
            if (key != null) {
                Endpoint e = ((AggregateAnalysisEngineController)this.parentController).lookUpEndpoint(key, false);
                concurrentRequestConsumers = e.getConcurrentRequestConsumers();
                concurrentReplyConsumers = e.getConcurrentReplyConsumers();
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initializeVMTransport", "uimaee_messages", "UIMAEE_starting_colocated_listener__INFO", new Object[]{this.getComponentName(), concurrentRequestConsumers, concurrentReplyConsumers});
            }
            uimaAsContext.setConcurrentConsumerCount(concurrentRequestConsumers);
            uimaAsContext.put("EndpointName", this.endpointName);
            UimaTransport vmTransport = this.getTransport(uimaAsContext);
            UimaMessageListener messageListener = vmTransport.produceUimaMessageListener();
            messageListener.initialize(uimaAsContext);
            this.messageListeners.put(this.getName(), messageListener);
            UimaAsContext uimaAsContext2 = new UimaAsContext();
            uimaAsContext2.setConcurrentConsumerCount(concurrentReplyConsumers);
            uimaAsContext2.put("EndpointName", this.endpointName);
            UimaTransport parentVmTransport = this.parentController.getTransport(uimaAsContext2, this.endpointName);
            parentVmTransport.produceUimaMessageDispatcher(vmTransport);
            UimaMessageListener parentListener = parentVmTransport.produceUimaMessageListener();
            parentListener.initialize(uimaAsContext2);
            vmTransport.produceUimaMessageDispatcher(parentVmTransport);
            vmTransport.registerWithJMX(this, "VmInputQueue");
            parentVmTransport.registerWithJMX(this, "VmReplyQueue");
        }
    }

    @Override
    public synchronized UimaMessageListener getUimaMessageListener(String aDelegateKey) {
        return this.messageListeners.get(aDelegateKey);
    }

    @Override
    public String getJMXDomain() {
        return this.getJMXDomain(serviceInstance);
    }

    public String getJMXDomain(int sequence) {
        if (!this.isTopLevelComponent()) {
            return this.parentController.getJMXDomain();
        }
        return "org.apache.uima:type=ee.jms.services,s=" + this.getComponentName() + " Uima EE Service " + sequence + ",";
    }

    @Override
    public JmxManagement getManagementInterface() {
        return this.jmxManagement;
    }

    @Override
    public int getIndex() {
        if (this.isTopLevelComponent()) {
            return 0;
        }
        return this.parentController.getIndex() + 1;
    }

    private void initializeServiceStats() {
        LongNumericStatistic statistic = null;
        statistic = this.getMonitor().getLongNumericStatistic("", "TotalDeserializeTime");
        if (statistic == null) {
            statistic = new LongNumericStatistic("TotalDeserializeTime");
            this.getMonitor().addStatistic("", statistic);
        }
        if ((statistic = this.getMonitor().getLongNumericStatistic("", "TotalSerializeTime")) == null) {
            statistic = new LongNumericStatistic("TotalSerializeTime");
            this.getMonitor().addStatistic("", statistic);
        }
        if ((statistic = this.getMonitor().getLongNumericStatistic("", "IdleTime")) == null) {
            statistic = new LongNumericStatistic("IdleTime");
            this.getMonitor().addStatistic("", statistic);
        }
        if ((statistic = this.getMonitor().getLongNumericStatistic("", "ProcessCount")) == null) {
            statistic = new LongNumericStatistic("ProcessCount");
            this.getMonitor().addStatistic("", statistic);
        }
        if (this instanceof PrimitiveAnalysisEngineController) {
            statistic = this.getMonitor().getLongNumericStatistic("", "ProcessErrorCount");
            if (statistic == null) {
                statistic = new LongNumericStatistic("ProcessErrorCount");
                this.getMonitor().addStatistic("", statistic);
            }
            if ((statistic = this.getMonitor().getLongNumericStatistic("", "TotalProcessErrorCount")) == null) {
                statistic = new LongNumericStatistic("TotalProcessErrorCount");
                this.getMonitor().addStatistic("", statistic);
            }
            if ((statistic = this.getMonitor().getLongNumericStatistic("", "TotalAEProcessTime")) == null) {
                statistic = new LongNumericStatistic("TotalAEProcessTime");
                this.getMonitor().addStatistic("", statistic);
            }
        }
    }

    private void removeFromJmxServer(ObjectName anMBean) throws Exception {
        this.jmxManagement.unregisterMBean(anMBean);
    }

    @Override
    public String getJmxContext() {
        String si = "";
        if (serviceInstance > 1) {
            si = String.valueOf(serviceInstance);
        }
        if (this.isTopLevelComponent()) {
            if (this instanceof AggregateAnalysisEngineController) {
                return "p0=" + this.getComponentName() + si + " Components";
            }
            if (this instanceof PrimitiveAnalysisEngineController) {
                return "p0=" + this.getComponentName() + " Uima EE";
            }
        }
        int index = this.getIndex();
        String parentContext = this.parentController.getJmxContext();
        if (this.parentController.isTopLevelComponent()) {
            index = 1;
        }
        if (this instanceof AggregateAnalysisEngineController) {
            String thisComponentName = this.getComponentName();
            if (!this.isTopLevelComponent() && this.endpointName != null) {
                thisComponentName = ((AggregateAnalysisEngineController)this.parentController).lookUpDelegateKey(this.endpointName);
            }
            return parentContext + ",p" + index + "=" + thisComponentName + si + " Components";
        }
        return parentContext + ",p" + index + "=";
    }

    @Override
    public void addUimaObject(String objectName) throws Exception {
        this.jmxManagement.addObject(objectName);
    }

    protected void registerWithAgent(Object o, String aName) {
        block2: {
            try {
                ObjectName on = new ObjectName(aName);
                this.jmxManagement.registerMBean(o, on);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "registerWithAgent", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "registerWithAgent", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    @Override
    public void registerVmQueueWithJMX(Object o, String aName) throws Exception {
        String jmxName = this.getManagementInterface().getJmxDomain() + this.jmxContext + ",name=" + this.getComponentName() + "_" + aName;
        this.registerWithAgent(o, jmxName);
        if ("VmReplyQueue".equals(aName)) {
            this.getServiceInfo().setReplyQueueName(jmxName);
        } else {
            this.getServiceInfo().setInputQueueName(jmxName);
        }
    }

    protected void registerServiceWithJMX(String key_value_list, boolean remote) {
        String thisComponentName = this.getComponentName();
        String name = "";
        this.getIndex();
        this.servicePerformance = new ServicePerformance(this);
        name = this.jmxManagement.getJmxDomain() + key_value_list + ",name=" + thisComponentName + "_" + this.servicePerformance.getLabel();
        this.registerWithAgent(this.servicePerformance, name);
        this.servicePerformance.setIdleTime(System.nanoTime());
        ServiceInfo serviceInfo = null;
        if (remote) {
            serviceInfo = this.getInputChannel().getServiceInfo();
        } else {
            serviceInfo = new ServiceInfo(this.isCasMultiplier(), this);
            serviceInfo.setBrokerURL(this.getBrokerURL());
            serviceInfo.setInputQueueName(this.getName());
            if (!this.isTopLevelComponent()) {
                serviceInfo.setServiceKey(this.delegateKey);
                Delegate delegate = ((AggregateAnalysisEngineController)this.parentController).lookupDelegate(this.delegateKey);
                if (delegate != null) {
                    this.servicePerformance.setReplyThreadCount(delegate.getEndpoint().getConcurrentReplyConsumers());
                }
            }
        }
        ServiceInfo pServiceInfo = null;
        if (this instanceof PrimitiveAnalysisEngineController) {
            pServiceInfo = ((PrimitiveAnalysisEngineController)((Object)this)).getServiceInfo();
            this.servicePerformance.setProcessThreadCount(((PrimitiveAnalysisEngineController)((Object)this)).getServiceInfo().getAnalysisEngineInstanceCount());
        } else {
            pServiceInfo = ((AggregateAnalysisEngineController)((Object)this)).getServiceInfo();
            pServiceInfo.setAggregate(true);
        }
        if (pServiceInfo != null) {
            if (this.isCasMultiplier()) {
                pServiceInfo.setServiceKey(this.getUimaContextAdmin().getQualifiedContextName());
                pServiceInfo.setCmRegisteredName(this.getUimaContextAdmin().getUniqueName());
            }
            name = this.jmxManagement.getJmxDomain() + key_value_list + ",name=" + thisComponentName + "_" + serviceInfo.getLabel();
            if (!this.isTopLevelComponent()) {
                pServiceInfo.setBrokerURL("Embedded Broker");
            } else {
                pServiceInfo.setTopLevel();
            }
            if (this.isCasMultiplier()) {
                pServiceInfo.setCASMultiplier();
            }
            this.registerWithAgent(pServiceInfo, name);
        }
        this.serviceErrors = new ServiceErrors();
        name = this.jmxManagement.getJmxDomain() + key_value_list + ",name=" + thisComponentName + "_" + this.serviceErrors.getLabel();
        this.registerWithAgent(this.serviceErrors, name);
    }

    protected void cleanUp() throws Exception {
        if (this.inProcessCache != null && this.isTopLevelComponent()) {
            ObjectName on = new ObjectName(this.inProcessCache.getName());
            this.removeFromJmxServer(on);
        }
    }

    public void setJmxManagement(JmxManagement aJmxManagement) {
        this.jmxManagement = aJmxManagement;
    }

    private void initializeComponentCasPool(int aComponentCasPoolSize, long anInitialCasHeapSize, boolean disableJCasCache) {
        if (aComponentCasPoolSize > 0) {
            EECasManager_impl cm = (EECasManager_impl)this.getResourceManager().getCasManager();
            cm.setInitialCasHeapSize(anInitialCasHeapSize);
            cm.setPoolSize(this.getUimaContextAdmin().getUniqueName(), aComponentCasPoolSize);
            if (disableJCasCache) {
                cm.disableJCasCaching();
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initializeComponentCasPool", "uimaee_messages", "UIMAEE_cas_pool_config_INFO", new Object[]{this.getComponentName(), this.getUimaContextAdmin().getQualifiedContextName(), aComponentCasPoolSize, anInitialCasHeapSize / 4L, disableJCasCache});
            }
        }
    }

    @Override
    public boolean isTopLevelComponent() {
        return this.parentController == null;
    }

    private String setupName() {
        String serviceName = ((ResourceCreationSpecifier)this.resourceSpecifier).getMetaData().getName();
        if (serviceName == null || serviceName.trim().length() == 0) {
            if (this.isTopLevelComponent()) {
                if (this.isPrimitive()) {
                    String implementationName = ((ResourceCreationSpecifier)this.resourceSpecifier).getImplementationName();
                    if (implementationName.indexOf(".") > 0) {
                        implementationName = implementationName.substring(implementationName.lastIndexOf(".") + 1);
                    }
                    serviceName = implementationName;
                } else {
                    serviceName = "Top Level Aggregate Service";
                }
            } else {
                try {
                    UimaContext childContext = this.parentController.getChildUimaContext(this.endpointName);
                    serviceName = ((UimaContextAdmin)childContext).getQualifiedContextName();
                    if (serviceName != null && serviceName.startsWith("/")) {
                        serviceName = serviceName.substring(1);
                        if ((serviceName = serviceName.replaceAll("/", "_")).endsWith("_")) {
                            serviceName = serviceName.substring(0, serviceName.length() - 1);
                        }
                    }
                }
                catch (Exception e) {
                    serviceName = this.delegateKey;
                }
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "setupName", "uimaee_messages", "UIMAEE_using_generated_name_INFO", new Object[]{serviceName});
            }
        }
        return serviceName;
    }

    @Override
    public String getComponentName() {
        if (this.serviceName == null) {
            this.serviceName = this.setupName();
        }
        return this.serviceName;
    }

    public String toString() {
        return this.getComponentName();
    }

    @Override
    public void addServiceInfo(ServiceInfo aServiceInfo) {
        ServiceInfo sInfo = null;
        if (this instanceof PrimitiveAnalysisEngineController) {
            sInfo = ((PrimitiveAnalysisEngineController)((Object)this)).getServiceInfo();
        } else if (this instanceof AggregateAnalysisEngineController) {
            sInfo = ((AggregateAnalysisEngineController)((Object)this)).getServiceInfo();
        }
        if (sInfo != null) {
            sInfo.setBrokerURL(aServiceInfo.getBrokerURL());
            sInfo.setInputQueueName(aServiceInfo.getInputQueueName());
            sInfo.setState(aServiceInfo.getState());
            sInfo.setDeploymentDescriptorPath(this.aeDescriptor);
            if (this.isCasMultiplier()) {
                sInfo.setCASMultiplier();
            }
        }
    }

    @Override
    public ServicePerformance getServicePerformance() {
        return this.servicePerformance;
    }

    @Override
    public ServiceErrors getServiceErrors() {
        return this.serviceErrors;
    }

    @Override
    public UimaContext getChildUimaContext(String aDelegateEndpointName) throws Exception {
        if (this instanceof AggregateAnalysisEngineController) {
            AnalysisEngineDescription desc;
            SofaMapping[] sofaMappings;
            String key = ((AggregateAnalysisEngineController)((Object)this)).lookUpDelegateKey(aDelegateEndpointName);
            if (key == null && ((AggregateAnalysisEngineController)((Object)this)).isDelegateKeyValid(aDelegateEndpointName)) {
                key = aDelegateEndpointName;
            }
            if (key == null) {
                throw new AsynchAEException(this.getName() + "-Unable to look up delegate " + aDelegateEndpointName + " in internal map");
            }
            UimaContextAdmin uctx = this.getUimaContextAdmin();
            HashMap<String, String> sofamap = new HashMap<String, String>();
            if (this.resourceSpecifier instanceof AnalysisEngineDescription && (sofaMappings = (desc = (AnalysisEngineDescription)this.resourceSpecifier).getSofaMappings()) != null && sofaMappings.length > 0) {
                for (int s = 0; s < sofaMappings.length; ++s) {
                    if (!sofaMappings[s].getComponentKey().equals(key)) continue;
                    if (sofaMappings[s].getComponentSofaName() == null) {
                        sofaMappings[s].setComponentSofaName("_InitialView");
                    }
                    sofamap.put(sofaMappings[s].getComponentSofaName(), sofaMappings[s].getAggregateSofaName());
                }
            }
            return uctx.createChild(key, sofamap);
        }
        return null;
    }

    @Override
    public void setInputChannel(InputChannel anInputChannel) throws Exception {
        this.inputChannel = anInputChannel;
        this.inputChannelList.add(anInputChannel);
        this.inputChannelLatch.countDown();
        if (!this.registeredWithJMXServer) {
            this.registeredWithJMXServer = true;
            this.registerServiceWithJMX(this.jmxContext, false);
        }
    }

    @Override
    public void addInputChannel(InputChannel anInputChannel) {
        this.inputChannelLatch.countDown();
        if (!this.inputChannelMap.containsKey(anInputChannel.getInputQueueName())) {
            this.inputChannelMap.put(anInputChannel.getInputQueueName(), anInputChannel);
            if (!this.inputChannelList.contains(anInputChannel)) {
                this.inputChannelList.add(anInputChannel);
            }
        }
    }

    @Override
    public InputChannel getInputChannel() {
        try {
            this.inputChannelLatch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.inputChannel;
    }

    @Override
    public void dropCAS(CAS aCAS) {
        if (aCAS != null) {
            if (this.releasedAllCASes) {
                try {
                    aCAS.release();
                }
                catch (Exception exception) {}
            } else {
                aCAS.release();
            }
        }
    }

    @Override
    public synchronized void saveReplyTime(long snapshot, String aKey) {
        this.replyTime = snapshot;
    }

    @Override
    public synchronized long getReplyTime() {
        return this.replyTime;
    }

    protected void handleAction(String anAction, String anEndpoint, ErrorContext anErrorContext) throws Exception {
        String casReferenceId = null;
        if (anErrorContext != null) {
            casReferenceId = (String)anErrorContext.get("CasReference");
        }
        if ("Terminate".equalsIgnoreCase(anAction)) {
            UimaEEAdminContext ctx;
            String parentCasReferenceId = null;
            if (casReferenceId != null) {
                LocalCache.CasStateEntry stateEntry = null;
                try {
                    this.stopInputChannels(0, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Endpoint endpoint;
                    stateEntry = this.getLocalCache().lookupEntry(casReferenceId);
                    if (stateEntry != null && stateEntry.isSubordinate()) {
                        LocalCache.CasStateEntry topParentEntry = this.getLocalCache().getTopCasAncestor(casReferenceId);
                        parentCasReferenceId = topParentEntry.getCasReferenceId();
                    }
                    if (!this.isStopped() && (endpoint = (Endpoint)anErrorContext.get("Endpoint")) != null && !"WarmupDelegate".equals(endpoint.getDelegateKey())) {
                        this.getOutputChannel().sendReply((Throwable)anErrorContext.get("ThrowableError"), casReferenceId, parentCasReferenceId, endpoint, 2000);
                    }
                }
                catch (Exception endpoint) {
                    // empty catch block
                }
            }
            if ((ctx = this.getUimaEEAdminContext()) != null) {
                ctx.onTerminate("ExceededErrorThreshold", UimaASApplicationEvent.EventTrigger.ExceededErrorThreshold);
            }
            if (System.getProperty("dontKill") == null) {
                // empty if block
            }
            if (anErrorContext != null && anErrorContext.containsKey("ThrowableError") && anErrorContext.containsKey("CasReference")) {
                this.terminate((Throwable)anErrorContext.get("ThrowableError"), (String)anErrorContext.get("CasReference"));
            } else {
                this.terminate();
            }
            if (System.getProperty("dontKill") == null) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleAction", "uimaee_messages", "UIMAEE_killing_process__INFO", new Object[]{this.getComponentName()});
                System.exit(0);
            }
        } else if ("Disable".equalsIgnoreCase(anAction)) {
            if (anEndpoint != null) {
                Endpoint endpoint = null;
                ArrayList<String> list = new ArrayList<String>();
                String key = "";
                endpoint = ((AggregateAnalysisEngineController)((Object)this)).lookUpEndpoint(anEndpoint, false);
                if (endpoint == null) {
                    key = ((AggregateAnalysisEngineController)((Object)this)).lookUpDelegateKey(anEndpoint);
                    endpoint = ((AggregateAnalysisEngineController)((Object)this)).lookUpEndpoint(key, false);
                    list.add(key);
                } else {
                    key = anEndpoint;
                    list.add(anEndpoint);
                }
                ((AggregateAnalysisEngineController_impl)this).disableDelegates(list, casReferenceId);
                if (key != null && key.trim().length() > 0) {
                    Delegate delegate = ((AggregateAnalysisEngineController)((Object)this)).lookupDelegate(key);
                    delegate.cancelDelegateTimer();
                    if (!anErrorContext.containsKey("SkipPendingLists")) {
                        this.forceTimeoutOnPendingCases(key);
                    }
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleAction", "uimaee_messages", "UIMAEE_disabled_delegate_INFO", new Object[]{this.getComponentName(), key});
                }
            }
        } else if ("Continue".equalsIgnoreCase(anAction)) {
            if (anEndpoint != null) {
                Exception ex;
                boolean continueOnError;
                String key = anEndpoint;
                if (((AggregateAnalysisEngineController)((Object)this)).lookupDelegate(key) == null) {
                    key = ((AggregateAnalysisEngineController)((Object)this)).lookUpDelegateKey(anEndpoint);
                }
                if (continueOnError = ((AggregateAnalysisEngineController)((Object)this)).continueOnError(casReferenceId, key, ex = (Exception)anErrorContext.get("ThrowableError"))) {
                    InProcessCache.CacheEntry entry;
                    block32: {
                        entry = null;
                        try {
                            entry = this.getInProcessCache().getCacheEntryForCAS(casReferenceId);
                        }
                        catch (AsynchAEException e) {
                            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) break block32;
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleAction", "uimaee_messages", "UIMAEE_parent_cas_notin_cache__INFO", new Object[]{this.getComponentName(), casReferenceId});
                        }
                    }
                    CAS cas = null;
                    if (entry != null && (cas = entry.getCas()) != null) {
                        anErrorContext.add("ErrorHandled", true);
                        ((AggregateAnalysisEngineController)((Object)this)).process(cas, casReferenceId);
                    }
                }
            }
        } else if ("DropCas".equalsIgnoreCase(anAction) && casReferenceId != null) {
            this.dropCAS(casReferenceId, true);
        }
    }

    @Override
    public void forceTimeoutOnPendingCases(String key) {
        ErrorContext errorContext;
        String timedOutCasId;
        Delegate delegate = ((AggregateAnalysisEngineController)((Object)this)).lookupDelegate(key);
        delegate.cancelDelegateTimer();
        Endpoint endpoint = delegate.getEndpoint();
        while (delegate.getCasPendingReplyListSize() > 0) {
            timedOutCasId = delegate.removeOldestCasFromOutstandingList();
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleAction", "uimaee_messages", "UIMAEE_force_cas_timeout__INFO", new Object[]{this.getComponentName(), key, timedOutCasId, " Pending Reply List"});
            }
            errorContext = new ErrorContext();
            errorContext.add("Command", 2000);
            errorContext.add("CasReference", timedOutCasId);
            errorContext.add("Endpoint", endpoint);
            this.getErrorHandlerChain().handle(new ForcedMessageTimeoutException(), errorContext, this);
        }
        while (delegate.getCasPendingDispatchListSize() > 0) {
            timedOutCasId = delegate.removeOldestFromPendingDispatchList();
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleAction", "uimaee_messages", "UIMAEE_force_cas_timeout__INFO", new Object[]{this.getComponentName(), key, timedOutCasId, " Pending Dispatch List"});
            }
            errorContext = new ErrorContext();
            errorContext.add("Command", 2000);
            errorContext.add("CasReference", timedOutCasId);
            errorContext.add("Endpoint", endpoint);
            this.getErrorHandlerChain().handle(new ForcedMessageTimeoutException(), errorContext, this);
        }
    }

    protected void plugInDefaultErrorHandlerChain() {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "plugInDefaultErrorHandlerChain", "uimaee_messages", "UIMAEE_add_default_eh__CONFIG", new Object[]{this.getComponentName()});
        }
        ArrayList<ProcessCasErrorHandler> errorHandlerList = new ArrayList<ProcessCasErrorHandler>();
        errorHandlerList.add(new ProcessCasErrorHandler());
        this.errorHandlerChain = new ErrorHandlerChain(errorHandlerList);
    }

    public void setErrorHandlerChain(ErrorHandlerChain errorHandlerChain) {
        this.errorHandlerChain = errorHandlerChain;
    }

    @Override
    public ErrorHandlerChain getErrorHandlerChain() {
        return this.errorHandlerChain;
    }

    public void handleError(HashMap aMap, Throwable e) {
        ErrorContext errorContext = new ErrorContext();
        errorContext.add(aMap);
        this.getErrorHandlerChain().handle(e, errorContext, this);
    }

    @Override
    public void dropCAS(String aCasReferenceId, boolean deleteCacheEntry) {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "dropCAS", "uimaee_messages", "UIMAEE_dropping_cas__FINE", new Object[]{aCasReferenceId, this.getComponentName()});
        }
        InProcessCache.CacheEntry entry = null;
        if (this.inProcessCache.entryExists(aCasReferenceId)) {
            try {
                entry = this.inProcessCache.getCacheEntryForCAS(aCasReferenceId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entry != null) {
            CAS cas = this.inProcessCache.getCasByReference(aCasReferenceId);
            if (deleteCacheEntry) {
                Semaphore semaphore = null;
                if (!this.isPrimitive() && (semaphore = entry.getThreadCompletionSemaphore()) != null) {
                    semaphore.release();
                }
                this.inProcessCache.remove(aCasReferenceId);
                if (this.localCache.containsKey(aCasReferenceId)) {
                    block17: {
                        try {
                            this.localCache.lookupEntry(aCasReferenceId).setDropped(true);
                        }
                        catch (Exception e) {
                            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) break block17;
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "dropCAS", "uimaee_messages", "UIMAEE_parent_cas_notin_cache__INFO", new Object[]{this.getComponentName(), aCasReferenceId});
                        }
                    }
                    this.localCache.remove(aCasReferenceId);
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "dropCAS", "uimaee_messages", "UIMAEE_removed_cache_entry__FINE", new Object[]{aCasReferenceId, this.getComponentName()});
                }
            }
            if (cas != null) {
                int casHashCode = cas.hashCode();
                if (entry == null || entry.releaseCAS()) {
                    this.dropCAS(cas);
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "dropCAS", "uimaee_messages", "UIMAEE_released_cas__FINE", new Object[]{aCasReferenceId, this.getComponentName(), casHashCode});
                }
            } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "dropCAS", "uimaee_messages", "UIMAEE_unable_to_release_cas__WARNING", new Object[]{aCasReferenceId, this.getComponentName()});
            }
            this.inProcessCache.dumpContents(this.getComponentName());
        }
        if (this.perCasStatistics.containsKey(aCasReferenceId)) {
            this.perCasStatistics.remove(aCasReferenceId);
        }
    }

    @Override
    public synchronized void saveTime(long aTime, String aCasReferenceId, String anEndpointName) {
        String key = aCasReferenceId + anEndpointName;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "saveTime", "uimaee_messages", "UIMAEE_save_time__FINE", new Object[]{aTime, aCasReferenceId, this.getComponentName(), anEndpointName, key});
        }
        this.statsMap.put(key, aTime);
    }

    @Override
    public long getTime(String aCasReferenceId, String anEndpointName) {
        String key = aCasReferenceId + anEndpointName;
        if (this.statsMap.containsKey(key)) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getTime", "uimaee_messages", "UIMAEE_get_time__FINE", new Object[]{aCasReferenceId, this.getComponentName(), anEndpointName, key});
            }
            long time = 0L;
            Long value = this.statsMap.get(key);
            if (value != null) {
                time = value;
            }
            this.statsMap.remove(key);
            return time;
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getTime", "uimaee_messages", "UIMAEE_time_not_found__FINE", new Object[]{aCasReferenceId, this.getName(), anEndpointName, key});
        }
        return 0L;
    }

    protected void resetErrorCounter() {
        this.errorCount = 0L;
    }

    protected void incrementErrorCounter() {
        ++this.errorCount;
    }

    protected boolean exceedsThresholdWithinWindow(int threshold, long docCount, int windowSize) {
        if (this.errorCount > 0L && this.errorCount % (long)threshold == 0L) {
            return true;
        }
        if (docCount % (long)windowSize == 0L) {
            this.resetErrorCounter();
        }
        return false;
    }

    @Override
    public OutputChannel getOutputChannel() {
        return this.outputChannel;
    }

    @Override
    public void setOutputChannel(OutputChannel outputChannel) throws Exception {
        this.outputChannel = outputChannel;
    }

    @Override
    public AsynchAECasManager getCasManagerWrapper() {
        return this.casManager;
    }

    @Override
    public void setCasManager(AsynchAECasManager casManager) {
        this.casManager = casManager;
    }

    @Override
    public InProcessCache getInProcessCache() {
        return this.inProcessCache;
    }

    protected ResourceSpecifier getResourceSpecifier() {
        return this.resourceSpecifier;
    }

    @Override
    public String getName() {
        return this.endpointName;
    }

    @Override
    public String getKey() {
        return this.delegateKey;
    }

    @Override
    public void process(CAS aCas, String aCasId) {
    }

    @Override
    public void process(CAS aCAS, String anInputCasReferenceId, String aNewCasReferenceId, String newCASProducedBy) {
    }

    @Override
    public void process(CAS aCAS, String aCasReferenceId, Endpoint anEndpoint) {
    }

    @Override
    public void setUimaEEAdminContext(UimaEEAdminContext anAdminContext) {
        this.adminContext = anAdminContext;
    }

    @Override
    public UimaEEAdminContext getUimaEEAdminContext() {
        return this.adminContext;
    }

    private void dropStats(String aKey) {
        if (aKey != null && this.statsMap.containsKey(aKey)) {
            this.statsMap.remove(aKey);
        }
    }

    @Override
    public void dropStats(String aCasReferenceId, String anEndpointName) {
        String key = aCasReferenceId + anEndpointName;
        this.dropStats(key);
        if (this instanceof AggregateAnalysisEngineController) {
            Set set = ((AggregateAnalysisEngineController)((Object)this)).getDestinations().entrySet();
            for (Map.Entry entry : set) {
                key = aCasReferenceId + ((Endpoint)entry.getValue()).getEndpoint();
                this.dropStats(key);
            }
        }
        this.dropCasStatistics(aCasReferenceId);
    }

    protected void logStats() {
        if (this instanceof AggregateAnalysisEngineController) {
            Map delegates = ((AggregateAnalysisEngineController)((Object)this)).getDestinations();
            Set set = delegates.entrySet();
            for (Map.Entry entry : set) {
                Endpoint endpoint = (Endpoint)entry.getValue();
                if (endpoint == null) continue;
                ServicePerformance delegatePerformanceStats = ((AggregateAnalysisEngineController)((Object)this)).getDelegateServicePerformance((String)entry.getKey());
                this.logStats((String)entry.getKey(), delegatePerformanceStats);
            }
        }
        this.logStats(this.getComponentName(), this.servicePerformance);
    }

    @Override
    public ServicePerformance getCasStatistics(String aCasReferenceId) {
        ServicePerformance casStats = null;
        if (this.perCasStatistics.containsKey(aCasReferenceId)) {
            casStats = (ServicePerformance)this.perCasStatistics.get(aCasReferenceId);
        } else {
            casStats = new ServicePerformance(this);
            this.perCasStatistics.put(aCasReferenceId, casStats);
        }
        return casStats;
    }

    protected void logStats(String aDelegateKey, ServicePerformance aServicePerformance) {
        if (aServicePerformance != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "logStats", "uimaee_messages", "UIMAEE_dump_primitive_stats__INFO", new Object[]{this.getComponentName(), aDelegateKey, aServicePerformance.getNumberOfCASesProcessed(), aServicePerformance.getCasDeserializationTime(), aServicePerformance.getCasSerializationTime(), aServicePerformance.getAnalysisTime(), aServicePerformance.getMaxSerializationTime(), aServicePerformance.getMaxDeserializationTime(), aServicePerformance.getMaxAnalysisTime(), aServicePerformance.getIdleTime()});
        }
    }

    protected void clearStats() {
        Statistics stats = this.getMonitor().getStatistics("");
        Set set = stats.entrySet();
        for (Map.Entry entry : set) {
            if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof LongNumericStatistic)) continue;
            ((LongNumericStatistic)entry.getValue()).reset();
        }
        this.perCasStatistics.clear();
    }

    @Override
    public Map getStats() {
        float totalIdleTime = 0.0f;
        long numberCASesProcessed = 0L;
        float totalDeserializeTime = 0.0f;
        float totalSerializeTime = 0.0f;
        HashMap<String, Number> map = new HashMap<String, Number>();
        LongNumericStatistic statistic = this.getMonitor().getLongNumericStatistic("", "IdleTime");
        if (statistic != null && statistic.getValue() > 0L) {
            totalIdleTime = (float)statistic.getValue() / 1000000.0f;
        }
        map.put("IdleTime", Float.valueOf(totalIdleTime));
        statistic = this.getMonitor().getLongNumericStatistic("", "ProcessCount");
        if (statistic != null) {
            numberCASesProcessed = statistic.getValue();
        }
        map.put("ProcessCount", numberCASesProcessed);
        statistic = this.getMonitor().getLongNumericStatistic("", "TotalDeserializeTime");
        if (statistic != null && statistic.getValue() > 0L) {
            totalDeserializeTime = (float)statistic.getValue() / 1000000.0f;
        }
        map.put("TotalDeserializeTime", Float.valueOf(totalDeserializeTime));
        statistic = this.getMonitor().getLongNumericStatistic("", "TotalSerializeTime");
        if (statistic != null && statistic.getValue() > 0L) {
            totalSerializeTime = (float)statistic.getValue() / 1000000.0f;
        }
        map.put("TotalSerializeTime", Float.valueOf(totalSerializeTime));
        if (this instanceof PrimitiveAnalysisEngineController) {
            float totalAEProcessTime = 0.0f;
            statistic = this.getMonitor().getLongNumericStatistic("", "TotalAEProcessTime");
            if (statistic != null && statistic.getValue() > 0L) {
                totalAEProcessTime = (float)statistic.getValue() / 1000000.0f;
            }
            map.put("TotalAEProcessTime", Float.valueOf(totalAEProcessTime));
        }
        return map;
    }

    @Override
    public void setDeployDescriptor(String aDeployDescriptor) {
        this.deploymentDescriptor = aDeployDescriptor;
        ServiceInfo serviceInfo = null;
        serviceInfo = this instanceof PrimitiveAnalysisEngineController ? ((PrimitiveAnalysisEngineController)((Object)this)).getServiceInfo() : ((AggregateAnalysisEngineController)((Object)this)).getServiceInfo();
        if (serviceInfo != null) {
            serviceInfo.setDeploymentDescriptorPath(this.aeDescriptor);
        }
    }

    public String getServiceName() {
        return this.getInputChannel().getName();
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getDeploymentMode() {
        return this.isTopLevelComponent() ? "remote" : "collocated";
    }

    public String getBrokerURL() {
        while (System.getProperty("BrokerURI") == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return System.getProperty("BrokerURI");
    }

    public String getInputQueue() {
        return this.getInputChannel().getInputQueueName();
    }

    public long getTotalTimeSpentSerializingCAS() {
        return 0L;
    }

    public long getTotalTimeSpendDeSerializingCAS() {
        return 0L;
    }

    public long getTotalTimeSpentWaitingForFreeCASInstance() {
        return 0L;
    }

    public long getTotalNumberOfCASesReceived() {
        return 0L;
    }

    public long getTotalNumberOfCASesProcessed() {
        return 0L;
    }

    public long getTotalNumberOfCASesDropped() {
        return 0L;
    }

    public long getTotalNumberOfErrors() {
        return 0L;
    }

    @Override
    public Endpoint getClientEndpoint() {
        return this.clientEndpoint;
    }

    @Override
    public void cacheClientEndpoint(Endpoint anEndpoint) {
        this.clientEndpoint = anEndpoint;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void setStopped() {
        this.stopped = true;
    }

    protected void stopTransportLayer() {
        if (this.transports.size() > 0) {
            Set<Map.Entry<String, UimaTransport>> set = this.transports.entrySet();
            for (Map.Entry<String, UimaTransport> entry : set) {
                UimaTransport transport = entry.getValue();
                try {
                    transport.stopIt();
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopTransportLayer", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "stopTransportLayer", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }
    }

    public void stop(boolean shutdownNow) {
        this.stop(null, null, shutdownNow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Throwable cause, String aCasReferenceId, boolean shutdownNow) {
        EECasManager_impl cm;
        block45: {
            if (!this.isStopped()) {
                this.setStopped();
            }
            try {
                this.jmxManagement.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cause != null && aCasReferenceId != null && this.getOutputChannel() != null && this.isTopLevelComponent()) {
                Endpoint clientEndpoint = null;
                clientEndpoint = this.getClientEndpoint();
                if (clientEndpoint != null) {
                    try {
                        this.getOutputChannel().sendReply(cause, aCasReferenceId, null, clientEndpoint, clientEndpoint.getCommand());
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block45;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stop", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stop", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                    }
                }
            }
        }
        if (this.daemonServiceExecutor != null) {
            this.daemonServiceExecutor.shutdown();
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "stop", "uimaee_messages", "UIMAEE_stop__INFO", new Object[]{this.getComponentName()});
        }
        if (this.getOutputChannel() != null) {
            this.getOutputChannel().cancelTimers();
        }
        if (this instanceof PrimitiveAnalysisEngineController) {
            this.getControllerLatch().release();
            this.stopInputChannels(0, shutdownNow);
        } else {
            List colocatedControllerList;
            ((AggregateAnalysisEngineController_impl)this).stopTimers();
            this.stopInputChannels(0, shutdownNow);
            List e = colocatedControllerList = ((AggregateAnalysisEngineController_impl)this).getChildControllerList();
            synchronized (e) {
                if (colocatedControllerList.size() > 0) {
                    for (AnalysisEngineController childController : colocatedControllerList) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "stop", "uimaee_messages", "UIMAEE_stop_delegate__INFO", new Object[]{this.getComponentName(), childController.getComponentName()});
                        }
                        childController.stop();
                        childController.getControllerLatch().release();
                    }
                }
            }
        }
        this.stopTransportLayer();
        for (Map.Entry entry : this.getLocalCache().entrySet()) {
            LocalCache.CasStateEntry casStateEntry = (LocalCache.CasStateEntry)entry.getValue();
            if (!casStateEntry.isSubordinate()) continue;
            try {
                this.getInProcessCache().getCacheEntryForCAS(casStateEntry.getCasReferenceId()).getCas().release();
            }
            catch (Exception exception) {}
        }
        this.getInProcessCache().releaseAllCASes();
        this.getLocalCache().clear();
        this.releasedAllCASes = true;
        if (!this.isTopLevelComponent()) {
            this.adminContext = null;
        } else {
            this.getOutputChannel().stop();
            try {
                this.getInProcessCache().destroy();
            }
            catch (Exception it) {
                // empty catch block
            }
        }
        if (this instanceof AggregateAnalysisEngineController_impl) {
            ((AggregateAnalysisEngineController_impl)this).cleanUp();
            if (!((AggregateAnalysisEngineController_impl)this).initialized) {
                this.notifyListenersWithInitializationStatus((Exception)((Object)new ResourceInitializationException()));
            }
        }
        if (this.statsMap != null) {
            this.statsMap.clear();
        }
        if (this.inputChannelList != null) {
            this.inputChannelList.clear();
        }
        if (this.serviceErrorMap != null) {
            this.serviceErrorMap.clear();
        }
        if (this.unregisteredDelegateList != null) {
            this.unregisteredDelegateList.clear();
        }
        if (this.casManager != null) {
            if (this.casManager instanceof EECasManager_impl) {
                try {
                    ((EECasManager_impl)((Object)this.casManager)).destroy();
                }
                catch (Throwable it) {}
            } else if (this.casManager instanceof AsynchAECasManager_impl) {
                ((AsynchAECasManager_impl)this.casManager).destroy();
            }
            this.casManager = null;
        }
        if (this.transports != null) {
            this.transports.clear();
        }
        if (this.threadStateMap != null) {
            this.threadStateMap.clear();
        }
        if (this.inputChannelMap != null) {
            this.inputChannelMap.clear();
        }
        if (this.controllerListeners != null) {
            this.controllerListeners.clear();
        }
        if (this.perCasStatistics != null) {
            this.perCasStatistics.clear();
        }
        if (this.cmOutstandingCASes != null) {
            this.cmOutstandingCASes.clear();
        }
        if (this.messageListeners != null) {
            this.messageListeners.clear();
        }
        if ((cm = (EECasManager_impl)this.getResourceManager().getCasManager()) != null) {
            cm.cleanUp();
        }
        super.destroy();
    }

    public void notifyOnCacheEmpty() {
        this.quiesceSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quiesceAndStop() {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "quiesceAndStop", "uimaee_messages", "UIMAEE_stop__INFO", new Object[]{this.getComponentName()});
        }
        System.out.println("Quiescing UIMA-AS Service. Remaining Number of CASes to Process:" + this.getInProcessCache().getSize());
        this.getInProcessCache().registerController(this);
        if (!this.isStopped() && !this.callbackReceived) {
            this.getControllerLatch().release();
            if (this.isTopLevelComponent()) {
                this.getInputChannel().setTerminating();
                this.stopReceivingCASes(false);
                if (this instanceof PrimitiveAnalysisEngineController_impl && ((PrimitiveAnalysisEngineController_impl)this).aeInstancePool != null) {
                    try {
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait(2000L);
                        }
                        ((PrimitiveAnalysisEngineController_impl)this).aeInstancePool.destroy();
                    }
                    catch (Exception e) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "quiesceAndStop", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                    }
                }
                this.stopInputChannels(1, true);
                try {
                    if (!this.getInProcessCache().isEmpty()) {
                        this.quiesceSemaphore.acquire();
                    }
                    this.stopReceivingCASes(true);
                    this.stopInputChannels(1, true);
                    System.out.println("UIMA-AS Service is Stopping, All CASes Have Been Processed");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.stop(true);
            }
        }
    }

    protected void stopDelegateTimers() {
        Iterator<Delegate> it = this.delegates.iterator();
        while (it.hasNext()) {
            it.next().cancelDelegateTimer();
        }
    }

    @Override
    public void terminate() {
        this.terminate(null, null);
    }

    public void terminate(Throwable cause, String aCasReferenceId) {
        if (this.stopLatch.getCount() > 0L) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "terminate", "uimaee_messages", "UIMAEE_process_termiate_event__INFO", new Object[]{this.getComponentName()});
            }
        } else {
            return;
        }
        this.stopLatch.countDown();
        if (!this.isTopLevelComponent()) {
            ((BaseAnalysisEngineController)this.parentController).stop();
        } else if (!this.isStopped()) {
            this.stopDelegateTimers();
            this.getOutputChannel().cancelTimers();
            InputChannel iC = this.getInputChannel(this.endpointName);
            if (iC != null) {
                iC.setTerminating();
            }
            this.stopInputChannel(true);
            if (iC != null) {
                iC.terminate();
            }
            this.stopCasMultipliers();
            this.stopTransportLayer();
            if (cause != null && aCasReferenceId != null) {
                this.stop(cause, aCasReferenceId, true);
            } else {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnalysisEngineController lookupDelegateController(String aName) {
        List colocatedControllerList;
        List list = colocatedControllerList = ((AggregateAnalysisEngineController_impl)this).getChildControllerList();
        synchronized (list) {
            if (colocatedControllerList.size() > 0) {
                for (AnalysisEngineController childController : colocatedControllerList) {
                    if (!childController.getName().equals(aName)) continue;
                    return childController;
                }
            }
        }
        return null;
    }

    public void stopCasMultipliers() {
        if (this instanceof AggregateAnalysisEngineController) {
            Map endpoints = ((AggregateAnalysisEngineController)((Object)this)).getDestinations();
            Set set = endpoints.entrySet();
            for (Map.Entry entry : set) {
                String[] pendingReplyCasIds;
                Delegate delegate;
                Endpoint endpoint = (Endpoint)entry.getValue();
                if (endpoint == null || !endpoint.isCasMultiplier() || (delegate = ((AggregateAnalysisEngineController)((Object)this)).lookupDelegate((String)entry.getKey())) == null || (pendingReplyCasIds = delegate.getDelegateCasIdsPendingReply()) == null || pendingReplyCasIds.length <= 0) continue;
                for (String casReferenceId : pendingReplyCasIds) {
                    if (endpoint.isRemote()) {
                        this.stopCasMultiplier(delegate, casReferenceId);
                        continue;
                    }
                    AnalysisEngineController delegateCasMultiplier = this.lookupDelegateController(endpoint.getEndpoint());
                    delegateCasMultiplier.addAbortedCasReferenceId(casReferenceId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCasMultiplier(Delegate casMultiplier, String aCasReferenceId) {
        LocalCache.CasStateEntry casEntry = this.getLocalCache().lookupEntry(aCasReferenceId);
        if (casEntry != null) {
            try {
                if (casMultiplier != null) {
                    if (casMultiplier.getEndpoint().isRemote()) {
                        Endpoint freeCasNotificationEndpoint = casEntry.getFreeCasNotificationEndpoint();
                        if (freeCasNotificationEndpoint != null) {
                            freeCasNotificationEndpoint.setCommand(2006);
                            this.getOutputChannel().sendRequest(2006, aCasReferenceId, freeCasNotificationEndpoint);
                        }
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "stopCasMultiplier", "uimaee_messages", "UIMAEE_stopping_remote_cm_INFO", new Object[]{this.getComponentName(), casMultiplier.getComponentName(), aCasReferenceId});
                        }
                    } else {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "stopCasMultiplier", "uimaee_messages", "UIMAEE_stopping_collocated_cm_INFO", new Object[]{this.getComponentName(), casMultiplier.getComponentName(), aCasReferenceId});
                        }
                        AnalysisEngineController cm = this.getCasMultiplierController(casMultiplier.getKey());
                        cm.addAbortedCasReferenceId(aCasReferenceId);
                    }
                }
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopCasMultiplier", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "stopCasMultiplier", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
            finally {
                if (casMultiplier != null) {
                    casMultiplier.setGeneratingChildrenFrom(aCasReferenceId, false);
                }
            }
        }
    }

    protected void stopInputChannel(boolean shutdownNow) {
        block3: {
            InputChannel iC = this.getInputChannel(this.endpointName);
            if (iC != null && !iC.isStopped()) {
                try {
                    iC.stop(shutdownNow);
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) break block3;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "terminate", "uimaee_messages", "UIMAEE_unable_to_stop_inputchannel__INFO", new Object[]{this.getComponentName(), this.endpointName});
                }
            }
        }
    }

    private void setInputChannelForNoRecovery() {
        if (this.inputChannelMap.size() > 0) {
            InputChannel iC = this.getInputChannel();
            iC.setTerminating();
        }
    }

    protected void stopReceivingCASes(boolean stopAllListeners) {
        InputChannel iC = null;
        this.setInputChannelForNoRecovery();
        Iterator it = ((ConcurrentHashMap.KeySetView)this.inputChannelMap.keySet()).iterator();
        while (it.hasNext()) {
            try {
                String key = (String)it.next();
                if (key == null || key.trim().length() <= 0 || (iC = this.inputChannelMap.get(key)) == null) continue;
                if (stopAllListeners) {
                    iC.disconnectListenersFromQueue();
                    continue;
                }
                if (iC.getInputQueueName() == null || iC.getInputQueueName().startsWith("temp-queue")) continue;
                iC.disconnectListenersFromQueue();
            }
            catch (Exception e) {
                if (iC != null) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "stopReceivingCASes", "uimaee_messages", "UIMAEE_unable_to_stop_inputchannel__INFO", new Object[]{this.getComponentName(), iC.getInputQueueName()});
                    continue;
                }
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopReceivingCASes", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "stopReceivingCASes", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    protected void stopInputChannels(int channelsToStop, boolean shutdownNow) {
        InputChannel iC = null;
        this.setInputChannelForNoRecovery();
        Iterator it = ((ConcurrentHashMap.KeySetView)this.inputChannelMap.keySet()).iterator();
        int i = 1;
        while (it.hasNext()) {
            try {
                String key = (String)it.next();
                if (key != null && key.trim().length() > 0 && (iC = this.inputChannelMap.get(key)) != null) {
                    if (channelsToStop == 1 && iC.getServiceInfo() != null && iC.getServiceInfo().getInputQueueName().startsWith("top_level_input_queue")) {
                        iC.stop(channelsToStop, shutdownNow);
                        return;
                    }
                    iC.stop(channelsToStop, shutdownNow);
                }
                ++i;
            }
            catch (Exception e) {
                if (iC != null) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "stopInputChannels", "uimaee_messages", "UIMAEE_unable_to_stop_inputchannel__INFO", new Object[]{this.getComponentName(), iC.getInputQueueName()});
                    continue;
                }
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stopInputChannels", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "stopInputChannels", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisEngineController getCasMultiplierController(String cmKey) {
        List colocatedControllerList;
        List list = colocatedControllerList = ((AggregateAnalysisEngineController_impl)this).getChildControllerList();
        synchronized (list) {
            if (colocatedControllerList.size() > 0) {
                for (AnalysisEngineController childController : colocatedControllerList) {
                    if (!childController.isCasMultiplier() || !((BaseAnalysisEngineController)childController).delegateKey.equals(cmKey)) continue;
                    return childController;
                }
            }
        }
        return null;
    }

    @Override
    public InputChannel getInputChannel(String anEndpointName) {
        for (int i = 0; this.inputChannelList != null && i < this.inputChannelList.size(); ++i) {
            InputChannel iC = this.inputChannelList.get(i);
            if (iC == null || !iC.isListenerForDestination(anEndpointName)) continue;
            return this.inputChannelList.get(i);
        }
        return null;
    }

    @Override
    public InputChannel getReplyInputChannel(String aDestination) {
        InputChannel IC = null;
        if (this.inputChannelMap.containsKey(aDestination)) {
            return this.inputChannelMap.get(aDestination);
        }
        return IC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCacheEmpty() {
        this.callbackReceived = true;
        if (!this.stopped) {
            this.quiesceAndStop();
        }
        this.getInProcessCache().cancelTimers();
        Object object = this.callbackMonitor;
        synchronized (object) {
            try {
                this.callbackMonitor.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public EventSubscriber getEventListener() {
        return this;
    }

    @Override
    public void addControllerCallbackListener(ControllerCallbackListener aListener) {
        if (!this.controllerListeners.contains(aListener)) {
            this.controllerListeners.add(aListener);
        }
        if (this.initException != null) {
            this.notifyListenersWithInitializationStatus(this.initException);
        } else if (this.serviceInitialized) {
            this.notifyListenersWithInitializationStatus(null);
        }
    }

    @Override
    public void removeControllerCallbackListener(ControllerCallbackListener aListener) {
        this.controllerListeners.remove(aListener);
    }

    @Override
    public void notifyListenersWithInitializationStatus(Exception e) {
        this.initException = e;
        if (this.controllerListeners.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.controllerListeners.size(); ++i) {
            if (e != null) {
                ((ControllerCallbackListener)this.controllerListeners.get(i)).notifyOnInitializationFailure(this, e);
                continue;
            }
            if (!this.isTopLevelComponent()) continue;
            InputChannel ic = this.getInputChannel();
            try {
                ic.createListenerForTargetedMessages();
                ((ControllerCallbackListener)this.controllerListeners.get(i)).notifyOnInitializationSuccess(this);
                continue;
            }
            catch (Exception ex) {
                ((ControllerCallbackListener)this.controllerListeners.get(i)).notifyOnInitializationFailure(this, ex);
            }
        }
    }

    protected void dropCasStatistics(String aCasReferenceId) {
        if (this.perCasStatistics.containsKey(aCasReferenceId)) {
            this.perCasStatistics.remove(aCasReferenceId);
        }
    }

    @Override
    public boolean isCasMultiplier() {
        return this.casMultiplier;
    }

    @Override
    public void releaseNextCas(String casReferenceId) {
        block4: {
            if (this.cmOutstandingCASes.size() > 0 && this.cmOutstandingCASes.containsKey(casReferenceId) && this.getInProcessCache().entryExists(casReferenceId)) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "releaseNextCas", "uimaee_messages", "UIMAEE_release_cas_req__FINE", new Object[]{this.getComponentName(), casReferenceId});
                }
                try {
                    this.dropCAS(casReferenceId, true);
                    this.cmOutstandingCASes.remove(casReferenceId);
                    this.getInProcessCache().dumpContents(this.getComponentName());
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseNextCas", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseNextCas", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }
    }

    private boolean validMessageForSnapshot(int msgType) {
        return 2000 == msgType || 2002 == msgType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginProcess(int msgType) {
        if (this.validMessageForSnapshot(msgType)) {
            Object object = this.mux;
            synchronized (object) {
                AnalysisThreadState threadState = null;
                if (this.threadStateMap.containsKey(Thread.currentThread().getId())) {
                    threadState = this.threadStateMap.get(Thread.currentThread().getId());
                    if (threadState.isIdle) {
                        threadState.setIdle(false);
                        threadState.incrementIdleTime(System.nanoTime() - threadState.getLastUpdate());
                        threadState.computeIdleTimeBetweenProcessCalls();
                    }
                } else {
                    this.threadStateMap.put(Thread.currentThread().getId(), new AnalysisThreadState(Thread.currentThread().getId()));
                    threadState = this.threadStateMap.get(Thread.currentThread().getId());
                    threadState.setIdle(false);
                    threadState.incrementIdleTime(System.nanoTime() - this.startTime);
                    threadState.setLastMessageDispatchTime(this.startTime);
                    threadState.computeIdleTimeBetweenProcessCalls();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endProcess(int msgType) {
        if (this.validMessageForSnapshot(msgType)) {
            Object object = this.mux;
            synchronized (object) {
                AnalysisThreadState threadState = this.getThreadState();
                if (threadState != null) {
                    threadState.setLastUpdate(System.nanoTime());
                    threadState.setIdle(true);
                    threadState.setLastMessageDispatchTime();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getIdleTimeBetweenProcessCalls(int msgType) {
        if (this.validMessageForSnapshot(msgType)) {
            Object object = this.mux;
            synchronized (object) {
                AnalysisThreadState threadState = this.getThreadState();
                if (threadState != null) {
                    return threadState.getIdleTimeBetweenProcessCalls();
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getIdleTime() {
        Object object = this.mux;
        synchronized (object) {
            long now = System.nanoTime();
            long serviceIdleTime = 0L;
            Set<Long> set = this.threadStateMap.keySet();
            int howManyThreads = this.threadStateMap.size();
            for (Long key : set) {
                AnalysisThreadState threadState = this.threadStateMap.get(key);
                serviceIdleTime += threadState.getIdleTime();
                if (!threadState.isIdle()) continue;
                long delta = now - threadState.getLastUpdate();
                threadState.setLastUpdate(System.nanoTime());
                threadState.incrementIdleTime(delta);
                serviceIdleTime += delta;
            }
            if (howManyThreads == 0) {
                return System.nanoTime() - this.startTime;
            }
            if (this instanceof PrimitiveAnalysisEngineController) {
                int aeInstanceCount = ((PrimitiveAnalysisEngineController)((Object)this)).getAEInstanceCount();
                return (serviceIdleTime += (long)(aeInstanceCount - howManyThreads) * (System.nanoTime() - this.startTime)) / (long)aeInstanceCount;
            }
            return serviceIdleTime;
        }
    }

    @Override
    public synchronized long getCpuTime() {
        if (ManagementFactory.getPlatformMBeanServer() != null) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() : System.nanoTime();
        }
        return System.nanoTime();
    }

    private synchronized long getCpuTime(long threadId) {
        if (ManagementFactory.getPlatformMBeanServer() != null) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            return bean.isCurrentThreadCpuTimeSupported() ? bean.getThreadCpuTime(threadId) : System.nanoTime();
        }
        return System.nanoTime();
    }

    private AnalysisThreadState getFirstThreadState() {
        Set<Long> set = this.threadStateMap.keySet();
        Iterator<Long> it = set.iterator();
        if (it.hasNext()) {
            return this.threadStateMap.get(it.next());
        }
        return null;
    }

    private AnalysisThreadState getThreadState() {
        AnalysisThreadState threadState;
        if (this instanceof AggregateAnalysisEngineController) {
            threadState = this.getFirstThreadState();
        } else {
            threadState = this.threadStateMap.get(Thread.currentThread().getId());
            if (threadState == null) {
                threadState = this.getFirstThreadState();
            }
        }
        return threadState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAnalysisTime() {
        long totalCpuProcessTime = 0L;
        Object object = this.mux;
        synchronized (object) {
            Set<Long> set = this.threadStateMap.keySet();
            for (long threadId : set) {
                AnalysisThreadState threadState = this.threadStateMap.get(threadId);
                if (this instanceof AggregateAnalysisEngineController_impl) {
                    List<AnalysisEngineController> delegateControllerList;
                    List<AnalysisEngineController> list = delegateControllerList = ((AggregateAnalysisEngineController_impl)this).childControllerList;
                    synchronized (list) {
                        for (AnalysisEngineController delegateController : delegateControllerList) {
                            if (delegateController == null || delegateController.isStopped()) continue;
                            totalCpuProcessTime += delegateController.getAnalysisTime();
                        }
                        continue;
                    }
                }
                if ((totalCpuProcessTime += this.getCpuTime(threadId)) <= 0L) continue;
                totalCpuProcessTime -= threadState.getDeserializationTime();
                totalCpuProcessTime -= threadState.getSerializationTime();
            }
        }
        return totalCpuProcessTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementSerializationTime(long cpuTime) {
        Object object = this.mux;
        synchronized (object) {
            AnalysisThreadState threadState = this.getThreadState();
            if (threadState != null) {
                threadState.incrementSerializationTime(cpuTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDeserializationTime(long cpuTime) {
        Object object = this.mux;
        synchronized (object) {
            AnalysisThreadState threadState = this.getThreadState();
            if (threadState != null) {
                threadState.incrementDeserializationTime(cpuTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMetadata(Endpoint anEndpoint, AnalysisEngineMetaData metadata) {
        block16: {
            try {
                if (metadata == null) break block16;
                if (anEndpoint.getServerURI().equals("vm://localhost?broker.persistent=false")) {
                    anEndpoint.setRemote(true);
                }
                if (!anEndpoint.isRemote()) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        UimaTransport transport = null;
                        transport = this.getTransport(anEndpoint.getEndpoint());
                        UimaVmMessage message = transport.produceMessage(2001, 3001, this.getName());
                        metadata.toXML((OutputStream)bos);
                        message.addStringCargo(bos.toString());
                        transport.getUimaMessageDispatcher(anEndpoint.getEndpoint()).dispatch(message);
                        break block16;
                    }
                    catch (Exception e) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendMetadata", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getComponentName());
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "sendMetadata", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                        }
                        break block16;
                    }
                    finally {
                        try {
                            bos.close();
                        }
                        catch (Exception e) {}
                    }
                }
                this.getOutputChannel().sendReply((ProcessingResourceMetaData)metadata, anEndpoint, true);
            }
            catch (Exception e) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Endpoint", anEndpoint);
                map.put("MessageType", 3000);
                map.put("Command", 1002);
                this.handleError(map, e);
            }
        }
    }

    @Override
    public LocalCache getLocalCache() {
        return this.localCache;
    }

    @Override
    public void addAbortedCasReferenceId(String aCasReferenceId) {
        this.abortedCasesMap.put(aCasReferenceId, aCasReferenceId);
    }

    protected boolean abortGeneratingCASes(String aCasReferenceId) {
        if (this.abortedCasesMap.containsKey(aCasReferenceId)) {
            this.abortedCasesMap.remove(aCasReferenceId);
            return true;
        }
        return false;
    }

    @Override
    public boolean isAwaitingCacheCallbackNotification() {
        return this.awaitingCacheCallbackNotification;
    }

    @Override
    public void changeState(ServiceState state) {
        this.currentState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceState getState() {
        ServiceState serviceState = this.currentState;
        synchronized (serviceState) {
            return this.currentState;
        }
    }

    @Override
    public Map<String, String> getDeadClientMap() {
        return this.deadClientDestinationMap;
    }

    @Override
    public void warmUp(String warmUpDataPath, CountDownLatch warmUpLatch) throws Exception {
        if (this.isPrimitive()) {
            this.runWarmup(warmUpDataPath, warmUpLatch);
        } else {
            this.asyncWarmup(warmUpDataPath, warmUpLatch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runWarmup(String warmUpDataPath, CountDownLatch warmUpLatch) throws Exception {
        block12: {
            long warmupStartTime = 0L;
            long warmupCasCount = 0L;
            CAS cas = null;
            boolean isException = false;
            if (this.isTopLevelComponent()) {
                try {
                    warmupStartTime = System.currentTimeMillis();
                    WarmUpDataProvider wdp = new WarmUpDataProvider(warmUpDataPath);
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "runWarmup", "uimaee_messages", "UIMAEE_service_warmup_start_INFO", new Object[]{this.getComponentName(), Thread.currentThread().getId()});
                    }
                    while (wdp.hasNext() && !this.isStopped()) {
                        cas = this.getCasManagerWrapper().getNewCas();
                        wdp.next(cas);
                        ++warmupCasCount;
                        UIDGenerator idGenerator = new UIDGenerator();
                        String casReferenceId = idGenerator.nextId();
                        LocalCache.CasStateEntry cse = this.getLocalCache().createCasStateEntry(casReferenceId);
                        InProcessCache.CacheEntry entry = this.getInProcessCache().register(cas, null, null, null, casReferenceId, null, false);
                        entry.setWarmUp(true);
                        this.doWarmUp(cas, casReferenceId);
                    }
                    if (isException) break block12;
                }
                catch (Exception e) {
                    try {
                        isException = true;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (!isException) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "runWarmup", "uimaee_messages", "UIMAEE_service_warmup_success_INFO", new Object[]{this.getComponentName(), Thread.currentThread().getId(), warmupCasCount, (System.currentTimeMillis() - warmupStartTime) / 1000L});
                            }
                            if (this instanceof AggregateAnalysisEngineController) {
                                ((AggregateAnalysisEngineController_impl)this).startProcessing();
                            }
                        }
                        throw throwable;
                    }
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "runWarmup", "uimaee_messages", "UIMAEE_service_warmup_success_INFO", new Object[]{this.getComponentName(), Thread.currentThread().getId(), warmupCasCount, (System.currentTimeMillis() - warmupStartTime) / 1000L});
                }
                if (this instanceof AggregateAnalysisEngineController) {
                    ((AggregateAnalysisEngineController_impl)this).startProcessing();
                }
            }
        }
        warmUpLatch.countDown();
    }

    private void asyncWarmup(final String warmUpDataPath, final CountDownLatch warmUpLatch) throws Exception {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseAnalysisEngineController.this.runWarmup(warmUpDataPath, warmUpLatch);
                }
                catch (Exception e) {
                    BaseAnalysisEngineController.this.notifyListenersWithInitializationStatus(new RuntimeException(e));
                }
            }
        });
        t.start();
    }

    private static class AnalysisThreadState {
        private long threadId;
        private boolean isIdle = false;
        private long lastUpdate = 0L;
        private long totalIdleTime = 0L;
        private long idleTimeSinceLastProcess = 0L;
        private long lastMessageDispatchTime = 0L;
        private long serializationTime = 0L;
        private long deserializationTime = 0L;

        public AnalysisThreadState(long aThreadId) {
            this.threadId = aThreadId;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public long getSerializationTime() {
            return this.serializationTime;
        }

        public void incrementSerializationTime(long serializationTime) {
            this.serializationTime += serializationTime;
        }

        public long getDeserializationTime() {
            return this.deserializationTime;
        }

        public void incrementDeserializationTime(long deserializationTime) {
            this.deserializationTime += deserializationTime;
        }

        public boolean isIdle() {
            return this.isIdle;
        }

        public void computeIdleTimeBetweenProcessCalls() {
            this.idleTimeSinceLastProcess = System.nanoTime() - this.lastMessageDispatchTime;
        }

        public void setLastMessageDispatchTime(long aTime) {
            this.lastMessageDispatchTime = aTime;
        }

        public void incrementIdleTime(long idleTime) {
            this.totalIdleTime += idleTime;
        }

        public void setIdle(boolean isIdle) {
            this.isIdle = isIdle;
        }

        public long getIdleTime() {
            return this.totalIdleTime;
        }

        public void setLastMessageDispatchTime() {
            this.lastMessageDispatchTime = System.nanoTime();
        }

        public long getIdleTimeBetweenProcessCalls() {
            long val = this.idleTimeSinceLastProcess;
            this.idleTimeSinceLastProcess = 0L;
            return val;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }

    public static enum ServiceState {
        INITIALIZING,
        RUNNING,
        DISABLED,
        STOPPING,
        FAILED;

    }
}

