/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jmx.monitor;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.jmx.monitor.JmxMonitorListener;
import org.apache.uima.aae.jmx.monitor.ServiceMetrics;
import org.apache.uima.util.Level;

public class BasicUimaJmxMonitorListener
implements JmxMonitorListener {
    private static final Class CLASS_NAME = JmxMonitorListener.class;
    private int maxNameLength = 0;

    public BasicUimaJmxMonitorListener(int aMaxNameLength) {
        this.maxNameLength = aMaxNameLength;
    }

    @Override
    public void onNewMetrics(long sampleTime, ServiceMetrics[] metrics) {
        for (ServiceMetrics serviceMetrics : metrics) {
            if (serviceMetrics.isCasMultiplier() && serviceMetrics.isServiceRemote() && !serviceMetrics.isTopLevelService()) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "run", "uimaee_messages", "UIMAEE_service_idle_time_shadow_cas_pool_INFO", new Object[]{this.format((double)sampleTime / 1000000.0), this.padName(serviceMetrics.getServiceName()), serviceMetrics.isCasMultiplier(), serviceMetrics.isServiceRemote(), this.format(serviceMetrics.getIdleTime()), serviceMetrics.getProcessCount(), serviceMetrics.getInputQueueDepth(), serviceMetrics.getReplyQueueDepth(), this.format(serviceMetrics.getShadowCasPoolWaitTime()), this.format(serviceMetrics.getAnalysisTime()), serviceMetrics.getProcessThreadCount(), serviceMetrics.getCmFreeCasInstanceCount(), serviceMetrics.getSvcFreeCasInstanceCount()});
                continue;
            }
            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "run", "uimaee_messages", "UIMAEE_service_idle_time_cas_pool_INFO", new Object[]{this.format((double)sampleTime / 1000000.0), this.padName(serviceMetrics.getServiceName()), serviceMetrics.isCasMultiplier(), serviceMetrics.isServiceRemote(), this.format(serviceMetrics.getIdleTime()), serviceMetrics.getProcessCount(), serviceMetrics.getInputQueueDepth(), serviceMetrics.getReplyQueueDepth(), this.format(serviceMetrics.getCasPoolWaitTime()), this.format(serviceMetrics.getAnalysisTime()), serviceMetrics.getProcessThreadCount(), serviceMetrics.getCmFreeCasInstanceCount(), serviceMetrics.getSvcFreeCasInstanceCount()});
        }
        this.onNewSamplingInterval();
    }

    public void onNewSamplingInterval() {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "run", "uimaee_messages", "UIMAEE_marker_INFO", new Object[0]);
        }
    }

    private String format(double value) {
        DecimalFormat formatter = new DecimalFormat();
        ((NumberFormat)formatter).setMinimumFractionDigits(0);
        ((NumberFormat)formatter).setMaximumFractionDigits(0);
        return formatter.format(value);
    }

    private String format2(double value) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        return formatter.format(value);
    }

    private String padName(String aName) {
        StringBuffer name = new StringBuffer(aName);
        if (aName.length() < this.maxNameLength) {
            for (int i = aName.length(); i < this.maxNameLength; ++i) {
                name.append(' ');
            }
        }
        return name.toString();
    }
}

