/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.DeferredIndexUpdates;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XCASParsingException;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.internal.util.function.Runnable_withSaxException;
import org.apache.uima.jcas.cas.AnnotationBase;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.EmptyList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.FloatList;
import org.apache.uima.jcas.cas.IntegerList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyIntegerList;
import org.apache.uima.jcas.cas.NonEmptyList;
import org.apache.uima.jcas.cas.NonEmptyStringList;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.impl.Constants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmiCasDeserializer {
    private static final boolean IS_NEW_FS = true;
    private static final boolean IS_EXISTING_FS = false;
    private static final int sofaTypeCode = 33;
    private static final Pattern whiteSpace = Pattern.compile("\\s+");
    private static final String ID_ATTR_NAME = "xmi:id";
    private TypeSystemImpl ts;
    private Map<String, String> xmiNamespaceToUimaNamespaceMap = new HashMap<String, String>();

    public XmiCasDeserializer(TypeSystem ts, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)ts;
    }

    public XmiCasDeserializer(TypeSystem ts) {
        this(ts, null);
    }

    public DefaultHandler getXmiCasHandler(CAS cas) {
        return this.getXmiCasHandler(cas, false);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient) {
        return this.getXmiCasHandler(cas, lenient, null);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData) {
        return this.getXmiCasHandler(cas, lenient, sharedData, -1);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint) {
        return this.getXmiCasHandler(cas, lenient, sharedData, mergePoint, AllowPreexistingFS.ignore);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint, AllowPreexistingFS allow) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, sharedData, mergePoint, allow);
    }

    public static void deserialize(InputStream aStream, CAS aCAS) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, false, null, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, aLenient, null, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, aLenient, aSharedData, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData, int aMergePoint) throws SAXException, IOException {
        XMLReader xmlReader = XMLUtils.createXMLReader();
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(aStream));
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData, int aMergePoint, AllowPreexistingFS allowPreexistingFS) throws SAXException, IOException {
        XMLReader xmlReader = XMLUtils.createXMLReader();
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint, allowPreexistingFS);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(aStream));
    }

    private String xmiElementName2uimaTypeName(String nsUri, String localName) throws SAXException {
        String uimaNamespace = this.xmiNamespaceToUimaNamespaceMap.get(nsUri);
        if (uimaNamespace == null) {
            if ("http:///uima/noNamespace.ecore".equals(nsUri)) {
                uimaNamespace = "";
            } else {
                URI uri;
                try {
                    uri = new URI(nsUri);
                }
                catch (URISyntaxException e) {
                    throw new SAXException(e);
                }
                String path = uri.getPath();
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith(".ecore")) {
                    path = path.substring(0, path.length() - 6);
                }
                uimaNamespace = path.replace('/', '.') + '.';
            }
            this.xmiNamespaceToUimaNamespaceMap.put(nsUri, uimaNamespace);
        }
        return uimaNamespace + localName;
    }

    private void addOutOfTypeSystemAttributes(XmiSerializationSharedData.OotsElementData ootsElem, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getQName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals(ID_ATTR_NAME)) continue;
            ootsElem.attributes.add(new XmlAttribute(attrName, attrValue));
        }
    }

    private void report0xmiId() {
        Throwable t = new Throwable();
        System.err.println("Debug 0 xmiId encountered where not expected");
        t.printStackTrace();
    }

    public class XmiCasDeserializerHandler
    extends DefaultHandler {
        private static final int DOC_STATE = 0;
        private static final int FS_STATE = 1;
        private static final int FEAT_STATE = 2;
        private static final int FEAT_CONTENT_STATE = 3;
        private static final int IGNORING_XMI_ELEMENTS_STATE = 4;
        private static final int REF_FEAT_STATE = 5;
        private static final String unknownXMLSource = "<unknown>";
        private Locator locator;
        private CASImpl casBeingFilled;
        private int state;
        private StringBuilder buffer;
        private TOP currentFs;
        private TypeImpl currentType;
        private int currentArrayId;
        private List<String> currentArrayElements;
        private Map<String, ArrayList<String>> multiValuedFeatures = new TreeMap<String, ArrayList<String>>();
        private List<FSIndexRepository> indexRepositories;
        private List<CAS> views;
        boolean lenient;
        private int ignoreDepth = 0;
        private Map<String, String> nsPrefixToUriMap = new HashMap<String, String>();
        private XmiSerializationSharedData sharedData;
        private int nextSofaNum;
        private int mergePoint;
        private XmiSerializationSharedData.OotsElementData outOfTypeSystemElement = null;
        private List<XmiSerializationSharedData.OotsElementData> deferredFSs = null;
        private XmiSerializationSharedData.OotsElementData deferredFsElement = null;
        private boolean processingDeferredFSs = false;
        private boolean isDoingDeferredChildElements = false;
        private Map<Integer, TOP> localXmiIdToFs = new HashMap<Integer, TOP>();
        AllowPreexistingFS allowPreexistingFS;
        IntVector featsSeen = null;
        boolean disallowedViewMemberEncountered;
        private final DeferredIndexUpdates toBeAdded = new DeferredIndexUpdates();
        private final DeferredIndexUpdates toBeRemoved = new DeferredIndexUpdates();
        private final List<Runnable_withSaxException> fixupToDos = new ArrayList<Runnable_withSaxException>();
        private final List<Runnable> uimaSerializableFixups = new ArrayList<Runnable>();

        private XmiCasDeserializerHandler(CASImpl aCAS, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint, AllowPreexistingFS allowPreexistingFS) {
            this.casBeingFilled = aCAS.getBaseCAS();
            this.lenient = lenient;
            this.sharedData = sharedData != null ? sharedData : new XmiSerializationSharedData();
            this.mergePoint = mergePoint;
            this.allowPreexistingFS = allowPreexistingFS;
            this.featsSeen = null;
            this.disallowedViewMemberEncountered = false;
            if (mergePoint < 0) {
                this.casBeingFilled.resetNoQuestions();
                this.sharedData.clearIdMap();
                this.nextSofaNum = 2;
            } else {
                this.nextSofaNum = this.casBeingFilled.getViewCount() + 1;
            }
            this.buffer = new StringBuilder();
            this.indexRepositories = new ArrayList<FSIndexRepository>();
            this.views = new ArrayList<CAS>();
            this.indexRepositories.add(this.casBeingFilled.getBaseIndexRepository());
            this.indexRepositories.add(this.casBeingFilled.getView("_InitialView").getIndexRepository());
            FSIterator sofaIter = this.casBeingFilled.getSofaIterator();
            while (sofaIter.hasNext()) {
                SofaFS sofa = (SofaFS)sofaIter.next();
                if (sofa.getSofaRef() == 1) {
                    this.casBeingFilled.registerInitialSofa();
                    continue;
                }
                Misc.setWithExpand(this.indexRepositories, sofa.getSofaRef(), this.casBeingFilled.getSofaIndexRepository(sofa));
            }
        }

        private final void resetBuffer() {
            this.buffer.setLength(0);
        }

        @Override
        public void startDocument() throws SAXException {
            this.state = 0;
        }

        @Override
        public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            this.resetBuffer();
            switch (this.state) {
                case 0: {
                    if (attrs != null) {
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            String attrName = attrs.getQName(i);
                            if (!attrName.startsWith("xmlns:")) continue;
                            String prefix = attrName.substring(6);
                            String uri = attrs.getValue(i);
                            this.nsPrefixToUriMap.put(prefix, uri);
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    int idInt;
                    String id;
                    if (qualifiedName.startsWith("xmi")) {
                        this.state = 4;
                        ++this.ignoreDepth;
                        return;
                    }
                    if (this.mergePoint >= 0 && (id = attrs.getValue(XmiCasDeserializer.ID_ATTR_NAME)) != null && (idInt = Integer.parseInt(id)) > 0 && !this.isNewFS(idInt)) {
                        if (this.allowPreexistingFS == AllowPreexistingFS.ignore) {
                            this.state = 4;
                            ++this.ignoreDepth;
                            return;
                        }
                        if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                            throw new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", "xmi:id=" + id, nameSpaceURI, localName, qualifiedName);
                        }
                    }
                    if (nameSpaceURI == null || nameSpaceURI.length() == 0) {
                        int colonIndex = qualifiedName.indexOf(58);
                        if (colonIndex != -1) {
                            String prefix = qualifiedName.substring(0, colonIndex);
                            nameSpaceURI = this.nsPrefixToUriMap.get(prefix);
                            if (nameSpaceURI == null) {
                                nameSpaceURI = "http:///" + prefix + ".ecore";
                            }
                            localName = qualifiedName.substring(colonIndex + 1);
                        } else {
                            nameSpaceURI = "http:///uima/noNamespace.ecore";
                        }
                    }
                    this.readFS(nameSpaceURI, localName, qualifiedName, attrs);
                    this.multiValuedFeatures.clear();
                    this.state = 2;
                    break;
                }
                case 2: {
                    String href = attrs.getValue("href");
                    if (href != null && href.startsWith("#")) {
                        if (this.outOfTypeSystemElement != null) {
                            XmlElementName elemName = new XmlElementName(nameSpaceURI, localName, qualifiedName);
                            ArrayList<XmlAttribute> ootsAttrs = new ArrayList<XmlAttribute>();
                            ootsAttrs.add(new XmlAttribute("href", href));
                            XmlElementNameAndContents elemWithContents = new XmlElementNameAndContents(elemName, null, ootsAttrs);
                            this.outOfTypeSystemElement.childElements.add(elemWithContents);
                        } else {
                            ArrayList valueList = this.multiValuedFeatures.computeIfAbsent(qualifiedName, k -> new ArrayList());
                            valueList.add(href.substring(1));
                        }
                        this.state = 5;
                        break;
                    }
                    this.state = 3;
                    break;
                }
                case 4: {
                    ++this.ignoreDepth;
                    break;
                }
                default: {
                    throw this.createException(1, qualifiedName);
                }
            }
        }

        private void readFS(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            String typeName = XmiCasDeserializer.this.xmiElementName2uimaTypeName(nameSpaceURI, localName);
            this.currentType = XmiCasDeserializer.this.ts.getType(typeName);
            if (this.currentType == null) {
                if ("uima.cas.NULL".equals(typeName)) {
                    return;
                }
                if ("uima.cas.View".equals(typeName)) {
                    this.processDeferredFSs();
                    this.processView(attrs.getValue("sofa"), attrs.getValue("members"));
                    String added = attrs.getValue("added_members");
                    String deleted = attrs.getValue("deleted_members");
                    String reindexed = attrs.getValue("reindexed_members");
                    this.processView(attrs.getValue("sofa"), added, deleted, reindexed);
                    return;
                }
                if (!this.lenient) {
                    throw this.createException(4, typeName);
                }
                this.addToOutOfTypeSystemData(new XmlElementName(nameSpaceURI, localName, qualifiedName), attrs);
                return;
            }
            if (this.currentType.isArray()) {
                String idStr = attrs.getValue(XmiCasDeserializer.ID_ATTR_NAME);
                this.currentArrayId = idStr == null ? -1 : Integer.parseInt(idStr);
                String elements = attrs.getValue("elements");
                if (this.casBeingFilled.isByteArrayType(this.currentType)) {
                    this.createOrUpdateByteArray(elements, this.currentArrayId, null);
                } else if (elements != null) {
                    String[] parsedElements = this.parseArray(elements);
                    this.currentArrayElements = Arrays.asList(parsedElements);
                } else {
                    this.currentArrayElements = null;
                }
            } else {
                int xmiId;
                String idStr = attrs.getValue(XmiCasDeserializer.ID_ATTR_NAME);
                int n = xmiId = idStr == null ? -1 : Integer.parseInt(idStr);
                if (this.isNewFS(xmiId)) {
                    TOP fs;
                    if (33 == this.currentType.getCode()) {
                        int n2;
                        String sofaID = attrs.getValue("sofaID");
                        if (sofaID.equals("_InitialView") || sofaID.equals("_DefaultTextSofaName")) {
                            n2 = 1;
                        } else {
                            int n3 = this.nextSofaNum;
                            n2 = n3;
                            this.nextSofaNum = n3 + 1;
                        }
                        int thisSofaNum = n2;
                        String sofaMimeType = attrs.getValue("mimeType");
                        if (sofaID.equals("_DefaultTextSofaName")) {
                            sofaID = "_InitialView";
                        }
                        fs = this.casBeingFilled.createSofa(thisSofaNum, sofaID, sofaMimeType);
                    } else if (this.currentType.isAnnotationBaseType()) {
                        String extSofaRef = attrs.getValue("sofa");
                        CASImpl casView = null;
                        if (extSofaRef == null || extSofaRef.length() == 0) {
                            this.doDeferFsOrThrow(idStr, nameSpaceURI, localName, qualifiedName, attrs);
                            return;
                        }
                        Sofa sofa = (Sofa)this.maybeGetFsForXmiId(Integer.parseInt(extSofaRef));
                        if (null != sofa) {
                            casView = this.casBeingFilled.getView(sofa);
                        }
                        if (casView == null) {
                            this.doDeferFsOrThrow(idStr, nameSpaceURI, localName, qualifiedName, attrs);
                            return;
                        }
                        if (this.currentType.getCode() == 36) {
                            fs = (TOP)casView.getDocumentAnnotation();
                        } else {
                            fs = (TOP)casView.createFS(this.currentType);
                            if (this.currentFs instanceof UimaSerializable) {
                                UimaSerializable ufs = (UimaSerializable)((Object)this.currentFs);
                                this.uimaSerializableFixups.add(() -> ufs._init_from_cas_data());
                            }
                        }
                    } else {
                        fs = (TOP)this.casBeingFilled.createFS(this.currentType);
                        if (this.currentFs instanceof UimaSerializable) {
                            UimaSerializable ufs = (UimaSerializable)((Object)this.currentFs);
                            this.uimaSerializableFixups.add(() -> ufs._init_from_cas_data());
                        }
                    }
                    this.readFS(fs, attrs, true);
                } else {
                    if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                        throw new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", "xmi:id=" + idStr, nameSpaceURI, localName, qualifiedName);
                    }
                    if (this.allowPreexistingFS == AllowPreexistingFS.allow) {
                        TOP fs = this.getFsForXmiId(xmiId);
                        this.readFS(fs, attrs, false);
                    }
                }
            }
        }

        private void doDeferFsOrThrow(String idStr, String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws XCASParsingException {
            if (this.processingDeferredFSs) {
                throw this.createException(13);
            }
            if (this.deferredFSs == null) {
                this.deferredFSs = new ArrayList<XmiSerializationSharedData.OotsElementData>();
            }
            this.deferredFsElement = new XmiSerializationSharedData.OotsElementData(idStr, new XmlElementName(nameSpaceURI, localName, qualifiedName), this.locator == null ? 0 : this.locator.getLineNumber(), this.locator == null ? 0 : this.locator.getColumnNumber());
            this.deferredFSs.add(this.deferredFsElement);
            XmiCasDeserializer.this.addOutOfTypeSystemAttributes(this.deferredFsElement, attrs);
        }

        private void processView(String sofa, String membersString) throws SAXParseException {
            if (membersString != null) {
                int sofaXmiId = sofa == null ? 1 : Integer.parseInt(sofa);
                FSIndexRepositoryImpl indexRep = this.getIndexRepo(sofa, sofaXmiId);
                boolean newview = sofa == null ? false : this.isNewFS(sofaXmiId);
                List<TOP> todo = this.toBeAdded.getTodos(indexRep);
                String[] members = this.parseArray(membersString);
                for (int i = 0; i < members.length; ++i) {
                    TOP fs;
                    int xmiId = Integer.parseInt(members[i]);
                    if (!newview && !this.isNewFS(xmiId)) {
                        if (this.allowPreexistingFS == AllowPreexistingFS.ignore) continue;
                        if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                            this.disallowedViewMemberEncountered = true;
                            continue;
                        }
                    }
                    if ((fs = this.maybeGetFsForXmiId(xmiId)) != null) {
                        todo.add(fs);
                        continue;
                    }
                    if (!this.lenient) {
                        if (xmiId == 0) {
                            XmiCasDeserializer.this.report0xmiId();
                        }
                        throw this.createException(12, Integer.toString(xmiId));
                    }
                    this.sharedData.addOutOfTypeSystemViewMember(sofa, members[i]);
                }
            }
        }

        private FSIndexRepositoryImpl getIndexRepo(String sofaXmiIdAsString, int sofaXmiId) throws XCASParsingException {
            if (sofaXmiIdAsString == null) {
                return (FSIndexRepositoryImpl)this.indexRepositories.get(1);
            }
            Sofa sofa = (Sofa)this.maybeGetFsForXmiId(sofaXmiId);
            if (null == sofa) {
                if (sofaXmiId == 0) {
                    XmiCasDeserializer.this.report0xmiId();
                }
                throw this.createException(12, Integer.toString(sofaXmiId));
            }
            return (FSIndexRepositoryImpl)this.indexRepositories.get(sofa.getSofaNum());
        }

        private void processView(String sofa, String addmembersString, String delmemberString, String reindexmemberString) throws SAXParseException {
            if (addmembersString != null) {
                this.processView(sofa, addmembersString);
            }
            if (delmemberString == null && reindexmemberString == null) {
                return;
            }
            int sofaXmiId = sofa == null ? 1 : Integer.parseInt(sofa);
            FSIndexRepositoryImpl indexRep = this.getIndexRepo(sofa, sofaXmiId);
            if (delmemberString != null) {
                List<TOP> localRemoves = this.toBeRemoved.getTodos(indexRep);
                String[] members = this.parseArray(delmemberString);
                for (int i = 0; i < members.length; ++i) {
                    TOP fs;
                    int xmiId = Integer.parseInt(members[i]);
                    if (!this.isNewFS(xmiId)) {
                        if (this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                            this.disallowedViewMemberEncountered = true;
                            continue;
                        }
                        if (this.allowPreexistingFS == AllowPreexistingFS.ignore) continue;
                    }
                    if ((fs = this.maybeGetFsForXmiId(xmiId)) != null) {
                        localRemoves.add(fs);
                        continue;
                    }
                    if (!this.lenient) {
                        if (xmiId == 0) {
                            XmiCasDeserializer.this.report0xmiId();
                        }
                        throw this.createException(12, Integer.toString(xmiId));
                    }
                    this.sharedData.addOutOfTypeSystemViewMember(sofa, members[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFS(TOP fs, Attributes attrs, boolean isNewFs) throws SAXException {
            this.currentFs = fs;
            TypeImpl type = fs._getTypeImpl();
            int typeCode = type.getCode();
            this.featsSeen = null;
            try {
                int extId;
                if (!isNewFs || fs._getTypeCode() == 36) {
                    this.casBeingFilled.removeFromCorruptableIndexAnyView(fs, this.casBeingFilled.getAddbackSingle());
                }
                String idStr = attrs.getValue(XmiCasDeserializer.ID_ATTR_NAME);
                try {
                    extId = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    throw this.createException(5, idStr);
                }
                this.addFsToXmiId(fs, extId);
                this.featsSeen = 33 != typeCode && !isNewFs ? new IntVector(attrs.getLength()) : null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attrName = attrs.getQName(i);
                    String attrValue = attrs.getValue(i);
                    if (attrName.equals(XmiCasDeserializer.ID_ATTR_NAME)) continue;
                    int featCode = this.handleFeatureFromName(type, fs, attrName, attrValue, isNewFs);
                    if (this.featsSeen == null || featCode == -1) continue;
                    this.featsSeen.add(featCode);
                }
            }
            finally {
                if (!isNewFs || fs._getTypeCode() == 36) {
                    this.casBeingFilled.addbackSingle(fs);
                }
            }
            if (33 == typeCode && isNewFs) {
                Sofa sofa = (Sofa)fs;
                this.casBeingFilled.getBaseIndexRepository().addFS(sofa);
                CASImpl view = this.casBeingFilled.getView(sofa);
                if (sofa.getSofaRef() == 1) {
                    this.casBeingFilled.registerInitialSofa();
                } else {
                    this.indexRepositories.add(this.casBeingFilled.getSofaIndexRepository(sofa));
                }
                view.registerView(sofa);
                this.views.add(view);
            }
        }

        private final boolean emptyVal(String val) {
            return val == null || val.length() == 0;
        }

        private int handleFeatureFromName(TypeImpl type, TOP fs, String featName, String featVal, boolean isNewFS) throws SAXException {
            FeatureImpl feat = type.getFeatureByBaseName(featName);
            if (feat == null) {
                if (!this.lenient) {
                    throw this.createException(8, featName);
                }
                if (this.isDoingDeferredChildElements) {
                    ArrayList<String> featValAsArrayList = new ArrayList<String>(1);
                    featValAsArrayList.add(featVal);
                    this.sharedData.addOutOfTypeSystemChildElements(fs, featName, featValAsArrayList);
                } else {
                    this.sharedData.addOutOfTypeSystemAttribute(fs, featName, featVal);
                }
                return -1;
            }
            if (fs instanceof Sofa && !isNewFS) {
                if (featName.equals("sofaID") || featName.equals("sofaNum")) {
                    return feat.getCode();
                }
                if (((Sofa)fs).isSofaDataSet()) {
                    return feat.getCode();
                }
            }
            this.handleFeatSingleValue(fs, feat, featVal);
            return feat.getCode();
        }

        private int handleFeatMultiValueFromName(Type type, TOP fs, String featName, ArrayList<String> featVals) throws SAXException {
            FeatureImpl feat = (FeatureImpl)type.getFeatureByBaseName(featName);
            if (feat == null) {
                if (!this.lenient) {
                    throw this.createException(8, featName);
                }
                this.sharedData.addOutOfTypeSystemChildElements(fs, featName, featVals);
                return -1;
            }
            this.handleFeatMultiValue(fs, feat, featVals);
            return feat.getCode();
        }

        private void handleFeatSingleValue(TOP fs, FeatureImpl fi, String featVal) throws SAXException {
            if (fs instanceof AnnotationBase && fi.getCode() == 15) {
                return;
            }
            int rangeClass = fi.rangeTypeClass;
            switch (rangeClass) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    CASImpl.setFeatureValueFromStringNoDocAnnotUpdate(fs, fi, featVal);
                    break;
                }
                case 8: {
                    this.deserializeFsRef(featVal, fi, fs);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    if (fi.isMultipleReferencesAllowed()) {
                        this.deserializeFsRef(featVal, fi, fs);
                        break;
                    }
                    if (rangeClass == 15) {
                        ByteArray existingByteArray = (ByteArray)fs.getFeatureValue(fi);
                        ByteArray byteArray = this.createOrUpdateByteArray(featVal, -1, existingByteArray);
                        if (byteArray == existingByteArray) break;
                        CASImpl.setFeatureValueMaybeSofa(fs, fi, byteArray);
                        break;
                    }
                    String[] arrayVals = this.parseArray(featVal);
                    this.handleFeatMultiValue(fs, fi, Arrays.asList(arrayVals));
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    if (fi.isMultipleReferencesAllowed()) {
                        this.deserializeFsRef(featVal, fi, fs);
                        break;
                    }
                    String[] arrayVals = this.parseArray(featVal);
                    this.handleFeatMultiValue(fs, fi, Arrays.asList(arrayVals));
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }

        private void deserializeFsRef(String featVal, FeatureImpl fi, TOP fs) {
            if (featVal == null || featVal.length() == 0) {
                CASImpl.setFeatureValueMaybeSofa(fs, fi, null);
            } else {
                int xmiId = Integer.parseInt(featVal);
                TOP tgtFs = this.maybeGetFsForXmiId(xmiId);
                if (null == tgtFs) {
                    this.fixupToDos.add(() -> this.finalizeRefValue(xmiId, fs, fi));
                } else {
                    CASImpl.setFeatureValueMaybeSofa(fs, fi, tgtFs);
                    XmiCasDeserializer.this.ts.fixupFSArrayTypes(fi.getRangeImpl(), tgtFs);
                }
            }
        }

        private String[] parseArray(String val) {
            String[] arrayVals = this.emptyVal(val = val.trim()) ? Constants.EMPTY_STRING_ARRAY : whiteSpace.split(val);
            return arrayVals;
        }

        private void handleFeatMultiValue(TOP fs, FeatureImpl fi, List<String> featVals) throws SAXException {
            int rangeCode = fi.rangeTypeClass;
            switch (rangeCode) {
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (featVals.size() != 1) {
                        throw new SAXParseException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "multiple_values_unexpected", new Object[]{fi.getName()}), this.locator);
                    }
                    this.handleFeatSingleValue(fs, fi, featVals.get(0));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    CommonArrayFS existingArray = (CommonArrayFS)((Object)fs.getFeatureValue(fi));
                    CommonArrayFS casArray = this.createOrUpdateArray(fi.getRangeImpl(), featVals, -1, existingArray);
                    if (existingArray != casArray) {
                        CASImpl.setFeatureValueMaybeSofa(fs, fi, (TOP)((Object)casArray));
                    }
                    if (fi.isMultipleReferencesAllowed()) break;
                    this.addNonsharedFSToEncompassingFSMapping((TOP)((Object)casArray), fs);
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    CommonList theList;
                    if (featVals == null) {
                        fs.setFeatureValue(fi, null);
                        break;
                    }
                    if (featVals.size() == 0) {
                        fs.setFeatureValue(fi, this.casBeingFilled.emptyList(rangeCode));
                        break;
                    }
                    CommonList existingList = (CommonList)((Object)fs.getFeatureValue(fi));
                    if (existingList != (theList = this.createOrUpdateList(fi.getRangeImpl(), featVals, -1, existingList))) {
                        fs.setFeatureValue(fi, theList);
                    }
                    if (fi.isMultipleReferencesAllowed()) break;
                    for (CommonList node = theList; node != null && node instanceof NonEmptyList; node = node.getCommonTail()) {
                        this.addNonsharedFSToEncompassingFSMapping((TOP)((Object)node), fs);
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private CommonList createOrUpdateList(TypeImpl listType, List<String> values, int xmiId, CommonList existingList) {
            if (existingList != null) {
                this.updateExistingList(values, existingList);
                return existingList;
            }
            return this.createListFromStringValues(values, this.casBeingFilled.emptyListFromTypeCode(listType.getCode()));
        }

        private CommonArrayFS createOrUpdateArray(TypeImpl arrayType, List<String> values, int xmiId, CommonArrayFS existingArray) throws XCASParsingException {
            CommonArrayFS resultArray;
            if (values == null) {
                return null;
            }
            int arrayLen = values.size();
            if (existingArray != null) {
                if (arrayLen == 0) {
                    resultArray = existingArray.size() == 0 ? existingArray : (CommonArrayFS)((Object)this.casBeingFilled.createArray(arrayType, 0));
                } else if (existingArray.size() == arrayLen) {
                    this.updateExistingArray(values, existingArray);
                    resultArray = existingArray;
                } else {
                    resultArray = this.createNewArray(arrayType, values);
                }
            } else if (xmiId == -1 || this.isNewFS(xmiId)) {
                resultArray = this.createNewArray(arrayType, values);
            } else {
                existingArray = (CommonArrayFS)((Object)this.getFsForXmiId(xmiId));
                if (existingArray.size() == arrayLen) {
                    this.updateExistingArray(values, existingArray);
                    resultArray = existingArray;
                } else {
                    resultArray = this.createNewArray(arrayType, values);
                }
            }
            TOP newOrUpdated = (TOP)((Object)resultArray);
            this.addFsToXmiId(newOrUpdated, xmiId);
            return resultArray;
        }

        private CommonArrayFS createNewArray(TypeImpl type, List<String> values) {
            CommonArrayFS fs;
            int sz = values.size();
            CommonArrayFS commonArrayFS = fs = sz == 0 ? this.casBeingFilled.emptyArray(type) : (CommonArrayFS)((Object)this.casBeingFilled.createArray(type, sz));
            if (fs instanceof FSArray) {
                FSArray fsArray = (FSArray)fs;
                for (int i = 0; i < sz; ++i) {
                    this.maybeSetFsArrayElement(values, i, fsArray);
                }
            } else {
                CommonPrimitiveArray fsp = (CommonPrimitiveArray)fs;
                for (int i = 0; i < sz; ++i) {
                    fsp.setArrayValueFromString(i, values.get(i));
                }
            }
            return fs;
        }

        private void updateExistingArray(List<String> values, CommonArrayFS existingArray) {
            int sz = values.size();
            if (existingArray instanceof FSArray) {
                FSArray fsArray = (FSArray)existingArray;
                for (int i = 0; i < sz; ++i) {
                    String featVal = values.get(i);
                    if (this.emptyVal(featVal)) {
                        fsArray.set(i, null);
                        continue;
                    }
                    this.maybeSetFsArrayElement(values, i, fsArray);
                    int xmiId = Integer.parseInt(featVal);
                    int pos = i;
                    TOP tgtFs = this.maybeGetFsForXmiId(xmiId);
                    if (null == tgtFs) {
                        this.fixupToDos.add(() -> this.finalizeFSArrayRefValue(xmiId, fsArray, pos));
                        continue;
                    }
                    fsArray.set(i, tgtFs);
                }
                return;
            }
            CommonPrimitiveArray existingPrimitiveArray = (CommonPrimitiveArray)existingArray;
            for (int i = 0; i < sz; ++i) {
                existingPrimitiveArray.setArrayValueFromString(i, values.get(i));
            }
        }

        private CommonList updateExistingList(List<String> values, CommonList existingList) {
            if (values == null || values.size() == 0) {
                if (existingList instanceof EmptyList) {
                    return existingList;
                }
                return existingList.emptyList();
            }
            int valLen = values.size();
            if (existingList instanceof EmptyList) {
                return this.createListFromStringValues(values, (EmptyList)((Object)existingList));
            }
            if (existingList instanceof FSList) {
                FSList node = (FSList)existingList;
                NonEmptyFSList prevNode = null;
                for (int i = 0; i < valLen; ++i) {
                    if (node instanceof EmptyList) {
                        prevNode.setTail(this.createListFromStringValues(values, i, (EmptyList)((Object)node)));
                        return existingList;
                    }
                    NonEmptyFSList neNode = (NonEmptyFSList)node;
                    this.maybeSetFsListHead(values.get(i), neNode);
                    prevNode = (NonEmptyFSList)node;
                    node = prevNode.getTail();
                }
                prevNode.setTail(existingList.emptyList());
                return existingList;
            }
            CommonList node = existingList;
            CommonList prevNode = null;
            for (int i = 0; i < valLen; ++i) {
                if (node instanceof EmptyList) {
                    prevNode.setTail(this.createListFromStringValues(values, i, (EmptyList)((Object)node)));
                    return existingList;
                }
                node.set_headFromString(values.get(i));
                prevNode = node;
                node = node.getCommonTail();
            }
            prevNode.setTail(existingList.emptyList());
            return existingList;
        }

        private void maybeSetFsArrayElement(List<String> values, int i, FSArray fsArray) {
            String featVal = values.get(i);
            if (this.emptyVal(featVal)) {
                fsArray.set(i, null);
            } else {
                int xmiId = Integer.parseInt(featVal);
                int pos = i;
                TOP tgtFs = this.maybeGetFsForXmiId(xmiId);
                if (null == tgtFs) {
                    this.fixupToDos.add(() -> this.finalizeFSArrayRefValue(xmiId, fsArray, pos));
                } else {
                    fsArray.set(i, tgtFs);
                }
            }
        }

        private void maybeSetFsListHead(String featVal, NonEmptyFSList neNode) {
            if (this.emptyVal(featVal)) {
                neNode.setHead(null);
            } else {
                int xmiId = Integer.parseInt(featVal);
                TOP tgtFs = this.maybeGetFsForXmiId(xmiId);
                if (null == tgtFs) {
                    this.fixupToDos.add(() -> this.finalizeFSListRefValue(xmiId, neNode));
                } else {
                    neNode.setHead(tgtFs);
                }
            }
        }

        CommonList createListFromStringValues(List<String> stringValues, EmptyList emptyNode) {
            return this.createListFromStringValues(stringValues, 0, emptyNode);
        }

        private CommonList createListFromStringValues(List<String> stringValues, int startPos, EmptyList emptyNode) {
            if (emptyNode instanceof FSList) {
                CommonList n = (FSList)((Object)emptyNode);
                for (int i = stringValues.size() - 1; i >= startPos; --i) {
                    String v = stringValues.get(i);
                    CommonList nn = n.pushNode();
                    this.maybeSetFsListHead(v, (NonEmptyFSList)nn);
                    n = nn;
                }
                return n;
            }
            if (emptyNode instanceof IntegerList) {
                IntegerList n = (IntegerList)((Object)emptyNode);
                for (int i = stringValues.size() - 1; i >= startPos; --i) {
                    String v = stringValues.get(i);
                    NonEmptyIntegerList nn = n.push(Integer.parseInt(v));
                    n = nn;
                }
                return n;
            }
            if (emptyNode instanceof FloatList) {
                FloatList n = (FloatList)((Object)emptyNode);
                for (int i = stringValues.size() - 1; i >= startPos; --i) {
                    String v = stringValues.get(i);
                    NonEmptyFloatList nn = n.push(Float.parseFloat(v));
                    n = nn;
                }
                return n;
            }
            StringList n = (StringList)((Object)emptyNode);
            for (int i = stringValues.size() - 1; i >= startPos; --i) {
                String v = stringValues.get(i);
                NonEmptyStringList nn = n.push(v);
                n = nn;
            }
            return n;
        }

        private ByteArray createOrUpdateByteArray(String hexString, int xmiId, ByteArray existingArray) throws XCASParsingException {
            ByteArray fs;
            if (hexString == null) {
                return null;
            }
            if ((hexString.length() & 1) != 0) {
                throw this.createException(14);
            }
            int arrayLen = hexString.length() / 2;
            if (existingArray != null) {
                if (arrayLen == 0) {
                    return existingArray.size() == 0 ? existingArray : (ByteArray)this.casBeingFilled.createByteArrayFS(0);
                }
                fs = existingArray.size() == arrayLen ? existingArray : (ByteArray)this.casBeingFilled.createByteArrayFS(arrayLen);
            } else {
                fs = xmiId == -1 || this.isNewFS(xmiId) ? (ByteArray)this.casBeingFilled.createByteArrayFS(arrayLen) : ((existingArray = (ByteArray)this.getFsForXmiId(xmiId)).size() == arrayLen ? existingArray : (ByteArray)this.casBeingFilled.createByteArrayFS(arrayLen));
            }
            for (int i = 0; i < arrayLen; ++i) {
                byte high = this.hexCharToByte(hexString.charAt(i * 2));
                byte low = this.hexCharToByte(hexString.charAt(i * 2 + 1));
                byte b = (byte)(high << 4 | low);
                fs.set(i, b);
            }
            this.addFsToXmiId(fs, xmiId);
            return fs;
        }

        private byte hexCharToByte(char c) {
            if ('0' <= c && c <= '9') {
                return (byte)(c - 48);
            }
            if ('A' <= c && c <= 'F') {
                return (byte)(c - 65 + 10);
            }
            if ('a' <= c && c <= 'f') {
                return (byte)(c - 97 + 10);
            }
            throw new NumberFormatException("Invalid hex char: " + c);
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            switch (this.state) {
                case 3: {
                    this.buffer.append(chars, start, length);
                    break;
                }
            }
        }

        @Override
        public void endElement(String nsURI, String localName, String qualifiedName) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 0;
                    break;
                }
                case 3: {
                    ArrayList valueList = this.multiValuedFeatures.computeIfAbsent(qualifiedName, k -> new ArrayList());
                    valueList.add(this.buffer.toString());
                    this.state = 2;
                    break;
                }
                case 5: {
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (this.outOfTypeSystemElement != null || this.deferredFsElement != null) {
                        if (!this.multiValuedFeatures.isEmpty()) {
                            for (Map.Entry<String, ArrayList<String>> entry : this.multiValuedFeatures.entrySet()) {
                                String featName = entry.getKey();
                                ArrayList<String> featVals = entry.getValue();
                                XmiSerializationSharedData.addOutOfTypeSystemFeature(this.outOfTypeSystemElement == null ? this.deferredFsElement : this.outOfTypeSystemElement, featName, featVals);
                            }
                        }
                        this.deferredFsElement = null;
                        this.outOfTypeSystemElement = null;
                    } else if (this.currentType != null) {
                        if (this.currentType.isArray() && this.currentType.getCode() != 29) {
                            if (this.currentArrayElements == null) {
                                this.currentArrayElements = this.multiValuedFeatures.get("elements");
                                if (this.currentArrayElements == null) {
                                    this.currentArrayElements = Collections.emptyList();
                                }
                            }
                            this.createOrUpdateArray(this.currentType, this.currentArrayElements, this.currentArrayId, null);
                        } else if (!this.multiValuedFeatures.isEmpty()) {
                            for (Map.Entry<String, ArrayList<String>> entry : this.multiValuedFeatures.entrySet()) {
                                ArrayList<String> featVals;
                                String featName = entry.getKey();
                                int featcode = this.handleFeatMultiValueFromName(this.currentType, this.currentFs, featName, featVals = entry.getValue());
                                if (featcode == -1 || this.featsSeen == null) continue;
                                this.featsSeen.add(featcode);
                            }
                        }
                        if (33 != this.currentType.getCode() && this.featsSeen != null) {
                            for (FeatureImpl fi : this.currentType.getFeatureImpls()) {
                                if (fi.getName().equals("uima.cas.AnnotationBase:sofa") || this.featsSeen.contains(fi.getCode())) continue;
                                CASImpl.setFeatureValueFromStringNoDocAnnotUpdate(this.currentFs, fi, null);
                            }
                            this.featsSeen = null;
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 4: {
                    --this.ignoreDepth;
                    if (this.ignoreDepth != 0) break;
                    this.state = 1;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            List todo;
            FSIndexRepositoryImpl indexRep;
            this.processDeferredFSs();
            for (Runnable_withSaxException runnable_withSaxException : this.fixupToDos) {
                runnable_withSaxException.run();
            }
            for (Map.Entry entry : this.toBeAdded.entrySet()) {
                indexRep = (FSIndexRepositoryImpl)entry.getKey();
                todo = (List)entry.getValue();
                for (TOP fs : todo) {
                    indexRep.addFS(fs);
                }
            }
            for (Map.Entry entry : this.toBeRemoved.entrySet()) {
                indexRep = (FSIndexRepositoryImpl)entry.getKey();
                todo = (List)entry.getValue();
                for (TOP fs : todo) {
                    indexRep.removeFS(fs);
                }
            }
            for (CAS cAS : this.views) {
                ((CASImpl)cAS).updateDocumentAnnotation();
            }
            if (this.disallowedViewMemberEncountered) {
                throw new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", "Preexisting FS view member encountered.");
            }
            for (Runnable runnable : this.uimaSerializableFixups) {
                runnable.run();
            }
        }

        private void finalizeRefValue(int xmiId, TOP fs, FeatureImpl fi) throws XCASParsingException {
            TOP tgtFs = this.maybeGetFsForXmiId(xmiId);
            if (null == tgtFs && xmiId != 0) {
                if (!this.lenient) {
                    throw this.createException(12, Integer.toString(xmiId));
                }
                this.sharedData.addOutOfTypeSystemAttribute(fs, fi.getShortName(), Integer.toString(xmiId));
                CASImpl.setFeatureValueMaybeSofa(fs, fi, null);
            } else {
                CASImpl.setFeatureValueMaybeSofa(fs, fi, tgtFs);
                XmiCasDeserializer.this.ts.fixupFSArrayTypes(fi.getRangeImpl(), tgtFs);
            }
        }

        private void finalizeFSListRefValue(int xmiId, NonEmptyFSList neNode) throws XCASParsingException {
            TOP tgtFs = this.maybeGetFsForXmiId(xmiId);
            if (null == tgtFs && xmiId != 0) {
                if (!this.lenient) {
                    throw this.createException(12, Integer.toString(xmiId));
                }
                this.sharedData.addOutOfTypeSystemAttribute(neNode, "head", Integer.toString(xmiId));
                neNode.setHead(null);
            } else {
                neNode.setHead(tgtFs);
            }
        }

        private void finalizeFSArrayRefValue(int xmiId, FSArray fsArray, int index) throws XCASParsingException {
            TOP tgtFs = this.maybeGetFsForXmiId(xmiId);
            if (null == tgtFs && xmiId != 0) {
                if (!this.lenient) {
                    throw this.createException(12, Integer.toString(xmiId));
                }
                this.sharedData.addOutOfTypeSystemArrayElement(fsArray, index, xmiId);
                fsArray.set(index, null);
            } else {
                fsArray.set(index, tgtFs);
            }
        }

        private XCASParsingException createException(int code) {
            XCASParsingException e = new XCASParsingException(code);
            String source = unknownXMLSource;
            String line = unknownXMLSource;
            String col = unknownXMLSource;
            if (this.locator != null) {
                source = this.locator.getSystemId();
                if (source == null) {
                    source = this.locator.getPublicId();
                }
                if (source == null) {
                    source = unknownXMLSource;
                }
                line = Integer.toString(this.locator.getLineNumber());
                col = Integer.toString(this.locator.getColumnNumber());
            }
            e.addArgument(source);
            e.addArgument(line);
            e.addArgument(col);
            return e;
        }

        private XCASParsingException createException(int code, String arg) {
            XCASParsingException e = this.createException(code);
            e.addArgument(arg);
            return e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator loc) {
            this.locator = loc;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        private void addFsToXmiId(TOP fs, int xmiId) {
            if (xmiId > 0) {
                if (this.mergePoint < 0) {
                    this.sharedData.addIdMapping(fs, xmiId);
                } else {
                    this.localXmiIdToFs.put(xmiId, fs);
                }
            }
        }

        private TOP getFsForXmiId(int xmiId) {
            TOP r = this.maybeGetFsForXmiId(xmiId);
            if (r == null) {
                throw new NoSuchElementException();
            }
            return r;
        }

        private TOP maybeGetFsForXmiId(int xmiId) {
            if (this.mergePoint < 0 || !this.isNewFS(xmiId)) {
                TOP fs = this.sharedData.getFsForXmiId(xmiId);
                if (fs != null) {
                    return fs;
                }
                return null;
            }
            return this.localXmiIdToFs.get(xmiId);
        }

        private void addToOutOfTypeSystemData(XmlElementName xmlElementName, Attributes attrs) throws XCASParsingException {
            String xmiId = attrs.getValue(XmiCasDeserializer.ID_ATTR_NAME);
            this.outOfTypeSystemElement = new XmiSerializationSharedData.OotsElementData(xmiId, xmlElementName);
            XmiCasDeserializer.this.addOutOfTypeSystemAttributes(this.outOfTypeSystemElement, attrs);
            this.sharedData.addOutOfTypeSystemElement(this.outOfTypeSystemElement);
        }

        private boolean isNewFS(int id) {
            return id > this.mergePoint;
        }

        private void addNonsharedFSToEncompassingFSMapping(TOP nonsharedFS, TOP encompassingFS) {
            this.sharedData.addNonsharedRefToFSMapping(nonsharedFS, encompassingFS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDeferredFSs() throws SAXException {
            if (null == this.deferredFSs) {
                return;
            }
            this.processingDeferredFSs = true;
            List<XmiSerializationSharedData.OotsElementData> localDeferredFSs = this.deferredFSs;
            this.deferredFSs = null;
            for (XmiSerializationSharedData.OotsElementData deferredFs : localDeferredFSs) {
                List<XmlAttribute> attrs = deferredFs.attributes;
                for (XmlElementNameAndContents childElement : deferredFs.childElements) {
                    if (!childElement.name.qName.equals("sofa")) continue;
                    attrs.add(new XmlAttribute("sofa", childElement.contents));
                    break;
                }
                attrs.add(new XmlAttribute(XmiCasDeserializer.ID_ATTR_NAME, deferredFs.xmiId));
                this.readFS(deferredFs.elementName.nsUri, deferredFs.elementName.localName, deferredFs.elementName.qName, deferredFs.getAttributes());
                try {
                    this.isDoingDeferredChildElements = true;
                    for (XmiSerializationSharedData.NameMultiValue nmv : deferredFs.multiValuedFeatures) {
                        int featcode = this.handleFeatMultiValueFromName(this.currentType, this.currentFs, nmv.name, nmv.values);
                        if (featcode == -1 || this.featsSeen == null) continue;
                        this.featsSeen.add(featcode);
                    }
                }
                finally {
                    this.isDoingDeferredChildElements = false;
                }
            }
        }
    }
}

