/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.response;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uniffle.client.response.ClientResponse;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.proto.RssProtos;

public class RssPartitionToShuffleServerResponse
extends ClientResponse {
    private Map<Integer, List<ShuffleServerInfo>> partitionToServers;
    private Set<ShuffleServerInfo> shuffleServersForData;
    private RemoteStorageInfo remoteStorageInfo;

    public RssPartitionToShuffleServerResponse(StatusCode statusCode, String message, Map<Integer, List<ShuffleServerInfo>> partitionToServers, Set<ShuffleServerInfo> shuffleServersForData, RemoteStorageInfo remoteStorageInfo) {
        super(statusCode, message);
        this.partitionToServers = partitionToServers;
        this.remoteStorageInfo = remoteStorageInfo;
        this.shuffleServersForData = shuffleServersForData;
    }

    public Map<Integer, List<ShuffleServerInfo>> getPartitionToServers() {
        return this.partitionToServers;
    }

    public Set<ShuffleServerInfo> getShuffleServersForData() {
        return this.shuffleServersForData;
    }

    public RemoteStorageInfo getRemoteStorageInfo() {
        return this.remoteStorageInfo;
    }

    public static RssPartitionToShuffleServerResponse fromProto(RssProtos.PartitionToShuffleServerResponse response) {
        Map partitionToShuffleServerMap = response.getPartitionToShuffleServerMap();
        HashMap rpcPartitionToShuffleServerInfos = Maps.newHashMap();
        Set entries = partitionToShuffleServerMap.entrySet();
        for (Map.Entry entry : entries) {
            Integer partitionId = (Integer)entry.getKey();
            ArrayList shuffleServerInfos = Lists.newArrayList();
            List serversOrBuilderList = ((RssProtos.GetShuffleServerListResponse)entry.getValue()).getServersOrBuilderList();
            for (RssProtos.ShuffleServerIdOrBuilder shuffleServerIdOrBuilder : serversOrBuilderList) {
                shuffleServerInfos.add(new ShuffleServerInfo(shuffleServerIdOrBuilder.getId(), shuffleServerIdOrBuilder.getIp(), shuffleServerIdOrBuilder.getPort(), shuffleServerIdOrBuilder.getNettyPort()));
            }
            rpcPartitionToShuffleServerInfos.put(partitionId, shuffleServerInfos);
        }
        HashSet rpcShuffleServersForData = Sets.newHashSet();
        for (List ssis : rpcPartitionToShuffleServerInfos.values()) {
            rpcShuffleServersForData.addAll(ssis);
        }
        RssProtos.RemoteStorageInfo remoteStorageInfo = response.getRemoteStorageInfo();
        RemoteStorageInfo rpcRemoteStorageInfo = new RemoteStorageInfo(remoteStorageInfo.getPath(), remoteStorageInfo.getConfItemsMap());
        return new RssPartitionToShuffleServerResponse(StatusCode.valueOf((String)response.getStatus().name()), response.getMsg(), rpcPartitionToShuffleServerInfos, rpcShuffleServersForData, rpcRemoteStorageInfo);
    }
}

